/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.modeshape.jboss.Element;
import org.modeshape.jboss.ModeShapeAdd;
import org.modeshape.jboss.ModeShapeSubsystemDescribe;
import org.modeshape.jboss.ModeShapeSubsystemParser;
import org.modeshape.jboss.Namespace;
import org.modeshape.jboss.RepositoryAdd;
import org.modeshape.jboss.RepositoryRemove;
import org.modeshape.jboss.subsystem.JBossManagedI18n;

public class ModeShapeExtension
implements Extension {
    public static final String MODESHAPE_SUBSYSTEM = "modeshape";
    public static final String NAMESPACE = "urn:jboss.domain.modeshape:3.0";
    private static ModeShapeSubsystemParser parser = new ModeShapeSubsystemParser();
    private static RepositoryAdd REPOSITORY_ADD = new RepositoryAdd();
    private static RepositoryRemove REPOSITORY_REMOVE = new RepositoryRemove();
    private static ModeShapeAdd MODESHAPE_BOOT_ADD = new ModeShapeAdd();
    private static ModeShapeSubsystemDescribe MODESHAPE_DESCRIBE = new ModeShapeSubsystemDescribe();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(MODESHAPE_SUBSYSTEM);
        registration.registerXMLElementWriter((XMLElementWriter)parser);
        ManagementResourceRegistration modeShapeSubsystem = registration.registerSubsystemModel((DescriptionProvider)MODESHAPE_DESCRIBE);
        modeShapeSubsystem.registerOperationHandler("add", (OperationStepHandler)MODESHAPE_BOOT_ADD, (DescriptionProvider)MODESHAPE_BOOT_ADD, false);
        modeShapeSubsystem.registerOperationHandler("describe", (OperationStepHandler)MODESHAPE_DESCRIBE, (DescriptionProvider)MODESHAPE_DESCRIBE, false);
        ManagementResourceRegistration repositorySubsystem = modeShapeSubsystem.registerSubModel(PathElement.pathElement((String)Element.REPOSITORY_ELEMENT.getLocalName()), new DescriptionProvider(){

            public ModelNode getModelDescription(Locale locale) {
                ResourceBundle bundle = JBossManagedI18n.getResourceBundle(locale);
                ModelNode node = new ModelNode();
                node.get("description").set(Element.REPOSITORY_ELEMENT.getDescription(bundle));
                node.get("head-comment-allowed").set(true);
                RepositoryAdd.repositoryDescribe(node, "attributes", bundle);
                return node;
            }
        });
        repositorySubsystem.registerOperationHandler("add", (OperationStepHandler)REPOSITORY_ADD, (DescriptionProvider)REPOSITORY_ADD, false);
        repositorySubsystem.registerOperationHandler("remove", (OperationStepHandler)REPOSITORY_REMOVE, (DescriptionProvider)REPOSITORY_REMOVE, false);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(Namespace.CURRENT.getUri(), (XMLElementReader)parser);
    }
}

