/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.subsystem.test.AbstractSubsystemTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.jboss.subsystem.ModeShapeExtension;
import org.modeshape.jboss.subsystem.ModeShapeSubsystemProviders;
import org.modeshape.jboss.subsystem.ObjectConverterUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TestModeShapeConfiguration
extends AbstractSubsystemTest {
    public TestModeShapeConfiguration() {
        super("modeshape", (Extension)new ModeShapeExtension());
    }

    @Test
    public void testDescribeHandler() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.xml"));
        KernelServices servicesA = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        ModelNode modelA = servicesA.readWholeModel();
        String marshalled = servicesA.getPersistedSubsystemXml();
        Assert.assertNotNull((Object)modelA);
        Assert.assertNotNull((Object)marshalled);
        ModelNode describeOp = new ModelNode();
        describeOp.get("operation").set("describe");
        describeOp.get("address").set(PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"modeshape")}).toModelNode());
        List operations = AbstractSubsystemTest.checkResultAndGetContents((ModelNode)servicesA.executeOperation(describeOp)).asList();
        KernelServices servicesB = super.installInController(AdditionalInitialization.MANAGEMENT, operations);
        ModelNode modelB = servicesB.readWholeModel();
        Assert.assertNotNull((Object)modelB);
    }

    @Test
    public void testMinimalConfigurationWithOneMinimalRepository() throws Exception {
        String subsystemXml = "<subsystem xmlns=\"urn:jboss:domain:modeshape:1.0\">\n    <repository name=\"repo1\" />\n</subsystem>";
        KernelServices services = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        services.readWholeModel();
    }

    @Test
    public void testOutputPersistance() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.xml"));
        String json = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.json"));
        ModelNode testModel = this.filterValues(ModelNode.fromJSONString((String)json));
        String triggered = this.outputModel(testModel);
        KernelServices services = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        ModelNode model = services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        junit.framework.Assert.assertEquals((String)json, (String)model.toJSONString(false));
        junit.framework.Assert.assertEquals((String)triggered, (String)marshalled);
        junit.framework.Assert.assertEquals((String)this.normalizeXML(triggered), (String)this.normalizeXML(marshalled));
    }

    @Test
    public void testOutputPersistanceOfRelativelyThoroughConfiguration() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-full-config.xml"));
        String json = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-full-config.json"));
        ModelNode testModel = this.filterValues(ModelNode.fromJSONString((String)json));
        String triggered = this.outputModel(testModel);
        KernelServices services = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        ModelNode model = services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        junit.framework.Assert.assertEquals((String)json, (String)model.toJSONString(false));
        this.compare(testModel, model);
        junit.framework.Assert.assertEquals((String)this.normalizeXML(triggered), (String)this.normalizeXML(marshalled));
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithLocalFileIndexStorage() throws Exception {
        this.roundTrip("modeshape-local-file-index-storage.xml", "modeshape-local-file-index-storage.json");
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithCacheIndexStorage() throws Exception {
        this.roundTrip("modeshape-cache-index-storage.xml", "modeshape-cache-index-storage.json");
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithFileBinaryStorage() throws Exception {
        this.roundTrip("modeshape-file-binary-storage.xml", "modeshape-file-binary-storage.json");
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithCacheBinaryStorage() throws Exception {
        this.roundTrip("modeshape-cache-binary-storage.xml", "modeshape-cache-binary-storage.json");
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithClustering() throws Exception {
        this.roundTrip("modeshape-clustered-config.xml", "modeshape-clustered-config.json");
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithMinimalRepository() throws Exception {
        this.roundTrip("modeshape-minimal-config.xml", "modeshape-minimal-config.json");
    }

    protected void roundTrip(String filenameOfInputXmlConfig, String filenameOfExpectedJson) throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/" + filenameOfInputXmlConfig));
        String json = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/" + filenameOfExpectedJson));
        ModelNode testModel = this.filterValues(ModelNode.fromJSONString((String)json));
        String triggered = this.outputModel(testModel);
        KernelServices services = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        ModelNode model = services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        junit.framework.Assert.assertEquals((String)json, (String)model.toJSONString(false));
        this.compare(testModel, model);
        junit.framework.Assert.assertEquals((String)this.normalizeXML(triggered), (String)this.normalizeXML(marshalled));
    }

    @Test
    public void testSchema() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.xml"));
        this.validate(subsystemXml);
        KernelServices services = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        this.validate(marshalled);
    }

    private void validate(String marshalled) throws SAXException, IOException {
        URL xsdURL = Thread.currentThread().getContextClassLoader().getResource("schema/modeshape_1_0.xsd");
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(xsdURL);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new ByteArrayInputStream(marshalled.getBytes()));
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void error(SAXParseException exception) {
                if (!exception.getMessage().contains("cvc-enumeration-valid") && !exception.getMessage().contains("cvc-type")) {
                    Assert.fail((String)exception.getMessage());
                }
            }
        });
        validator.validate(source);
    }

    @Test
    public void testSubSystemDescription() throws IOException {
        ModelNode desc = ModeShapeSubsystemProviders.SUBSYSTEM.getModelDescription(Locale.getDefault());
        junit.framework.Assert.assertEquals((String)ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-subsystem-description.json")), (String)desc.toString());
    }

    @Test
    public void testParseSubsystem() throws Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.xml"));
        List operations = super.parse(subsystemXml);
        junit.framework.Assert.assertEquals((int)7, (int)operations.size());
        ModelNode addSubsystem = (ModelNode)operations.get(0);
        junit.framework.Assert.assertEquals((String)"add", (String)addSubsystem.get("operation").asString());
        PathAddress addr = PathAddress.pathAddress((ModelNode)addSubsystem.get("address"));
        junit.framework.Assert.assertEquals((int)1, (int)addr.size());
        PathElement element = addr.getElement(0);
        junit.framework.Assert.assertEquals((String)"subsystem", (String)element.getKey());
        junit.framework.Assert.assertEquals((String)"modeshape", (String)element.getValue());
    }

    @Ignore
    @Test
    public void testAddRemoveRepository() throws Exception {
        KernelServices services = this.buildSubsystem();
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"modeshape")});
        ModelNode read = new ModelNode();
        read.get("operation").set("read-children-names");
        read.get("address").set(addr.toModelNode());
        read.get("child-type").set("repository");
        ModelNode result = services.executeOperation(read);
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        List<String> opNames = TestModeShapeConfiguration.getList(result);
        junit.framework.Assert.assertEquals((int)2, (int)opNames.size());
        String[] ops = new String[]{"sample1", "sample2"};
        junit.framework.Assert.assertEquals(Arrays.asList(ops), opNames);
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(addr.toModelNode().add("repository", "myrepository"));
        addOp.get("jndi-name").set("jcr:local:myrepository");
        result = services.executeOperation(addOp);
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        result = services.executeOperation(read);
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        opNames = TestModeShapeConfiguration.getList(result);
        junit.framework.Assert.assertEquals((int)3, (int)opNames.size());
        String[] ops2 = new String[]{"myrepository", "sample1", "sample2"};
        junit.framework.Assert.assertEquals(Arrays.asList(ops2), opNames);
    }

    private KernelServices buildSubsystem() throws IOException, FileNotFoundException, Exception {
        String subsystemXml = ObjectConverterUtil.convertToString(new FileReader("src/test/resources/modeshape-sample-config.xml"));
        KernelServices services = super.installInController(subsystemXml);
        return services;
    }

    private static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    protected ModelNode filterValues(ModelNode node) {
        ModelNode result = new ModelNode();
        switch (node.getType()) {
            case OBJECT: {
                for (String key : node.keys()) {
                    ModelNode value = node.get(key);
                    result.get(key).set(this.filterValues(value));
                }
                break;
            }
            case LIST: {
                for (ModelNode value : node.asList()) {
                    result.add(this.filterValues(value));
                }
                break;
            }
            case PROPERTY: {
                Property prop = node.asProperty();
                ModelNode propValue = prop.getValue();
                ModelNode filteredValue = this.filterValues(propValue);
                if (propValue != filteredValue) {
                    Property newProp = new Property(prop.getName(), filteredValue);
                    result.set(newProp);
                    break;
                }
                result = node;
                break;
            }
            case BIG_INTEGER: {
                result.set(node.asBigInteger().intValue());
                break;
            }
            default: {
                result = node;
            }
        }
        return result;
    }
}

