/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.BinaryStorage;
import org.modeshape.jboss.service.BinaryStorageService;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;

public abstract class AbstractAddBinaryStorage
extends AbstractAddStepHandler {
    protected AbstractAddBinaryStorage() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        String opName = operation.get("operation").asString();
        if ("add-file-binary-storage".equals(opName)) {
            AbstractAddBinaryStorage.populate(operation, model, "file-binary-storage", ModelAttributes.FILE_BINARY_STORAGE_ATTRIBUTES);
        } else if ("add-cache-binary-storage".equals(opName)) {
            AbstractAddBinaryStorage.populate(operation, model, "cache-binary-storage", ModelAttributes.CACHE_BINARY_STORAGE_ATTRIBUTES);
        } else if ("add-db-binary-storage".equals(opName)) {
            AbstractAddBinaryStorage.populate(operation, model, "db-binary-storage", ModelAttributes.DATABASE_BINARY_STORAGE_ATTRIBUTES);
        } else if ("add-custom-binary-storage".equals(opName)) {
            AbstractAddBinaryStorage.populate(operation, model, "custom-binary-storage", ModelAttributes.CUSTOM_BINARY_STORAGE_ATTRIBUTES);
        }
    }

    static void populate(ModelNode operation, ModelNode model, String modelName, AttributeDefinition[] attributes) throws OperationFailedException {
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(operation, model);
        }
        model.get("binary-storage-type").set(modelName);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getElement(1).getValue();
        EditableDocument binaries = Schematic.newDocument();
        this.writeBinaryStorageConfiguration(repositoryName, context, model, binaries);
        BinaryStorageService service = new BinaryStorageService(repositoryName, binaries);
        ServiceBuilder builder = target.addService(ModeShapeServiceNames.binaryStorageServiceName(repositoryName), (Service)service);
        this.addControllersAndDependencies(repositoryName, service, (ServiceBuilder<BinaryStorage>)builder, newControllers, target);
        builder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(builder.install());
    }

    protected abstract void writeBinaryStorageConfiguration(String var1, OperationContext var2, ModelNode var3, EditableDocument var4) throws OperationFailedException;

    protected void addControllersAndDependencies(String repositoryName, BinaryStorageService service, ServiceBuilder<BinaryStorage> builder, List<ServiceController<?>> newControllers, ServiceTarget target) throws OperationFailedException {
    }
}

