/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.ModeShapeJndiNames;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

class RemoveRepository
extends AbstractRemoveStepHandler {
    private static final Logger log = Logger.getLogger((String)RemoveRepository.class.getPackage().getName());
    public static final RemoveRepository INSTANCE = new RemoveRepository();

    private RemoveRepository() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress serviceAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String repositoryName = serviceAddress.getLastElement().getValue();
        String jndiName = ModeShapeJndiNames.jndiNameFrom(model, repositoryName);
        ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)jndiName);
        context.removeService(bindInfo.getBinderServiceName());
        ServiceName serviceName = ModeShapeServiceNames.repositoryServiceName(repositoryName);
        context.removeService(serviceName);
        ServiceName dataDirServiceName = ModeShapeServiceNames.dataDirectoryServiceName(repositoryName);
        context.removeService(dataDirServiceName);
        log.debugf("repository '%s' removed", (Object)repositoryName);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

