/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.HashMap;
import java.util.Map;

public enum Element {
    UNKNOWN(null),
    AUTHENTICATORS("authenticators"),
    AUTHENTICATOR("authenticator"),
    CACHE_BINARY_STORAGE("cache-binary-storage"),
    CACHE_INDEX_STORAGE("cache-index-storage"),
    CUSTOM_BINARY_STORAGE("file-binary-storage"),
    CUSTOM_INDEX_STORAGE("custom-index-storage"),
    DB_BINARY_STORAGE("db-binary-storage"),
    FILE_BINARY_STORAGE("file-binary-storage"),
    INDEXING("indexing"),
    LOCAL_FILE_INDEX_STORAGE("local-file-index-storage"),
    MASTER_FILE_INDEX_STORAGE("master-file-index-storage"),
    PATH_EXPRESSION("path-expression"),
    RAM_INDEX_STORAGE("ram-index-storage"),
    REPOSITORY("repository"),
    SEQUENCER("sequencer"),
    SEQUENCERS("sequencers"),
    TEXT_EXTRACTORS("text-extractors"),
    TEXT_EXTRACTOR("text-extractor"),
    SLAVE_FILE_INDEX_STORAGE("slave-file-index-storage"),
    WORKSPACE("workspace"),
    WORKSPACES("workspaces");

    private final String name;
    private static final Map<String, Element> attributes;

    private Element(String name) {
        this.name = name;
    }

    public String getLocalName() {
        return this.name;
    }

    public static Element forName(String localName) {
        Element attribute = attributes.get(localName);
        return attribute == null ? UNKNOWN : attribute;
    }

    static {
        HashMap<String, Element> map = new HashMap<String, Element>();
        for (Element attribute : Element.values()) {
            String name = attribute.getLocalName();
            if (name == null) continue;
            map.put(name, attribute);
        }
        attributes = map;
    }
}

