/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.modeshape.jboss.subsystem.AddCacheBinaryStorage;
import org.modeshape.jboss.subsystem.AddCacheIndexStorage;
import org.modeshape.jboss.subsystem.AddCustomBinaryStorage;
import org.modeshape.jboss.subsystem.AddCustomIndexStorage;
import org.modeshape.jboss.subsystem.AddDatabaseBinaryStorage;
import org.modeshape.jboss.subsystem.AddFileBinaryStorage;
import org.modeshape.jboss.subsystem.AddLocalFileSystemIndexStorage;
import org.modeshape.jboss.subsystem.AddMasterFileSystemIndexStorage;
import org.modeshape.jboss.subsystem.AddModeShapeSubsystem;
import org.modeshape.jboss.subsystem.AddRamIndexStorage;
import org.modeshape.jboss.subsystem.AddRepository;
import org.modeshape.jboss.subsystem.AddSequencer;
import org.modeshape.jboss.subsystem.AddSlaveFileSystemIndexStorage;
import org.modeshape.jboss.subsystem.AddTextExtractor;
import org.modeshape.jboss.subsystem.BinaryStorageWriteAttributeHandler;
import org.modeshape.jboss.subsystem.DescribeModeShapeSubsystem;
import org.modeshape.jboss.subsystem.IndexStorageWriteAttributeHandler;
import org.modeshape.jboss.subsystem.ModeShapeSubsystemProviders;
import org.modeshape.jboss.subsystem.ModeShapeSubsystemXMLWriter;
import org.modeshape.jboss.subsystem.Namespace;
import org.modeshape.jboss.subsystem.RemoveBinaryStorage;
import org.modeshape.jboss.subsystem.RemoveIndexStorage;
import org.modeshape.jboss.subsystem.RemoveRepository;
import org.modeshape.jboss.subsystem.RemoveSequencer;
import org.modeshape.jboss.subsystem.RemoveTextExtractor;
import org.modeshape.jboss.subsystem.RepositoryWriteAttributeHandler;
import org.modeshape.jboss.subsystem.SequencerWriteAttributeHandler;
import org.modeshape.jboss.subsystem.TextExtractorWriteAttributeHandler;

public class ModeShapeExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "modeshape";
    static final String DATA_DIR_VARIABLE = "jboss.server.data.dir";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final PathElement repositoryPath = PathElement.pathElement((String)"repository");
    private static final PathElement sequencerPath = PathElement.pathElement((String)"sequencer");
    private static final PathElement textExtractorPath = PathElement.pathElement((String)"text-extractor");
    private static final PathElement indexStoragePath = PathElement.pathElement((String)"index-storage", (String)"INDEXES");
    private static final PathElement binaryStoragePath = PathElement.pathElement((String)"binary-storage", (String)"BINARIES");

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2);
        registration.registerXMLElementWriter((XMLElementWriter)new ModeShapeSubsystemXMLWriter());
        ManagementResourceRegistration modeShapeSubsystem = registration.registerSubsystemModel(ModeShapeSubsystemProviders.SUBSYSTEM);
        modeShapeSubsystem.registerOperationHandler("add", (OperationStepHandler)AddModeShapeSubsystem.INSTANCE, ModeShapeSubsystemProviders.SUBSYSTEM_ADD, false);
        modeShapeSubsystem.registerOperationHandler("describe", (OperationStepHandler)DescribeModeShapeSubsystem.INSTANCE, ModeShapeSubsystemProviders.SUBSYSTEM_DESCRIBE, false);
        ManagementResourceRegistration repositorySubmodel = modeShapeSubsystem.registerSubModel(repositoryPath, ModeShapeSubsystemProviders.REPOSITORY);
        repositorySubmodel.registerOperationHandler("add", (OperationStepHandler)AddRepository.INSTANCE, ModeShapeSubsystemProviders.REPOSITORY_ADD, false);
        repositorySubmodel.registerOperationHandler("remove", (OperationStepHandler)RemoveRepository.INSTANCE, ModeShapeSubsystemProviders.REPOSITORY_REMOVE, false);
        RepositoryWriteAttributeHandler.INSTANCE.registerAttributes(repositorySubmodel);
        ManagementResourceRegistration sequencerSubmodel = repositorySubmodel.registerSubModel(sequencerPath, ModeShapeSubsystemProviders.SEQUENCER);
        sequencerSubmodel.registerOperationHandler("add", (OperationStepHandler)AddSequencer.INSTANCE, ModeShapeSubsystemProviders.SEQUENCER_ADD, false);
        sequencerSubmodel.registerOperationHandler("remove", (OperationStepHandler)RemoveSequencer.INSTANCE, ModeShapeSubsystemProviders.SEQUENCER_REMOVE, false);
        SequencerWriteAttributeHandler.INSTANCE.registerAttributes(sequencerSubmodel);
        ManagementResourceRegistration extractorSubmodel = repositorySubmodel.registerSubModel(textExtractorPath, ModeShapeSubsystemProviders.TEXT_EXTRACTOR);
        extractorSubmodel.registerOperationHandler("add", (OperationStepHandler)AddTextExtractor.INSTANCE, ModeShapeSubsystemProviders.TEXT_EXTRACTOR_ADD, false);
        extractorSubmodel.registerOperationHandler("remove", (OperationStepHandler)RemoveTextExtractor.INSTANCE, ModeShapeSubsystemProviders.TEXT_EXTRACTOR_REMOVE, false);
        TextExtractorWriteAttributeHandler.INSTANCE.registerAttributes(extractorSubmodel);
        ManagementResourceRegistration indexStorageSubmodel = repositorySubmodel.registerSubModel(indexStoragePath, ModeShapeSubsystemProviders.INDEX_STORAGE);
        indexStorageSubmodel.registerOperationHandler("add-ram-index-storage", (OperationStepHandler)AddRamIndexStorage.INSTANCE, ModeShapeSubsystemProviders.RAM_INDEX_STORAGE_ADD, false);
        indexStorageSubmodel.registerOperationHandler("add-local-file-index-storage", (OperationStepHandler)AddLocalFileSystemIndexStorage.INSTANCE, ModeShapeSubsystemProviders.LOCAL_FILE_INDEX_STORAGE_ADD, false);
        indexStorageSubmodel.registerOperationHandler("add-master-file-index-storage", (OperationStepHandler)AddMasterFileSystemIndexStorage.INSTANCE, ModeShapeSubsystemProviders.MASTER_FILE_INDEX_STORAGE_ADD, false);
        indexStorageSubmodel.registerOperationHandler("add-slave-file-index-storage", (OperationStepHandler)AddSlaveFileSystemIndexStorage.INSTANCE, ModeShapeSubsystemProviders.SLAVE_FILE_INDEX_STORAGE_ADD, false);
        indexStorageSubmodel.registerOperationHandler("add-cache-index-storage", (OperationStepHandler)AddCacheIndexStorage.INSTANCE, ModeShapeSubsystemProviders.CACHE_INDEX_STORAGE_ADD, false);
        indexStorageSubmodel.registerOperationHandler("add-custom-index-storage", (OperationStepHandler)AddCustomIndexStorage.INSTANCE, ModeShapeSubsystemProviders.CUSTOM_INDEX_STORAGE_ADD, false);
        indexStorageSubmodel.registerOperationHandler("remove-index-storage", (OperationStepHandler)RemoveIndexStorage.INSTANCE, ModeShapeSubsystemProviders.INDEX_STORAGE_REMOVE, false);
        IndexStorageWriteAttributeHandler.INSTANCE.registerAttributes(indexStorageSubmodel);
        ManagementResourceRegistration binaryStorageSubmodel = repositorySubmodel.registerSubModel(binaryStoragePath, ModeShapeSubsystemProviders.BINARY_STORAGE);
        binaryStorageSubmodel.registerOperationHandler("add-file-binary-storage", (OperationStepHandler)AddFileBinaryStorage.INSTANCE, ModeShapeSubsystemProviders.FILE_BINARY_STORAGE_ADD, false);
        binaryStorageSubmodel.registerOperationHandler("add-db-binary-storage", (OperationStepHandler)AddDatabaseBinaryStorage.INSTANCE, ModeShapeSubsystemProviders.DB_BINARY_STORAGE_ADD, false);
        binaryStorageSubmodel.registerOperationHandler("add-cache-binary-storage", (OperationStepHandler)AddCacheBinaryStorage.INSTANCE, ModeShapeSubsystemProviders.CACHE_BINARY_STORAGE_ADD, false);
        binaryStorageSubmodel.registerOperationHandler("add-custom-binary-storage", (OperationStepHandler)AddCustomBinaryStorage.INSTANCE, ModeShapeSubsystemProviders.CUSTOM_BINARY_STORAGE_ADD, false);
        binaryStorageSubmodel.registerOperationHandler("remove-binary-storage", (OperationStepHandler)RemoveBinaryStorage.INSTANCE, ModeShapeSubsystemProviders.BINARY_STORAGE_REMOVE, false);
        BinaryStorageWriteAttributeHandler.INSTANCE.registerAttributes(binaryStorageSubmodel);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), reader);
        }
    }
}

