/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.subsystem.test.AbstractSubsystemBaseTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.modeshape.jboss.subsystem.ModeShapeExtension;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModeShapeConfigurationTest
extends AbstractSubsystemBaseTest {
    public ModeShapeConfigurationTest() {
        super("modeshape", (Extension)new ModeShapeExtension());
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource("modeshape-sample-config.xml");
    }

    protected String getSubsystemXml(String configId) throws IOException {
        if ("minimal".equals(configId)) {
            return "<subsystem xmlns=\"urn:jboss:domain:modeshape:1.0\">\n <repository name=\"repo1\" />\n</subsystem>";
        }
        return this.getSubsystemXml();
    }

    @Test
    public void testMinimalConfigurationWithOneMinimalRepository() throws Exception {
        this.standardSubsystemTest("minimal");
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithLocalFileIndexStorage() throws Exception {
        this.parse(this.readResource("modeshape-local-file-index-storage.xml"));
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithCacheIndexStorage() throws Exception {
        this.parse(this.readResource("modeshape-cache-index-storage.xml"));
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithFileBinaryStorage() throws Exception {
        this.parse(this.readResource("modeshape-file-binary-storage.xml"));
    }

    @Test
    public void testOutputPersistanceOfConfigurationWithCacheBinaryStorage() throws Exception {
        this.parse(this.readResource("modeshape-cache-binary-storage.xml"));
    }

    @Test
    public void testSchema() throws Exception {
        String subsystemXml = this.readResource("modeshape-sample-config.xml");
        this.validate(subsystemXml);
        KernelServices services = super.installInController(AdditionalInitialization.MANAGEMENT, subsystemXml);
        services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        this.validate(marshalled);
    }

    private void validate(String marshalled) throws SAXException, IOException {
        URL xsdURL = Thread.currentThread().getContextClassLoader().getResource("schema/modeshape_1_0.xsd");
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(xsdURL);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new ByteArrayInputStream(marshalled.getBytes()));
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void error(SAXParseException exception) {
                if (exception.getMessage().contains("cvc-enumeration-valid")) {
                    return;
                }
                if (exception.getMessage().contains("cvc-type")) {
                    return;
                }
                Assert.fail((String)exception.getMessage());
            }
        });
        validator.validate(source);
    }

    @Ignore
    @Test
    public void testAddRemoveRepository() throws Exception {
        KernelServices services = this.buildSubsystem();
        PathAddress addr = PathAddress.pathAddress((PathElement[])new PathElement[]{PathElement.pathElement((String)"subsystem", (String)"modeshape")});
        ModelNode read = new ModelNode();
        read.get("operation").set("read-children-names");
        read.get("address").set(addr.toModelNode());
        read.get("child-type").set("repository");
        ModelNode result = services.executeOperation(read);
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        List<String> opNames = ModeShapeConfigurationTest.getList(result);
        junit.framework.Assert.assertEquals((int)2, (int)opNames.size());
        String[] ops = new String[]{"sample1", "sample2"};
        junit.framework.Assert.assertEquals(Arrays.asList(ops), opNames);
        ModelNode addOp = new ModelNode();
        addOp.get("operation").set("add");
        addOp.get("address").set(addr.toModelNode().add("repository", "myrepository"));
        addOp.get("jndi-name").set("jcr:local:myrepository");
        result = services.executeOperation(addOp);
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        result = services.executeOperation(read);
        junit.framework.Assert.assertEquals((String)"success", (String)result.get("outcome").asString());
        opNames = ModeShapeConfigurationTest.getList(result);
        junit.framework.Assert.assertEquals((int)3, (int)opNames.size());
        String[] ops2 = new String[]{"myrepository", "sample1", "sample2"};
        junit.framework.Assert.assertEquals(Arrays.asList(ops2), opNames);
    }

    private KernelServices buildSubsystem() throws IOException, FileNotFoundException, Exception {
        String subsystemXml = this.readResource("modeshape-sample-config.xml");
        KernelServices services = super.installInController(subsystemXml);
        return services;
    }

    private static List<String> getList(ModelNode operationResult) {
        if (!operationResult.hasDefined("result")) {
            return Collections.emptyList();
        }
        List nodeList = operationResult.get("result").asList();
        if (nodeList.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> list = new ArrayList<String>(nodeList.size());
        for (ModelNode node : nodeList) {
            list.add(node.asString());
        }
        return list;
    }

    protected ModelNode filterValues(ModelNode node) {
        ModelNode result = new ModelNode();
        switch (node.getType()) {
            case OBJECT: {
                for (String key : node.keys()) {
                    ModelNode value = node.get(key);
                    result.get(key).set(this.filterValues(value));
                }
                break;
            }
            case LIST: {
                for (ModelNode value : node.asList()) {
                    result.add(this.filterValues(value));
                }
                break;
            }
            case PROPERTY: {
                Property prop = node.asProperty();
                ModelNode propValue = prop.getValue();
                ModelNode filteredValue = this.filterValues(propValue);
                if (propValue != filteredValue) {
                    Property newProp = new Property(prop.getName(), filteredValue);
                    result.set(newProp);
                    break;
                }
                result = node;
                break;
            }
            case BIG_INTEGER: {
                result.set(node.asBigInteger().intValue());
                break;
            }
            default: {
                result = node;
            }
        }
        return result;
    }
}

