/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.jboss.as.controller.services.path.RelativePathService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.IndexStorageService;
import org.modeshape.jboss.subsystem.AbstractAddIndexStorage;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

public abstract class AbstractAddFileSystemIndexStorage
extends AbstractAddIndexStorage {
    protected String indexStoragePathInDataDirectory;
    protected String indexSourcePathInDataDirectory;

    protected AbstractAddFileSystemIndexStorage() {
    }

    protected void setIndexStoragePathInDataDirectory(String relativePath) {
        this.indexStoragePathInDataDirectory = relativePath;
    }

    protected void setIndexSourcePathInDataDirectory(String relativePath) {
        this.indexSourcePathInDataDirectory = relativePath;
    }

    @Override
    protected void addControllersAndDependencies(String repositoryName, IndexStorageService service, List<ServiceController<?>> newControllers, ServiceTarget target) {
        ServiceName serviceName;
        ServiceBuilder builder = null;
        if (this.indexStoragePathInDataDirectory != null) {
            serviceName = ModeShapeServiceNames.indexStorageDirectoryServiceName(repositoryName);
            newControllers.add(RelativePathService.addService((ServiceName)serviceName, (String)this.indexStoragePathInDataDirectory, (String)"jboss.server.data.dir", (ServiceTarget)target));
            builder = target.addService(serviceName, (Service)service);
            builder.addDependency(serviceName, String.class, service.getIndexStorageBasePathInjector());
        }
        if (this.indexSourcePathInDataDirectory != null) {
            serviceName = ModeShapeServiceNames.indexSourceStorageDirectoryServiceName(repositoryName);
            newControllers.add(RelativePathService.addService((ServiceName)serviceName, (String)this.indexSourcePathInDataDirectory, (String)"jboss.server.data.dir", (ServiceTarget)target));
            if (builder == null) {
                builder = target.addService(serviceName, (Service)service);
            }
            builder.addDependency(serviceName, String.class, service.getIndexStorageSourceBasePathInjector());
        }
        if (builder != null) {
            newControllers.add(builder.install());
        }
    }
}

