/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.ListAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.modeshape.jboss.subsystem.Attribute;
import org.modeshape.jboss.subsystem.Element;
import org.modeshape.jboss.subsystem.ModelAttributes;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeSubsystemXMLWriter
implements XMLStreamConstants,
XMLElementWriter<SubsystemMarshallingContext> {
    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUri(), false);
        ModelNode model = context.getModelNode();
        if (model.isDefined()) {
            for (Property entry : model.get("repository").asPropertyList()) {
                String repositoryName = entry.getName();
                ModelNode repository = entry.getValue();
                this.writeRepositoryConfiguration(writer, repository, repositoryName);
            }
        }
        writer.writeEndElement();
    }

    private void writeRepositoryConfiguration(XMLExtendedStreamWriter writer, ModelNode repository, String repositoryName) throws XMLStreamException {
        writer.writeStartElement(Element.REPOSITORY.getLocalName());
        writer.writeAttribute(Attribute.NAME.getLocalName(), repositoryName);
        ModelAttributes.CACHE_NAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.CACHE_CONTAINER.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.JNDI_NAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.ENABLE_MONITORING.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.SECURITY_DOMAIN.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        this.writeAttributeAsList(writer, repository, ModelAttributes.ANONYMOUS_ROLES);
        ModelAttributes.ANONYMOUS_USERNAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.USE_ANONYMOUS_IF_AUTH_FAILED.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.CLUSTER_NAME.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        ModelAttributes.CLUSTER_STACK.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
        this.writeWorkspaces(writer, repository);
        this.writeIndexing(writer, repository);
        this.writeIndexStorage(writer, repository);
        this.writeBinaryStorage(writer, repository);
        this.writeAuthenticators(writer, repository);
        this.writeSequencing(writer, repository);
        this.writeTextExtraction(writer, repository);
        writer.writeEndElement();
    }

    private void writeWorkspaces(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        if (ModelAttributes.DEFAULT_WORKSPACE.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.DEFAULT_WORKSPACE.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (ModelAttributes.ALLOW_WORKSPACE_CREATION.isMarshallable(repository, false)) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelAttributes.ALLOW_WORKSPACE_CREATION.marshallAsAttribute(repository, (XMLStreamWriter)writer);
        }
        if (this.has(repository, "predefined-workspace-names")) {
            started = this.startIfNeeded(writer, Element.WORKSPACES, started);
            ModelNode names = repository.get("predefined-workspace-names");
            if (names.isDefined()) {
                HashMap<String, String> workspacesInitialContent = new HashMap<String, String>();
                if (this.has(repository, "workspaces-initial-content")) {
                    List initialContentNodes = repository.get("workspaces-initial-content").asList();
                    for (ModelNode modelNode : initialContentNodes) {
                        Property property = modelNode.asProperty();
                        workspacesInitialContent.put(property.getName(), property.getValue().asString());
                    }
                }
                for (ModelNode workspace : repository.get("predefined-workspace-names").asList()) {
                    writer.writeStartElement(Element.WORKSPACE.getLocalName());
                    String name = workspace.asString();
                    writer.writeAttribute(Attribute.NAME.getLocalName(), name);
                    if (workspacesInitialContent.containsKey(name)) {
                        writer.writeStartElement(Element.INITIAL_CONTENT.getLocalName());
                        writer.writeCharacters((String)workspacesInitialContent.get(name));
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
            }
        }
        if (this.has(repository, "default-initial-content")) {
            writer.writeStartElement(Element.INITIAL_CONTENT.getLocalName());
            writer.writeCharacters(repository.get("default-initial-content").asString());
            writer.writeEndElement();
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private void writeIndexing(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        boolean started = false;
        for (String key : repository.keys()) {
            if ("rebuild-indexes-upon-startup".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.REBUILD_INDEXES_UPON_STARTUP, Element.INDEXING, started);
                continue;
            }
            if ("indexing-analyzer-classname".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.ANALYZER_CLASSNAME, Element.INDEXING, started);
                continue;
            }
            if ("indexing-analyzer-module".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.ANALYZER_MODULE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-async-thread-pool-size".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.ASYNC_THREAD_POOL_SIZE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-async-max-queue-size".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.ASYNC_MAX_QUEUE_SIZE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-batch-size".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.BATCH_SIZE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-mode".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.MODE, Element.INDEXING, started);
                continue;
            }
            if ("system-content-indexing-mode".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.SYSTEM_CONTENT_MODE, Element.INDEXING, started);
                continue;
            }
            if ("indexing-reader-strategy".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.READER_STRATEGY, Element.INDEXING, started);
                continue;
            }
            if ("indexing-thread-pool".equals(key)) {
                started = this.startAndWriteAttribute(writer, repository, ModelAttributes.THREAD_POOL, Element.INDEXING, started);
                continue;
            }
            if (!key.startsWith("hibernate")) continue;
            writer.writeAttribute(key, repository.get(key).asString());
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private boolean startIfNeeded(XMLExtendedStreamWriter writer, Element name, boolean alreadyStarted) throws XMLStreamException {
        if (!alreadyStarted) {
            writer.writeStartElement(name.getLocalName());
        }
        return true;
    }

    private void writeIndexStorageAttributes(XMLExtendedStreamWriter writer, ModelNode node, Element element, boolean started) throws XMLStreamException {
        ModelNode storage = node.get((String)node.keys().toArray()[0]);
        for (String key : storage.keys()) {
            if ("index-storage-type".equals(key)) continue;
            if ("index-format".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.INDEX_FORMAT, element, started);
                continue;
            }
            if ("path".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.PATH, element, started);
                continue;
            }
            if ("relative-to".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.RELATIVE_TO, element, started);
                continue;
            }
            if ("source-path".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.SOURCE_PATH, element, started);
                continue;
            }
            if ("source-relative-to".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.SOURCE_RELATIVE_TO, element, started);
                continue;
            }
            if ("access-type".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.ACCESS_TYPE, element, started);
                continue;
            }
            if ("locking-strategy".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.LOCKING_STRATEGY, element, started);
                continue;
            }
            if ("refresh-period".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.REFRESH_PERIOD, element, started);
                continue;
            }
            if ("copy-buffer-size".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.COPY_BUFFER_SIZE, element, started);
                continue;
            }
            if ("connection-factory-jndi-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.CONNECTION_FACTORY_JNDI_NAME, element, started);
                continue;
            }
            if ("queue-jndi-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.QUEUE_JNDI_NAME, element, started);
                continue;
            }
            if ("lock-cache-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.LOCK_CACHE_NAME, element, started);
                continue;
            }
            if ("data-cache-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.DATA_CACHE_NAME, element, started);
                continue;
            }
            if ("metadata-cache-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.METADATA_CACHE_NAME, element, started);
                continue;
            }
            if ("cache-container-jndi-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.CACHE_CONTAINER_JNDI_NAME, element, started);
                continue;
            }
            if ("data-cache-name".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.DATA_CACHE_NAME, element, started);
                continue;
            }
            if ("chunk-size".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.CHUNK_SIZE, element, started);
                continue;
            }
            if ("classname".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.CLASSNAME, element, started);
                continue;
            }
            if ("module".equals(key)) {
                started = this.startAndWriteAttribute(writer, storage, ModelAttributes.CLASSNAME, element, started);
                continue;
            }
            writer.writeAttribute(key, storage.get(key).asString());
        }
        if (started) {
            writer.writeEndElement();
        }
    }

    private void writeIndexStorage(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "configuration", "index-storage")) {
            String storageType;
            ModelNode indexStorage = repository.get("configuration").get("index-storage");
            ModelNode indexStorageType = indexStorage.get("storage-type");
            String string = storageType = indexStorageType.isDefined() && indexStorageType.keys().size() == 1 ? (String)indexStorageType.keys().toArray()[0] : null;
            if ("ram-index-storage".equals(storageType)) {
                writer.writeStartElement(Element.RAM_INDEX_STORAGE.getLocalName());
                this.writeIndexStorageAttributes(writer, indexStorageType, Element.RAM_INDEX_STORAGE, true);
            } else if ("local-file-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorageType, Element.LOCAL_FILE_INDEX_STORAGE, false);
            } else if ("master-file-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorageType, Element.MASTER_FILE_INDEX_STORAGE, false);
            } else if ("slave-file-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorageType, Element.SLAVE_FILE_INDEX_STORAGE, false);
            } else if ("cache-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorageType, Element.CACHE_INDEX_STORAGE, false);
            } else if ("custom-index-storage".equals(storageType)) {
                this.writeIndexStorageAttributes(writer, indexStorageType, Element.CUSTOM_INDEX_STORAGE, false);
            }
        }
    }

    private void writeBinaryStorage(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "configuration", "binary-storage")) {
            ModelNode storage;
            ModelNode configuration = repository.get("configuration");
            ModelNode binaryStorage = configuration.get("binary-storage");
            ModelNode binaryStorageType = binaryStorage.get("storage-type");
            String storageType = binaryStorageType.isDefined() && binaryStorageType.keys().size() == 1 ? (String)binaryStorageType.keys().toArray()[0] : null;
            ModelNode modelNode = storage = storageType != null ? binaryStorageType.get((String)binaryStorageType.keys().toArray()[0]) : new ModelNode();
            if ("file-binary-storage".equals(storageType)) {
                writer.writeStartElement(Element.FILE_BINARY_STORAGE.getLocalName());
                ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                ModelAttributes.PATH.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                ModelAttributes.RELATIVE_TO.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            } else if ("cache-binary-storage".equals(storageType)) {
                writer.writeStartElement(Element.CACHE_BINARY_STORAGE.getLocalName());
                ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                ModelAttributes.DATA_CACHE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                ModelAttributes.METADATA_CACHE_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                ModelAttributes.CACHE_CONTAINER.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            } else if ("db-binary-storage".equals(storageType)) {
                writer.writeStartElement(Element.DB_BINARY_STORAGE.getLocalName());
                ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                ModelAttributes.DATA_SOURCE_JNDI_NAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                writer.writeEndElement();
            } else if ("custom-binary-storage".equals(storageType)) {
                ModelNode custom_storage = binaryStorage.get("custom-binary-storage");
                writer.writeStartElement(Element.CUSTOM_BINARY_STORAGE.getLocalName());
                ModelAttributes.MINIMUM_BINARY_SIZE.marshallAsAttribute(repository, false, (XMLStreamWriter)writer);
                for (String key : storage.keys()) {
                    if (key.equals("classname")) {
                        ModelAttributes.CLASSNAME.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                        continue;
                    }
                    if (key.equals("module")) {
                        ModelAttributes.MODULE.marshallAsAttribute(storage, false, (XMLStreamWriter)writer);
                        continue;
                    }
                    writer.writeAttribute(key, custom_storage.get(key).asString());
                }
                writer.writeEndElement();
            }
        }
    }

    private void writeAuthenticators(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "authenticators")) {
            ModelNode indexing = repository.get("authenticators");
            writer.writeStartElement(Element.AUTHENTICATORS.getLocalName());
            for (String key : indexing.keys()) {
                if ("name".equals(key)) {
                    ModelAttributes.NAME.marshallAsAttribute(indexing, (XMLStreamWriter)writer);
                    continue;
                }
                if ("classname".equals(key)) {
                    ModelAttributes.CLASSNAME.marshallAsAttribute(indexing, (XMLStreamWriter)writer);
                    continue;
                }
                if ("module".equals(key)) {
                    ModelAttributes.MODULE.marshallAsAttribute(indexing, (XMLStreamWriter)writer);
                    continue;
                }
                ModelNode param = indexing.get(key);
                writer.writeAttribute(key, param.asString());
            }
            writer.writeEndElement();
        }
    }

    private void writeSequencing(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "sequencer")) {
            writer.writeStartElement(Element.SEQUENCERS.getLocalName());
            ModelNode sequencerNode = repository.get("sequencer");
            for (Property sequencer : sequencerNode.asPropertyList()) {
                writer.writeStartElement(Element.SEQUENCER.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), sequencer.getName());
                ModelNode prop = sequencer.getValue();
                ModelAttributes.SEQUENCER_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                List pathExpressions = prop.get("path-expressions").asList();
                switch (pathExpressions.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        ModelNode pathExpression = (ModelNode)pathExpressions.iterator().next();
                        writer.writeAttribute(Attribute.PATH_EXPRESSION.getLocalName(), pathExpression.asString());
                        break;
                    }
                    default: {
                        for (ModelNode pathExpr : pathExpressions) {
                            writer.writeStartElement(Element.PATH_EXPRESSION.getLocalName());
                            writer.writeCharacters(pathExpr.asString());
                            writer.writeEndElement();
                        }
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private void writeTextExtraction(XMLExtendedStreamWriter writer, ModelNode repository) throws XMLStreamException {
        if (this.has(repository, "text-extractor")) {
            writer.writeStartElement(Element.TEXT_EXTRACTORS.getLocalName());
            for (Property extractor : repository.get("text-extractor").asPropertyList()) {
                writer.writeStartElement(Element.TEXT_EXTRACTOR.getLocalName());
                writer.writeAttribute(Attribute.NAME.getLocalName(), extractor.getName());
                ModelNode prop = extractor.getValue();
                ModelAttributes.TEXT_EXTRACTOR_CLASSNAME.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                ModelAttributes.MODULE.marshallAsAttribute(prop, (XMLStreamWriter)writer);
                if (this.has(prop, "properties")) {
                    ModelNode properties = prop.get("properties");
                    for (Property property : properties.asPropertyList()) {
                        writer.writeAttribute(property.getName(), property.getValue().asString());
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    private boolean has(ModelNode node, String name) {
        return node.isDefined() && node.has(name) && node.get(name).isDefined();
    }

    private boolean has(ModelNode node, String ... names) {
        for (String name : names) {
            if (!node.isDefined() || !node.has(name)) {
                return false;
            }
            node = node.get(name);
        }
        return true;
    }

    private boolean startAndWriteAttribute(XMLExtendedStreamWriter writer, ModelNode node, SimpleAttributeDefinition modelAttribute, Element name, boolean started) throws XMLStreamException {
        assert (modelAttribute.getXmlName() != null);
        boolean result = started;
        if (modelAttribute.isMarshallable(node, false)) {
            result = this.startIfNeeded(writer, name, started);
            modelAttribute.marshallAsAttribute(node, false, (XMLStreamWriter)writer);
        }
        return result;
    }

    private void writeAttributeAsList(XMLExtendedStreamWriter writer, ModelNode node, ListAttributeDefinition modelAttribute) throws XMLStreamException {
        if (modelAttribute.isMarshallable(node, false)) {
            StringBuilder sb = new StringBuilder();
            Iterator iter = node.get(modelAttribute.getName()).asList().iterator();
            if (iter.hasNext()) {
                sb.append(((ModelNode)iter.next()).asString());
                while (iter.hasNext()) {
                    sb.append(" ").append(((ModelNode)iter.next()).asString());
                }
                writer.writeAttribute(modelAttribute.getXmlName(), sb.toString());
            }
        }
    }
}

