/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;

class RemoveTextExtractor
extends AbstractRemoveStepHandler {
    private static final Logger log = Logger.getLogger((String)RemoveTextExtractor.class.getPackage().getName());
    public static final RemoveTextExtractor INSTANCE = new RemoveTextExtractor();

    private RemoveTextExtractor() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        PathAddress serviceAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String sequencerName = serviceAddress.getLastElement().getValue();
        String repositoryName = serviceAddress.getElement(1).getValue();
        ServiceName serviceName = ModeShapeServiceNames.textExtractorServiceName(repositoryName, sequencerName);
        context.removeService(serviceName);
        log.debugf("extractor '%s' removed for repository '%s'", (Object)sequencerName, (Object)repositoryName);
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

