/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.modeshape.jboss.service.IndexStorage;
import org.modeshape.jboss.service.IndexStorageService;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;

public abstract class AbstractAddIndexStorage
extends AbstractAddStepHandler {
    protected AbstractAddIndexStorage() {
    }

    static void populate(ModelNode operation, ModelNode model, String modelName, AttributeDefinition[] attributes) throws OperationFailedException {
        for (AttributeDefinition attribute : attributes) {
            attribute.validateAndSet(operation, model);
        }
        model.get("index-storage-type").set(modelName);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode storage, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String repositoryName = pathAddress.getElement(1).getValue();
        ServiceName indexStorageServiceName = ModeShapeServiceNames.indexStorageServiceName(repositoryName);
        IndexStorageService existingService = (IndexStorageService)context.getServiceRegistry(false).getService(indexStorageServiceName).getService();
        EditableDocument query = existingService.getValue().getQueryConfiguration();
        EditableDocument indexing = query.getOrCreateDocument("indexing");
        this.writeIndexStorageSpecificIndexingConfiguration(context, storage, indexing);
        EditableDocument indexStorage = query.setDocument("indexStorage");
        this.writeIndexStorageConfiguration(context, storage, indexStorage, repositoryName);
        EditableDocument backend = indexing.getOrCreateDocument("backend");
        this.writeIndexingBackendConfiguration(context, storage, backend);
        IndexStorageService service = new IndexStorageService(query);
        ServiceBuilder indexBuilder = target.addService(indexStorageServiceName, (Service)service);
        indexBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        this.addControllersAndDependencies(repositoryName, service, newControllers, (ServiceBuilder<IndexStorage>)indexBuilder, target);
        context.removeService(indexStorageServiceName);
        newControllers.add(indexBuilder.install());
    }

    protected abstract void writeIndexStorageConfiguration(OperationContext var1, ModelNode var2, EditableDocument var3, String var4) throws OperationFailedException;

    protected void writeIndexStorageSpecificIndexingConfiguration(OperationContext context, ModelNode storage, EditableDocument indexing) throws OperationFailedException {
        String format = ModelAttributes.INDEX_FORMAT.resolveModelAttribute(context, storage).asString();
        indexing.set("indexFormat", (Object)format);
    }

    protected void writeIndexingBackendConfiguration(OperationContext context, ModelNode storage, EditableDocument backend) throws OperationFailedException {
        backend.set("type", (Object)"lucene");
    }

    protected void addControllersAndDependencies(String repositoryName, IndexStorageService service, List<ServiceController<?>> newControllers, ServiceBuilder<IndexStorage> builder, ServiceTarget target) throws OperationFailedException {
    }
}

