/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.AbstractModeShapeRemoveStepHandler;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;

class RemoveBinaryStorage
extends AbstractModeShapeRemoveStepHandler {
    static final RemoveBinaryStorage INSTANCE = new RemoveBinaryStorage();

    private RemoveBinaryStorage() {
    }

    @Override
    List<ServiceName> servicesToRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String repositoryName = this.repositoryName(operation);
        ArrayList<ServiceName> servicesToRemove = new ArrayList<ServiceName>();
        String storeName = null;
        if (model.hasDefined("store-name")) {
            storeName = model.get("store-name").asString();
        }
        ServiceName binaryStorageServiceName = storeName != null ? ModeShapeServiceNames.binaryStorageNestedServiceName(repositoryName, storeName) : ModeShapeServiceNames.binaryStorageDefaultServiceName(repositoryName);
        servicesToRemove.add(binaryStorageServiceName);
        String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, model).asString();
        if (relativeTo.equalsIgnoreCase("jboss.server.data.dir")) {
            ServiceName dirServiceName = storeName != null ? ModeShapeServiceNames.binaryStorageDirectoryServiceName(repositoryName, storeName) : ModeShapeServiceNames.binaryStorageDirectoryServiceName(repositoryName);
            servicesToRemove.add(dirServiceName);
        }
        return servicesToRemove;
    }
}

