/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.jboss.as.controller.Extension;
import org.jboss.as.subsystem.test.AbstractSubsystemBaseTest;
import org.jboss.as.subsystem.test.AdditionalInitialization;
import org.jboss.as.subsystem.test.KernelServices;
import org.junit.Assert;
import org.junit.Test;
import org.modeshape.jboss.subsystem.ModeShapeExtension;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ModeShapeConfigurationTest
extends AbstractSubsystemBaseTest {
    private static final AdditionalInitialization NORMAL_INITIALIZATION_MODE = new AdditionalInitialization();

    public ModeShapeConfigurationTest() {
        super("modeshape", (Extension)new ModeShapeExtension());
    }

    protected String getSubsystemXml() throws IOException {
        return this.readResource("modeshape-sample-config.xml");
    }

    protected AdditionalInitialization createAdditionalInitialization() {
        return NORMAL_INITIALIZATION_MODE;
    }

    protected String getSubsystemXml(String configId) throws IOException {
        return configId != null ? this.readResource("modeshape-" + configId + "-config.xml") : this.getSubsystemXml();
    }

    @Test
    public void testMinimalConfigurationWithOneMinimalRepository() throws Exception {
        this.standardSubsystemTest("minimal");
    }

    @Test
    public void testFullConfiguration() throws Exception {
        this.standardSubsystemTest("full");
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithLocalFileIndexStorage() throws Exception {
        this.parse(this.readResource("modeshape-local-file-index-storage.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithFileBinaryStorage() throws Exception {
        this.parse(this.readResource("modeshape-file-binary-storage.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithCacheBinaryStorage() throws Exception {
        this.parse(this.readResource("modeshape-cache-binary-storage.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithCompositeBinaryStores() throws Exception {
        this.parse(this.readResource("modeshape-composite-binary-storage-config.xml"));
    }

    @Test(expected=XMLStreamException.class)
    public void shouldRejectInvalidCompositeBinaryStoreConfiguration() throws Exception {
        this.parse(this.readResource("modeshape-invalid-composite-binary-storage.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithWorkspaceInitialContent() throws Exception {
        this.parse(this.readResource("modeshape-initial-content-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithNodeTypes() throws Exception {
        this.parse(this.readResource("modeshape-node-types-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithCustomAuthenticators() throws Exception {
        this.parse(this.readResource("modeshape-custom-authenticators-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithWorkspacesCacheContainer() throws Exception {
        this.parse(this.readResource("modeshape-workspaces-cache-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithExternalSources() throws Exception {
        this.parse(this.readResource("modeshape-federation-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithDisabledQueries() throws Exception {
        this.parse(this.readResource("modeshape-disabled-queries.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithGarbageCollectionSpecified() throws Exception {
        this.parse(this.readResource("modeshape-garbage-collection.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithCustomIndexRebuildOptions() throws Exception {
        this.parse(this.readResource("modeshape-index-rebuilding-config.xml"));
    }

    @Test
    public void testOutputPersistenceOfConfigurationWithWebapps() throws Exception {
        this.parse(this.readResource("modeshape-webapp-config.xml"));
    }

    @Test
    public void testAnonymousRolesConfiguration() throws Exception {
        this.standardSubsystemTest("anonymous");
    }

    @Test
    public void testSequencingConfiguration() throws Exception {
        this.standardSubsystemTest("sequencing");
    }

    @Test
    public void testSchema() throws Exception {
        String subsystemXml = this.readResource("modeshape-sample-config.xml");
        this.validate(subsystemXml);
        KernelServices services = this.initKernel(subsystemXml);
        services.readWholeModel();
        String marshalled = services.getPersistedSubsystemXml();
        this.validate(marshalled);
    }

    private KernelServices initKernel(String subsystemXml) throws Exception {
        return super.createKernelServicesBuilder(NORMAL_INITIALIZATION_MODE).setSubsystemXml(subsystemXml).build();
    }

    private void validate(String marshalled) throws SAXException, IOException {
        URL xsdURL = Thread.currentThread().getContextClassLoader().getResource("schema/modeshape_1_0.xsd");
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema schema = factory.newSchema(xsdURL);
        Validator validator = schema.newValidator();
        StreamSource source = new StreamSource(new ByteArrayInputStream(marshalled.getBytes()));
        validator.setErrorHandler(new ErrorHandler(){

            @Override
            public void warning(SAXParseException exception) {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void fatalError(SAXParseException exception) {
                Assert.fail((String)exception.getMessage());
            }

            @Override
            public void error(SAXParseException exception) {
                if (exception.getMessage().contains("cvc-enumeration-valid")) {
                    return;
                }
                if (exception.getMessage().contains("cvc-type")) {
                    return;
                }
                Assert.fail((String)exception.getMessage());
            }
        });
        validator.validate(source);
    }
}

