/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.AbstractModeShapeRemoveStepHandler;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;

class RemoveIndexStorage
extends AbstractModeShapeRemoveStepHandler {
    static final RemoveIndexStorage INSTANCE = new RemoveIndexStorage();

    private RemoveIndexStorage() {
    }

    @Override
    List<ServiceName> servicesToRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String sourceRelativeTo;
        String repositoryName = this.repositoryName(operation);
        ArrayList<ServiceName> servicesToRemove = new ArrayList<ServiceName>();
        servicesToRemove.add(ModeShapeServiceNames.indexStorageServiceName(repositoryName));
        String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, model).asString();
        if (relativeTo.equalsIgnoreCase("jboss.server.data.dir")) {
            servicesToRemove.add(ModeShapeServiceNames.indexStorageDirectoryServiceName(repositoryName));
        }
        if ((sourceRelativeTo = ModelAttributes.SOURCE_RELATIVE_TO.resolveModelAttribute(context, model).asString()).equalsIgnoreCase("jboss.server.data.dir")) {
            servicesToRemove.add(ModeShapeServiceNames.indexSourceStorageDirectoryServiceName(repositoryName));
        }
        return servicesToRemove;
    }
}

