/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddFileSystemIndexStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddMasterFileSystemIndexStorage
extends AbstractAddFileSystemIndexStorage {
    public static final AddMasterFileSystemIndexStorage INSTANCE = new AddMasterFileSystemIndexStorage();

    private AddMasterFileSystemIndexStorage() {
    }

    @Override
    protected void writeIndexingBackendConfiguration(OperationContext context, ModelNode storage, EditableDocument backend) throws OperationFailedException {
        backend.set("type", (Object)"jms-master");
        String connJndi = ModelAttributes.CONNECTION_FACTORY_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        String queueJndi = ModelAttributes.QUEUE_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        backend.set("connectionFactoryJndiName", (Object)connJndi);
        backend.set("queueJndiName", (Object)queueJndi);
    }

    @Override
    protected void writeIndexStorageConfiguration(OperationContext context, ModelNode storage, EditableDocument indexStorage, String repositoryName) throws OperationFailedException {
        indexStorage.set("type", (Object)"filesystem-master");
        this.processLocalIndexStorageLocation(context, storage, repositoryName, indexStorage);
        this.processSourceIndexStorageLocation(context, storage, repositoryName, indexStorage);
        String accessType = ModelAttributes.ACCESS_TYPE.resolveModelAttribute(context, storage).asString();
        indexStorage.set("fileSystemAccessType", (Object)accessType.toLowerCase());
        String locking = ModelAttributes.LOCKING_STRATEGY.resolveModelAttribute(context, storage).asString();
        indexStorage.set("lockingStrategy", (Object)locking.toLowerCase());
        String refresh = ModelAttributes.REFRESH_PERIOD.resolveModelAttribute(context, storage).asString();
        indexStorage.set("refreshInSeconds", (Object)refresh);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddMasterFileSystemIndexStorage.populate(operation, model, ModelAttributes.MASTER_FILE_INDEX_STORAGE_ATTRIBUTES);
    }
}

