/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import org.infinispan.schematic.document.EditableDocument;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.modeshape.jboss.subsystem.AbstractAddFileSystemIndexStorage;
import org.modeshape.jboss.subsystem.ModelAttributes;

public class AddSlaveFileSystemIndexStorage
extends AbstractAddFileSystemIndexStorage {
    public static final AddSlaveFileSystemIndexStorage INSTANCE = new AddSlaveFileSystemIndexStorage();

    private AddSlaveFileSystemIndexStorage() {
    }

    @Override
    protected void writeIndexingBackendConfiguration(OperationContext context, ModelNode storage, EditableDocument backend) throws OperationFailedException {
        backend.set("type", (Object)"jms-slave");
        String connJndi = ModelAttributes.CONNECTION_FACTORY_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        String queueJndi = ModelAttributes.QUEUE_JNDI_NAME.resolveModelAttribute(context, storage).asString();
        backend.set("connectionFactoryJndiName", (Object)connJndi);
        backend.set("queueJndiName", (Object)queueJndi);
    }

    @Override
    protected void writeIndexStorageConfiguration(OperationContext context, ModelNode storage, EditableDocument indexStorage, String repositoryName) throws OperationFailedException {
        indexStorage.set("type", (Object)"filesystem-slave");
        this.processLocalIndexStorageLocation(context, storage, repositoryName, indexStorage);
        this.processSourceIndexStorageLocation(context, storage, repositoryName, indexStorage);
        String accessType = ModelAttributes.ACCESS_TYPE.resolveModelAttribute(context, storage).asString();
        indexStorage.set("fileSystemAccessType", (Object)accessType.toLowerCase());
        String locking = ModelAttributes.LOCKING_STRATEGY.resolveModelAttribute(context, storage).asString();
        indexStorage.set("lockingStrategy", (Object)locking.toLowerCase());
        int refresh = ModelAttributes.REFRESH_PERIOD.resolveModelAttribute(context, storage).asInt();
        indexStorage.set("refreshInSeconds", (Object)refresh);
        int copyBufferSize = ModelAttributes.COPY_BUFFER_SIZE.resolveModelAttribute(context, storage).asInt();
        indexStorage.set("copyBufferSizeInMegabytes", (Object)copyBufferSize);
        int retryLookup = ModelAttributes.RETRY_MARKER_LOOKUP.resolveModelAttribute(context, storage).asInt();
        indexStorage.set("retryMarkerLookup", (Object)retryLookup);
        int retryPeriod = ModelAttributes.RETRY_INITIALIZE_PERIOD.resolveModelAttribute(context, storage).asInt();
        indexStorage.set("retryInitializePeriodInSeconds", (Object)retryPeriod);
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        AddSlaveFileSystemIndexStorage.populate(operation, model, ModelAttributes.SLAVE_FILE_INDEX_STORAGE_ATTRIBUTES);
    }
}

