/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.modeshape.jboss.subsystem.AbstractModeShapeRemoveStepHandler;
import org.modeshape.jboss.subsystem.ModeShapeServiceNames;
import org.modeshape.jboss.subsystem.ModelAttributes;

class RemoveIndexStorage
extends AbstractModeShapeRemoveStepHandler {
    static final RemoveIndexStorage INSTANCE = new RemoveIndexStorage();

    private RemoveIndexStorage() {
    }

    @Override
    List<ServiceName> servicesToRemove(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        String sourceRelativeTo;
        String indexStorageType;
        ArrayList<ServiceName> servicesToRemove = new ArrayList<ServiceName>();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String lastElementKey = pathAddress.getLastElement().getKey();
        String string = indexStorageType = lastElementKey.equalsIgnoreCase("storage-type") ? pathAddress.getLastElement().getValue() : null;
        if (indexStorageType == null) {
            return servicesToRemove;
        }
        String repositoryName = this.repositoryName(operation);
        servicesToRemove.add(ModeShapeServiceNames.indexStorageServiceName(repositoryName));
        if ("custom-index-storage".equalsIgnoreCase(indexStorageType) || "ram-index-storage".equalsIgnoreCase(indexStorageType)) {
            return servicesToRemove;
        }
        String relativeTo = ModelAttributes.RELATIVE_TO.resolveModelAttribute(context, model).asString();
        if (relativeTo.equalsIgnoreCase("jboss.server.data.dir")) {
            servicesToRemove.add(ModeShapeServiceNames.indexStorageDirectoryServiceName(repositoryName));
        }
        if ((indexStorageType.equalsIgnoreCase("master-file-index-storage") || indexStorageType.equals("slave-file-index-storage")) && (sourceRelativeTo = ModelAttributes.SOURCE_RELATIVE_TO.resolveModelAttribute(context, model).asString()).equalsIgnoreCase("jboss.server.data.dir")) {
            servicesToRemove.add(ModeShapeServiceNames.indexSourceStorageDirectoryServiceName(repositoryName));
        }
        return servicesToRemove;
    }
}

