/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.service;

import java.util.List;
import java.util.Properties;
import javax.jcr.RepositoryException;
import org.infinispan.schematic.Schematic;
import org.infinispan.schematic.document.Changes;
import org.infinispan.schematic.document.EditableDocument;
import org.infinispan.schematic.document.Editor;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.ConfigurationException;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;

public class TextExtractorService
implements Service<JcrRepository> {
    private final InjectedValue<ModeShapeEngine> engineInjector = new InjectedValue();
    private final InjectedValue<JcrRepository> jcrRepositoryInjector = new InjectedValue();
    private final Properties extractorProperties;
    private final String repositoryName;

    public TextExtractorService(String repositoryName, Properties extractorProperties) {
        this.repositoryName = repositoryName;
        this.extractorProperties = extractorProperties;
    }

    public JcrRepository getValue() throws IllegalStateException, IllegalArgumentException {
        return (JcrRepository)this.jcrRepositoryInjector.getValue();
    }

    private ModeShapeEngine getModeShapeEngine() {
        return (ModeShapeEngine)this.engineInjector.getValue();
    }

    public void start(StartContext arg0) throws StartException {
        ModeShapeEngine engine = this.getModeShapeEngine();
        JcrRepository repository = null;
        try {
            repository = engine.getRepository(this.repositoryName);
        }
        catch (NoSuchRepositoryException e) {
            throw new StartException((Throwable)e);
        }
        RepositoryConfiguration repositoryConfig = repository.getConfiguration();
        Editor configEditor = repositoryConfig.edit();
        EditableDocument textExtracting = configEditor.getOrCreateDocument("textExtraction");
        EditableDocument extractors = textExtracting.getOrCreateDocument("extractors");
        EditableDocument extractor = Schematic.newDocument();
        String extractorName = this.extractorProperties.getProperty("name");
        for (Object key : this.extractorProperties.keySet()) {
            String keyStr = (String)key;
            if ("name".equals(keyStr)) continue;
            Object value = this.extractorProperties.get(keyStr);
            if (value instanceof List) {
                for (Object val : (List)value) {
                    extractor.getOrCreateArray(keyStr).addValue(val);
                }
                continue;
            }
            extractor.set(keyStr, value);
        }
        extractors.set(extractorName, (Object)extractor);
        Changes changes = configEditor.getChanges();
        Problems validationResults = repositoryConfig.validate(changes);
        if (validationResults.hasErrors()) {
            String msg = JcrI18n.errorsInRepositoryConfiguration.text(new Object[]{this.repositoryName, validationResults.errorCount(), validationResults.toString()});
            throw new StartException(msg);
        }
        try {
            engine.update(this.repositoryName, changes);
        }
        catch (ConfigurationException e) {
            throw new StartException((Throwable)e);
        }
        catch (NoSuchRepositoryException e) {
            throw new StartException((Throwable)e);
        }
        catch (RepositoryException e) {
            throw new StartException((Throwable)e);
        }
    }

    public void stop(StopContext arg0) {
    }

    public InjectedValue<ModeShapeEngine> getModeShapeEngineInjector() {
        return this.engineInjector;
    }

    public InjectedValue<JcrRepository> getJcrRepositoryInjector() {
        return this.jcrRepositoryInjector;
    }
}

