/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jboss.subsystem;

import java.util.List;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.modeshape.jboss.subsystem.ModeShapeAuthenticatorResource;
import org.modeshape.jboss.subsystem.ModeShapeBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCacheBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCompositeBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeCustomBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeDatabaseBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeFileBinaryStorageResource;
import org.modeshape.jboss.subsystem.ModeShapeIndexDefinitionResource;
import org.modeshape.jboss.subsystem.ModeShapeIndexProviderResource;
import org.modeshape.jboss.subsystem.ModeShapeRepositoryResource;
import org.modeshape.jboss.subsystem.ModeShapeRootResource;
import org.modeshape.jboss.subsystem.ModeShapeSequencerResource;
import org.modeshape.jboss.subsystem.ModeShapeSourceResource;
import org.modeshape.jboss.subsystem.ModeShapeSubsystemXMLWriter;
import org.modeshape.jboss.subsystem.ModeShapeTextExtractorResource;
import org.modeshape.jboss.subsystem.ModeShapeWebAppResource;
import org.modeshape.jboss.subsystem.Namespace;

public class ModeShapeExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "modeshape";
    public static final String JBOSS_DATA_DIR_VARIABLE = "jboss.server.data.dir";
    private static final int MANAGEMENT_API_MAJOR_VERSION = 1;
    private static final int MANAGEMENT_API_MINOR_VERSION = 2;
    private static final String RESOURCE_NAME = ModeShapeExtension.class.getPackage().getName() + ".LocalDescriptions";
    static final PathElement SUBSYSTEM_PATH = PathElement.pathElement((String)"subsystem", (String)"modeshape");
    static final PathElement WEBAPP_PATH = PathElement.pathElement((String)"webapp");
    static final PathElement REPOSITORY_PATH = PathElement.pathElement((String)"repository");
    static final PathElement SEQUENCER_PATH = PathElement.pathElement((String)"sequencer");
    static final PathElement INDEX_PROVIDER_PATH = PathElement.pathElement((String)"index-provider");
    static final PathElement INDEX_DEFINITION_PATH = PathElement.pathElement((String)"index");
    static final PathElement SOURCE_PATH = PathElement.pathElement((String)"source");
    static final PathElement TEXT_EXTRACTOR_PATH = PathElement.pathElement((String)"text-extractor");
    static final PathElement AUTHENTICATOR_PATH = PathElement.pathElement((String)"authenticator");

    static StandardResourceDescriptionResolver getResourceDescriptionResolver(String ... keyPrefix) {
        StringBuilder prefix = new StringBuilder(SUBSYSTEM_NAME);
        for (String kp : keyPrefix) {
            prefix.append('.').append(kp);
        }
        return new StandardResourceDescriptionResolver(prefix.toString(), RESOURCE_NAME, ModeShapeExtension.class.getClassLoader(), true, false);
    }

    public void initialize(ExtensionContext context) {
        SubsystemRegistration registration = context.registerSubsystem(SUBSYSTEM_NAME, 1, 2);
        registration.registerXMLElementWriter((XMLElementWriter)new ModeShapeSubsystemXMLWriter());
        ManagementResourceRegistration modeShapeSubsystem = registration.registerSubsystemModel((ResourceDefinition)ModeShapeRootResource.INSTANCE);
        modeShapeSubsystem.registerSubModel((ResourceDefinition)ModeShapeWebAppResource.INSTANCE);
        ManagementResourceRegistration repositorySubmodel = modeShapeSubsystem.registerSubModel((ResourceDefinition)ModeShapeRepositoryResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeSequencerResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeIndexProviderResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeIndexDefinitionResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeSourceResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeTextExtractorResource.INSTANCE);
        repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeAuthenticatorResource.INSTANCE);
        ManagementResourceRegistration binaryStorageSubmodel = repositorySubmodel.registerSubModel((ResourceDefinition)ModeShapeBinaryStorageResource.INSTANCE);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeFileBinaryStorageResource.DEFAULT);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCacheBinaryStorageResource.DEFAULT);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeDatabaseBinaryStorageResource.DEFAULT);
        binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCustomBinaryStorageResource.DEFAULT);
        ManagementResourceRegistration compositeStorageSubmodel = binaryStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCompositeBinaryStorageResource.INSTANCE);
        compositeStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeFileBinaryStorageResource.NESTED);
        compositeStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCacheBinaryStorageResource.NESTED);
        compositeStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeDatabaseBinaryStorageResource.NESTED);
        compositeStorageSubmodel.registerSubModel((ResourceDefinition)ModeShapeCustomBinaryStorageResource.NESTED);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        for (Namespace namespace : Namespace.values()) {
            XMLElementReader<List<ModelNode>> reader = namespace.getXMLReader();
            if (reader == null) continue;
            context.setSubsystemXmlMapping(SUBSYSTEM_NAME, namespace.getUri(), reader);
        }
    }

    public static final class ModuleID {
        public static final String MAIN = "org.modeshape";
    }
}

