/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jca;

import java.io.PrintWriter;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.modeshape.common.logging.Logger;
import org.modeshape.jca.JcrConnectionRequestInfo;
import org.modeshape.jca.JcrManagedConnectionFactory;
import org.modeshape.jca.JcrManagedConnectionMetaData;
import org.modeshape.jca.JcrSessionHandle;

public class JcrManagedConnection
implements ManagedConnection {
    private static final Logger LOGGER = Logger.getLogger(JcrManagedConnection.class);
    private PrintWriter logwriter;
    private final JcrManagedConnectionFactory mcf;
    private final List<ConnectionEventListener> listeners = new CopyOnWriteArrayList<ConnectionEventListener>();
    private final JcrConnectionRequestInfo cri;
    private Session session;
    private final List<JcrSessionHandle> handles = new CopyOnWriteArrayList<JcrSessionHandle>();

    public JcrManagedConnection(JcrManagedConnectionFactory mcf, JcrConnectionRequestInfo cri) throws ResourceException {
        this.mcf = mcf;
        this.cri = cri;
        this.logwriter = null;
        this.session = this.openSession();
    }

    public JcrManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    public JcrConnectionRequestInfo getConnectionRequestInfo() {
        return this.cri;
    }

    private void addHandle(JcrSessionHandle handle) {
        this.handles.add(handle);
    }

    private void removeHandle(JcrSessionHandle handle) {
        this.handles.remove(handle);
    }

    private Session openSession() throws ResourceException {
        try {
            Repository repo = this.mcf.getRepository();
            Session s = repo.login(this.cri.getCredentials(), this.cri.getWorkspace());
            return s;
        }
        catch (RepositoryException e) {
            throw new ResourceException("Failed to create session: " + e.getMessage(), (Throwable)e);
        }
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        JcrSessionHandle handle = new JcrSessionHandle(this);
        this.addHandle(handle);
        return handle;
    }

    public void associateConnection(Object connection) throws ResourceException {
        JcrSessionHandle handle = (JcrSessionHandle)connection;
        if (handle.getManagedConnection() != this) {
            handle.getManagedConnection().removeHandle(handle);
            handle.setManagedConnection(this);
            this.addHandle(handle);
        }
    }

    public void cleanup() throws ResourceException {
        this.session.logout();
        this.session = this.openSession();
        this.handles.clear();
    }

    public void destroy() throws ResourceException {
        LOGGER.debug("Shutting down connection to repo '{0}'", new Object[]{this.mcf.getRepositoryURL()});
        this.session.logout();
        this.handles.clear();
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener is null");
        }
        this.listeners.remove(listener);
    }

    protected void closeHandle(JcrSessionHandle handle) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)handle);
        for (ConnectionEventListener cel : this.listeners) {
            cel.connectionClosed(event);
        }
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logwriter;
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logwriter = out;
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        return null;
    }

    public XAResource getXAResource() throws ResourceException {
        return (XAResource)this.session;
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        try {
            return new JcrManagedConnectionMetaData(this.mcf.getRepository(), this.session);
        }
        catch (Exception e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public Session getSession(JcrSessionHandle handle) {
        if (this.handles.size() > 0 && this.handles.get(0) == handle) {
            return this.session;
        }
        throw new IllegalStateException("Inactive logical session handle called");
    }
}

