/*
 * ModeShape (http://www.modeshape.org)
 * See the COPYRIGHT.txt file distributed with this work for information
 * regarding copyright ownership.  Some portions may be licensed
 * to Red Hat, Inc. under one or more contributor license agreements.
 * See the AUTHORS.txt file in the distribution for a full listing of
 * individual contributors.
 *
 * ModeShape is free software. Unless otherwise indicated, all code in ModeShape
 * is licensed to you under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * ModeShape is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org
 */
package org.modeshape.jcr.api;

/**
 * Class which should hold string constants defined by the JCR spec.
 * 
 * @author Horia Chiorean
 */
public final class JcrConstants {
    public static final String JCR_CONTENT = "jcr:content";
    public static final String JCR_NAME = "jcr:name";
    public static final String JCR_PATH = "jcr:path";
    public static final String JCR_SCORE = "jcr:score";
    public static final String JCR_DATA = "jcr:data";
    public static final String JCR_MIXIN_TYPES = "jcr:mixinTypes";
    public static final String JCR_PRIMARY_TYPE = "jcr:primaryType";
    public static final String JCR_MIME_TYPE = "jcr:mimeType";

    public static final String NT_UNSTRUCTURED = "nt:unstructured";
    public static final String NT_FOLDER = "nt:folder";
    public static final String NT_FILE = "nt:file";
    public static final String NT_RESOURCE = "nt:resource";

    public static final String MIX_LAST_MODIFIED = "mix:lastModified";
    public static final String MIX_REFERENCEABLE = "mix:referenceable";

    public static final String MODE_LOCAL_NAME = "mode:localName";
    public static final String MODE_DEPTH = "mode:depth";
    public static final String MODE_SHA1 = "mode:sha1";

    private JcrConstants() {
    }
}
