/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeType;
import net.jcip.annotations.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.basic.BasicName;
import org.modeshape.jcr.DefinitionCache;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
class JcrNodeType
implements NodeType {
    public static final String RESIDUAL_ITEM_NAME = "*";
    public static final Name RESIDUAL_NAME = new BasicName("", "*");
    private final Name name;
    private final Name primaryItemName;
    private final List<JcrNodeType> declaredSupertypes;
    private final List<JcrNodeType> allSupertypes;
    private final List<JcrNodeType> thisAndAllSupertypes;
    private final Set<Name> thisAndAllSupertypesNames;
    private boolean mixin;
    private boolean orderableChildNodes;
    private final List<JcrNodeDefinition> childNodeDefinitions;
    private final List<JcrPropertyDefinition> propertyDefinitions;
    private final DefinitionCache allDefinitions;
    private ExecutionContext context;
    private RepositoryNodeTypeManager nodeTypeManager;

    JcrNodeType(ExecutionContext context, RepositoryNodeTypeManager nodeTypeManager, Name name, List<JcrNodeType> declaredSupertypes, Name primaryItemName, Collection<JcrNodeDefinition> childNodeDefinitions, Collection<JcrPropertyDefinition> propertyDefinitions, boolean mixin, boolean orderableChildNodes) {
        assert (context != null);
        this.context = context;
        this.nodeTypeManager = nodeTypeManager;
        this.name = name;
        this.primaryItemName = primaryItemName;
        this.declaredSupertypes = declaredSupertypes != null ? declaredSupertypes : Collections.emptyList();
        this.mixin = mixin;
        this.orderableChildNodes = orderableChildNodes;
        this.propertyDefinitions = new ArrayList<JcrPropertyDefinition>(propertyDefinitions.size());
        for (JcrPropertyDefinition property : propertyDefinitions) {
            this.propertyDefinitions.add(property.with(this));
        }
        this.childNodeDefinitions = new ArrayList<JcrNodeDefinition>(childNodeDefinitions.size());
        for (JcrNodeDefinition childNode : childNodeDefinitions) {
            this.childNodeDefinitions.add(childNode.with(this));
        }
        LinkedList<JcrNodeType> thisAndAllSupertypes = new LinkedList<JcrNodeType>();
        HashSet<Name> typeNames = new HashSet<Name>();
        thisAndAllSupertypes.add(this);
        typeNames.add(this.name);
        for (int i = 0; i != thisAndAllSupertypes.size(); ++i) {
            JcrNodeType superType = (JcrNodeType)thisAndAllSupertypes.get(i);
            for (JcrNodeType superSuperType : superType.getDeclaredSupertypes()) {
                JcrNodeType jcrSuperSuperType = superSuperType;
                if (jcrSuperSuperType == null) {
                    assert (JcrNtLexicon.BASE.equals(name));
                    continue;
                }
                if (!typeNames.add(jcrSuperSuperType.getInternalName())) continue;
                thisAndAllSupertypes.add(jcrSuperSuperType);
            }
        }
        this.thisAndAllSupertypes = Collections.unmodifiableList(thisAndAllSupertypes);
        this.allSupertypes = thisAndAllSupertypes.size() > 1 ? thisAndAllSupertypes.subList(1, thisAndAllSupertypes.size()) : Collections.emptyList();
        this.thisAndAllSupertypesNames = Collections.unmodifiableSet(typeNames);
        this.allDefinitions = new DefinitionCache(this);
    }

    List<JcrNodeType> getTypeAndSupertypes() {
        return this.thisAndAllSupertypes;
    }

    List<JcrNodeType> supertypes() {
        return this.allSupertypes;
    }

    List<JcrNodeDefinition> childNodeDefinitions() {
        return this.childNodeDefinitions;
    }

    List<JcrPropertyDefinition> propertyDefinitions() {
        return this.propertyDefinitions;
    }

    Collection<JcrPropertyDefinition> allSingleValuePropertyDefinitions(Name propertyName) {
        return this.allDefinitions.allSingleValuePropertyDefinitions(propertyName);
    }

    Collection<JcrPropertyDefinition> allMultiValuePropertyDefinitions(Name propertyName) {
        return this.allDefinitions.allMultiValuePropertyDefinitions(propertyName);
    }

    Collection<JcrPropertyDefinition> allPropertyDefinitions(Name propertyName) {
        return this.allDefinitions.allPropertyDefinitions(propertyName);
    }

    Collection<JcrNodeDefinition> allChildNodeDefinitions(Name childName, boolean requireSns) {
        return this.allDefinitions.allChildNodeDefinitions(childName, requireSns);
    }

    Collection<JcrNodeDefinition> allChildNodeDefinitions(Name childName) {
        return this.allDefinitions.allChildNodeDefinitions(childName);
    }

    JcrNodeDefinition childNodeDefinition(NodeDefinitionId nodeDefnId) {
        List<Name> requiredPrimaryTypeNames = Arrays.asList(nodeDefnId.getRequiredPrimaryTypes());
        for (JcrNodeDefinition nodeDefn : this.allChildNodeDefinitions(nodeDefnId.getChildDefinitionName())) {
            if (nodeDefn.getRequiredPrimaryTypeNames().size() != requiredPrimaryTypeNames.size() || !nodeDefn.getRequiredPrimaryTypeNames().containsAll(requiredPrimaryTypeNames)) continue;
            return nodeDefn;
        }
        return null;
    }

    public boolean canAddChildNode(String childNodeName) {
        CheckArg.isNotNull((Object)childNodeName, (String)"childNodeName");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create(childNodeName);
        return this.nodeTypeManager().findChildNodeDefinition(this.name, null, childName, null, 0, true) != null;
    }

    public boolean canAddChildNode(String childNodeName, String primaryNodeTypeName) {
        CheckArg.isNotNull((Object)childNodeName, (String)"childNodeName");
        CheckArg.isNotNull((Object)primaryNodeTypeName, (String)"primaryNodeTypeName");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create(childNodeName);
        Name childPrimaryTypeName = (Name)this.context.getValueFactories().getNameFactory().create(primaryNodeTypeName);
        return this.nodeTypeManager().findChildNodeDefinition(this.name, null, childName, childPrimaryTypeName, 0, true) != null;
    }

    public boolean canRemoveNode(String itemName) {
        CheckArg.isNotNull((Object)itemName, (String)"itemName");
        Name childName = (Name)this.context.getValueFactories().getNameFactory().create(itemName);
        return this.nodeTypeManager().canRemoveAllChildren(this.name, null, childName, true);
    }

    public boolean canRemoveItem(String itemName) {
        return this.canRemoveNode(itemName) || this.canRemoveProperty(itemName);
    }

    boolean canCastToTypeAndMatchesConstraints(JcrPropertyDefinition propertyDefinition, Value value) {
        try {
            assert (value instanceof JcrValue) : "Illegal implementation of Value interface";
            ((JcrValue)value).asType(propertyDefinition.getRequiredType());
            return propertyDefinition.satisfiesConstraints(value);
        }
        catch (ValueFormatException vfe) {
            return false;
        }
    }

    boolean canCastToTypeAndMatchesConstraints(JcrPropertyDefinition propertyDefinition, Value[] values) {
        for (Value value : values) {
            if (this.canCastToTypeAndMatchesConstraints(propertyDefinition, value)) continue;
            return false;
        }
        return true;
    }

    public boolean canSetProperty(String propertyName, Value value) {
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        return this.nodeTypeManager().findPropertyDefinition(this.name, null, name, value, false, true) != null;
    }

    public boolean canSetProperty(String propertyName, Value[] values) {
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        if (values == null || values.length == 0) {
            return this.canRemoveProperty(propertyName);
        }
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        return this.nodeTypeManager().findPropertyDefinition(this.name, null, name, values, true) != null;
    }

    public boolean canRemoveProperty(String propertyName) {
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(propertyName);
        return this.nodeTypeManager().canRemoveProperty(this.name, null, name, true);
    }

    public JcrNodeDefinition[] getDeclaredChildNodeDefinitions() {
        return this.childNodeDefinitions.toArray(new JcrNodeDefinition[this.childNodeDefinitions.size()]);
    }

    public JcrNodeDefinition[] getChildNodeDefinitions() {
        Collection<JcrNodeDefinition> definitions = this.allDefinitions.allChildNodeDefinitions();
        return definitions.toArray(new JcrNodeDefinition[definitions.size()]);
    }

    public JcrPropertyDefinition[] getPropertyDefinitions() {
        Collection<JcrPropertyDefinition> definitions = this.allDefinitions.allPropertyDefinitions();
        return definitions.toArray(new JcrPropertyDefinition[definitions.size()]);
    }

    public JcrNodeType[] getDeclaredSupertypes() {
        return this.declaredSupertypes.toArray(new JcrNodeType[this.declaredSupertypes.size()]);
    }

    public String getName() {
        return this.name.getString(this.context.getNamespaceRegistry());
    }

    Name getInternalName() {
        return this.name;
    }

    Name getInternalPrimaryItemName() {
        return this.primaryItemName;
    }

    public String getPrimaryItemName() {
        if (this.primaryItemName == null) {
            return null;
        }
        return this.primaryItemName.getString(this.context.getNamespaceRegistry());
    }

    public JcrPropertyDefinition[] getDeclaredPropertyDefinitions() {
        return this.propertyDefinitions.toArray(new JcrPropertyDefinition[this.propertyDefinitions.size()]);
    }

    public NodeType[] getSupertypes() {
        return this.allSupertypes.toArray(new NodeType[this.allSupertypes.size()]);
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean isNodeType(String nodeTypeName) {
        if (nodeTypeName == null) {
            return false;
        }
        Name name = (Name)this.context.getValueFactories().getNameFactory().create(nodeTypeName);
        return this.thisAndAllSupertypesNames.contains(name);
    }

    boolean isNodeType(Name nodeTypeName) {
        if (nodeTypeName == null) {
            return false;
        }
        return this.thisAndAllSupertypesNames.contains(nodeTypeName);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof JcrNodeType) {
            JcrNodeType that = (JcrNodeType)obj;
            return this.name.equals(that.name);
        }
        if (obj instanceof NodeType) {
            NodeType that = (NodeType)obj;
            return this.getName().equals(that.getName());
        }
        return false;
    }

    public String toString() {
        return this.getName();
    }

    final JcrNodeType with(RepositoryNodeTypeManager nodeTypeManager) {
        return new JcrNodeType(this.context, nodeTypeManager, this.name, this.declaredSupertypes, this.primaryItemName, this.childNodeDefinitions, this.propertyDefinitions, this.mixin, this.orderableChildNodes);
    }

    final JcrNodeType with(ExecutionContext context) {
        return new JcrNodeType(context, this.nodeTypeManager, this.name, this.declaredSupertypes, this.primaryItemName, this.childNodeDefinitions, this.propertyDefinitions, this.mixin, this.orderableChildNodes);
    }

    final RepositoryNodeTypeManager nodeTypeManager() {
        return this.nodeTypeManager;
    }

    final boolean conflictsWith(NodeType primaryNodeType, NodeType[] mixinNodeTypes) {
        NodeDefinitionId nid;
        PropertyDefinitionId pid;
        HashMap<PropertyDefinitionId, JcrPropertyDefinition> props = new HashMap<PropertyDefinitionId, JcrPropertyDefinition>();
        Name DEFAULT_NAME = this.name;
        for (JcrPropertyDefinition property : this.propertyDefinitions()) {
            pid = new PropertyDefinitionId(DEFAULT_NAME, property.name, 0, property.isMultiple());
            props.put(pid, property);
        }
        if (primaryNodeType.getName().equals(this.getName())) {
            return true;
        }
        for (JcrPropertyDefinition property : ((JcrNodeType)primaryNodeType).propertyDefinitions()) {
            String propTypeName;
            String oldPropTypeName;
            pid = new PropertyDefinitionId(DEFAULT_NAME, property.name, 0, property.isMultiple());
            JcrPropertyDefinition oldProp = props.put(pid, property);
            if (oldProp == null || (oldPropTypeName = oldProp.getDeclaringNodeType().getName()).equals(propTypeName = property.getDeclaringNodeType().getName())) continue;
            return true;
        }
        for (NodeType mixinNodeType : mixinNodeTypes) {
            if (mixinNodeType.getName().equals(this.getName())) {
                return true;
            }
            for (JcrPropertyDefinition property : ((JcrNodeType)mixinNodeType).propertyDefinitions()) {
                String propTypeName;
                String oldPropTypeName;
                PropertyDefinitionId pid2 = new PropertyDefinitionId(DEFAULT_NAME, property.name, 0, property.isMultiple());
                JcrPropertyDefinition oldProp = props.put(pid2, property);
                if (oldProp == null || (oldPropTypeName = oldProp.getDeclaringNodeType().getName()).equals(propTypeName = property.getDeclaringNodeType().getName())) continue;
                return true;
            }
        }
        HashMap<NodeDefinitionId, JcrNodeDefinition> childNodes = new HashMap<NodeDefinitionId, JcrNodeDefinition>();
        for (JcrNodeDefinition childNode : this.childNodeDefinitions()) {
            nid = new NodeDefinitionId(DEFAULT_NAME, childNode.name, new Name[0]);
            childNodes.put(nid, childNode);
        }
        Iterator<JcrNodeDefinition> i$ = ((JcrNodeType)primaryNodeType).childNodeDefinitions().iterator();
        while (i$.hasNext()) {
            String childNodeTypeName;
            String oldNodeTypeName;
            JcrNodeDefinition childNode;
            nid = new NodeDefinitionId(DEFAULT_NAME, childNode.name, new Name[0]);
            childNode = i$.next();
            JcrNodeDefinition oldNode = childNodes.put(nid, childNode);
            if (oldNode == null || (oldNodeTypeName = oldNode.getDeclaringNodeType().getName()).equals(childNodeTypeName = childNode.getDeclaringNodeType().getName())) continue;
            return true;
        }
        for (NodeType mixinNodeType : mixinNodeTypes) {
            Iterator<JcrNodeDefinition> i$2 = ((JcrNodeType)mixinNodeType).childNodeDefinitions().iterator();
            while (i$2.hasNext()) {
                String childNodeTypeName;
                String oldNodeTypeName;
                JcrNodeDefinition childNode;
                NodeDefinitionId nid2 = new NodeDefinitionId(DEFAULT_NAME, childNode.name, new Name[0]);
                childNode = i$2.next();
                JcrNodeDefinition oldNode = childNodes.put(nid2, childNode);
                if (oldNode == null || (oldNodeTypeName = oldNode.getDeclaringNodeType().getName()).equals(childNodeTypeName = childNode.getDeclaringNodeType().getName())) continue;
                return true;
            }
        }
        return false;
    }
}

