/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.SessionCache;

@Immutable
abstract class AbstractJcrItem
implements Item {
    protected final SessionCache cache;

    protected AbstractJcrItem(SessionCache cache) {
        assert (cache != null);
        this.cache = cache;
    }

    public Session getSession() {
        return this.cache.session();
    }

    final JcrSession session() {
        return this.cache.session();
    }

    final ExecutionContext context() {
        return this.cache.context();
    }

    final Name nameFrom(String name) {
        return (Name)this.context().getValueFactories().getNameFactory().create(name);
    }

    final Path pathFrom(String path) {
        return (Path)this.context().getValueFactories().getPathFactory().create(path);
    }

    final Path.Segment segmentFrom(String segment) {
        return this.context().getValueFactories().getPathFactory().createSegment(segment);
    }

    final NamespaceRegistry namespaces() {
        return this.context().getNamespaceRegistry();
    }

    abstract Path path() throws RepositoryException;

    public boolean isSame(Item otherItem) throws RepositoryException {
        assert (this.getSession() != null);
        assert (otherItem.getSession() != null);
        assert (this.getSession().getRepository() != null);
        assert (otherItem.getSession().getRepository() != null);
        if (this.getSession().getRepository() != otherItem.getSession().getRepository()) {
            return false;
        }
        assert (this.getSession().getWorkspace() != null);
        assert (otherItem.getSession().getWorkspace() != null);
        String workspaceName = this.getSession().getWorkspace().getName();
        String otherWorkspaceName = otherItem.getSession().getWorkspace().getName();
        if (workspaceName == null) {
            return otherWorkspaceName == null;
        }
        return workspaceName.equals(otherWorkspaceName);
    }

    public Item getAncestor(int depth) throws RepositoryException {
        if (depth < 0) {
            throw new ItemNotFoundException(JcrI18n.noNegativeDepth.text(new Object[]{depth}));
        }
        depth = this.getDepth() - depth;
        if (depth < 0) {
            throw new ItemNotFoundException(JcrI18n.tooDeep.text(new Object[]{depth}));
        }
        AbstractJcrItem ancestor = this;
        while (--depth >= 0) {
            ancestor = ancestor.getParent();
        }
        return ancestor;
    }

    public int getDepth() throws RepositoryException {
        return this.path().size();
    }
}

