/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.text.StringCharacterIterator;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.Base64;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.jcr.AbstractJcrExporter;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSingleValueProperty;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

@NotThreadSafe
class JcrDocumentViewExporter
extends AbstractJcrExporter {
    private static final int ENCODE_BUFFER_SIZE = 65536;
    private static final TextEncoder VALUE_ENCODER = new JcrDocumentViewPropertyEncoder();

    JcrDocumentViewExporter(JcrSession session) {
        super(session, Collections.<String>emptyList());
    }

    @Override
    public void exportNode(Node node, ContentHandler contentHandler, boolean skipBinary, boolean noRecurse) throws RepositoryException, SAXException {
        ExecutionContext executionContext = this.session.getExecutionContext();
        if (node.getParent() != null && this.isXmlTextNode(node)) {
            String xmlCharacters = this.getXmlCharacters(node);
            contentHandler.characters(xmlCharacters.toCharArray(), 0, xmlCharacters.length());
            return;
        }
        ValueFactories valueFactories = executionContext.getValueFactories();
        AttributesImpl atts = new AttributesImpl();
        PropertyIterator properties = node.getProperties();
        while (properties.hasNext()) {
            String valueAsString;
            Property prop = properties.nextProperty();
            Name propName = ((AbstractJcrProperty)prop).name();
            String localPropName = this.getPrefixedName(propName);
            if (skipBinary && 2 == prop.getType()) {
                atts.addAttribute(propName.getNamespaceUri(), propName.getLocalName(), localPropName, PropertyType.nameFromValue((int)prop.getType()), "");
                continue;
            }
            Value value = prop instanceof JcrSingleValueProperty ? prop.getValue() : prop.getValues()[0];
            if (2 == prop.getType()) {
                StringBuffer buff = new StringBuffer(65536);
                try {
                    int len;
                    Base64.InputStream is = new Base64.InputStream(value.getStream(), 1);
                    byte[] bytes = new byte[65536];
                    while (-1 != (len = is.read(bytes, 0, 65536))) {
                        buff.append(new String(bytes, 0, len));
                    }
                }
                catch (IOException ioe) {
                    throw new RepositoryException((Throwable)ioe);
                }
                valueAsString = buff.toString();
            } else {
                valueAsString = VALUE_ENCODER.encode(value.getString());
            }
            atts.addAttribute(propName.getNamespaceUri(), propName.getLocalName(), localPropName, PropertyType.nameFromValue((int)prop.getType()), valueAsString);
        }
        Name name = "/".equals(node.getPath()) ? JcrLexicon.ROOT : (Name)valueFactories.getNameFactory().create(node.getName());
        this.startElement(contentHandler, name, atts);
        if (!noRecurse) {
            NodeIterator nodes = node.getNodes();
            while (nodes.hasNext()) {
                this.exportNode(nodes.nextNode(), contentHandler, skipBinary, noRecurse);
            }
        }
        this.endElement(contentHandler, name);
    }

    private boolean isXmlTextNode(Node node) throws RepositoryException {
        if (this.getPrefixedName(JcrLexicon.XMLTEXT).equals(node.getName()) && node.getNodes().getSize() == 0L) {
            PropertyIterator properties = node.getProperties();
            boolean xmlCharactersFound = false;
            while (properties.hasNext()) {
                Property property = properties.nextProperty();
                if (this.getPrefixedName(JcrLexicon.PRIMARY_TYPE).equals(property.getName())) continue;
                if (this.getPrefixedName(JcrLexicon.XMLCHARACTERS).equals(property.getName())) {
                    xmlCharactersFound = true;
                    continue;
                }
                return false;
            }
            return xmlCharactersFound;
        }
        return false;
    }

    private String getXmlCharacters(Node node) throws RepositoryException {
        assert (this.isXmlTextNode(node));
        Property xmlCharacters = node.getProperty(this.getPrefixedName(JcrLexicon.XMLCHARACTERS));
        assert (xmlCharacters != null);
        if (xmlCharacters.getDefinition().isMultiple()) {
            StringBuffer buff = new StringBuffer();
            for (Value value : xmlCharacters.getValues()) {
                buff.append(value.getString());
            }
            return buff.toString();
        }
        return xmlCharacters.getValue().getString();
    }

    protected static class JcrDocumentViewPropertyEncoder
    extends XmlNameEncoder {
        private static final Set<Character> MAPPED_CHARACTERS = new HashSet<Character>();

        protected JcrDocumentViewPropertyEncoder() {
        }

        public String encode(String text) {
            if (text == null) {
                return null;
            }
            if (text.length() == 0) {
                return text;
            }
            StringBuilder sb = new StringBuilder();
            String hex = null;
            StringCharacterIterator iter = new StringCharacterIterator(text);
            char c = iter.first();
            while (c != '\uffff') {
                if (c == '_') {
                    char next = iter.next();
                    if (next == '\uffff') {
                        sb.append(c);
                        break;
                    }
                    if (next != 'x') {
                        sb.append(c).append(next);
                    } else {
                        sb.append("_x005f_");
                        sb.append(next);
                    }
                } else if (!MAPPED_CHARACTERS.contains(Character.valueOf(c))) {
                    sb.append(c);
                } else {
                    hex = Integer.toHexString(c);
                    if (c >= '\u0000' && c <= '\u000f') {
                        sb.append("_x000").append(hex);
                    } else if (c >= '\u0010' && c <= '\u00ff') {
                        sb.append("_x00").append(hex);
                    } else if (c >= '\u0100' && c <= '\u0fff') {
                        sb.append("_x0").append(hex);
                    } else {
                        sb.append("_x").append(hex);
                    }
                    sb.append('_');
                }
                c = iter.next();
            }
            return sb.toString();
        }

        static {
            MAPPED_CHARACTERS.add(Character.valueOf(' '));
            MAPPED_CHARACTERS.add(Character.valueOf('\r'));
            MAPPED_CHARACTERS.add(Character.valueOf('\n'));
            MAPPED_CHARACTERS.add(Character.valueOf('\t'));
        }
    }
}

