/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;

@Immutable
final class NodeDefinitionId
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ANY_NAME = "*";
    private final Name nodeTypeName;
    private final Name childDefinitionName;
    private final Name[] requiredPrimaryTypes;
    private final String stringRepresentation;

    public NodeDefinitionId(Name nodeTypeName, Name childDefinitionName, Name[] requiredPrimaryTypes) {
        assert (nodeTypeName != null);
        assert (childDefinitionName != null);
        this.nodeTypeName = nodeTypeName;
        this.childDefinitionName = childDefinitionName;
        this.requiredPrimaryTypes = requiredPrimaryTypes;
        StringBuilder sb = new StringBuilder(this.nodeTypeName.getString());
        sb.append('/').append(this.childDefinitionName.getString());
        for (Name requiredPrimaryType : requiredPrimaryTypes) {
            sb.append('/');
            sb.append(requiredPrimaryType.getString());
        }
        this.stringRepresentation = sb.toString();
    }

    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    public Name getChildDefinitionName() {
        return this.childDefinitionName;
    }

    public Name[] getRequiredPrimaryTypes() {
        Name[] copy = new Name[this.requiredPrimaryTypes.length];
        System.arraycopy(this.requiredPrimaryTypes, 0, copy, 0, this.requiredPrimaryTypes.length);
        return copy;
    }

    public boolean allowsAnyChildName() {
        return this.childDefinitionName.getLocalName().equals(ANY_NAME) && this.childDefinitionName.getNamespaceUri().length() == 0;
    }

    public String getString() {
        return this.stringRepresentation;
    }

    public static NodeDefinitionId fromString(String definition, NameFactory factory) {
        String[] parts = definition.split("/");
        String nodeTypeNameString = parts[0];
        String childDefinitionNameString = parts[1];
        Name[] requiredPrimaryTypes = new Name[parts.length - 2];
        int i = 2;
        int j = 0;
        while (i != parts.length) {
            requiredPrimaryTypes[j] = (Name)factory.create(parts[i]);
            ++i;
            ++j;
        }
        Name nodeTypeName = (Name)factory.create(nodeTypeNameString);
        Name childDefinitionName = (Name)factory.create(childDefinitionNameString);
        return new NodeDefinitionId(nodeTypeName, childDefinitionName, requiredPrimaryTypes);
    }

    public int hashCode() {
        return this.stringRepresentation.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof NodeDefinitionId) {
            NodeDefinitionId that = (NodeDefinitionId)obj;
            return this.stringRepresentation.equals(that.stringRepresentation);
        }
        return false;
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

