/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.apache.lucene.document.Field;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.graph.property.basic.LocalNamespaceRegistry;
import org.modeshape.graph.query.model.AllNodes;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.validate.ImmutableSchemata;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.PropertyTypeUtil;
import org.modeshape.search.lucene.IndexRules;
import org.modeshape.search.lucene.LuceneSearchEngine;

@Immutable
class NodeTypeSchemata
implements Schemata {
    protected static final boolean DEFAULT_CAN_CONTAIN_REFERENCES = true;
    protected static final boolean DEFAULT_FULL_TEXT_SEARCHABLE = true;
    private final Schemata schemata;
    private final Map<Integer, String> types;
    private final Map<String, String> prefixesByUris = new HashMap<String, String>();
    private final boolean includeColumnsForInheritedProperties;
    private final Iterable<JcrPropertyDefinition> propertyDefinitions;
    private final Map<Name, JcrNodeType> nodeTypesByName;
    private final Multimap<JcrNodeType, JcrNodeType> subtypesByName = LinkedHashMultimap.create();
    private final IndexRules indexRules;

    NodeTypeSchemata(ExecutionContext context, Map<Name, JcrNodeType> nodeTypes, Iterable<JcrPropertyDefinition> propertyDefinitions, boolean includeColumnsForInheritedProperties) {
        this.includeColumnsForInheritedProperties = includeColumnsForInheritedProperties;
        this.propertyDefinitions = propertyDefinitions;
        this.nodeTypesByName = nodeTypes;
        for (NamespaceRegistry.Namespace namespace : context.getNamespaceRegistry().getNamespaces()) {
            this.prefixesByUris.put(namespace.getNamespaceUri(), namespace.getPrefix());
        }
        for (JcrNodeType nodeType : this.nodeTypesByName.values()) {
            for (JcrNodeType supertype : nodeType.getTypeAndSupertypes()) {
                this.subtypesByName.put((Object)supertype, (Object)nodeType);
            }
        }
        TypeSystem typeSystem = context.getValueFactories().getTypeSystem();
        ImmutableSchemata.Builder builder = ImmutableSchemata.createBuilder((TypeSystem)typeSystem);
        this.types = new HashMap<Integer, String>();
        for (String typeName : typeSystem.getTypeNames()) {
            PropertyType dnaType = PropertyType.valueOf((String)typeName);
            int jcrType = PropertyTypeUtil.jcrPropertyTypeFor(dnaType);
            this.types.put(jcrType, typeName);
        }
        IndexRules.Builder indexRulesBuilder = IndexRules.createBuilder((IndexRules)LuceneSearchEngine.DEFAULT_RULES);
        indexRulesBuilder.defaultTo(Field.Store.YES, Field.Index.ANALYZED, true, true);
        this.addAllNodesTable(builder, indexRulesBuilder, context);
        for (JcrNodeType nodeType : this.nodeTypesByName.values()) {
            this.addView(builder, context, nodeType);
        }
        this.schemata = builder.build();
        this.indexRules = indexRulesBuilder.build();
    }

    public IndexRules getIndexRules() {
        return this.indexRules;
    }

    protected JcrNodeType getNodeType(Name nodeTypeName) {
        return this.nodeTypesByName.get(nodeTypeName);
    }

    protected final void addAllNodesTable(ImmutableSchemata.Builder builder, IndexRules.Builder indexRuleBuilder, ExecutionContext context) {
        NamespaceRegistry registry = context.getNamespaceRegistry();
        TypeSystem typeSystem = context.getValueFactories().getTypeSystem();
        String tableName = AllNodes.ALL_NODES_NAME.getName();
        boolean first = true;
        HashMap<String, String> typesForNames = new HashMap<String, String>();
        HashSet<String> fullTextSearchableNames = new HashSet<String>();
        for (JcrPropertyDefinition defn : this.propertyDefinitions) {
            boolean fullTextSearchable;
            if (defn.isResidual() || defn.isPrivate()) continue;
            Name name = defn.getInternalName();
            String columnName = name.getString(registry);
            if (first) {
                builder.addTable(tableName, new String[]{columnName});
                first = false;
            }
            boolean canBeReference = false;
            switch (defn.getRequiredType()) {
                case 0: 
                case 9: {
                    canBeReference = true;
                }
            }
            String type = typeSystem.getDefaultType();
            if (defn.getRequiredType() != 0) {
                type = this.types.get(defn.getRequiredType());
            }
            assert (type != null);
            String previousType = typesForNames.put(columnName, type);
            if (previousType != null && !previousType.equals(type)) {
                type = typeSystem.getCompatibleType(previousType, type);
            }
            boolean bl = fullTextSearchable = fullTextSearchableNames.contains(columnName) || defn.isFullTextSearchable();
            if (fullTextSearchable) {
                fullTextSearchableNames.add(columnName);
            }
            builder.addColumn(tableName, columnName, type, fullTextSearchable);
            if (indexRuleBuilder == null) continue;
            this.addIndexRule(indexRuleBuilder, defn, type, typeSystem, canBeReference);
        }
    }

    protected final void addIndexRule(IndexRules.Builder builder, JcrPropertyDefinition defn, String type, TypeSystem typeSystem, boolean canBeReference) {
        Field.Index index;
        Field.Store store = Field.Store.YES;
        Field.Index index2 = index = defn.isFullTextSearchable() ? Field.Index.ANALYZED : Field.Index.NO;
        if (typeSystem.getStringFactory().getTypeName().equals(type)) {
            builder.stringField(defn.getInternalName(), store, index, canBeReference, defn.isFullTextSearchable());
        } else if (typeSystem.getDateTimeFactory().getTypeName().equals(type)) {
            Long minimum = (Long)typeSystem.getLongFactory().create(defn.getMinimumValue());
            Long maximum = (Long)typeSystem.getLongFactory().create(defn.getMaximumValue());
            builder.dateField(defn.getInternalName(), store, index, minimum, maximum);
        } else if (typeSystem.getLongFactory().getTypeName().equals(type)) {
            Long minimum = (Long)typeSystem.getLongFactory().create(defn.getMinimumValue());
            Long maximum = (Long)typeSystem.getLongFactory().create(defn.getMaximumValue());
            builder.longField(defn.getInternalName(), store, index, minimum, maximum);
        } else if (typeSystem.getDoubleFactory().getTypeName().equals(type)) {
            Double minimum = (Double)typeSystem.getDoubleFactory().create(defn.getMinimumValue());
            Double maximum = (Double)typeSystem.getDoubleFactory().create(defn.getMaximumValue());
            builder.doubleField(defn.getInternalName(), store, index, minimum, maximum);
        } else if (typeSystem.getBooleanFactory().getTypeName().equals(type)) {
            builder.booleanField(defn.getInternalName(), store, index);
        } else if (typeSystem.getBinaryFactory().getTypeName().equals(type)) {
            store = Field.Store.NO;
            builder.binaryField(defn.getInternalName(), store, index, defn.isFullTextSearchable());
        } else if (typeSystem.getReferenceFactory().getTypeName().equals(type)) {
            store = Field.Store.NO;
            builder.referenceField(defn.getInternalName(), store, index);
        } else if (typeSystem.getPathFactory().getTypeName().equals(type)) {
            store = Field.Store.NO;
            builder.weakReferenceField(defn.getInternalName(), store, index, defn.isFullTextSearchable());
        } else {
            builder.stringField(defn.getInternalName(), store, index, canBeReference, defn.isFullTextSearchable());
        }
    }

    protected final void addView(ImmutableSchemata.Builder builder, ExecutionContext context, JcrNodeType nodeType) {
        NamespaceRegistry registry = context.getNamespaceRegistry();
        String tableName = nodeType.getName();
        JcrPropertyDefinition[] defns = null;
        defns = this.includeColumnsForInheritedProperties ? nodeType.getPropertyDefinitions() : nodeType.getDeclaredPropertyDefinitions();
        if (defns.length == 0) {
            return;
        }
        StringBuilder viewDefinition = new StringBuilder("SELECT ");
        boolean first = true;
        for (JcrPropertyDefinition defn : defns) {
            if (defn.isResidual() || defn.isMultiple() || defn.isPrivate()) continue;
            Name name = defn.getInternalName();
            String columnName = name.getString(registry);
            if (first) {
                first = false;
            } else {
                viewDefinition.append(',');
            }
            viewDefinition.append('[').append(columnName).append(']');
        }
        if (first) {
            return;
        }
        viewDefinition.append(" FROM ").append(AllNodes.ALL_NODES_NAME);
        if (!JcrNtLexicon.BASE.equals(nodeType.getInternalName())) {
            viewDefinition.append(" WHERE ");
            int mixinTypeCount = 0;
            int primaryTypeCount = 0;
            StringBuilder mixinTypes = new StringBuilder();
            StringBuilder primaryTypes = new StringBuilder();
            Collection typeAndSubtypes = this.subtypesByName.get((Object)nodeType);
            for (JcrNodeType thisOrSupertype : typeAndSubtypes) {
                String name;
                if (thisOrSupertype.isMixin()) {
                    if (mixinTypeCount > 0) {
                        mixinTypes.append(',');
                    }
                    assert (this.prefixesByUris.containsKey(thisOrSupertype.getInternalName().getNamespaceUri()));
                    name = thisOrSupertype.getInternalName().getString(registry);
                    mixinTypes.append('[').append(name).append(']');
                    ++mixinTypeCount;
                    continue;
                }
                if (primaryTypeCount > 0) {
                    primaryTypes.append(',');
                }
                assert (this.prefixesByUris.containsKey(thisOrSupertype.getInternalName().getNamespaceUri()));
                name = thisOrSupertype.getInternalName().getString(registry);
                primaryTypes.append('[').append(name).append(']');
                ++primaryTypeCount;
            }
            if (primaryTypeCount > 0) {
                viewDefinition.append('[').append(JcrLexicon.PRIMARY_TYPE.getString(registry)).append(']');
                if (primaryTypeCount == 1) {
                    viewDefinition.append('=').append((CharSequence)primaryTypes);
                } else {
                    viewDefinition.append(" IN (").append((CharSequence)primaryTypes).append(')');
                }
            }
            if (mixinTypeCount > 0) {
                if (primaryTypeCount > 0) {
                    viewDefinition.append(" OR ");
                }
                viewDefinition.append('[').append(JcrLexicon.MIXIN_TYPES.getString(registry)).append(']');
                if (mixinTypeCount == 1) {
                    viewDefinition.append('=').append((CharSequence)mixinTypes);
                } else {
                    viewDefinition.append(" IN (").append((CharSequence)mixinTypes).append(')');
                }
            }
        }
        builder.addView(tableName, viewDefinition.toString());
    }

    public Schemata.Table getTable(SelectorName name) {
        return this.schemata.getTable(name);
    }

    public Schemata getSchemataForSession(JcrSession session) {
        assert (session != null);
        if (!this.overridesNamespaceMappings(session)) {
            return this;
        }
        return new SessionSchemata(session);
    }

    private boolean overridesNamespaceMappings(JcrSession session) {
        NamespaceRegistry registry = session.getExecutionContext().getNamespaceRegistry();
        if (registry instanceof LocalNamespaceRegistry) {
            Set localNamespaces = ((LocalNamespaceRegistry)registry).getLocalNamespaces();
            if (localNamespaces.isEmpty()) {
                return false;
            }
            for (NamespaceRegistry.Namespace namespace : localNamespaces) {
                if (!this.prefixesByUris.containsKey(namespace.getNamespaceUri())) continue;
                return true;
            }
            return false;
        }
        for (NamespaceRegistry.Namespace namespace : registry.getNamespaces()) {
            String expectedPrefix = this.prefixesByUris.get(namespace.getNamespaceUri());
            if (expectedPrefix == null || namespace.getPrefix().equals(expectedPrefix)) continue;
            return true;
        }
        return false;
    }

    @NotThreadSafe
    protected class SessionSchemata
    implements Schemata {
        private final JcrSession session;
        private final ExecutionContext context;
        private final ImmutableSchemata.Builder builder;
        private final NameFactory nameFactory;
        private Schemata schemata;

        protected SessionSchemata(JcrSession session) {
            this.session = session;
            this.context = this.session.getExecutionContext();
            this.nameFactory = this.context.getValueFactories().getNameFactory();
            this.builder = ImmutableSchemata.createBuilder((TypeSystem)this.context.getValueFactories().getTypeSystem());
            NodeTypeSchemata.this.addAllNodesTable(this.builder, null, this.context);
            this.schemata = this.builder.build();
        }

        public Schemata.Table getTable(SelectorName name) {
            Schemata.Table table = this.schemata.getTable(name);
            if (table == null) {
                Name nodeTypeName = (Name)this.nameFactory.create(name.getName());
                JcrNodeType nodeType = NodeTypeSchemata.this.getNodeType(nodeTypeName);
                if (nodeType == null) {
                    return null;
                }
                NodeTypeSchemata.this.addView(this.builder, this.context, nodeType);
                this.schemata = this.builder.build();
            }
            return this.schemata.getTable(name);
        }
    }
}

