/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.query.Query;
import javax.jcr.query.QueryResult;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import net.jcip.annotations.Immutable;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.HashCode;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.query.QueryBuilder;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.CorrespondenceId;
import org.modeshape.jcr.JcrChildNodeIterator;
import org.modeshape.jcr.JcrEmptyNodeIterator;
import org.modeshape.jcr.JcrEmptyPropertyIterator;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrPropertyIterator;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.WorkspaceLockManager;

@Immutable
abstract class AbstractJcrNode
extends AbstractJcrItem
implements Node {
    private static final NodeType[] EMPTY_NODE_TYPES = new NodeType[0];
    protected final GraphSession.NodeId nodeId;
    protected final Location location;

    AbstractJcrNode(SessionCache cache, GraphSession.NodeId nodeId, Location location) {
        super(cache);
        this.nodeId = nodeId;
        this.location = location;
    }

    abstract boolean isRoot();

    public abstract AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException;

    final GraphSession.NodeId internalId() {
        return this.nodeId;
    }

    final Name name() throws RepositoryException {
        return this.nodeInfo().getName();
    }

    final Path.Segment segment() throws RepositoryException {
        return this.nodeInfo().getSegment();
    }

    final GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> nodeInfo() throws ItemNotFoundException, AccessDeniedException, RepositoryException {
        return this.cache.findNode(this.nodeId, this.location.getPath());
    }

    final SessionCache.NodeEditor editorForParent() throws RepositoryException {
        try {
            GraphSession.Node parent = this.nodeInfo().getParent();
            return this.cache.getEditorFor((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)parent);
        }
        catch (ItemNotFoundException err) {
            String msg = JcrI18n.nodeHasAlreadyBeenRemovedFromThisSession.text(new Object[]{this.nodeId, this.cache.workspaceName()});
            throw new RepositoryException(msg);
        }
        catch (InvalidItemStateException err) {
            String msg = JcrI18n.nodeHasAlreadyBeenRemovedFromThisSession.text(new Object[]{this.nodeId, this.cache.workspaceName()});
            throw new RepositoryException(msg);
        }
    }

    final SessionCache.NodeEditor editor() throws RepositoryException {
        try {
            return this.cache.getEditorFor(this.nodeId, this.location.getPath());
        }
        catch (ItemNotFoundException err) {
            String msg = JcrI18n.nodeHasAlreadyBeenRemovedFromThisSession.text(new Object[]{this.nodeId, this.cache.workspaceName()});
            throw new RepositoryException(msg);
        }
        catch (InvalidItemStateException err) {
            String msg = JcrI18n.nodeHasAlreadyBeenRemovedFromThisSession.text(new Object[]{this.nodeId, this.cache.workspaceName()});
            throw new RepositoryException(msg);
        }
    }

    final JcrValue valueFrom(int propertyType, Object value) {
        return new JcrValue(this.cache.factories(), this.cache, propertyType, value);
    }

    final JcrValue valueFrom(Calendar value) {
        ValueFactories factories = this.cache.factories();
        DateTime dateTime = (DateTime)factories.getDateFactory().create(value);
        return new JcrValue(factories, this.cache, 5, dateTime);
    }

    final JcrValue valueFrom(InputStream value) {
        ValueFactories factories = this.cache.factories();
        Binary binary = (Binary)factories.getBinaryFactory().create((Object)value);
        return new JcrValue(factories, this.cache, 5, binary);
    }

    final JcrValue valueFrom(Node value) throws UnsupportedRepositoryOperationException, RepositoryException {
        ValueFactories factories = this.cache.factories();
        String uuid = (String)factories.getStringFactory().create(value.getUUID());
        return new JcrValue(factories, this.cache, 9, uuid);
    }

    final JcrValue[] valuesFrom(int propertyType, Object[] values) {
        int len = values.length;
        ValueFactories factories = this.cache.factories();
        ArrayList<JcrValue> results = new ArrayList<JcrValue>(len);
        for (int i = 0; i != len; ++i) {
            if (values[i] == null) continue;
            results.add(new JcrValue(factories, this.cache, propertyType, values[i]));
        }
        return results.toArray(new JcrValue[results.size()]);
    }

    @Override
    Path path() throws RepositoryException {
        return this.nodeInfo().getPath();
    }

    boolean isReferenceable() throws RepositoryException {
        return this.isNodeType(JcrMixLexicon.REFERENCEABLE);
    }

    boolean isLockable() throws RepositoryException {
        return this.isNodeType(JcrMixLexicon.LOCKABLE);
    }

    UUID uuid() throws RepositoryException {
        GraphSession.PropertyInfo uuidProp = this.nodeInfo().getProperty(JcrLexicon.UUID);
        if (uuidProp == null) {
            uuidProp = this.nodeInfo().getProperty(ModeShapeLexicon.UUID);
        }
        assert (uuidProp != null);
        assert (!uuidProp.getProperty().isEmpty());
        return (UUID)this.context().getValueFactories().getUuidFactory().create(uuidProp.getProperty().getFirstValue());
    }

    public String getUUID() throws RepositoryException {
        if (!this.isReferenceable()) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
        }
        return this.uuid().toString();
    }

    public final boolean isNode() {
        return true;
    }

    public boolean isNodeType(String nodeTypeName) throws RepositoryException {
        return this.isNodeType(this.nameFrom(nodeTypeName));
    }

    public final boolean isNodeType(Name nodeTypeName) throws RepositoryException {
        return this.cache.isNodeType(this.nodeInfo(), nodeTypeName);
    }

    public NodeDefinition getDefinition() throws RepositoryException {
        NodeDefinitionId definitionId = ((SessionCache.JcrNodePayload)this.nodeInfo().getPayload()).getDefinitionId();
        return this.session().nodeTypeManager().getNodeDefinition(definitionId);
    }

    public JcrNodeType getPrimaryNodeType() throws RepositoryException {
        return this.session().nodeTypeManager().getNodeType(this.getPrimaryTypeName());
    }

    Name getPrimaryTypeName() throws RepositoryException {
        return ((SessionCache.JcrNodePayload)this.nodeInfo().getPayload()).getPrimaryTypeName();
    }

    public NodeType[] getMixinNodeTypes() throws RepositoryException {
        JcrNodeTypeManager nodeTypeManager = this.session().nodeTypeManager();
        AbstractJcrProperty mixinTypesProperty = this.getProperty(JcrLexicon.MIXIN_TYPES);
        if (mixinTypesProperty == null) {
            return EMPTY_NODE_TYPES;
        }
        LinkedList<NodeType> mixinNodeTypes = new LinkedList<NodeType>();
        for (Value value : mixinTypesProperty.getValues()) {
            String nodeTypeName = value.getString();
            NodeType nodeType = nodeTypeManager.getNodeType(nodeTypeName);
            if (nodeType == null) continue;
            mixinNodeTypes.add(nodeType);
        }
        return mixinNodeTypes.toArray(new NodeType[mixinNodeTypes.size()]);
    }

    List<Name> getMixinTypeNames() throws RepositoryException {
        return ((SessionCache.JcrNodePayload)this.nodeInfo().getPayload()).getMixinTypeNames();
    }

    public final Item getPrimaryItem() throws RepositoryException {
        JcrNodeType primaryType = this.getPrimaryNodeType();
        String primaryItemNameString = primaryType.getPrimaryItemName();
        if (primaryItemNameString == null) {
            I18n msg = JcrI18n.noPrimaryItemNameDefinedOnPrimaryType;
            throw new ItemNotFoundException(msg.text(new Object[]{primaryType.getName(), this.getPath(), this.cache.workspaceName()}));
        }
        try {
            Path primaryItemPath = (Path)this.context().getValueFactories().getPathFactory().create(primaryItemNameString);
            if (primaryItemPath.size() != 1 || primaryItemPath.isAbsolute()) {
                I18n msg = JcrI18n.primaryItemNameForPrimaryTypeIsNotValid;
                throw new ItemNotFoundException(msg.text(new Object[]{primaryType.getName(), primaryItemNameString, this.getPath(), this.cache.workspaceName()}));
            }
            return this.cache.findJcrItem(this.nodeId, this.location.getPath(), primaryItemPath);
        }
        catch (javax.jcr.ValueFormatException error) {
            I18n msg = JcrI18n.primaryItemNameForPrimaryTypeIsNotValid;
            throw new ItemNotFoundException(msg.text(new Object[]{primaryType.getName(), primaryItemNameString, this.getPath(), this.cache.workspaceName()}));
        }
        catch (PathNotFoundException error) {
            I18n msg = JcrI18n.primaryItemDoesNotExist;
            throw new ItemNotFoundException(msg.text(new Object[]{primaryType.getName(), primaryItemNameString, this.getPath(), this.cache.workspaceName()}));
        }
    }

    @Override
    public boolean isSame(Item otherItem) throws RepositoryException {
        CheckArg.isNotNull((Object)otherItem, (String)"otherItem");
        if (super.isSame(otherItem) && otherItem instanceof Node) {
            if (otherItem instanceof AbstractJcrNode) {
                AbstractJcrNode that = (AbstractJcrNode)otherItem;
                if (this.isReferenceable() && that.isReferenceable()) {
                    return this.getUUID().equals(((AbstractJcrNode)otherItem).getUUID());
                }
                CorrespondenceId thisId = this.getCorrespondenceId();
                CorrespondenceId thatId = that.getCorrespondenceId();
                return thisId.equals(thatId);
            }
            return otherItem.isSame((Item)this);
        }
        return false;
    }

    protected CorrespondenceId getCorrespondenceId() throws RepositoryException {
        if (this.isReferenceable()) {
            return new CorrespondenceId(this.getUUID());
        }
        assert (!this.isRoot());
        Path currentPath = this.path();
        AbstractJcrNode node = this.getParent();
        int beginIndex = currentPath.size() - 1;
        while (!node.isRoot() && !node.isReferenceable()) {
            node = node.getParent();
            --beginIndex;
        }
        Path relativePath = currentPath.relativeTo(node.path());
        assert (!relativePath.isAbsolute());
        return new CorrespondenceId(node.getUUID(), relativePath);
    }

    public final boolean hasProperties() throws RepositoryException {
        return this.nodeInfo().getPropertyCount() > 0;
    }

    public final boolean hasProperty(String relativePath) throws RepositoryException {
        CheckArg.isNotEmpty((String)relativePath, (String)"relativePath");
        if (relativePath.indexOf(47) >= 0) {
            try {
                this.getProperty(relativePath);
                return true;
            }
            catch (PathNotFoundException e) {
                return false;
            }
        }
        if (relativePath.equals(".")) {
            return false;
        }
        if (relativePath.equals("..")) {
            return false;
        }
        return this.nodeInfo().getProperty(this.nameFrom(relativePath)) != null;
    }

    public final boolean hasProperty(Name name) throws RepositoryException {
        return this.nodeInfo().getProperty(name) != null;
    }

    public final PropertyIterator getProperties() throws RepositoryException {
        return new JcrPropertyIterator(this.cache.findJcrPropertiesFor(this.nodeId, this.location.getPath()));
    }

    public PropertyIterator getProperties(String namePattern) throws RepositoryException {
        CheckArg.isNotNull((Object)namePattern, (String)"namePattern");
        namePattern = namePattern.trim();
        if (namePattern.length() == 0) {
            return new JcrEmptyPropertyIterator();
        }
        Collection<AbstractJcrProperty> properties = this.cache.findJcrPropertiesFor(this.nodeId, this.location.getPath());
        if ("*".equals(namePattern)) {
            return new JcrPropertyIterator(properties);
        }
        List<Object> patterns = AbstractJcrNode.createPatternsFor(namePattern);
        boolean foundMatch = true;
        LinkedList<AbstractJcrProperty> matchingProperties = new LinkedList<AbstractJcrProperty>();
        for (AbstractJcrProperty property : properties) {
            String propName = property.getName();
            assert (foundMatch);
            for (Object patternOrMatch : patterns) {
                String match;
                Pattern pattern;
                if (patternOrMatch instanceof Pattern ? (pattern = (Pattern)patternOrMatch).matcher(propName).matches() : propName.equals(match = (String)patternOrMatch)) break;
                foundMatch = false;
            }
            if (foundMatch) {
                matchingProperties.add(property);
                continue;
            }
            foundMatch = true;
        }
        return new JcrPropertyIterator(matchingProperties);
    }

    protected final NodeIterator referencingNodes(int maxNumberOfNodes) throws RepositoryException {
        if (!this.isReferenceable()) {
            return new JcrEmptyNodeIterator();
        }
        if (maxNumberOfNodes < 0) {
            maxNumberOfNodes = Integer.MAX_VALUE;
        }
        String uuid = this.getUUID();
        QueryBuilder builder = new QueryBuilder(this.context().getValueFactories().getTypeSystem());
        QueryCommand query = builder.select(new String[]{"jcr:primaryType"}).fromAllNodesAs("allNodes").where().referenceValue("allNodes").isEqualTo((Object)uuid).end().limit(maxNumberOfNodes).query();
        Query jcrQuery = this.session().workspace().queryManager().createQuery(query);
        QueryResult result = jcrQuery.execute();
        return result.getNodes();
    }

    protected final boolean hasIncomingReferences() throws RepositoryException {
        return this.referencingNodes(1).hasNext();
    }

    public final PropertyIterator getReferences() throws RepositoryException {
        if (!this.isReferenceable()) {
            return new JcrEmptyPropertyIterator();
        }
        NodeIterator iter = this.referencingNodes(Integer.MAX_VALUE);
        if (!iter.hasNext()) {
            return new JcrEmptyPropertyIterator();
        }
        String uuid = this.getUUID();
        LinkedList<Property> references = new LinkedList<Property>();
        while (iter.hasNext()) {
            Node node = iter.nextNode();
            PropertyIterator propIter = node.getProperties();
            block1: while (propIter.hasNext()) {
                Property prop = propIter.nextProperty();
                int propType = prop.getDefinition().getRequiredType();
                if (propType != 9 && propType != 0 && propType != 1) continue;
                if (prop.getDefinition().isMultiple()) {
                    for (Value value : prop.getValues()) {
                        if (!uuid.equals(value.getString())) continue;
                        references.add(prop);
                        continue block1;
                    }
                    continue;
                }
                Value value = prop.getValue();
                if (!uuid.equals(value.getString())) continue;
                references.add(prop);
            }
        }
        if (references.isEmpty()) {
            return new JcrEmptyPropertyIterator();
        }
        return new JcrPropertyIterator(references);
    }

    public final AbstractJcrProperty getProperty(Name propertyName) throws RepositoryException {
        AbstractJcrProperty property = this.cache.findJcrProperty(this.nodeId, this.location.getPath(), propertyName);
        if (property != null && JcrLexicon.UUID.equals(propertyName) && !this.isReferenceable()) {
            return null;
        }
        return property;
    }

    public final Property getProperty(String relativePath) throws RepositoryException {
        CheckArg.isNotEmpty((String)relativePath, (String)"relativePath");
        int indexOfFirstSlash = relativePath.indexOf(47);
        if (indexOfFirstSlash == 0) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(new Object[]{relativePath, "relativePath"}));
        }
        Name propertyName = null;
        if (indexOfFirstSlash != -1) {
            Path path = this.pathFrom(relativePath).getNormalizedPath();
            if (path.size() > 1) {
                try {
                    AbstractJcrItem item = this.cache.findJcrItem(this.nodeId, this.location.getPath(), path);
                    if (item instanceof Property) {
                        return (Property)item;
                    }
                }
                catch (ItemNotFoundException e) {
                    I18n msg = JcrI18n.propertyNotFoundAtPathRelativeToReferenceNode;
                    throw new PathNotFoundException(msg.text(new Object[]{relativePath, this.getPath(), this.cache.workspaceName()}));
                }
                I18n msg = JcrI18n.propertyNotFoundAtPathRelativeToReferenceNode;
                throw new PathNotFoundException(msg.text(new Object[]{relativePath, this.getPath(), this.cache.workspaceName()}));
            }
            propertyName = path.getLastSegment().getName();
        } else {
            propertyName = this.nameFrom(relativePath);
        }
        AbstractJcrProperty result = this.getProperty(propertyName);
        if (result != null) {
            return result;
        }
        I18n msg = JcrI18n.pathNotFoundRelativeTo;
        throw new PathNotFoundException(msg.text(new Object[]{relativePath, this.getPath(), this.cache.workspaceName()}));
    }

    public final boolean hasNode(String relativePath) throws RepositoryException {
        CheckArg.isNotEmpty((String)relativePath, (String)"relativePath");
        if (relativePath.equals(".")) {
            return true;
        }
        if (relativePath.equals("..")) {
            return !this.isRoot();
        }
        int indexOfFirstSlash = relativePath.indexOf(47);
        if (indexOfFirstSlash == 0) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(new Object[]{relativePath, "relativePath"}));
        }
        if (indexOfFirstSlash != -1) {
            Path path = this.pathFrom(relativePath).getNormalizedPath();
            try {
                AbstractJcrNode item = this.cache.findJcrNode(this.nodeId, this.location.getPath(), path);
                return item != null;
            }
            catch (PathNotFoundException e) {
                return false;
            }
        }
        try {
            Path.Segment segment = this.segmentFrom(relativePath);
            return this.nodeInfo().getChild(segment) != null;
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            return false;
        }
    }

    public final boolean hasNodes() throws RepositoryException {
        return this.nodeInfo().getChildrenCount() > 0;
    }

    public final AbstractJcrNode getNode(Name childNodeName) throws RepositoryException {
        try {
            Path childPath = this.context().getValueFactories().getPathFactory().createRelativePath(new Name[]{childNodeName});
            return this.cache.findJcrNode(this.nodeId, this.location.getPath(), childPath);
        }
        catch (ItemNotFoundException infe) {
            return null;
        }
    }

    public final AbstractJcrNode getNode(String relativePath) throws RepositoryException {
        CheckArg.isNotEmpty((String)relativePath, (String)"relativePath");
        if (relativePath.equals(".")) {
            return this;
        }
        if (relativePath.equals("..")) {
            return this.getParent();
        }
        int indexOfFirstSlash = relativePath.indexOf(47);
        if (indexOfFirstSlash == 0) {
            throw new IllegalArgumentException(JcrI18n.invalidPathParameter.text(new Object[]{relativePath, "relativePath"}));
        }
        Path.Segment segment = null;
        if (indexOfFirstSlash != -1) {
            Path path = this.pathFrom(relativePath).getNormalizedPath();
            if (path.size() == 1) {
                if (path.getLastSegment().isSelfReference()) {
                    return this;
                }
                if (path.getLastSegment().isParentReference()) {
                    return this.getParent();
                }
            }
            if (path.size() > 1) {
                AbstractJcrNode item = this.cache.findJcrNode(this.nodeId, this.location.getPath(), path);
                if (item instanceof Node) {
                    return item;
                }
                I18n msg = JcrI18n.nodeNotFoundAtPathRelativeToReferenceNode;
                throw new PathNotFoundException(msg.text(new Object[]{relativePath, this.getPath(), this.cache.workspaceName()}));
            }
            segment = path.getLastSegment();
        } else {
            segment = this.segmentFrom(relativePath);
        }
        try {
            return ((SessionCache.JcrNodePayload)this.nodeInfo().getChild(segment).getPayload()).getJcrNode();
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            String msg = JcrI18n.childNotFoundUnderNode.text(new Object[]{segment, this.getPath(), this.cache.workspaceName()});
            throw new PathNotFoundException(msg);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public final NodeIterator getNodes() throws RepositoryException {
        int childCount = this.nodeInfo().getChildrenCount();
        if (childCount == 0) {
            return new JcrEmptyNodeIterator();
        }
        LinkedList<AbstractJcrNode> matchingChildren = new LinkedList<AbstractJcrNode>();
        for (GraphSession.Node child : this.nodeInfo().getChildren()) {
            matchingChildren.add(((SessionCache.JcrNodePayload)child.getPayload()).getJcrNode());
        }
        return new JcrChildNodeIterator(matchingChildren, childCount);
    }

    public NodeIterator getNodes(String namePattern) throws RepositoryException {
        CheckArg.isNotNull((Object)namePattern, (String)"namePattern");
        namePattern = namePattern.trim();
        if (namePattern.length() == 0) {
            return new JcrEmptyNodeIterator();
        }
        if ("*".equals(namePattern)) {
            return this.getNodes();
        }
        List<Object> patterns = AbstractJcrNode.createPatternsFor(namePattern);
        LinkedList<AbstractJcrNode> matchingChildren = new LinkedList<AbstractJcrNode>();
        NamespaceRegistry registry = this.namespaces();
        boolean foundMatch = false;
        block0: for (GraphSession.Node child : this.nodeInfo().getChildren()) {
            String childName = child.getName().getString(registry);
            for (Object patternOrMatch : patterns) {
                if (patternOrMatch instanceof Pattern) {
                    Pattern pattern = (Pattern)patternOrMatch;
                    if (pattern.matcher(childName).matches()) {
                        foundMatch = true;
                    }
                } else {
                    String match = (String)patternOrMatch;
                    if (childName.equals(match)) {
                        foundMatch = true;
                    }
                }
                if (!foundMatch) continue;
                foundMatch = false;
                matchingChildren.add(((SessionCache.JcrNodePayload)child.getPayload()).getJcrNode());
                continue block0;
            }
        }
        return new JcrChildNodeIterator(matchingChildren, matchingChildren.size());
    }

    public final void accept(ItemVisitor visitor) throws RepositoryException {
        CheckArg.isNotNull((Object)visitor, (String)"visitor");
        visitor.visit((Node)this);
    }

    public final boolean canAddMixin(String mixinName) throws NoSuchNodeTypeException, RepositoryException {
        CheckArg.isNotNull((Object)mixinName, (String)"mixinName");
        CheckArg.isNotZeroLength((String)mixinName, (String)"mixinName");
        this.session().checkPermission(this.path(), "set_property");
        JcrNodeType mixinCandidateType = this.cache.nodeTypes().getNodeType(mixinName);
        if (this.isLocked()) {
            return false;
        }
        if (!this.isCheckedOut()) {
            return false;
        }
        if (this.getDefinition().isProtected()) {
            return false;
        }
        JcrNodeType primaryType = this.getPrimaryNodeType();
        NodeType[] mixinTypes = this.getMixinNodeTypes();
        if (!mixinCandidateType.isMixin()) {
            return false;
        }
        if (mixinCandidateType.conflictsWith(primaryType, mixinTypes)) {
            return false;
        }
        for (JcrPropertyDefinition propertyDefinition : mixinCandidateType.propertyDefinitions()) {
            AbstractJcrProperty existingProp;
            if (!this.hasProperty(propertyDefinition.getInternalName()) || (existingProp = this.cache.findJcrProperty(this.nodeId, this.location.getPath(), propertyDefinition.getInternalName())) == null || !(propertyDefinition.isMultiple() ? !propertyDefinition.canCastToTypeAndSatisfyConstraints(existingProp.getValues()) : !propertyDefinition.canCastToTypeAndSatisfyConstraints(existingProp.getValue()))) continue;
            return false;
        }
        HashSet<Name> mixinChildNodeNames = new HashSet<Name>();
        for (JcrNodeDefinition nodeDefinition : mixinCandidateType.childNodeDefinitions()) {
            mixinChildNodeNames.add(nodeDefinition.getInternalName());
        }
        for (Name nodeName : mixinChildNodeNames) {
            int snsCount = this.nodeInfo().getChildrenCount(nodeName);
            for (GraphSession.Node child : this.nodeInfo().getChildren(nodeName)) {
                JcrNodeDefinition match = this.cache.nodeTypes().findChildNodeDefinition(mixinCandidateType.getInternalName(), Collections.<Name>emptyList(), nodeName, ((SessionCache.JcrNodePayload)child.getPayload()).getPrimaryTypeName(), snsCount, false);
                if (match != null) continue;
                return false;
            }
        }
        return true;
    }

    public final void addMixin(String mixinName) throws RepositoryException {
        CheckArg.isNotNull((Object)mixinName, (String)"mixinName");
        CheckArg.isNotZeroLength((String)mixinName, (String)"mixinName");
        JcrNodeType mixinCandidateType = this.cache.nodeTypes().getNodeType(mixinName);
        if (this.isLocked() && !this.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.location}));
        }
        if (!this.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{this.getPath()}));
        }
        if (!this.canAddMixin(mixinName)) {
            throw new ConstraintViolationException(JcrI18n.cannotAddMixin.text(new Object[]{mixinName}));
        }
        this.editor().addMixin(mixinCandidateType);
    }

    public final void removeMixin(String mixinName) throws RepositoryException {
        if (this.isLocked() && !this.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.location}));
        }
        if (!this.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{this.getPath()}));
        }
        if (JcrMixLexicon.VERSIONABLE.getString(this.context().getNamespaceRegistry()).equals(mixinName)) {
            throw new ConstraintViolationException(JcrI18n.cannotRemoveMixVersionable.text(new Object[]{this.getPath()}));
        }
        AbstractJcrProperty existingMixinProperty = this.getProperty(JcrLexicon.MIXIN_TYPES);
        if (existingMixinProperty == null) {
            throw new NoSuchNodeTypeException(JcrI18n.invalidMixinTypeForNode.text(new Object[]{mixinName, this.getPath()}));
        }
        Value[] existingMixinValues = existingMixinProperty.getValues();
        if (existingMixinValues.length == 0) {
            throw new NoSuchNodeTypeException(JcrI18n.invalidMixinTypeForNode.text(new Object[]{mixinName, this.getPath()}));
        }
        int newMixinValuesCount = existingMixinValues.length - 1;
        Value[] newMixinValues = new Value[newMixinValuesCount];
        ArrayList<Name> newMixinNames = new ArrayList<Name>(newMixinValuesCount);
        Name primaryTypeName = this.getPrimaryNodeType().getInternalName();
        int j = 0;
        for (int i = 0; i < existingMixinValues.length; ++i) {
            if (existingMixinValues[i].getString().equals(mixinName)) continue;
            if (j < newMixinValuesCount) {
                newMixinValues[j++] = existingMixinValues[i];
                newMixinNames.add((Name)this.cache.nameFactory.create(existingMixinValues[i].getString()));
                continue;
            }
            throw new NoSuchNodeTypeException(JcrI18n.invalidMixinTypeForNode.text(new Object[]{mixinName, this.getPath()}));
        }
        PropertyIterator iter = this.getProperties();
        while (iter.hasNext()) {
            JcrPropertyDefinition match;
            Property property = iter.nextProperty();
            if (!mixinName.equals(property.getDefinition().getDeclaringNodeType().getName()) || (match = property.getDefinition().isMultiple() ? this.cache.nodeTypes().findPropertyDefinition(primaryTypeName, newMixinNames, JcrNodeType.RESIDUAL_NAME, property.getValues(), true) : this.cache.nodeTypes().findPropertyDefinition(primaryTypeName, newMixinNames, JcrNodeType.RESIDUAL_NAME, property.getValue(), true, true)) != null) continue;
            throw new ConstraintViolationException(JcrI18n.noDefinition.text(new Object[]{"property", property.getName(), this.getPath(), primaryTypeName, newMixinNames}));
        }
        iter = this.getNodes();
        while (iter.hasNext()) {
            JcrNodeDefinition match;
            AbstractJcrNode node = (AbstractJcrNode)iter.nextNode();
            Name childNodeName = (Name)this.cache.nameFactory.create(node.getName());
            int snsCount = node.nodeInfo().getChildrenCount(childNodeName);
            if (!mixinName.equals(node.getDefinition().getDeclaringNodeType().getName()) || (match = this.cache.nodeTypes().findChildNodeDefinition(primaryTypeName, newMixinNames, JcrNodeType.RESIDUAL_NAME, node.getPrimaryNodeType().getInternalName(), snsCount, true)) != null) continue;
            throw new ConstraintViolationException(JcrI18n.noDefinition.text(new Object[]{"child node", node.getName(), this.getPath(), primaryTypeName, newMixinNames}));
        }
        this.editor().setProperty(JcrLexicon.MIXIN_TYPES, newMixinValues, 7, false);
    }

    public final Node addNode(String relPath) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.addNode(relPath, null, null);
    }

    public final Node addNode(String relPath, String primaryNodeTypeName) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        return this.addNode(relPath, primaryNodeTypeName, null);
    }

    final AbstractJcrNode addNode(String relPath, String primaryNodeTypeName, UUID desiredUuid) throws ItemExistsException, PathNotFoundException, VersionException, ConstraintViolationException, LockException, RepositoryException {
        if (this.isLocked() && !this.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.location}));
        }
        SessionCache.NodeEditor editor = null;
        Path path = null;
        try {
            path = (Path)this.cache.pathFactory().create(relPath);
        }
        catch (ValueFormatException e) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(new Object[]{relPath, "relPath"}));
        }
        if (path.size() == 0) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(new Object[]{relPath, "relPath"}));
        }
        if (path.getLastSegment().getIndex() > 1 || relPath.endsWith("]")) {
            throw new RepositoryException(JcrI18n.invalidPathParameter.text(new Object[]{relPath, "relPath"}));
        }
        if (path.size() > 1) {
            Path parentPath = path.getParent();
            try {
                GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> parentOfNewNode = this.cache.findNode(this.nodeId, this.location.getPath(), parentPath);
                editor = this.cache.getEditorFor(parentOfNewNode);
            }
            catch (RepositoryException e) {
                try {
                    GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> grandparent;
                    if (parentPath.size() > 1) {
                        Path grandparentPath = parentPath.getParent();
                        assert (grandparentPath != null);
                        grandparent = this.cache.findNode(this.nodeId, this.location.getPath(), grandparentPath);
                    } else {
                        grandparent = this.nodeInfo();
                    }
                    if (grandparent.getProperty(parentPath.getLastSegment().getName()) != null) {
                        throw new ConstraintViolationException(JcrI18n.invalidPathParameter.text(new Object[]{relPath, "relPath"}));
                    }
                }
                catch (PathNotFoundException e2) {
                    // empty catch block
                }
                throw e;
            }
        }
        assert (path.size() == 1);
        editor = this.editor();
        Name childName = path.getLastSegment().getName();
        Name childPrimaryTypeName = null;
        if (primaryNodeTypeName != null) {
            try {
                childPrimaryTypeName = (Name)this.cache.nameFactory().create(primaryNodeTypeName);
            }
            catch (ValueFormatException e) {
                throw new RepositoryException(JcrI18n.invalidNodeTypeNameParameter.text(new Object[]{primaryNodeTypeName, "primaryNodeTypeName"}));
            }
        }
        return editor.createChild(childName, desiredUuid, childPrimaryTypeName);
    }

    protected final Property removeExistingValuedProperty(String name) throws ConstraintViolationException, RepositoryException {
        AbstractJcrProperty property = this.cache.findJcrProperty(this.nodeId, this.location.getPath(), this.nameFrom(name));
        if (property != null) {
            property.remove();
            return property;
        }
        throw new RepositoryException(JcrI18n.propertyNotFoundOnNode.text(new Object[]{name, this.getPath(), this.cache.workspaceName()}));
    }

    public final Property setProperty(String name, boolean value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(6, value));
    }

    public final Property setProperty(String name, Calendar value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(value));
    }

    public final Property setProperty(String name, double value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(4, value));
    }

    public final Property setProperty(String name, InputStream value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(value));
    }

    public final Property setProperty(String name, long value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(3, value));
    }

    public final Property setProperty(String name, Node value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(value));
    }

    public final Property setProperty(String name, String value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(1, value));
    }

    public final Property setProperty(String name, String value, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valueFrom(type, value));
    }

    public final Property setProperty(String name, String[] values) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (values == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valuesFrom(1, values), 0);
    }

    public final Property setProperty(String name, String[] values, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (values == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), this.valuesFrom(type, values), 0);
    }

    public final Property setProperty(String name, Value value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), (JcrValue)value);
    }

    public final Property setProperty(String name, Value value, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), ((JcrValue)value).asType(type));
    }

    public final Property setProperty(String name, Value[] values) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (values == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.setProperty(name, values, 0);
    }

    public final Property setProperty(String name, Value[] values, int type) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (values == null) {
            return this.removeExistingValuedProperty(name);
        }
        return this.editor().setProperty(this.nameFrom(name), values, type);
    }

    private void checkVersionable() throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!this.isNodeType(JcrMixLexicon.VERSIONABLE)) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
    }

    private void checkNotProtected() throws ConstraintViolationException, RepositoryException {
        JcrNodeDefinition nodeDefn = this.cache.nodeTypes().getNodeDefinition(((SessionCache.JcrNodePayload)this.nodeInfo().getPayload()).getDefinitionId());
        if (nodeDefn.isProtected()) {
            throw new ConstraintViolationException(JcrI18n.cannotRemoveItemWithProtectedDefinition.text(new Object[]{this.getPath()}));
        }
    }

    final JcrVersionManager versionManager() {
        return this.session().workspace().versionManager();
    }

    public final boolean isCheckedOut() throws RepositoryException {
        return this.editor().isCheckedOut();
    }

    public final Version checkin() throws RepositoryException {
        this.checkVersionable();
        return this.versionManager().checkin(this);
    }

    public final void checkout() throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.checkVersionable();
        this.versionManager().checkout(this);
    }

    public final NodeIterator merge(String srcWorkspace, boolean bestEffort) throws ConstraintViolationException, RepositoryException {
        CheckArg.isNotNull((Object)srcWorkspace, (String)"source workspace name");
        this.checkNotProtected();
        return this.versionManager().merge(this, srcWorkspace, bestEffort);
    }

    public final void cancelMerge(Version version) throws RepositoryException {
        this.checkVersionable();
        this.versionManager().cancelMerge(this, version);
    }

    public final void doneMerge(Version version) throws RepositoryException {
        this.checkVersionable();
        this.versionManager().doneMerge(this, version);
    }

    public final JcrVersionHistoryNode getVersionHistory() throws RepositoryException {
        this.checkVersionable();
        return this.versionManager().getVersionHistory(this.uuid());
    }

    public final JcrVersionNode getBaseVersion() throws RepositoryException {
        this.checkVersionable();
        return (JcrVersionNode)this.session().getNodeByUUID(this.getProperty(JcrLexicon.BASE_VERSION).getString());
    }

    public final void restore(String versionName, boolean removeExisting) throws RepositoryException {
        this.restore(this.getVersionHistory().getVersion(versionName), removeExisting);
    }

    public final void restore(Version version, boolean removeExisting) throws RepositoryException {
        try {
            this.checkNotProtected();
        }
        catch (ConstraintViolationException cve) {
            throw new UnsupportedRepositoryOperationException((Throwable)cve);
        }
        this.versionManager().restore(this.path(), version, null, removeExisting);
    }

    public final void restore(Version version, String relPath, boolean removeExisting) throws RepositoryException {
        this.checkNotProtected();
        PathFactory pathFactory = this.context().getValueFactories().getPathFactory();
        Path relPathAsPath = (Path)pathFactory.create(relPath);
        if (relPathAsPath.isAbsolute()) {
            throw new RepositoryException(JcrI18n.invalidRelativePath.text(new Object[]{relPath}));
        }
        Path actualPath = pathFactory.create(this.path(), relPathAsPath).getCanonicalPath();
        this.versionManager().restore(actualPath, version, null, removeExisting);
    }

    public final void restoreByLabel(String versionLabel, boolean removeExisting) throws RepositoryException {
        this.restore(this.getVersionHistory().getVersionByLabel(versionLabel), removeExisting);
    }

    public final boolean holdsLock() {
        WorkspaceLockManager.ModeShapeLock lock = this.session().workspace().lockManager().lockFor(this.session(), this.location);
        return lock != null && this.cache.session().lockTokens().contains(lock.getLockToken());
    }

    public final boolean isLocked() throws LockException, RepositoryException {
        return this.lock() != null;
    }

    public final Lock lock(boolean isDeep, boolean isSessionScoped) throws LockException, RepositoryException {
        if (!this.isLockable()) {
            throw new LockException(JcrI18n.nodeNotLockable.text(new Object[]{this.getPath()}));
        }
        if (this.isLocked()) {
            throw new LockException(JcrI18n.alreadyLocked.text(new Object[]{this.location}));
        }
        if (isDeep) {
            LinkedList<Object> nodesToVisit = new LinkedList<Object>();
            nodesToVisit.add(this.nodeInfo());
            while (!nodesToVisit.isEmpty()) {
                GraphSession.Node node = (GraphSession.Node)nodesToVisit.remove(nodesToVisit.size() - 1);
                if (this.session().workspace().lockManager().lockFor(this.session(), node.getLocation()) != null) {
                    throw new LockException(JcrI18n.parentAlreadyLocked.text(new Object[]{this.location, node.getLocation()}));
                }
                for (GraphSession.Node child : node.getChildren()) {
                    nodesToVisit.add(child);
                }
            }
        }
        WorkspaceLockManager.ModeShapeLock lock = this.session().workspace().lockManager().lock(this.session(), this.location, isDeep, isSessionScoped);
        this.cache.session().addLockToken(lock.getLockToken());
        return lock.lockFor(this.cache);
    }

    public final void unlock() throws LockException, RepositoryException {
        WorkspaceLockManager.ModeShapeLock lock = this.session().workspace().lockManager().lockFor(this.session(), this.location);
        if (lock == null) {
            throw new LockException(JcrI18n.notLocked.text(new Object[]{this.location}));
        }
        if (!this.session().lockTokens().contains(lock.getLockToken())) {
            try {
                this.session().checkPermission(this.cache.workspaceName(), null, "unlock_any");
            }
            catch (AccessControlException iae) {
                throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.location}));
            }
        }
        this.session().workspace().lockManager().unlock(this.session().getExecutionContext(), lock);
        this.session().removeLockToken(lock.getLockToken());
    }

    private final WorkspaceLockManager.ModeShapeLock lock() throws RepositoryException {
        if (this.session() == null || this.session().workspace() == null) {
            return null;
        }
        WorkspaceLockManager lockManager = this.session().workspace().lockManager();
        WorkspaceLockManager.ModeShapeLock lock = lockManager.lockFor(this.session(), this.location);
        if (lock != null) {
            return lock;
        }
        AbstractJcrNode parent = this;
        while (!parent.isRoot()) {
            parent = parent.getParent();
            WorkspaceLockManager.ModeShapeLock parentLock = lockManager.lockFor(this.session(), parent.location);
            if (parentLock == null || !parentLock.isLive()) continue;
            return parentLock.isDeep() ? parentLock : null;
        }
        return null;
    }

    public final Lock getLock() throws LockException, RepositoryException {
        WorkspaceLockManager.ModeShapeLock lock = this.lock();
        if (lock == null) {
            throw new LockException(JcrI18n.notLocked.text(new Object[]{this.location}));
        }
        return lock.lockFor(this.cache);
    }

    public final boolean isModified() {
        try {
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node = this.nodeInfo();
            return !node.isNew() && node.isChanged(true);
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final boolean isNew() {
        try {
            return this.nodeInfo().isNew();
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final String getCorrespondingNodePath(String workspaceName) throws NoSuchWorkspaceException, ItemNotFoundException, RepositoryException {
        CheckArg.isNotNull((Object)workspaceName, (String)"workspace name");
        NamespaceRegistry namespaces = this.context().getNamespaceRegistry();
        return this.correspondingNodePath(workspaceName).getString(namespaces);
    }

    protected final Path correspondingNodePath(String workspaceName) throws NoSuchWorkspaceException, ItemNotFoundException, RepositoryException {
        assert (workspaceName != null);
        NamespaceRegistry namespaces = this.context().getNamespaceRegistry();
        AbstractJcrNode referenceableRoot = this;
        while (!referenceableRoot.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(namespaces))) {
            referenceableRoot = referenceableRoot.getParent();
        }
        Path relativePath = this.path().equals(referenceableRoot.path()) ? null : this.path().relativeTo(referenceableRoot.path());
        UUID uuid = UUID.fromString(referenceableRoot.getUUID());
        return this.cache.getPathForCorrespondingNode(workspaceName, uuid, relativePath);
    }

    public final void update(String srcWorkspaceName) throws NoSuchWorkspaceException, RepositoryException {
        CheckArg.isNotNull((Object)srcWorkspaceName, (String)"workspace name");
        if (this.session().hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        this.checkNotProtected();
        Path correspondingPath = null;
        try {
            correspondingPath = this.correspondingNodePath(srcWorkspaceName);
        }
        catch (ItemNotFoundException infe) {
            return;
        }
        this.cache.graphSession().immediateClone(correspondingPath, srcWorkspaceName, this.path(), true, true);
        this.session().refresh(false);
    }

    public final void orderBefore(String srcChildRelPath, String destChildRelPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (!this.getPrimaryNodeType().hasOrderableChildNodes()) {
            throw new UnsupportedRepositoryOperationException(JcrI18n.notOrderable.text(new Object[]{this.getPrimaryNodeType().getName(), this.getPath()}));
        }
        PathFactory pathFactory = this.cache.pathFactory();
        Path srcPath = (Path)pathFactory.create(srcChildRelPath);
        if (srcPath.isAbsolute() || srcPath.size() != 1) {
            throw new ItemNotFoundException(JcrI18n.pathNotFound.text(new Object[]{srcPath.getString(this.cache.context().getNamespaceRegistry()), this.cache.session().workspace().getName()}));
        }
        Path.Segment sourceSegment = srcPath.getLastSegment();
        try {
            this.nodeInfo().getChild(sourceSegment);
        }
        catch (org.modeshape.graph.property.PathNotFoundException e) {
            String workspaceName = this.cache.session().getWorkspace().getName();
            throw new ItemNotFoundException(JcrI18n.pathNotFound.text(new Object[]{srcPath, workspaceName}));
        }
        Path.Segment destSegment = null;
        if (destChildRelPath != null) {
            Path destPath = (Path)pathFactory.create(destChildRelPath);
            if (destPath.isAbsolute() || destPath.size() != 1) {
                throw new ItemNotFoundException(JcrI18n.pathNotFound.text(new Object[]{destPath.getString(this.cache.context().getNamespaceRegistry()), this.cache.session().workspace().getName()}));
            }
            destSegment = destPath.getLastSegment();
            try {
                this.nodeInfo().getChild(destSegment);
            }
            catch (org.modeshape.graph.property.PathNotFoundException e) {
                String workspaceName = this.cache.session().getWorkspace().getName();
                throw new ItemNotFoundException(JcrI18n.pathNotFound.text(new Object[]{destPath, workspaceName}));
            }
        }
        this.editor().orderChildBefore(sourceSegment, destSegment);
    }

    protected static List<Object> createPatternsFor(String namePattern) throws RepositoryException {
        LinkedList<Object> patterns = new LinkedList<Object>();
        for (String stringPattern : namePattern.split("[|]")) {
            int length = (stringPattern = stringPattern.trim()).length();
            if (length == 0) continue;
            if (stringPattern.indexOf("*") == -1) {
                patterns.add(stringPattern);
                continue;
            }
            StringBuilder sb = new StringBuilder(length);
            block6: for (int i = 0; i != length; ++i) {
                char c = stringPattern.charAt(i);
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case '\"': 
                    case '\'': 
                    case '/': 
                    case '[': 
                    case ']': 
                    case '|': {
                        String msg = JcrI18n.invalidNamePattern.text(new Object[]{Character.valueOf(c), namePattern});
                        throw new RepositoryException(msg);
                    }
                    case '$': 
                    case '(': 
                    case ')': 
                    case '.': 
                    case '?': 
                    case '\\': 
                    case '^': 
                    case '{': 
                    case '}': {
                        sb.append("\\");
                        sb.append(c);
                        continue block6;
                    }
                    case '*': {
                        sb.append(".*");
                        continue block6;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            String escapedString = sb.toString();
            Pattern pattern = Pattern.compile(escapedString);
            patterns.add(pattern);
        }
        return patterns;
    }

    public void refresh(boolean keepChanges) throws RepositoryException {
        this.cache.refresh(this.nodeId, this.location.getPath(), keepChanges);
    }

    public void save() throws RepositoryException {
        this.session().checkReferentialIntegrityOfChanges(this);
        this.cache.save(this.nodeId, this.location.getPath());
    }

    public String toString() {
        try {
            PropertyIterator iter = this.getProperties();
            StringBuffer propertyBuff = new StringBuffer();
            while (iter.hasNext()) {
                AbstractJcrProperty prop = (AbstractJcrProperty)iter.nextProperty();
                propertyBuff.append(prop).append(", ");
            }
            return this.getPath() + " {" + propertyBuff.toString() + "}";
        }
        catch (RepositoryException re) {
            return re.getMessage();
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractJcrNode) {
            AbstractJcrNode that = (AbstractJcrNode)obj;
            if (this.cache != that.cache) {
                return false;
            }
            return this.location.equals((Object)that.location);
        }
        return false;
    }

    public int hashCode() {
        return HashCode.compute((Object[])new Object[]{this.cache, this.location});
    }
}

