/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import net.jcip.annotations.Immutable;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.JcrItemDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.RepositoryNodeTypeManager;

@Immutable
class JcrNodeDefinition
extends JcrItemDefinition
implements NodeDefinition {
    private final boolean allowsSameNameSiblings;
    private final Name defaultPrimaryTypeName;
    private Map<Name, JcrNodeType> requiredPrimaryTypesByName;
    private JcrNodeType[] requiredPrimaryTypes;
    private Name[] requiredPrimaryTypeNames;
    private NodeDefinitionId id;
    private final RepositoryNodeTypeManager nodeTypeManager;

    JcrNodeDefinition(ExecutionContext context, JcrNodeType declaringNodeType, Name name, int onParentVersion, boolean autoCreated, boolean mandatory, boolean protectedItem, boolean allowsSameNameSiblings, Name defaultPrimaryTypeName, Name[] requiredPrimaryTypeNames) {
        this(context, null, declaringNodeType, name, onParentVersion, autoCreated, mandatory, protectedItem, allowsSameNameSiblings, defaultPrimaryTypeName, requiredPrimaryTypeNames);
    }

    JcrNodeDefinition(ExecutionContext context, RepositoryNodeTypeManager nodeTypeManager, JcrNodeType declaringNodeType, Name name, int onParentVersion, boolean autoCreated, boolean mandatory, boolean protectedItem, boolean allowsSameNameSiblings, Name defaultPrimaryTypeName, Name[] requiredPrimaryTypeNames) {
        super(context, declaringNodeType, name, onParentVersion, autoCreated, mandatory, protectedItem);
        this.nodeTypeManager = nodeTypeManager;
        this.allowsSameNameSiblings = allowsSameNameSiblings;
        this.defaultPrimaryTypeName = defaultPrimaryTypeName;
        this.requiredPrimaryTypes = new JcrNodeType[requiredPrimaryTypeNames.length];
        this.requiredPrimaryTypeNames = requiredPrimaryTypeNames;
    }

    private void ensureRequiredPrimaryTypesLoaded() {
        if (this.requiredPrimaryTypesByName != null) {
            return;
        }
        this.requiredPrimaryTypes = new JcrNodeType[this.requiredPrimaryTypeNames.length];
        for (int i = 0; i != this.requiredPrimaryTypeNames.length; ++i) {
            this.requiredPrimaryTypes[i] = this.nodeTypeManager.getNodeType(this.requiredPrimaryTypeNames[i]);
        }
        HashMap<Name, JcrNodeType> requiredPrimaryTypesByName = new HashMap<Name, JcrNodeType>();
        for (JcrNodeType requiredPrimaryType : this.requiredPrimaryTypes) {
            requiredPrimaryTypesByName.put(requiredPrimaryType.getInternalName(), requiredPrimaryType);
        }
        this.requiredPrimaryTypesByName = Collections.unmodifiableMap(requiredPrimaryTypesByName);
    }

    public NodeDefinitionId getId() {
        if (this.id == null) {
            this.id = new NodeDefinitionId(this.declaringNodeType.getInternalName(), this.name, this.requiredPrimaryTypeNames);
        }
        return this.id;
    }

    public boolean allowsSameNameSiblings() {
        return this.allowsSameNameSiblings;
    }

    final Name defaultPrimaryTypeName() {
        return this.defaultPrimaryTypeName;
    }

    public NodeType getDefaultPrimaryType() {
        if (this.defaultPrimaryTypeName == null) {
            return null;
        }
        return this.nodeTypeManager.getNodeType(this.defaultPrimaryTypeName);
    }

    public NodeType[] getRequiredPrimaryTypes() {
        this.ensureRequiredPrimaryTypesLoaded();
        NodeType[] result = new NodeType[this.requiredPrimaryTypes.length];
        for (int i = 0; i != this.requiredPrimaryTypes.length; ++i) {
            result[i] = this.requiredPrimaryTypes[i];
        }
        return result;
    }

    Name[] requiredPrimaryTypeNames() {
        return this.requiredPrimaryTypeNames;
    }

    Set<Name> getRequiredPrimaryTypeNames() {
        this.ensureRequiredPrimaryTypesLoaded();
        return this.requiredPrimaryTypesByName.keySet();
    }

    final boolean allowsChildWithType(JcrNodeType childPrimaryType) {
        if (childPrimaryType == null) {
            return this.defaultPrimaryTypeName != null;
        }
        this.ensureRequiredPrimaryTypesLoaded();
        for (Name requiredPrimaryTypeName : this.requiredPrimaryTypesByName.keySet()) {
            if (childPrimaryType.isNodeType(requiredPrimaryTypeName)) continue;
            return false;
        }
        return true;
    }

    JcrNodeDefinition with(JcrNodeType declaringNodeType) {
        return new JcrNodeDefinition(this.context, declaringNodeType.nodeTypeManager(), declaringNodeType, this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.allowsSameNameSiblings(), this.defaultPrimaryTypeName, this.requiredPrimaryTypeNames);
    }

    JcrNodeDefinition with(ExecutionContext context) {
        return new JcrNodeDefinition(context, this.nodeTypeManager, this.declaringNodeType, this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.allowsSameNameSiblings(), this.defaultPrimaryTypeName, this.requiredPrimaryTypeNames);
    }

    JcrNodeDefinition with(RepositoryNodeTypeManager nodeTypeManager) {
        return new JcrNodeDefinition(this.context, nodeTypeManager, this.declaringNodeType, this.name, this.getOnParentVersion(), this.isAutoCreated(), this.isMandatory(), this.isProtected(), this.allowsSameNameSiblings(), this.defaultPrimaryTypeName, this.requiredPrimaryTypeNames);
    }

    public int hashCode() {
        return this.getId().toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JcrNodeDefinition other = (JcrNodeDefinition)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return this.getId().toString();
    }
}

