/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.InputStream;
import java.util.Calendar;
import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Reference;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SelfClosingInputStream;
import org.modeshape.jcr.SessionCache;

@NotThreadSafe
final class JcrSingleValueProperty
extends AbstractJcrProperty {
    JcrSingleValueProperty(SessionCache cache, AbstractJcrNode node, Name name) {
        super(cache, node, name);
    }

    @Override
    boolean isMultiple() {
        return false;
    }

    public boolean getBoolean() throws RepositoryException {
        try {
            return (Boolean)this.context().getValueFactories().getBooleanFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public Calendar getDate() throws RepositoryException {
        try {
            return ((DateTime)this.context().getValueFactories().getDateFactory().create(this.property().getFirstValue())).toCalendar();
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public double getDouble() throws RepositoryException {
        try {
            return (Double)this.context().getValueFactories().getDoubleFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public long getLength() throws RepositoryException {
        return this.createValue(this.property().getFirstValue()).getLength();
    }

    public long[] getLengths() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }

    public long getLong() throws RepositoryException {
        try {
            return (Long)this.context().getValueFactories().getLongFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public final Node getNode() throws RepositoryException {
        try {
            ValueFactories factories = this.context().getValueFactories();
            Reference dnaReference = (Reference)factories.getReferenceFactory().create(this.property().getFirstValue());
            UUID uuid = (UUID)factories.getUuidFactory().create(dnaReference);
            return this.cache.findJcrNode(Location.create((UUID)uuid));
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public InputStream getStream() throws RepositoryException {
        try {
            Binary binary = (Binary)this.context().getValueFactories().getBinaryFactory().create(this.property().getFirstValue());
            return new SelfClosingInputStream(binary);
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public String getString() throws RepositoryException {
        try {
            return (String)this.context().getValueFactories().getStringFactory().create(this.property().getFirstValue());
        }
        catch (ValueFormatException e) {
            throw new javax.jcr.ValueFormatException(e.getMessage(), (Throwable)e);
        }
    }

    public Value getValue() throws RepositoryException {
        return this.createValue(this.property().getFirstValue());
    }

    public void setValue(Value value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        JcrValue jcrValue = null;
        this.checkForLock();
        if (value instanceof JcrValue) {
            jcrValue = (JcrValue)value;
            jcrValue.asType(this.getType());
            this.editor().setProperty(this.name(), jcrValue);
            return;
        }
        if (value == null) {
            this.editor().removeProperty(this.name());
            return;
        }
        switch (value.getType()) {
            case 1: {
                this.setValue(value.getString());
                break;
            }
            case 2: {
                this.setValue(value.getStream());
                break;
            }
            case 6: {
                this.setValue(value.getBoolean());
                break;
            }
            case 5: {
                this.setValue(value.getDate());
                break;
            }
            case 4: {
                this.setValue(value.getDouble());
                break;
            }
            case 3: {
                this.setValue(value.getLong());
                break;
            }
            case 7: {
                this.setValue(value.getString());
                break;
            }
            case 8: {
                this.setValue(value.getString());
                break;
            }
            case 9: {
                this.setValue(value.getString());
                break;
            }
            default: {
                throw new RepositoryException(JcrI18n.invalidPropertyType.text(new Object[]{value.getType()}));
            }
        }
    }

    protected void setValue(JcrValue jcrValue) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        assert (jcrValue != null);
        this.checkForLock();
        this.editor().setProperty(this.name(), jcrValue);
    }

    public void setValue(String value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.setValue(this.createValue(value, 1).asType(this.getType()));
    }

    public void setValue(InputStream value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.setValue(this.createValue(this.context().getValueFactories().getBinaryFactory().create((Object)value), 2).asType(this.getType()));
    }

    public void setValue(long value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.createValue(new Long(value), 3).asType(this.getType()));
    }

    public void setValue(double value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.createValue(new Double(value), 4).asType(this.getType()));
    }

    public void setValue(Calendar value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        this.setValue(this.createValue(this.context().getValueFactories().getDateFactory().create(value), 5).asType(this.getType()));
    }

    public void setValue(boolean value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(this.createValue(new Boolean(value), 6).asType(this.getType()));
    }

    public void setValue(Node value) throws javax.jcr.ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        if (value == null) {
            this.remove();
            return;
        }
        if (!value.isNodeType(JcrMixLexicon.REFERENCEABLE.getString(this.context().getNamespaceRegistry()))) {
            throw new javax.jcr.ValueFormatException(JcrI18n.nodeNotReferenceable.text(new Object[0]));
        }
        String uuid = value.getUUID();
        this.setValue(this.createValue(uuid, 9).asType(this.getType()));
    }

    public Value[] getValues() throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }

    public void setValue(Value[] values) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }

    public void setValue(String[] values) throws javax.jcr.ValueFormatException {
        throw new javax.jcr.ValueFormatException(JcrI18n.invalidMethodForSingleValuedProperty.text(new Object[0]));
    }
}

