/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.version.OnParentVersionAction;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.SubgraphNode;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.parse.QueryParser;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrItemDefinition;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeSource;
import org.modeshape.jcr.JcrNodeTypeTemplate;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.NodeTemplateNodeTypeSource;
import org.modeshape.jcr.NodeTypeSchemata;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.nodetype.InvalidNodeTypeDefinitionException;
import org.modeshape.jcr.nodetype.NodeTypeDefinition;
import org.modeshape.jcr.nodetype.NodeTypeExistsException;
import org.modeshape.jcr.nodetype.NodeTypeTemplate;

@ThreadSafe
class RepositoryNodeTypeManager {
    private static final Map<String, Integer> PROPERTY_TYPE_VALUES_FROM_NAME;
    private static final TextEncoder NAME_ENCODER;
    private final JcrRepository repository;
    private final QueryParser queryParser;
    private final ExecutionContext context;
    @GuardedBy(value="nodeTypeManagerLock")
    private final Map<Name, JcrNodeType> nodeTypes;
    @GuardedBy(value="nodeTypeManagerLock")
    private final Map<PropertyDefinitionId, JcrPropertyDefinition> propertyDefinitions;
    @GuardedBy(value="nodeTypeManagerLock")
    private final Map<NodeDefinitionId, JcrNodeDefinition> childNodeDefinitions;
    @GuardedBy(value="nodeTypeManagerLock")
    private NodeTypeSchemata schemata;
    private final PropertyFactory propertyFactory;
    private final PathFactory pathFactory;
    private final ReadWriteLock nodeTypeManagerLock = new ReentrantReadWriteLock();
    private final boolean includeColumnsForInheritedProperties;

    RepositoryNodeTypeManager(JcrRepository repository, boolean includeColumnsForInheritedProperties) {
        this.repository = repository;
        this.context = repository.getExecutionContext();
        this.includeColumnsForInheritedProperties = includeColumnsForInheritedProperties;
        this.propertyFactory = this.context.getPropertyFactory();
        this.pathFactory = this.context.getValueFactories().getPathFactory();
        this.propertyDefinitions = new HashMap<PropertyDefinitionId, JcrPropertyDefinition>();
        this.childNodeDefinitions = new HashMap<NodeDefinitionId, JcrNodeDefinition>();
        this.nodeTypes = new HashMap<Name, JcrNodeType>(50);
        this.queryParser = new SqlQueryParser();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JcrNodeType> getAllNodeTypes() {
        try {
            this.nodeTypeManagerLock.readLock().lock();
            Collection<JcrNodeType> collection = Collections.unmodifiableCollection(new ArrayList<JcrNodeType>(this.nodeTypes.values()));
            return collection;
        }
        finally {
            this.nodeTypeManagerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JcrNodeType> getMixinNodeTypes() {
        try {
            this.nodeTypeManagerLock.readLock().lock();
            ArrayList<JcrNodeType> types = new ArrayList<JcrNodeType>(this.nodeTypes.size());
            for (JcrNodeType nodeType : this.nodeTypes.values()) {
                if (!nodeType.isMixin()) continue;
                types.add(nodeType);
            }
            ArrayList<JcrNodeType> arrayList = types;
            return arrayList;
        }
        finally {
            this.nodeTypeManagerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<JcrNodeType> getPrimaryNodeTypes() {
        try {
            this.nodeTypeManagerLock.readLock().lock();
            ArrayList<JcrNodeType> types = new ArrayList<JcrNodeType>(this.nodeTypes.size());
            for (JcrNodeType nodeType : this.nodeTypes.values()) {
                if (nodeType.isMixin()) continue;
                types.add(nodeType);
            }
            ArrayList<JcrNodeType> arrayList = types;
            return arrayList;
        }
        finally {
            this.nodeTypeManagerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrPropertyDefinition getPropertyDefinition(PropertyDefinitionId id) {
        try {
            this.nodeTypeManagerLock.readLock().lock();
            JcrPropertyDefinition jcrPropertyDefinition = this.propertyDefinitions.get(id);
            return jcrPropertyDefinition;
        }
        finally {
            this.nodeTypeManagerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JcrNodeDefinition getChildNodeDefinition(NodeDefinitionId id) {
        try {
            this.nodeTypeManagerLock.readLock().lock();
            JcrNodeDefinition jcrNodeDefinition = this.childNodeDefinitions.get(id);
            return jcrNodeDefinition;
        }
        finally {
            this.nodeTypeManagerLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeTypeSchemata getRepositorySchemata() {
        try {
            this.nodeTypeManagerLock.writeLock().lock();
            if (this.schemata == null) {
                this.schemata = new NodeTypeSchemata(this.context, this.nodeTypes, this.propertyDefinitions.values(), this.includeColumnsForInheritedProperties);
            }
            NodeTypeSchemata nodeTypeSchemata = this.schemata;
            return nodeTypeSchemata;
        }
        finally {
            this.nodeTypeManagerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void signalNamespaceChanges() {
        try {
            this.nodeTypeManagerLock.writeLock().lock();
            this.schemata = null;
        }
        finally {
            this.nodeTypeManagerLock.writeLock().unlock();
        }
        this.schemata = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JcrNodeType getNodeType(Name nodeTypeName) {
        try {
            this.nodeTypeManagerLock.readLock().lock();
            JcrNodeType jcrNodeType = this.nodeTypes.get(nodeTypeName);
            return jcrNodeType;
        }
        finally {
            this.nodeTypeManagerLock.readLock().unlock();
        }
    }

    JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, List<Name> mixinTypeNames, Name propertyName, Value value, boolean checkMultiValuedDefinitions, boolean skipProtected) {
        int type;
        boolean setToEmpty = value == null;
        boolean matchedOnName = false;
        JcrNodeType primaryType = this.getNodeType(primaryTypeName);
        if (primaryType != null) {
            int type2;
            for (JcrPropertyDefinition definition : primaryType.allSingleValuePropertyDefinitions(propertyName)) {
                matchedOnName = true;
                if (skipProtected && definition.isProtected()) {
                    return null;
                }
                if (setToEmpty) {
                    if (definition.isMandatory()) continue;
                    return definition;
                }
                assert (value != null);
                type2 = definition.getRequiredType();
                if (type2 == 9 && type2 == value.getType()) {
                    return definition;
                }
                if (type2 != 0 && type2 != value.getType() || !definition.satisfiesConstraints(value)) continue;
                return definition;
            }
            if (matchedOnName) {
                if (value != null) {
                    for (JcrPropertyDefinition definition : primaryType.allSingleValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        type2 = definition.getRequiredType();
                        if (type2 == 9 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(value)) continue;
                        return definition;
                    }
                }
                if (checkMultiValuedDefinitions) {
                    for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (setToEmpty) {
                            if (definition.isMandatory()) continue;
                            return definition;
                        }
                        assert (value != null);
                        type2 = definition.getRequiredType();
                        if (type2 == 9 && type2 == value.getType()) {
                            return definition;
                        }
                        if (type2 != 0 && type2 != value.getType() || !definition.satisfiesConstraints(value)) continue;
                        return definition;
                    }
                    if (value != null) {
                        for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            assert (definition.getRequiredType() != 0);
                            type2 = definition.getRequiredType();
                            if (type2 == 9 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(value)) continue;
                            return definition;
                        }
                    }
                }
                return null;
            }
        }
        LinkedList<JcrNodeType> mixinTypes = null;
        if (mixinTypeNames != null && !mixinTypeNames.isEmpty()) {
            mixinTypes = new LinkedList<JcrNodeType>();
            for (Name mixinTypeName : mixinTypeNames) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                mixinTypes.add(mixinType);
                for (JcrPropertyDefinition definition : mixinType.allSingleValuePropertyDefinitions(propertyName)) {
                    matchedOnName = true;
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (setToEmpty) {
                        if (definition.isMandatory()) continue;
                        return definition;
                    }
                    assert (value != null);
                    type = definition.getRequiredType();
                    if (type == 9 && type == value.getType()) {
                        return definition;
                    }
                    if (type != 0 && type != value.getType() || !definition.satisfiesConstraints(value)) continue;
                    return definition;
                }
                if (!matchedOnName) continue;
                if (value != null) {
                    for (JcrPropertyDefinition definition : mixinType.allSingleValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        type = definition.getRequiredType();
                        if (type == 9 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(value)) continue;
                        return definition;
                    }
                }
                if (checkMultiValuedDefinitions) {
                    for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (setToEmpty) {
                            if (definition.isMandatory()) continue;
                            return definition;
                        }
                        assert (value != null);
                        type = definition.getRequiredType();
                        if (type == 9 && type == value.getType()) {
                            return definition;
                        }
                        if (type != 0 && type != value.getType() || !definition.satisfiesConstraints(value)) continue;
                        return definition;
                    }
                    if (value != null) {
                        for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                            matchedOnName = true;
                            if (skipProtected && definition.isProtected()) {
                                return null;
                            }
                            assert (definition.getRequiredType() != 0);
                            type = definition.getRequiredType();
                            if (type == 9 && definition.canCastToType(value)) {
                                return definition;
                            }
                            if (!definition.canCastToTypeAndSatisfyConstraints(value)) continue;
                            return definition;
                        }
                    }
                }
                return null;
            }
        }
        if (checkMultiValuedDefinitions) {
            if (primaryType != null) {
                for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                    matchedOnName = true;
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (setToEmpty) {
                        if (definition.isMandatory()) continue;
                        return definition;
                    }
                    assert (value != null);
                    int type3 = definition.getRequiredType();
                    if (type3 == 9 && type3 == value.getType()) {
                        return definition;
                    }
                    if (type3 != 0 && type3 != value.getType() || !definition.satisfiesConstraints(value)) continue;
                    return definition;
                }
                if (value != null) {
                    for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                        matchedOnName = true;
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        int type4 = definition.getRequiredType();
                        if (type4 == 9 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(value)) continue;
                        return definition;
                    }
                }
            }
            if (matchedOnName) {
                return null;
            }
            if (mixinTypeNames != null && !mixinTypeNames.isEmpty()) {
                mixinTypes = new LinkedList();
                for (Name mixinTypeName : mixinTypeNames) {
                    JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                    if (mixinType == null) continue;
                    mixinTypes.add(mixinType);
                    for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                        matchedOnName = true;
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        if (setToEmpty) {
                            if (definition.isMandatory()) continue;
                            return definition;
                        }
                        assert (value != null);
                        type = definition.getRequiredType();
                        if (type == 9 && type == value.getType()) {
                            return definition;
                        }
                        if (type != 0 && type != value.getType() || !definition.satisfiesConstraints(value)) continue;
                        return definition;
                    }
                    if (value == null) continue;
                    for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                        matchedOnName = true;
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        type = definition.getRequiredType();
                        if (type == 9 && definition.canCastToType(value)) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(value)) continue;
                        return definition;
                    }
                }
            }
            if (matchedOnName) {
                return null;
            }
        }
        if (!propertyName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.findPropertyDefinition(primaryTypeName, mixinTypeNames, JcrNodeType.RESIDUAL_NAME, value, checkMultiValuedDefinitions, skipProtected);
        }
        return null;
    }

    JcrPropertyDefinition findPropertyDefinition(Name primaryTypeName, List<Name> mixinTypeNames, Name propertyName, Value[] values, boolean skipProtected) {
        boolean setToEmpty = values == null;
        int propertyType = values == null || values.length == 0 ? 1 : values[0].getType();
        boolean matchedOnName = false;
        JcrNodeType primaryType = this.getNodeType(primaryTypeName);
        if (primaryType != null) {
            for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                boolean typeMatches;
                matchedOnName = true;
                if (skipProtected && definition.isProtected()) {
                    return null;
                }
                if (setToEmpty) {
                    if (definition.isMandatory()) continue;
                    return definition;
                }
                assert (values != null);
                int type = definition.getRequiredType();
                boolean bl = typeMatches = values.length == 0 || type == 0 || type == propertyType;
                if (typeMatches && type == 9) {
                    return definition;
                }
                if (!typeMatches || !definition.satisfiesConstraints(values)) continue;
                return definition;
            }
            if (matchedOnName) {
                if (values != null && values.length != 0) {
                    for (JcrPropertyDefinition definition : primaryType.allMultiValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        if (definition.getRequiredType() == 9 && definition.canCastToType(values)) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(values)) continue;
                        return definition;
                    }
                }
                return null;
            }
        }
        LinkedList<JcrNodeType> mixinTypes = null;
        if (mixinTypeNames != null && !mixinTypeNames.isEmpty()) {
            mixinTypes = new LinkedList<JcrNodeType>();
            for (Name mixinTypeName : mixinTypeNames) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                mixinTypes.add(mixinType);
                for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                    boolean typeMatches;
                    matchedOnName = true;
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (setToEmpty) {
                        if (definition.isMandatory()) continue;
                        return definition;
                    }
                    assert (values != null);
                    int type = definition.getRequiredType();
                    boolean bl = typeMatches = values.length == 0 || type == 0 || type == propertyType;
                    if (typeMatches && type == 9) {
                        return definition;
                    }
                    if (!typeMatches || !definition.satisfiesConstraints(values)) continue;
                    return definition;
                }
                if (!matchedOnName) continue;
                if (values != null && values.length != 0) {
                    for (JcrPropertyDefinition definition : mixinType.allMultiValuePropertyDefinitions(propertyName)) {
                        if (skipProtected && definition.isProtected()) {
                            return null;
                        }
                        assert (definition.getRequiredType() != 0);
                        if (definition.getRequiredType() == 9 && definition.canCastToType(values)) {
                            return definition;
                        }
                        if (!definition.canCastToTypeAndSatisfyConstraints(values)) continue;
                        return definition;
                    }
                }
                return null;
            }
        }
        if (!propertyName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.findPropertyDefinition(primaryTypeName, mixinTypeNames, JcrNodeType.RESIDUAL_NAME, values, skipProtected);
        }
        return null;
    }

    private List<JcrPropertyDefinition> findPropertyDefinitions(List<Name> typeNamesToCheck, Name propertyName, PropertyCardinality typeToCheck, List<JcrNodeType> pendingTypes) {
        assert (typeNamesToCheck != null);
        Collection<JcrPropertyDefinition> propDefs = null;
        ArrayList<JcrPropertyDefinition> matchingDefs = new ArrayList<JcrPropertyDefinition>();
        for (Name typeNameToCheck : typeNamesToCheck) {
            JcrNodeType typeName = this.findTypeInMapOrList(typeNameToCheck, pendingTypes);
            if (typeName == null) continue;
            switch (typeToCheck) {
                case SINGLE_VALUED_ONLY: {
                    propDefs = typeName.allSingleValuePropertyDefinitions(propertyName);
                    break;
                }
                case MULTI_VALUED_ONLY: {
                    propDefs = typeName.allMultiValuePropertyDefinitions(propertyName);
                    break;
                }
                case ANY: {
                    propDefs = typeName.allPropertyDefinitions(propertyName);
                    break;
                }
                default: {
                    throw new IllegalStateException("Should be unreachable: " + (Object)((Object)typeToCheck));
                }
            }
            matchingDefs.addAll(propDefs);
        }
        return matchingDefs;
    }

    boolean canRemoveProperty(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name propertyName, boolean skipProtected) {
        JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
        if (primaryType != null) {
            for (JcrPropertyDefinition definition : primaryType.allPropertyDefinitions(propertyName)) {
                if (skipProtected && definition.isProtected()) continue;
                return !definition.isMandatory();
            }
        }
        if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
            for (Name mixinTypeName : mixinTypeNamesOfParent) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                for (JcrPropertyDefinition definition : mixinType.allPropertyDefinitions(propertyName)) {
                    if (skipProtected && definition.isProtected()) continue;
                    return !definition.isMandatory();
                }
            }
        }
        if (!propertyName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.canRemoveProperty(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, skipProtected);
        }
        return false;
    }

    boolean canRemoveItem(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name itemName, boolean skipProtected) {
        JcrNodeType mixinType;
        JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
        if (primaryType != null) {
            for (JcrPropertyDefinition jcrPropertyDefinition : primaryType.allPropertyDefinitions(itemName)) {
                if (skipProtected && jcrPropertyDefinition.isProtected()) continue;
                return !jcrPropertyDefinition.isMandatory();
            }
        }
        if (primaryType != null) {
            for (JcrNodeDefinition jcrNodeDefinition : primaryType.allChildNodeDefinitions(itemName)) {
                if (skipProtected && jcrNodeDefinition.isProtected()) continue;
                return !jcrNodeDefinition.isMandatory();
            }
        }
        if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
            for (Name name : mixinTypeNamesOfParent) {
                mixinType = this.getNodeType(name);
                if (mixinType == null) continue;
                for (JcrPropertyDefinition jcrPropertyDefinition : mixinType.allPropertyDefinitions(itemName)) {
                    if (skipProtected && jcrPropertyDefinition.isProtected()) continue;
                    return !jcrPropertyDefinition.isMandatory();
                }
            }
        }
        if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
            for (Name name : mixinTypeNamesOfParent) {
                mixinType = this.getNodeType(name);
                if (mixinType == null) continue;
                for (JcrNodeDefinition jcrNodeDefinition : mixinType.allChildNodeDefinitions(itemName)) {
                    if (skipProtected && jcrNodeDefinition.isProtected()) continue;
                    return !jcrNodeDefinition.isMandatory();
                }
            }
        }
        if (!itemName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.canRemoveItem(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, skipProtected);
        }
        return false;
    }

    JcrNodeDefinition findChildNodeDefinition(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name childName, Name childPrimaryNodeType, int numberOfExistingChildrenWithSameName, boolean skipProtected) {
        JcrNodeType childType = childPrimaryNodeType != null ? this.getNodeType(childPrimaryNodeType) : null;
        boolean requireSns = numberOfExistingChildrenWithSameName > 1;
        JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
        if (primaryType != null) {
            for (JcrNodeDefinition definition : primaryType.allChildNodeDefinitions(childName, requireSns)) {
                if (skipProtected && definition.isProtected()) {
                    return null;
                }
                if (!definition.allowsChildWithType(childType)) continue;
                return definition;
            }
        }
        if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
            for (Name mixinTypeName : mixinTypeNamesOfParent) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                for (JcrNodeDefinition definition : mixinType.allChildNodeDefinitions(childName, requireSns)) {
                    if (skipProtected && definition.isProtected()) {
                        return null;
                    }
                    if (!definition.allowsChildWithType(childType)) continue;
                    return definition;
                }
            }
        }
        if (!childName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.findChildNodeDefinition(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, childPrimaryNodeType, numberOfExistingChildrenWithSameName, skipProtected);
        }
        return null;
    }

    private List<JcrNodeDefinition> findChildNodeDefinitions(List<Name> typeNamesToCheck, Name childNodeName, NodeCardinality typesToCheck, List<JcrNodeType> pendingTypes) {
        assert (typeNamesToCheck != null);
        Collection<JcrNodeDefinition> nodeDefs = null;
        ArrayList<JcrNodeDefinition> matchingDefs = new ArrayList<JcrNodeDefinition>();
        for (Name typeNameToCheck : typeNamesToCheck) {
            JcrNodeType typeName = this.findTypeInMapOrList(typeNameToCheck, pendingTypes);
            if (typeName == null) continue;
            switch (typesToCheck) {
                case NO_SAME_NAME_SIBLINGS: {
                    nodeDefs = typeName.allChildNodeDefinitions(childNodeName, false);
                    break;
                }
                case SAME_NAME_SIBLINGS: {
                    nodeDefs = typeName.allChildNodeDefinitions(childNodeName, true);
                    break;
                }
                case ANY: {
                    nodeDefs = typeName.allChildNodeDefinitions(childNodeName);
                }
            }
            assert (nodeDefs != null);
            for (JcrNodeDefinition definition : nodeDefs) {
                if (NodeCardinality.NO_SAME_NAME_SIBLINGS == typesToCheck && definition.allowsSameNameSiblings()) continue;
                matchingDefs.add(definition);
            }
        }
        return matchingDefs;
    }

    boolean canRemoveAllChildren(Name primaryTypeNameOfParent, List<Name> mixinTypeNamesOfParent, Name childName, boolean skipProtected) {
        JcrNodeType primaryType = this.getNodeType(primaryTypeNameOfParent);
        if (primaryType != null) {
            for (JcrNodeDefinition definition : primaryType.allChildNodeDefinitions(childName)) {
                if (skipProtected && definition.isProtected()) continue;
                return !definition.isMandatory();
            }
        }
        if (mixinTypeNamesOfParent != null && !mixinTypeNamesOfParent.isEmpty()) {
            for (Name mixinTypeName : mixinTypeNamesOfParent) {
                JcrNodeType mixinType = this.getNodeType(mixinTypeName);
                if (mixinType == null) continue;
                for (JcrNodeDefinition definition : mixinType.allChildNodeDefinitions(childName)) {
                    if (skipProtected && definition.isProtected()) continue;
                    return !definition.isMandatory();
                }
            }
        }
        if (!childName.equals(JcrNodeType.RESIDUAL_NAME)) {
            return this.canRemoveAllChildren(primaryTypeNameOfParent, mixinTypeNamesOfParent, JcrNodeType.RESIDUAL_NAME, skipProtected);
        }
        return false;
    }

    void projectOnto(Graph graph, Path parentOfTypeNodes) {
        assert (graph != null);
        assert (parentOfTypeNodes != null);
        try {
            graph.getNodeAt(parentOfTypeNodes);
        }
        catch (PathNotFoundException pnfe) {
            PropertyFactory propertyFactory = this.context.getPropertyFactory();
            graph.create(parentOfTypeNodes, propertyFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.NODE_TYPES.getString(this.context.getNamespaceRegistry())})).and();
        }
        Graph.Batch batch = graph.batch();
        for (JcrNodeType nodeType : this.getAllNodeTypes()) {
            this.projectNodeTypeOnto(nodeType, parentOfTypeNodes, batch);
        }
        batch.execute();
    }

    private void projectNodeTypeOnto(JcrNodeType nodeType, Path parentOfTypeNodes, Graph.Batch batch) {
        assert (nodeType != null);
        assert (parentOfTypeNodes != null);
        assert (batch != null);
        Path nodeTypePath = this.pathFactory.create(parentOfTypeNodes, new Name[]{nodeType.getInternalName()});
        JcrNodeType[] supertypes = nodeType.getDeclaredSupertypes();
        ArrayList<Name> supertypeNames = new ArrayList<Name>(supertypes.length);
        for (int i = 0; i < supertypes.length; ++i) {
            supertypeNames.add(supertypes[i].getInternalName());
        }
        ArrayList<Property> propsList = new ArrayList<Property>();
        propsList.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.NODE_TYPE}));
        propsList.add(this.propertyFactory.create(JcrLexicon.IS_MIXIN, new Object[]{nodeType.isMixin()}));
        if (nodeType.getPrimaryItemName() != null) {
            propsList.add(this.propertyFactory.create(JcrLexicon.PRIMARY_ITEM_NAME, new Object[]{nodeType.getPrimaryItemName()}));
        }
        propsList.add(this.propertyFactory.create(JcrLexicon.NODE_TYPE_NAME, new Object[]{nodeType.getName()}));
        propsList.add(this.propertyFactory.create(JcrLexicon.HAS_ORDERABLE_CHILD_NODES, new Object[]{nodeType.hasOrderableChildNodes()}));
        propsList.add(this.propertyFactory.create(JcrLexicon.SUPERTYPES, supertypeNames));
        batch.create(nodeTypePath).with(propsList).and();
        JcrPropertyDefinition[] propertyDefs = nodeType.getDeclaredPropertyDefinitions();
        for (int i = 0; i < propertyDefs.length; ++i) {
            this.projectPropertyDefinitionOnto(propertyDefs[i], nodeTypePath, batch);
        }
        JcrNodeDefinition[] childNodeDefs = nodeType.getDeclaredChildNodeDefinitions();
        for (int i = 0; i < childNodeDefs.length; ++i) {
            this.projectChildNodeDefinitionOnto(childNodeDefs[i], nodeTypePath, batch);
        }
    }

    private void projectPropertyDefinitionOnto(PropertyDefinition propertyDef, Path nodeTypePath, Graph.Batch batch) {
        String[] valueConstraints;
        assert (propertyDef != null);
        assert (nodeTypePath != null);
        assert (batch != null);
        JcrPropertyDefinition jcrPropDef = (JcrPropertyDefinition)propertyDef;
        String propName = jcrPropDef.getInternalName().getString(this.context.getNamespaceRegistry(), NAME_ENCODER);
        Path propDefPath = this.pathFactory.create(nodeTypePath, new Name[]{JcrLexicon.PROPERTY_DEFINITION});
        ArrayList<Property> propsList = new ArrayList<Property>();
        propsList.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.PROPERTY_DEFINITION}));
        if (!"*".equals(jcrPropDef.getName())) {
            propsList.add(this.propertyFactory.create(JcrLexicon.NAME, new Object[]{propName}));
        }
        propsList.add(this.propertyFactory.create(JcrLexicon.AUTO_CREATED, new Object[]{jcrPropDef.isAutoCreated()}));
        propsList.add(this.propertyFactory.create(JcrLexicon.MANDATORY, new Object[]{jcrPropDef.isMandatory()}));
        propsList.add(this.propertyFactory.create(JcrLexicon.MULTIPLE, new Object[]{jcrPropDef.isMultiple()}));
        propsList.add(this.propertyFactory.create(JcrLexicon.PROTECTED, new Object[]{jcrPropDef.isProtected()}));
        propsList.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, new Object[]{OnParentVersionAction.nameFromValue((int)jcrPropDef.getOnParentVersion())}));
        propsList.add(this.propertyFactory.create(JcrLexicon.REQUIRED_TYPE, new Object[]{PropertyType.nameFromValue((int)jcrPropDef.getRequiredType())}));
        Value[] defaultValues = jcrPropDef.getDefaultValues();
        if (defaultValues.length > 0) {
            String[] defaultsAsString = new String[defaultValues.length];
            for (int i = 0; i < defaultValues.length; ++i) {
                try {
                    defaultsAsString[i] = defaultValues[i].getString();
                    continue;
                }
                catch (RepositoryException re) {
                    throw new IllegalStateException(re);
                }
            }
            propsList.add(this.propertyFactory.create(JcrLexicon.DEFAULT_VALUES, (Object[])defaultsAsString));
        }
        if ((valueConstraints = jcrPropDef.getValueConstraints()).length > 0) {
            propsList.add(this.propertyFactory.create(JcrLexicon.DEFAULT_VALUES, (Object[])valueConstraints));
        }
        batch.create(propDefPath).with(propsList).and();
    }

    private void projectChildNodeDefinitionOnto(NodeDefinition childNodeDef, Path nodeTypePath, Graph.Batch batch) {
        assert (childNodeDef != null);
        assert (nodeTypePath != null);
        assert (batch != null);
        JcrNodeDefinition jcrNodeDef = (JcrNodeDefinition)childNodeDef;
        String nodeName = jcrNodeDef.getInternalName().getString(this.context.getNamespaceRegistry(), NAME_ENCODER);
        Path nodeDefPath = this.pathFactory.create(nodeTypePath, new Name[]{JcrLexicon.CHILD_NODE_DEFINITION});
        ArrayList<Property> propsList = new ArrayList<Property>();
        propsList.add(this.propertyFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.CHILD_NODE_DEFINITION}));
        if (!"*".equals(jcrNodeDef.getName())) {
            propsList.add(this.propertyFactory.create(JcrLexicon.NAME, new Object[]{nodeName}));
        }
        if (jcrNodeDef.getDefaultPrimaryType() != null) {
            propsList.add(this.propertyFactory.create(JcrLexicon.DEFAULT_PRIMARY_TYPE, new Object[]{jcrNodeDef.getDefaultPrimaryType().getName()}));
        }
        propsList.add(this.propertyFactory.create(JcrLexicon.REQUIRED_PRIMARY_TYPES, jcrNodeDef.getRequiredPrimaryTypeNames()));
        propsList.add(this.propertyFactory.create(JcrLexicon.SAME_NAME_SIBLINGS, new Object[]{jcrNodeDef.allowsSameNameSiblings()}));
        propsList.add(this.propertyFactory.create(JcrLexicon.ON_PARENT_VERSION, new Object[]{OnParentVersionAction.nameFromValue((int)jcrNodeDef.getOnParentVersion())}));
        propsList.add(this.propertyFactory.create(JcrLexicon.AUTO_CREATED, new Object[]{jcrNodeDef.isAutoCreated()}));
        propsList.add(this.propertyFactory.create(JcrLexicon.MANDATORY, new Object[]{jcrNodeDef.isMandatory()}));
        propsList.add(this.propertyFactory.create(JcrLexicon.PROTECTED, new Object[]{jcrNodeDef.isProtected()}));
        batch.create(nodeDefPath).with(propsList).and();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterNodeType(Collection<Name> nodeTypeNames) throws NoSuchNodeTypeException, InvalidNodeTypeDefinitionException, RepositoryException {
        CheckArg.isNotNull(nodeTypeNames, (String)"nodeTypeNames");
        try {
            this.nodeTypeManagerLock.writeLock().lock();
            for (Name nodeTypeName : nodeTypeNames) {
                if (nodeTypeName == null) {
                    throw new NoSuchNodeTypeException(JcrI18n.invalidNodeTypeName.text(new Object[0]));
                }
                String name = nodeTypeName.getString(this.context.getNamespaceRegistry());
                if (!this.nodeTypes.containsKey(nodeTypeName)) {
                    throw new NoSuchNodeTypeException(JcrI18n.noSuchNodeType.text(new Object[]{name}));
                }
                for (JcrNodeType nodeType : this.nodeTypes.values()) {
                    if (nodeTypeNames.contains(nodeType.getInternalName())) continue;
                    for (JcrNodeType supertype : nodeType.supertypes()) {
                        if (!nodeTypeName.equals(supertype.getInternalName())) continue;
                        throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterSupertype.text(new Object[]{name, supertype.getName()}));
                    }
                    for (JcrNodeDefinition childNode : nodeType.childNodeDefinitions()) {
                        NodeType defaultPrimaryType = childNode.getDefaultPrimaryType();
                        if (defaultPrimaryType != null && name.equals(defaultPrimaryType.getName())) {
                            throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterDefaultPrimaryType.text(new Object[]{name, nodeType.getName(), childNode.getName()}));
                        }
                        if (!childNode.getRequiredPrimaryTypeNames().contains(nodeTypeName)) continue;
                        throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterRequiredPrimaryType.text(new Object[]{name, nodeType.getName(), childNode.getName()}));
                    }
                    if (!this.isNodeTypeInUse(nodeTypeName)) continue;
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotUnregisterInUseType.text(new Object[]{name}));
                }
            }
            this.nodeTypes.keySet().removeAll(nodeTypeNames);
            this.schemata = null;
        }
        finally {
            this.nodeTypeManagerLock.writeLock().unlock();
        }
    }

    boolean isNodeTypeInUse(Name nodeTypeName) throws InvalidQueryException {
        String nodeTypeString = nodeTypeName.getString(this.context.getNamespaceRegistry());
        String expression = "SELECT * from [" + nodeTypeString + "] LIMIT 1";
        TypeSystem typeSystem = this.context.getValueFactories().getTypeSystem();
        QueryCommand command = this.queryParser.parseQuery(expression, typeSystem);
        assert (command != null) : "Could not parse " + expression;
        NodeTypeSchemata schemata = this.getRepositorySchemata();
        Set<String> workspaceNames = this.repository.workspaceNames();
        for (String workspaceName : workspaceNames) {
            QueryResults result = this.repository.queryManager().query(workspaceName, command, schemata, null, null);
            if (result.getRowCount() <= 0) continue;
            return true;
        }
        return false;
    }

    JcrNodeType registerNodeType(NodeTypeDefinition ntd, boolean allowUpdates) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        assert (ntd != null);
        assert (ntd instanceof JcrNodeTypeTemplate);
        JcrNodeTypeTemplate jntt = (JcrNodeTypeTemplate)ntd;
        return this.registerNodeTypes(new NodeTemplateNodeTypeSource(jntt)).get(0);
    }

    List<JcrNodeType> registerNodeTypes(Collection<NodeTypeDefinition> nodeTypeBatch, boolean allowUpdates) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        if (nodeTypeBatch.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<NodeTypeTemplate> ntts = new ArrayList<NodeTypeTemplate>(nodeTypeBatch.size());
        for (NodeTypeDefinition ntd : nodeTypeBatch) {
            assert (ntd instanceof JcrNodeTypeTemplate);
            ntts.add((JcrNodeTypeTemplate)ntd);
        }
        return this.registerNodeTypes(new NodeTemplateNodeTypeSource(ntts));
    }

    List<JcrNodeType> registerNodeTypes(JcrNodeTypeSource nodeTypeSource) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        assert (nodeTypeSource != null);
        Graph nodeTypesGraph = nodeTypeSource.getNodeTypes();
        Subgraph nodeTypesSubgraph = (Subgraph)nodeTypesGraph.getSubgraphOfDepth(3).at("/");
        return this.registerNodeTypes(nodeTypesSubgraph, nodeTypesSubgraph.getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<JcrNodeType> registerNodeTypes(Subgraph nodeTypeSubgraph, Location locationOfParentOfNodeTypes) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, RepositoryException {
        assert (nodeTypeSubgraph != null);
        assert (locationOfParentOfNodeTypes != null);
        NamespaceRegistry namespaces = this.context.getNamespaceRegistry();
        List nodeTypeLocations = ((SubgraphNode)nodeTypeSubgraph.getNode(locationOfParentOfNodeTypes)).getChildren();
        ArrayList<JcrNodeType> typesPendingRegistration = new ArrayList<JcrNodeType>(nodeTypeLocations.size());
        try {
            this.nodeTypeManagerLock.writeLock().lock();
            for (Location location : nodeTypeLocations) {
                Node nodeTypeNode = nodeTypeSubgraph.getNode(location);
                assert (location.getPath() != null);
                Name internalName = location.getPath().getLastSegment().getName();
                if (internalName == null || internalName.getLocalName().length() == 0) {
                    throw new InvalidNodeTypeDefinitionException(JcrI18n.invalidNodeTypeName.text(new Object[0]));
                }
                if (this.nodeTypes.containsKey(internalName)) {
                    throw new NodeTypeExistsException(internalName, JcrI18n.nodeTypeAlreadyExists.text(new Object[]{internalName.getString(namespaces)}));
                }
                List<JcrNodeType> supertypes = this.supertypesFor(nodeTypeNode, typesPendingRegistration);
                JcrNodeType nodeType = this.nodeTypeFrom(nodeTypeSubgraph, location, supertypes);
                this.validate(nodeType, supertypes, typesPendingRegistration);
                ArrayList<JcrPropertyDefinition> propertyDefs = new ArrayList<JcrPropertyDefinition>(nodeType.getDeclaredPropertyDefinitions().length);
                for (JcrPropertyDefinition propertyDef : nodeType.getDeclaredPropertyDefinitions()) {
                    propertyDefs.add(propertyDef.with(this.context));
                }
                ArrayList<JcrNodeDefinition> nodeDefs = new ArrayList<JcrNodeDefinition>(nodeType.getDeclaredChildNodeDefinitions().length);
                for (JcrNodeDefinition jcrNodeDefinition : nodeType.getDeclaredChildNodeDefinitions()) {
                    nodeDefs.add(jcrNodeDefinition.with(this.context).with(this));
                }
                JcrNodeType jcrNodeType = new JcrNodeType(this.context, this, nodeType.getInternalName(), supertypes, nodeType.getInternalPrimaryItemName(), nodeDefs, propertyDefs, nodeType.isMixin(), nodeType.hasOrderableChildNodes());
                typesPendingRegistration.add(jcrNodeType);
            }
            for (JcrNodeType nodeType : typesPendingRegistration) {
                for (JcrNodeDefinition nodeDef : nodeType.getDeclaredChildNodeDefinitions()) {
                    JcrNodeType[] requiredPrimaryTypes = new JcrNodeType[nodeDef.requiredPrimaryTypeNames().length];
                    int i = 0;
                    for (Name name : nodeDef.requiredPrimaryTypeNames()) {
                        requiredPrimaryTypes[i] = this.findTypeInMapOrList(name, typesPendingRegistration);
                        if (requiredPrimaryTypes[i] == null) {
                            throw new RepositoryException(JcrI18n.invalidPrimaryTypeName.text(new Object[]{name, nodeType.getName()}));
                        }
                        ++i;
                    }
                }
            }
            for (JcrNodeType nodeType : typesPendingRegistration) {
                this.nodeTypes.put(nodeType.getInternalName(), nodeType);
                for (JcrNodeDefinition childDefinition : nodeType.childNodeDefinitions()) {
                    this.childNodeDefinitions.put(childDefinition.getId(), childDefinition);
                }
                for (JcrPropertyDefinition propertyDefinition : nodeType.propertyDefinitions()) {
                    this.propertyDefinitions.put(propertyDefinition.getId(), propertyDefinition);
                }
            }
            this.schemata = null;
        }
        finally {
            this.nodeTypeManagerLock.writeLock().unlock();
        }
        return typesPendingRegistration;
    }

    private JcrNodeType nodeTypeFrom(Subgraph nodeTypeGraph, Location nodeTypeLocation, List<JcrNodeType> supertypes) {
        Node nodeTypeNode = nodeTypeGraph.getNode(nodeTypeLocation);
        List children = nodeTypeNode.getChildren();
        ArrayList<JcrPropertyDefinition> properties = new ArrayList<JcrPropertyDefinition>(children.size());
        ArrayList<JcrNodeDefinition> childNodes = new ArrayList<JcrNodeDefinition>(children.size());
        for (Location childLocation : children) {
            if (JcrLexicon.PROPERTY_DEFINITION.equals(childLocation.getPath().getLastSegment().getName())) {
                properties.add(this.propertyDefinitionFrom(nodeTypeGraph, childLocation));
                continue;
            }
            if (JcrLexicon.CHILD_NODE_DEFINITION.equals(childLocation.getPath().getLastSegment().getName())) {
                childNodes.add(this.childNodeDefinitionFrom(nodeTypeGraph, childLocation));
                continue;
            }
            throw new IllegalStateException("Unexpected child of node type at: " + childLocation);
        }
        Map nodeProperties = nodeTypeNode.getPropertiesByName();
        ValueFactories valueFactories = this.context.getValueFactories();
        NameFactory nameFactory = valueFactories.getNameFactory();
        ValueFactory booleanFactory = valueFactories.getBooleanFactory();
        Name name = (Name)nameFactory.create(this.getFirstPropertyValue((Property)nodeProperties.get(JcrLexicon.NODE_TYPE_NAME)));
        Name primaryItemName = (Name)nameFactory.create(this.getFirstPropertyValue((Property)nodeProperties.get(JcrLexicon.PRIMARY_ITEM_NAME)));
        boolean mixin = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)nodeProperties.get(JcrLexicon.IS_MIXIN)));
        boolean orderableChildNodes = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)nodeProperties.get(JcrLexicon.HAS_ORDERABLE_CHILD_NODES)));
        return new JcrNodeType(this.context, this, name, supertypes, primaryItemName, childNodes, properties, mixin, orderableChildNodes);
    }

    private JcrPropertyDefinition propertyDefinitionFrom(Subgraph nodeTypeGraph, Location propertyLocation) {
        String[] valueConstraints;
        Value[] defaultValues;
        Node propertyDefinitionNode = nodeTypeGraph.getNode(propertyLocation);
        Map properties = propertyDefinitionNode.getPropertiesByName();
        ValueFactories valueFactories = this.context.getValueFactories();
        NameFactory nameFactory = valueFactories.getNameFactory();
        ValueFactory booleanFactory = valueFactories.getBooleanFactory();
        Name propertyName = (Name)nameFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.NAME)));
        int onParentVersionBehavior = OnParentVersionAction.valueFromName((String)((String)this.getFirstPropertyValue((Property)properties.get(JcrLexicon.ON_PARENT_VERSION))));
        int requiredType = PROPERTY_TYPE_VALUES_FROM_NAME.get(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.REQUIRED_TYPE)));
        boolean mandatory = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.MANDATORY)));
        boolean multiple = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.MULTIPLE)));
        boolean autoCreated = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.AUTO_CREATED)));
        boolean isProtected = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.PROTECTED)));
        Boolean ftsObj = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.IS_FULL_TEXT_SEARCHABLE)));
        boolean fullTextSearchable = ftsObj != null ? ftsObj : false;
        Property defaultValuesProperty = (Property)properties.get(JcrLexicon.DEFAULT_VALUES);
        if (defaultValuesProperty != null) {
            ArrayList<JcrValue> values = new ArrayList<JcrValue>();
            for (Object value : defaultValuesProperty) {
                values.add(new JcrValue(this.context.getValueFactories(), null, requiredType, value));
            }
            defaultValues = values.toArray(new Value[values.size()]);
        } else {
            defaultValues = new Value[]{};
        }
        Property constraintsProperty = (Property)properties.get(JcrLexicon.VALUE_CONSTRAINTS);
        if (constraintsProperty != null) {
            ArrayList<String> constraints = new ArrayList<String>();
            for (Object value : constraintsProperty) {
                constraints.add((String)value);
            }
            valueConstraints = constraints.toArray(new String[constraints.size()]);
        } else {
            valueConstraints = new String[]{};
        }
        return new JcrPropertyDefinition(this.context, null, propertyName, onParentVersionBehavior, autoCreated, mandatory, isProtected, defaultValues, requiredType, valueConstraints, multiple, fullTextSearchable);
    }

    private JcrNodeDefinition childNodeDefinitionFrom(Subgraph nodeTypeGraph, Location childNodeLocation) {
        Name[] requiredTypes;
        Node childNodeDefinitionNode = nodeTypeGraph.getNode(childNodeLocation);
        Map properties = childNodeDefinitionNode.getPropertiesByName();
        ValueFactories valueFactories = this.context.getValueFactories();
        NameFactory nameFactory = valueFactories.getNameFactory();
        ValueFactory booleanFactory = valueFactories.getBooleanFactory();
        Name childNodeName = (Name)nameFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.NAME)));
        Name defaultPrimaryTypeName = (Name)nameFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.DEFAULT_PRIMARY_TYPE)));
        int onParentVersion = OnParentVersionAction.valueFromName((String)((String)this.getFirstPropertyValue((Property)properties.get(JcrLexicon.ON_PARENT_VERSION))));
        boolean mandatory = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.MANDATORY)));
        boolean allowsSns = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.SAME_NAME_SIBLINGS)));
        boolean autoCreated = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.AUTO_CREATED)));
        boolean isProtected = (Boolean)booleanFactory.create(this.getFirstPropertyValue((Property)properties.get(JcrLexicon.PROTECTED)));
        Property requiredTypeNamesProperty = (Property)properties.get(JcrLexicon.REQUIRED_PRIMARY_TYPES);
        if (requiredTypeNamesProperty != null) {
            ArrayList<Object> names = new ArrayList<Object>(requiredTypeNamesProperty.size());
            for (Object value : requiredTypeNamesProperty) {
                names.add(nameFactory.create(value));
            }
            requiredTypes = names.toArray(new Name[names.size()]);
        } else {
            requiredTypes = new Name[]{};
        }
        return new JcrNodeDefinition(this.context, null, childNodeName, onParentVersion, autoCreated, mandatory, isProtected, allowsSns, defaultPrimaryTypeName, requiredTypes);
    }

    private Object getFirstPropertyValue(Property property) {
        return property != null ? property.getFirstValue() : null;
    }

    private JcrNodeType findTypeInMapOrList(Name typeName, List<JcrNodeType> pendingList) {
        for (JcrNodeType pendingNodeType : pendingList) {
            if (!pendingNodeType.getInternalName().equals(typeName)) continue;
            return pendingNodeType;
        }
        return this.nodeTypes.get(typeName);
    }

    private List<JcrNodeType> supertypesFor(Node nodeType, List<JcrNodeType> pendingTypes) throws RepositoryException {
        assert (nodeType != null);
        Property supertypesProperty = nodeType.getProperty(JcrLexicon.SUPERTYPES);
        if (supertypesProperty == null || supertypesProperty.size() == 0) {
            Property isMixinProperty = nodeType.getProperty(JcrLexicon.IS_MIXIN);
            boolean isMixin = isMixinProperty != null && Boolean.valueOf(isMixinProperty.getFirstValue().toString()) != false;
            JcrNodeType supertype = this.findTypeInMapOrList(JcrNtLexicon.BASE, pendingTypes);
            if (supertype == null || isMixin) {
                return Collections.emptyList();
            }
            return Collections.singletonList(supertype);
        }
        Object[] supertypesArray = supertypesProperty.getValuesAsArray();
        ArrayList<JcrNodeType> supertypes = new ArrayList<JcrNodeType>(supertypesArray.length);
        for (int i = 0; i < supertypesArray.length; ++i) {
            supertypes.add(this.findTypeInMapOrList((Name)supertypesArray[i], pendingTypes));
            if (supertypes.get(i) != null) continue;
            Name nodeTypeName = nodeType.getLocation().getPath().getLastSegment().getName();
            throw new InvalidNodeTypeDefinitionException(JcrI18n.invalidSupertypeName.text(new Object[]{supertypesArray[i], nodeTypeName}));
        }
        return supertypes;
    }

    private void validate(List<JcrNodeType> supertypes, String nodeName) throws RepositoryException {
        assert (supertypes != null);
        HashMap<PropertyDefinitionId, JcrPropertyDefinition> props = new HashMap<PropertyDefinitionId, JcrPropertyDefinition>();
        for (JcrNodeType supertype : supertypes) {
            for (JcrPropertyDefinition property : supertype.propertyDefinitions()) {
                String propTypeName;
                String oldPropTypeName;
                JcrPropertyDefinition oldProp = props.put(new PropertyDefinitionId(property.getInternalName(), property.getInternalName(), 0, property.isMultiple()), property);
                if (oldProp == null || (oldPropTypeName = oldProp.getDeclaringNodeType().getName()).equals(propTypeName = property.getDeclaringNodeType().getName())) continue;
                throw new InvalidNodeTypeDefinitionException(JcrI18n.supertypesConflict.text(new Object[]{oldPropTypeName, propTypeName, "property", property.getName()}));
            }
        }
        HashMap<NodeDefinitionId, JcrNodeDefinition> childNodes = new HashMap<NodeDefinitionId, JcrNodeDefinition>();
        for (JcrNodeType supertype : supertypes) {
            for (JcrNodeDefinition childNode : supertype.childNodeDefinitions()) {
                String childNodeTypeName;
                String oldNodeTypeName;
                JcrNodeDefinition oldNode = childNodes.put(new NodeDefinitionId(childNode.getInternalName(), childNode.getInternalName(), new Name[0]), childNode);
                if (oldNode == null || (oldNodeTypeName = oldNode.getDeclaringNodeType().getName()).equals(childNodeTypeName = childNode.getDeclaringNodeType().getName())) continue;
                throw new InvalidNodeTypeDefinitionException(JcrI18n.supertypesConflict.text(new Object[]{oldNodeTypeName, childNodeTypeName, "child node", childNode.getName()}));
            }
        }
    }

    private void validate(JcrNodeType nodeType, List<JcrNodeType> supertypes, List<JcrNodeType> pendingTypes) throws RepositoryException {
        Name nodeTypeName = nodeType.getInternalName();
        this.validate(supertypes, nodeTypeName.getString(this.context.getNamespaceRegistry()));
        ArrayList<Name> supertypeNames = new ArrayList<Name>(supertypes.size());
        for (JcrNodeType supertype : supertypes) {
            supertypeNames.add(supertype.getInternalName());
        }
        boolean found = false;
        Name primaryItemName = nodeType.getInternalPrimaryItemName();
        for (JcrNodeDefinition jcrNodeDefinition : nodeType.getDeclaredChildNodeDefinitions()) {
            this.validate(jcrNodeDefinition, supertypeNames, pendingTypes);
            if (primaryItemName == null || !primaryItemName.equals(jcrNodeDefinition.getInternalName())) continue;
            found = true;
        }
        for (JcrItemDefinition jcrItemDefinition : nodeType.getDeclaredPropertyDefinitions()) {
            this.validate((JcrPropertyDefinition)jcrItemDefinition, supertypeNames, pendingTypes);
            if (primaryItemName == null || !primaryItemName.equals(jcrItemDefinition.getInternalName())) continue;
            if (found) {
                throw new RepositoryException(JcrI18n.ambiguousPrimaryItemName.text(new Object[]{primaryItemName}));
            }
            found = true;
        }
        if (primaryItemName != null && !found) {
            throw new RepositoryException(JcrI18n.invalidPrimaryItemName.text(new Object[]{primaryItemName}));
        }
    }

    private void validate(JcrNodeDefinition node, List<Name> supertypes, List<JcrNodeType> pendingTypes) throws RepositoryException {
        if (node.isAutoCreated() && !node.isProtected() && node.defaultPrimaryTypeName() == null) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.autocreatedNodesNeedDefaults.text(new Object[]{node.getName()}));
        }
        if (node.isMandatory() && "*".equals(node.getName())) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.residualDefinitionsCannotBeMandatory.text(new Object[]{"child nodes"}));
        }
        Name nodeName = (Name)this.context.getValueFactories().getNameFactory().create(node.getName());
        nodeName = nodeName == null ? JcrNodeType.RESIDUAL_NAME : nodeName;
        List<JcrNodeDefinition> ancestors = this.findChildNodeDefinitions(supertypes, nodeName, NodeCardinality.ANY, pendingTypes);
        for (JcrNodeDefinition ancestor : ancestors) {
            if (ancestor.isProtected()) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotOverrideProtectedDefinition.text(new Object[]{ancestor.getDeclaringNodeType().getName(), "child node"}));
            }
            if (ancestor.isMandatory() && !node.isMandatory()) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotMakeMandatoryDefinitionOptional.text(new Object[]{ancestor.getDeclaringNodeType().getName(), "child node"}));
            }
            Name[] requiredPrimaryTypeNames = ancestor.requiredPrimaryTypeNames();
            for (int i = 0; i < requiredPrimaryTypeNames.length; ++i) {
                JcrNodeType apt = this.findTypeInMapOrList(requiredPrimaryTypeNames[i], pendingTypes);
                if (apt == null) {
                    I18n msg = JcrI18n.couldNotFindDefinitionOfRequiredPrimaryType;
                    throw new InvalidNodeTypeDefinitionException(msg.text(new Object[]{requiredPrimaryTypeNames[i], node.getName(), node.getDeclaringNodeType()}));
                }
                boolean found = false;
                for (Name name : node.requiredPrimaryTypeNames()) {
                    JcrNodeType npt = this.findTypeInMapOrList(name, pendingTypes);
                    if (!npt.isNodeType(apt.getName())) continue;
                    found = true;
                    break;
                }
                if (found || JcrNodeType.RESIDUAL_NAME.equals(node.name)) continue;
                I18n msg = JcrI18n.cannotRedefineChildNodeWithIncompatibleDefinition;
                throw new InvalidNodeTypeDefinitionException(msg.text(new Object[]{nodeName, apt.getName(), node.getDeclaringNodeType()}));
            }
        }
    }

    private void validate(JcrPropertyDefinition prop, List<Name> supertypes, List<JcrNodeType> pendingTypes) throws RepositoryException {
        assert (prop != null);
        assert (supertypes != null);
        assert (pendingTypes != null);
        if (prop.isMandatory() && !prop.isProtected() && "*".equals(prop.getName())) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.residualDefinitionsCannotBeMandatory.text(new Object[]{"properties"}));
        }
        Value[] defaultValues = prop.getDefaultValues();
        if (prop.isAutoCreated() && !prop.isProtected() && (defaultValues == null || defaultValues.length == 0)) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.autocreatedPropertyNeedsDefault.text(new Object[]{prop.getName(), prop.getDeclaringNodeType().getName()}));
        }
        if (!prop.isMultiple() && defaultValues != null && defaultValues.length > 1) {
            throw new InvalidNodeTypeDefinitionException(JcrI18n.singleValuedPropertyNeedsSingleValuedDefault.text(new Object[]{prop.getName(), prop.getDeclaringNodeType().getName()}));
        }
        Name propName = (Name)this.context.getValueFactories().getNameFactory().create(prop.getName());
        propName = propName == null ? JcrNodeType.RESIDUAL_NAME : propName;
        List<JcrPropertyDefinition> ancestors = this.findPropertyDefinitions(supertypes, propName, prop.isMultiple() ? PropertyCardinality.MULTI_VALUED_ONLY : PropertyCardinality.SINGLE_VALUED_ONLY, pendingTypes);
        for (JcrPropertyDefinition ancestor : ancestors) {
            if (ancestor.isProtected()) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotOverrideProtectedDefinition.text(new Object[]{ancestor.getDeclaringNodeType().getName(), "property"}));
            }
            if (ancestor.isMandatory() && !prop.isMandatory()) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotMakeMandatoryDefinitionOptional.text(new Object[]{ancestor.getDeclaringNodeType().getName(), "property"}));
            }
            if (ancestor.getValueConstraints() != null && !Arrays.equals(ancestor.getValueConstraints(), prop.getValueConstraints())) {
                throw new InvalidNodeTypeDefinitionException(JcrI18n.constraintsChangedInSubtype.text(new Object[]{propName, ancestor.getDeclaringNodeType().getName()}));
            }
            if (this.isAlwaysSafeConversion(prop.getRequiredType(), ancestor.getRequiredType())) continue;
            throw new InvalidNodeTypeDefinitionException(JcrI18n.cannotRedefineProperty.text(new Object[]{propName, PropertyType.nameFromValue((int)prop.getRequiredType()), ancestor.getDeclaringNodeType().getName(), PropertyType.nameFromValue((int)ancestor.getRequiredType())}));
        }
    }

    private boolean isAlwaysSafeConversion(int fromType, int toType) {
        if (fromType == toType) {
            return true;
        }
        switch (toType) {
            case 6: {
                return fromType == 2 || fromType == 1;
            }
            case 5: {
                return fromType == 4 || fromType == 3;
            }
            case 4: {
                return fromType == 3;
            }
            case 3: {
                return fromType == 4;
            }
            case 8: {
                return fromType == 7;
            }
            case 7: 
            case 9: {
                return false;
            }
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        throw new IllegalStateException("Unexpected state: " + toType);
    }

    static {
        HashMap<String, Integer> temp = new HashMap<String, Integer>();
        temp.put("Binary".toUpperCase(), 2);
        temp.put("Boolean".toUpperCase(), 6);
        temp.put("Date".toUpperCase(), 5);
        temp.put("Double".toUpperCase(), 4);
        temp.put("Long".toUpperCase(), 3);
        temp.put("Name".toUpperCase(), 7);
        temp.put("Path".toUpperCase(), 8);
        temp.put("String".toUpperCase(), 1);
        temp.put("Reference".toUpperCase(), 9);
        temp.put("undefined".toUpperCase(), 0);
        PROPERTY_TYPE_VALUES_FROM_NAME = Collections.unmodifiableMap(temp);
        NAME_ENCODER = new XmlNameEncoder();
    }

    private static enum NodeCardinality {
        NO_SAME_NAME_SIBLINGS,
        SAME_NAME_SIBLINGS,
        ANY;

    }

    private static enum PropertyCardinality {
        SINGLE_VALUED_ONLY,
        MULTI_VALUED_ONLY,
        ANY;

    }
}

