/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.connector.LockFailedException;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.SessionCache;

@ThreadSafe
class WorkspaceLockManager {
    private final ExecutionContext context;
    private final Path locksPath;
    private final JcrRepository repository;
    private final String workspaceName;
    private final ConcurrentMap<UUID, ModeShapeLock> workspaceLocksByNodeUuid;

    WorkspaceLockManager(ExecutionContext context, JcrRepository repository, String workspaceName, Path locksPath) {
        this.context = context;
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.locksPath = locksPath;
        this.workspaceLocksByNodeUuid = new ConcurrentHashMap<UUID, ModeShapeLock>();
        Property locksPrimaryType = context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.LOCKS});
        repository.createSystemGraph(context).create(locksPath, locksPrimaryType).ifAbsent().and();
    }

    ModeShapeLock lock(JcrSession session, Location nodeLocation, boolean isDeep, boolean isSessionScoped) throws RepositoryException {
        assert (nodeLocation != null);
        UUID lockUuid = UUID.randomUUID();
        UUID nodeUuid = this.uuidFor(session, nodeLocation);
        if (nodeUuid == null) {
            throw new RepositoryException(JcrI18n.uuidRequiredForLock.text(new Object[]{nodeLocation}));
        }
        ExecutionContext sessionContext = session.getExecutionContext();
        String lockOwner = session.getUserID();
        ModeShapeLock lock = this.createLock(lockOwner, lockUuid, nodeUuid, isDeep, isSessionScoped);
        Graph.Batch batch = this.repository.createSystemGraph(sessionContext).batch();
        PropertyFactory propFactory = sessionContext.getPropertyFactory();
        PathFactory pathFactory = sessionContext.getValueFactories().getPathFactory();
        Property lockOwnerProp = propFactory.create(JcrLexicon.LOCK_OWNER, new Object[]{lockOwner});
        Property lockIsDeepProp = propFactory.create(JcrLexicon.LOCK_IS_DEEP, new Object[]{isDeep});
        DateTimeFactory dateFactory = sessionContext.getValueFactories().getDateFactory();
        DateTime expirationDate = dateFactory.create();
        expirationDate = expirationDate.plusMillis(60000);
        batch.create(pathFactory.create(this.locksPath, new Path.Segment[]{pathFactory.createSegment(lockUuid.toString())}), propFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.LOCK}), new Property[]{propFactory.create(ModeShapeLexicon.WORKSPACE, new Object[]{this.workspaceName}), propFactory.create(ModeShapeLexicon.LOCKED_UUID, new Object[]{nodeUuid.toString()}), propFactory.create(ModeShapeLexicon.IS_SESSION_SCOPED, new Object[]{isSessionScoped}), propFactory.create(ModeShapeLexicon.LOCKING_SESSION, new Object[]{session.sessionId()}), propFactory.create(ModeShapeLexicon.EXPIRATION_DATE, new Object[]{expirationDate}), propFactory.create(ModeShapeLexicon.IS_HELD_BY_SESSION, new Object[]{false}), lockOwnerProp, lockIsDeepProp}).ifAbsent().and();
        batch.execute();
        SessionCache cache = session.cache();
        AbstractJcrNode lockedNode = cache.findJcrNode(Location.create((UUID)nodeUuid));
        SessionCache.NodeEditor editor = cache.getEditorFor(lockedNode.nodeInfo());
        editor.setProperty(JcrLexicon.LOCK_OWNER, (JcrValue)cache.session().getValueFactory().createValue(lockOwner, 1), false);
        editor.setProperty(JcrLexicon.LOCK_IS_DEEP, (JcrValue)cache.session().getValueFactory().createValue(isDeep), false);
        this.lockNodeInRepository(session, nodeUuid, lockOwnerProp, lockIsDeepProp, lock, isDeep);
        this.workspaceLocksByNodeUuid.put(nodeUuid, lock);
        return lock;
    }

    ModeShapeLock createLock(org.modeshape.graph.Node lockNode) {
        return new ModeShapeLock(lockNode);
    }

    ModeShapeLock createLock(String lockOwner, UUID lockUuid, UUID nodeUuid, boolean isDeep, boolean isSessionScoped) {
        return new ModeShapeLock(lockOwner, lockUuid, nodeUuid, isDeep, isSessionScoped);
    }

    void lockNodeInRepository(JcrSession session, UUID nodeUuid, Property lockOwnerProp, Property lockIsDeepProp, ModeShapeLock lock, boolean isDeep) throws RepositoryException {
        Graph.Batch workspaceBatch = this.repository.createWorkspaceGraph(this.workspaceName, session.getExecutionContext()).batch();
        workspaceBatch.set(new Property[]{lockOwnerProp, lockIsDeepProp}).on(nodeUuid);
        if (isDeep) {
            ((Graph.LockTimeout)workspaceBatch.lock(nodeUuid).andItsDescendants()).withDefaultTimeout();
        } else {
            ((Graph.LockTimeout)workspaceBatch.lock(nodeUuid).only()).withDefaultTimeout();
        }
        try {
            workspaceBatch.execute();
        }
        catch (LockFailedException lfe) {
            this.unlock(session.getExecutionContext(), lock);
            throw new RepositoryException((Throwable)lfe);
        }
    }

    void unlock(ExecutionContext sessionExecutionContext, ModeShapeLock lock) {
        try {
            PathFactory pathFactory = sessionExecutionContext.getValueFactories().getPathFactory();
            Graph.Batch batch = this.repository.createSystemGraph(sessionExecutionContext).batch();
            batch.delete(pathFactory.create(this.locksPath, new Path.Segment[]{pathFactory.createSegment(lock.getUuid().toString())}));
            batch.execute();
            this.unlockNodeInRepository(sessionExecutionContext, lock);
            this.workspaceLocksByNodeUuid.remove(lock.nodeUuid);
        }
        catch (PathNotFoundException pnfe) {
            if (!lock.nodeUuid.equals(pnfe.getLocation().getUuid())) {
                throw new IllegalStateException(pnfe);
            }
            this.workspaceLocksByNodeUuid.remove(lock.nodeUuid);
        }
    }

    void unlockNodeInRepository(ExecutionContext sessionExecutionContext, ModeShapeLock lock) {
        Graph.Batch workspaceBatch = this.repository.createWorkspaceGraph(this.workspaceName, sessionExecutionContext).batch();
        workspaceBatch.remove(new Name[]{JcrLexicon.LOCK_OWNER, JcrLexicon.LOCK_IS_DEEP}).on(lock.nodeUuid);
        workspaceBatch.unlock(lock.nodeUuid);
        workspaceBatch.execute();
    }

    boolean isHeldBySession(JcrSession session, String lockToken) {
        assert (lockToken != null);
        ExecutionContext context = session.getExecutionContext();
        ValueFactory booleanFactory = context.getValueFactories().getBooleanFactory();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        org.modeshape.graph.Node lockNode = this.repository.createSystemGraph(context).getNodeAt(pathFactory.create(this.locksPath, new Path.Segment[]{pathFactory.createSegment(lockToken)}));
        return (Boolean)booleanFactory.create(lockNode.getProperty(ModeShapeLexicon.IS_HELD_BY_SESSION).getFirstValue());
    }

    void setHeldBySession(JcrSession session, String lockToken, boolean value) {
        assert (lockToken != null);
        ExecutionContext context = session.getExecutionContext();
        PropertyFactory propFactory = context.getPropertyFactory();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        this.repository.createSystemGraph(context).set(new Property[]{propFactory.create(ModeShapeLexicon.IS_HELD_BY_SESSION, new Object[]{value})}).on(pathFactory.create(this.locksPath, new Path.Segment[]{pathFactory.createSegment(lockToken)}));
    }

    ModeShapeLock lockFor(String lockToken) {
        for (ModeShapeLock lock : this.workspaceLocksByNodeUuid.values()) {
            if (!lockToken.equals(lock.getLockToken())) continue;
            return lock;
        }
        return null;
    }

    ModeShapeLock lockFor(JcrSession session, Location nodeLocation) {
        UUID nodeUuid = this.uuidFor(session, nodeLocation);
        if (nodeUuid == null) {
            return null;
        }
        return (ModeShapeLock)this.workspaceLocksByNodeUuid.get(nodeUuid);
    }

    UUID uuidFor(JcrSession session, Location location) {
        assert (location != null);
        if (location.getUuid() != null) {
            return location.getUuid();
        }
        Property uuidProp = location.getIdProperty(JcrLexicon.UUID);
        if (uuidProp == null) {
            return null;
        }
        ExecutionContext context = session.getExecutionContext();
        return (UUID)context.getValueFactories().getUuidFactory().create(uuidProp.getFirstValue());
    }

    void cleanLocks(JcrSession session) {
        ExecutionContext context = session.getExecutionContext();
        Collection<String> lockTokens = session.lockTokens();
        for (String lockToken : lockTokens) {
            ModeShapeLock lock = this.lockFor(lockToken);
            if (lock == null || !lock.isSessionScoped()) continue;
            this.unlock(context, lock);
        }
    }

    @ThreadSafe
    public class ModeShapeLock {
        final UUID nodeUuid;
        private final UUID lockUuid;
        private final String lockOwner;
        private final boolean deep;
        private final boolean sessionScoped;

        ModeShapeLock(org.modeshape.graph.Node lockNode) {
            ValueFactory stringFactory = WorkspaceLockManager.this.context.getValueFactories().getStringFactory();
            UuidFactory uuidFactory = WorkspaceLockManager.this.context.getValueFactories().getUuidFactory();
            ValueFactory booleanFactory = WorkspaceLockManager.this.context.getValueFactories().getBooleanFactory();
            assert (lockNode.getLocation().getPath() != null);
            String lockUuidAsString = lockNode.getLocation().getPath().getLastSegment().getName().getLocalName();
            Property lockOwnerProperty = lockNode.getProperty(JcrLexicon.LOCK_OWNER);
            Property nodeUuidProperty = lockNode.getProperty(ModeShapeLexicon.LOCKED_UUID);
            Property lockIsDeepProperty = lockNode.getProperty(JcrLexicon.LOCK_IS_DEEP);
            Property isSessionScopedProperty = lockNode.getProperty(ModeShapeLexicon.IS_SESSION_SCOPED);
            assert (lockUuidAsString != null);
            assert (lockOwnerProperty != null);
            assert (nodeUuidProperty != null);
            assert (lockIsDeepProperty != null);
            assert (isSessionScopedProperty != null);
            this.lockOwner = (String)stringFactory.create(lockOwnerProperty.getFirstValue());
            this.lockUuid = UUID.fromString(lockUuidAsString);
            this.nodeUuid = (UUID)uuidFactory.create(nodeUuidProperty.getFirstValue());
            this.deep = (Boolean)booleanFactory.create(lockIsDeepProperty.getFirstValue());
            this.sessionScoped = (Boolean)booleanFactory.create(isSessionScopedProperty.getFirstValue());
        }

        ModeShapeLock(String lockOwner, UUID lockUuid, UUID nodeUuid, boolean deep, boolean sessionScoped) {
            this.lockOwner = lockOwner;
            this.lockUuid = lockUuid;
            this.nodeUuid = nodeUuid;
            this.deep = deep;
            this.sessionScoped = sessionScoped;
        }

        public boolean isLive() {
            return WorkspaceLockManager.this.workspaceLocksByNodeUuid.containsKey(this.nodeUuid);
        }

        public UUID getUuid() {
            return this.lockUuid;
        }

        public boolean isDeep() {
            return this.deep;
        }

        public String getLockOwner() {
            return this.lockOwner;
        }

        public boolean isSessionScoped() {
            return this.sessionScoped;
        }

        public String getLockToken() {
            return this.lockUuid.toString();
        }

        public Lock lockFor(SessionCache cache) throws RepositoryException {
            final AbstractJcrNode node = cache.findJcrNode(Location.create((UUID)this.nodeUuid));
            final JcrSession session = cache.session();
            return new Lock(){

                public String getLockOwner() {
                    return ModeShapeLock.this.lockOwner;
                }

                public String getLockToken() {
                    String uuidString = ModeShapeLock.this.lockUuid.toString();
                    return session.lockTokens().contains(uuidString) ? uuidString : null;
                }

                public Node getNode() {
                    return node;
                }

                public boolean isDeep() {
                    return ModeShapeLock.this.deep;
                }

                public boolean isLive() {
                    return WorkspaceLockManager.this.workspaceLocksByNodeUuid.containsKey(ModeShapeLock.this.nodeUuid);
                }

                public boolean isSessionScoped() {
                    return ModeShapeLock.this.sessionScoped;
                }

                public void refresh() throws LockException {
                    if (this.getLockToken() == null) {
                        throw new LockException(JcrI18n.notLocked.text(new Object[]{node.location}));
                    }
                }
            };
        }
    }
}

