/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import net.jcip.annotations.Immutable;
import org.modeshape.cnd.CndImporter;
import org.modeshape.common.collection.ImmutableProblems;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.collection.SimpleProblems;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.io.Destination;
import org.modeshape.graph.io.GraphBatchDestination;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.jcr.JcrNodeTypeSource;

@Immutable
public class CndNodeTypeSource
implements JcrNodeTypeSource {
    private final Graph graph;
    private final Problems problems;

    public CndNodeTypeSource(String resourceName) throws IOException {
        this(new String[]{resourceName});
    }

    public CndNodeTypeSource(String[] resourceNames) throws IOException {
        SimpleProblems problems = new SimpleProblems();
        ExecutionContext context = new ExecutionContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        InMemoryRepositorySource source = new InMemoryRepositorySource();
        source.setName("CND Import Source");
        this.graph = Graph.create((RepositorySource)source, (ExecutionContext)context);
        for (String resourceName : Arrays.asList(resourceNames)) {
            Graph.Batch batch = this.graph.batch();
            GraphBatchDestination destination = new GraphBatchDestination(batch);
            CndImporter importer = new CndImporter((Destination)destination, pathFactory.createRootPath());
            InputStream is = this.getClass().getResourceAsStream(resourceName);
            importer.importFrom(is, (Problems)problems, resourceName);
        }
        this.problems = new ImmutableProblems((Problems)problems);
    }

    public boolean isValid() {
        return !this.problems.hasErrors();
    }

    public Problems getProblems() {
        return this.problems;
    }

    @Override
    public final Graph getNodeTypes() {
        return this.graph;
    }
}

