/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.Location;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.SessionCache;

@NotThreadSafe
class JcrNode
extends AbstractJcrNode {
    JcrNode(SessionCache cache, GraphSession.NodeId nodeId, Location location) {
        super(cache, nodeId, location);
    }

    @Override
    final boolean isRoot() {
        return false;
    }

    public int getIndex() throws RepositoryException {
        return this.segment().getIndex();
    }

    public String getName() throws RepositoryException {
        return this.name().getString(this.namespaces());
    }

    @Override
    public AbstractJcrNode getParent() throws ItemNotFoundException, RepositoryException {
        return ((SessionCache.JcrNodePayload)this.nodeInfo().getParent().getPayload()).getJcrNode();
    }

    public String getPath() throws RepositoryException {
        return this.nodeInfo().getPath().getString(this.namespaces());
    }

    public void remove() throws RepositoryException, LockException {
        Lock parentLock;
        AbstractJcrNode parentNode = this.getParent();
        if (parentNode.isLocked() && (parentLock = parentNode.getLock()) != null && parentLock.getLockToken() == null) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.location}));
        }
        if (!parentNode.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{parentNode.getPath()}));
        }
        JcrNodeDefinition nodeDefn = this.cache.nodeTypes().getNodeDefinition(((SessionCache.JcrNodePayload)this.nodeInfo().getPayload()).getDefinitionId());
        if (nodeDefn.isProtected()) {
            throw new ConstraintViolationException(JcrI18n.cannotRemoveItemWithProtectedDefinition.text(new Object[]{this.getPath()}));
        }
        this.session().recordRemoval(this.location);
        this.editor().destroy();
    }
}

