/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.PropertyDefinition;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.jcr.nodetype.NodeDefinitionTemplate;
import org.modeshape.jcr.nodetype.NodeTypeTemplate;
import org.modeshape.jcr.nodetype.PropertyDefinitionTemplate;

@NotThreadSafe
public class JcrNodeTypeTemplate
implements NodeTypeTemplate {
    private final ExecutionContext context;
    private final List<NodeDefinitionTemplate> nodeDefinitionTemplates = new ArrayList<NodeDefinitionTemplate>();
    private final List<PropertyDefinitionTemplate> propertyDefinitionTemplates = new ArrayList<PropertyDefinitionTemplate>();
    private boolean isAbstract;
    private boolean queryable = true;
    private boolean mixin;
    private boolean orderableChildNodes;
    private Name[] declaredSupertypeNames;
    private Name name;
    private Name primaryItemName;

    JcrNodeTypeTemplate(ExecutionContext context) {
        assert (context != null);
        this.context = context;
    }

    ExecutionContext getExecutionContext() {
        return this.context;
    }

    private String string(Name name) {
        if (name == null) {
            return null;
        }
        return name.getString(this.context.getNamespaceRegistry());
    }

    @Override
    public List<NodeDefinitionTemplate> getNodeDefinitionTemplates() {
        return this.nodeDefinitionTemplates;
    }

    @Override
    public List<PropertyDefinitionTemplate> getPropertyDefinitionTemplates() {
        return this.propertyDefinitionTemplates;
    }

    @Override
    public void setAbstract(boolean isAbstract) {
        this.isAbstract = isAbstract;
    }

    @Override
    public void setDeclaredSupertypeNames(String[] names) {
        this.setDeclaredSuperTypeNames(names);
    }

    @Override
    public void setDeclaredSuperTypeNames(String[] names) {
        CheckArg.isNotNull((Object)names, (String)"names");
        Name[] supertypeNames = new Name[names.length];
        for (int i = 0; i < names.length; ++i) {
            CheckArg.isNotEmpty((String)names[i], (String)("names[" + i + ""));
            supertypeNames[i] = (Name)this.context.getValueFactories().getNameFactory().create(names[i]);
        }
        this.declaredSupertypeNames = supertypeNames;
    }

    @Override
    public void setMixin(boolean mixin) {
        this.mixin = mixin;
    }

    @Override
    public void setName(String name) {
        CheckArg.isNotEmpty((String)name, (String)"name");
        this.name = (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    @Override
    public void setOrderableChildNodes(boolean orderable) {
        this.orderableChildNodes = orderable;
    }

    @Override
    public void setPrimaryItemName(String name) {
        this.primaryItemName = (Name)this.context.getValueFactories().getNameFactory().create(name);
    }

    @Override
    public NodeDefinition[] getDeclaredNodeDefinitions() {
        return this.getDeclaredChildNodeDefinitions();
    }

    public NodeDefinition[] getDeclaredChildNodeDefinitions() {
        return null;
    }

    @Override
    public PropertyDefinition[] getDeclaredPropertyDefinitions() {
        return null;
    }

    @Override
    @Deprecated
    public String[] getDeclaredSupertypes() {
        return this.getDeclaredSupertypeNames();
    }

    @Override
    public String[] getDeclaredSupertypeNames() {
        if (this.declaredSupertypeNames == null) {
            return new String[0];
        }
        String[] names = new String[this.declaredSupertypeNames.length];
        for (int i = 0; i < this.declaredSupertypeNames.length; ++i) {
            names[i] = this.declaredSupertypeNames[i].getString(this.context.getNamespaceRegistry());
        }
        return names;
    }

    @Override
    public String getName() {
        return this.string(this.name);
    }

    @Override
    public String getPrimaryItemName() {
        return this.string(this.primaryItemName);
    }

    @Override
    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    @Override
    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public boolean isMixin() {
        return this.mixin;
    }

    @Override
    public boolean isQueryable() {
        return this.queryable;
    }

    @Override
    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }
}

