/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.Value;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.jcr.JcrItemDefinitionTemplate;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.nodetype.PropertyDefinitionTemplate;

class JcrPropertyDefinitionTemplate
extends JcrItemDefinitionTemplate
implements PropertyDefinitionTemplate {
    private boolean multiple = false;
    private Value[] defaultValues = null;
    private int requiredType = 1;
    private String[] valueConstraints = null;
    private boolean fullTextSearchable = true;
    private boolean queryOrderable = true;
    private String[] availableQueryOperators;

    JcrPropertyDefinitionTemplate(ExecutionContext context) {
        super(context);
    }

    @Override
    public void setDefaultValues(String[] defaultValues) {
        if (defaultValues == null) {
            this.defaultValues = null;
            return;
        }
        this.defaultValues = new Value[defaultValues.length];
        ValueFactories factories = this.getExecutionContext().getValueFactories();
        for (int i = 0; i < defaultValues.length; ++i) {
            this.defaultValues[i] = new JcrValue(factories, null, 1, defaultValues[i]);
        }
    }

    @Override
    public void setDefaultValues(Value[] defaultValues) {
        this.defaultValues = defaultValues;
    }

    @Override
    public void setMultiple(boolean multiple) {
        this.multiple = multiple;
    }

    @Override
    public void setRequiredType(int requiredType) {
        assert (requiredType == 2 || requiredType == 6 || requiredType == 5 || requiredType == 4 || requiredType == 3 || requiredType == 7 || requiredType == 8 || requiredType == 9 || requiredType == 1 || requiredType == 0);
        this.requiredType = requiredType;
    }

    @Override
    public void setValueConstraints(String[] constraints) {
        this.valueConstraints = constraints;
    }

    public Value[] getDefaultValues() {
        return this.defaultValues;
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    @Override
    public boolean isFullTextSearchable() {
        return this.fullTextSearchable;
    }

    @Override
    public void setFullTextSearchable(boolean fullTextSearchable) {
        this.fullTextSearchable = fullTextSearchable;
    }

    @Override
    public String[] getAvailableQueryOperators() {
        return this.availableQueryOperators;
    }

    @Override
    public void setAvailableQueryOperators(String[] queryOperators) {
        this.availableQueryOperators = queryOperators;
    }

    @Override
    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }

    @Override
    public void setQueryOrderable(boolean queryOrderable) {
        this.queryOrderable = queryOrderable;
    }
}

