/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.RowIterator;
import javax.jcr.version.VersionException;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.StringUtil;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.model.Column;
import org.modeshape.graph.query.model.QueryCommand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.model.Visitable;
import org.modeshape.graph.query.model.Visitors;
import org.modeshape.graph.query.parse.InvalidQueryException;
import org.modeshape.graph.query.parse.QueryParser;
import org.modeshape.graph.query.plan.PlanHints;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrEmptyNodeIterator;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SessionCache;
import org.modeshape.jcr.api.query.QueryResult;
import org.modeshape.jcr.api.query.Row;

@Immutable
class JcrQueryManager
implements QueryManager {
    public static final int MAXIMUM_RESULTS_FOR_FULL_TEXT_SEARCH_QUERIES = Integer.MAX_VALUE;
    private final JcrSession session;
    protected static final String JCR_SCORE_COLUMN_NAME = "jcr:score";
    protected static final String JCR_PATH_COLUMN_NAME = "jcr:path";

    JcrQueryManager(JcrSession session) {
        this.session = session;
    }

    public Query createQuery(String statement, String language) throws javax.jcr.query.InvalidQueryException {
        CheckArg.isNotNull((Object)statement, (String)"statement");
        CheckArg.isNotNull((Object)language, (String)"language");
        return this.createQuery(statement, language, null);
    }

    public Query createQuery(String expression, String language, Path storedAtPath) throws javax.jcr.query.InvalidQueryException {
        QueryParser parser = this.session.repository().queryParsers().getParserFor(language);
        if (parser == null) {
            Set languages = this.session.repository().queryParsers().getLanguages();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.invalidQueryLanguage.text(new Object[]{language, languages}));
        }
        if (parser.getLanguage().equals("Search")) {
            return new JcrSearch(this.session, expression, parser.getLanguage(), storedAtPath);
        }
        TypeSystem typeSystem = this.session.executionContext.getValueFactories().getTypeSystem();
        try {
            QueryCommand command = parser.parseQuery(expression, typeSystem);
            if (command == null) {
                throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryCannotBeParsedUsingLanguage.text(new Object[]{language, expression}));
            }
            PlanHints hints = new PlanHints();
            hints.showPlan = true;
            hints.validateColumnExistance = false;
            if ("xpath".equals(language) || "sql".equals(language)) {
                hints.hasFullTextSearch = true;
            }
            return new JcrQuery(this.session, expression, parser.getLanguage(), command, hints, storedAtPath);
        }
        catch (ParsingException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryCannotBeParsedUsingLanguage.text(new Object[]{language, expression, reason}));
        }
        catch (InvalidQueryException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(new Object[]{language, expression, reason}));
        }
    }

    public Query createQuery(QueryCommand command) throws javax.jcr.query.InvalidQueryException {
        if (command == null) {
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(new Object[]{"JCR-SQL2", command}));
        }
        String expression = Visitors.readable((Visitable)command);
        try {
            PlanHints hints = new PlanHints();
            hints.showPlan = true;
            hints.validateColumnExistance = false;
            return new JcrQuery(this.session, expression, "JCR-SQL2", command, hints, null);
        }
        catch (InvalidQueryException e) {
            String reason = e.getMessage();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.queryInLanguageIsNotValid.text(new Object[]{"JCR-SQL2", expression, reason}));
        }
    }

    public Query getQuery(Node node) throws javax.jcr.query.InvalidQueryException, RepositoryException {
        AbstractJcrNode jcrNode = (AbstractJcrNode)CheckArg.getInstanceOf((Object)node, AbstractJcrNode.class, (String)"node");
        JcrNodeType nodeType = jcrNode.getPrimaryNodeType();
        if (!nodeType.getInternalName().equals(JcrNtLexicon.QUERY)) {
            NamespaceRegistry registry = this.session.getExecutionContext().getNamespaceRegistry();
            throw new javax.jcr.query.InvalidQueryException(JcrI18n.notStoredQuery.text(new Object[]{jcrNode.path().getString(registry)}));
        }
        String statement = jcrNode.getProperty(JcrLexicon.STATEMENT).getString();
        String language = jcrNode.getProperty(JcrLexicon.LANGUAGE).getString();
        return this.createQuery(statement, language, jcrNode.path());
    }

    public String[] getSupportedQueryLanguages() {
        Set languages = this.session.repository().queryParsers().getLanguages();
        return languages.toArray(new String[languages.size()]);
    }

    protected static class JcrSqlQueryResultRow
    extends SingleSelectorQueryResultRow {
        protected JcrSqlQueryResultRow(SingleSelectorQueryResultRowIterator iterator, Node node, Object[] tuple) {
            super(iterator, node, tuple);
        }

        @Override
        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            if (JcrQueryManager.JCR_PATH_COLUMN_NAME.equals(columnName)) {
                Location location = (Location)this.tuple[this.iterator.locationIndex];
                return ((JcrSqlQueryResultRowIterator)this.iterator).jcrPath(location.getPath());
            }
            if (JcrQueryManager.JCR_SCORE_COLUMN_NAME.equals(columnName)) {
                Float score = (Float)this.tuple[this.iterator.scoreIndex];
                return ((JcrSqlQueryResultRowIterator)this.iterator).jcrScore(score);
            }
            return super.getValue(columnName);
        }
    }

    protected static class JcrSqlQueryResultRowIterator
    extends SingleSelectorQueryResultRowIterator {
        private final ValueFactories factories;
        private final SessionCache cache;

        protected JcrSqlQueryResultRowIterator(JcrSession session, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            super(session, query, results, tuples, numRows);
            this.factories = session.executionContext.getValueFactories();
            this.cache = session.cache();
        }

        @Override
        protected javax.jcr.query.Row createRow(Node node, Object[] tuple) {
            return new JcrSqlQueryResultRow(this, node, tuple);
        }

        protected Value jcrPath(Path path) {
            return new JcrValue(this.factories, this.cache, 8, path);
        }

        protected Value jcrScore(Float score) {
            return new JcrValue(this.factories, this.cache, 4, score);
        }
    }

    protected static class JcrSqlQueryResult
    extends JcrQueryResult {
        private final List<String> columnNames;

        protected JcrSqlQueryResult(JcrSession session, String query, QueryResults graphResults, Schemata schemata) {
            super(session, query, graphResults, schemata);
            LinkedList<String> columnNames = new LinkedList<String>(graphResults.getColumns().getColumnNames());
            if (!columnNames.contains(JcrQueryManager.JCR_SCORE_COLUMN_NAME)) {
                columnNames.add(0, JcrQueryManager.JCR_SCORE_COLUMN_NAME);
            }
            if (!columnNames.contains(JcrQueryManager.JCR_PATH_COLUMN_NAME)) {
                columnNames.add(0, JcrQueryManager.JCR_PATH_COLUMN_NAME);
            }
            this.columnNames = Collections.unmodifiableList(columnNames);
        }

        @Override
        public List<String> getColumnNameList() {
            return this.columnNames;
        }

        @Override
        public RowIterator getRows() {
            int numRows = this.results.getRowCount();
            List tuples = this.results.getTuples();
            return new JcrSqlQueryResultRowIterator(this.session, this.queryStatement, this.results, tuples.iterator(), numRows);
        }
    }

    protected static class XPathQueryResultRow
    extends SingleSelectorQueryResultRow {
        protected XPathQueryResultRow(SingleSelectorQueryResultRowIterator iterator, Node node, Object[] tuple) {
            super(iterator, node, tuple);
        }

        @Override
        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            if (JcrQueryManager.JCR_PATH_COLUMN_NAME.equals(columnName)) {
                Location location = (Location)this.tuple[this.iterator.locationIndex];
                return ((XPathQueryResultRowIterator)this.iterator).jcrPath(location.getPath());
            }
            if (JcrQueryManager.JCR_SCORE_COLUMN_NAME.equals(columnName)) {
                Float score = (Float)this.tuple[this.iterator.scoreIndex];
                return ((XPathQueryResultRowIterator)this.iterator).jcrScore(score);
            }
            return super.getValue(columnName);
        }
    }

    protected static class XPathQueryResultRowIterator
    extends SingleSelectorQueryResultRowIterator {
        private final ValueFactories factories;
        private final SessionCache cache;

        protected XPathQueryResultRowIterator(JcrSession session, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            super(session, query, results, tuples, numRows);
            this.factories = session.executionContext.getValueFactories();
            this.cache = session.cache();
        }

        @Override
        protected javax.jcr.query.Row createRow(Node node, Object[] tuple) {
            return new XPathQueryResultRow(this, node, tuple);
        }

        protected Value jcrPath(Path path) {
            return new JcrValue(this.factories, this.cache, 8, path);
        }

        protected Value jcrScore(Float score) {
            return new JcrValue(this.factories, this.cache, 4, score);
        }
    }

    protected static class XPathQueryResult
    extends JcrQueryResult {
        private final List<String> columnNames;

        protected XPathQueryResult(JcrSession session, String query, QueryResults graphResults, Schemata schemata) {
            super(session, query, graphResults, schemata);
            LinkedList<String> columnNames = new LinkedList<String>(graphResults.getColumns().getColumnNames());
            if (graphResults.getColumns().hasFullTextSearchScores() && !columnNames.contains(JcrQueryManager.JCR_SCORE_COLUMN_NAME)) {
                columnNames.add(0, JcrQueryManager.JCR_SCORE_COLUMN_NAME);
            }
            columnNames.add(0, JcrQueryManager.JCR_PATH_COLUMN_NAME);
            this.columnNames = Collections.unmodifiableList(columnNames);
        }

        @Override
        public List<String> getColumnNameList() {
            return this.columnNames;
        }

        @Override
        public RowIterator getRows() {
            int numRows = this.results.getRowCount();
            List tuples = this.results.getTuples();
            return new XPathQueryResultRowIterator(this.session, this.queryStatement, this.results, tuples.iterator(), numRows);
        }
    }

    protected static class MultiSelectorQueryResultRow
    implements javax.jcr.query.Row,
    Row {
        protected final QueryResultRowIterator iterator;
        protected final Object[] tuple;
        private Value[] values = null;
        private Node[] nodes;
        private int[] locationIndexes;

        protected MultiSelectorQueryResultRow(QueryResultRowIterator iterator, Node[] nodes, int[] locationIndexes, Object[] tuple) {
            this.iterator = iterator;
            this.tuple = tuple;
            this.nodes = nodes;
            this.locationIndexes = locationIndexes;
            assert (this.iterator != null);
            assert (this.tuple != null);
        }

        public Node getNode(String selectorName) throws RepositoryException {
            try {
                int locationIndex = this.iterator.columns.getLocationIndex(selectorName);
                for (int i = 0; i != this.locationIndexes.length; ++i) {
                    if (this.locationIndexes[i] != locationIndex) continue;
                    return this.nodes[i];
                }
            }
            catch (NoSuchElementException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
            }
            assert (false);
            return null;
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            try {
                int locationIndex = this.iterator.columns.getLocationIndexForColumn(columnName);
                for (int i = 0; i != this.locationIndexes.length; ++i) {
                    if (this.locationIndexes[i] != locationIndex) continue;
                    Node node = this.nodes[i];
                    return node != null ? node.getProperty(columnName).getValue() : null;
                }
            }
            catch (NoSuchElementException e) {
                throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
            }
            assert (false);
            return null;
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                int i = 0;
                this.values = new Value[this.iterator.columnNames.size()];
                for (String columnName : this.iterator.columnNames) {
                    this.values[i++] = this.getValue(columnName);
                }
            }
            return this.values;
        }
    }

    protected static class SingleSelectorQueryResultRow
    implements javax.jcr.query.Row,
    Row {
        protected final SingleSelectorQueryResultRowIterator iterator;
        protected final Node node;
        protected final Object[] tuple;
        private Value[] values = null;

        protected SingleSelectorQueryResultRow(SingleSelectorQueryResultRowIterator iterator, Node node, Object[] tuple) {
            this.iterator = iterator;
            this.node = node;
            this.tuple = tuple;
            assert (this.iterator != null);
            assert (this.node != null);
            assert (this.tuple != null);
        }

        public Node getNode(String selectorName) throws RepositoryException {
            if (this.iterator.hasSelector(selectorName)) {
                throw new RepositoryException(JcrI18n.selectorNotUsedInQuery.text(new Object[]{selectorName, this.iterator.query}));
            }
            return this.node;
        }

        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            return this.node.getProperty(columnName).getValue();
        }

        public Value[] getValues() throws RepositoryException {
            if (this.values == null) {
                int i = 0;
                this.values = new Value[this.iterator.columnNames.size()];
                for (String columnName : this.iterator.columnNames) {
                    this.values[i++] = this.getValue(columnName);
                }
            }
            return this.values;
        }
    }

    @NotThreadSafe
    protected static class SingleSelectorQueryResultRowIterator
    extends QueryResultRowIterator {
        protected final int locationIndex;
        protected final int scoreIndex;

        protected SingleSelectorQueryResultRowIterator(JcrSession session, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            super(session, query, results, tuples, numRows);
            String selectorName = (String)this.columns.getSelectorNames().get(0);
            this.locationIndex = this.columns.getLocationIndex(selectorName);
            this.scoreIndex = this.columns.getFullTextSearchScoreIndexFor(selectorName);
        }

        @Override
        protected javax.jcr.query.Row getNextRow(Object[] tuple) throws RepositoryException {
            Location location = (Location)tuple[this.locationIndex];
            if (!this.session.wasRemovedInSession(location)) {
                AbstractJcrNode node = this.session.getNode(location.getPath());
                return this.createRow(node, tuple);
            }
            return null;
        }

        protected javax.jcr.query.Row createRow(Node node, Object[] tuple) {
            return new SingleSelectorQueryResultRow(this, node, tuple);
        }
    }

    @NotThreadSafe
    protected static class QueryResultRowIterator
    implements RowIterator {
        protected final List<String> columnNames;
        private final Iterator<Object[]> tuples;
        private final Set<String> selectorNames;
        protected final JcrSession session;
        protected final QueryResults.Columns columns;
        protected final String query;
        private int[] locationIndexes;
        private long position = 0L;
        private long numRows;
        private javax.jcr.query.Row nextRow;

        protected QueryResultRowIterator(JcrSession session, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            this.tuples = tuples;
            this.query = query;
            this.columns = results.getColumns();
            this.columnNames = this.columns.getColumnNames();
            this.session = session;
            this.numRows = numRows;
            this.selectorNames = new HashSet<String>(this.columns.getSelectorNames());
            int i = 0;
            this.locationIndexes = new int[this.selectorNames.size()];
            for (String selectorName : this.selectorNames) {
                this.locationIndexes[i++] = this.columns.getLocationIndex(selectorName);
            }
        }

        public boolean hasSelector(String selectorName) {
            return this.selectorNames.contains(selectorName);
        }

        public javax.jcr.query.Row nextRow() {
            if (this.nextRow == null && !this.hasNext()) {
                throw new NoSuchElementException();
            }
            assert (this.nextRow != null);
            javax.jcr.query.Row result = this.nextRow;
            this.nextRow = null;
            return result;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.numRows;
        }

        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                this.tuples.next();
            }
            this.position += skipNum;
        }

        public boolean hasNext() {
            if (this.nextRow != null) {
                return true;
            }
            while (this.tuples.hasNext()) {
                Object[] tuple = this.tuples.next();
                ++this.position;
                try {
                    this.nextRow = this.getNextRow(tuple);
                    if (this.nextRow != null) {
                        return true;
                    }
                }
                catch (RepositoryException repositoryException) {
                    // empty catch block
                }
                --this.numRows;
            }
            return false;
        }

        protected javax.jcr.query.Row getNextRow(Object[] tuple) throws RepositoryException {
            Node[] nodes = new Node[this.locationIndexes.length];
            int index = 0;
            for (int locationIndex : this.locationIndexes) {
                Location location = (Location)tuple[locationIndex];
                if (this.session.wasRemovedInSession(location)) {
                    return null;
                }
                try {
                    nodes[index++] = this.session.getNode(location.getPath());
                }
                catch (AccessDeniedException e) {
                    return null;
                }
            }
            return new MultiSelectorQueryResultRow(this, nodes, this.locationIndexes, tuple);
        }

        public Object next() {
            return this.nextRow();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @NotThreadSafe
    protected static class QueryResultNodeIterator
    implements NodeIterator {
        private final Iterator<? extends Node> nodes;
        private final int size;
        private long position = 0L;

        protected QueryResultNodeIterator(List<? extends Node> nodes) {
            this.nodes = nodes.iterator();
            this.size = nodes.size();
        }

        public Node nextNode() {
            Node node = this.nodes.next();
            ++this.position;
            return node;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.size;
        }

        public void skip(long skipNum) {
            for (long i = 0L; i != skipNum; ++i) {
                this.nextNode();
            }
        }

        public boolean hasNext() {
            return this.nodes.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    @NotThreadSafe
    public static class JcrQueryResult
    implements javax.jcr.query.QueryResult,
    QueryResult {
        protected final JcrSession session;
        protected final QueryResults results;
        protected final Schemata schemata;
        protected final String queryStatement;
        private List<String> columnTypes;
        private List<String> columnTables;

        protected JcrQueryResult(JcrSession session, String query, QueryResults graphResults, Schemata schemata) {
            this.session = session;
            this.results = graphResults;
            this.schemata = schemata;
            this.queryStatement = query;
            assert (this.session != null);
            assert (this.results != null);
            assert (this.schemata != null);
            assert (this.queryStatement != null);
        }

        protected QueryResults results() {
            return this.results;
        }

        public List<String> getColumnNameList() {
            return this.results.getColumns().getColumnNames();
        }

        public String[] getColumnNames() {
            List<String> names = this.getColumnNameList();
            return names.toArray(new String[names.size()]);
        }

        public String[] getColumnTypes() {
            if (this.columnTypes == null) {
                QueryResults.Columns columns = this.results.getColumns();
                ArrayList<String> types = new ArrayList<String>(columns.getColumnCount());
                for (Column column : columns) {
                    String typeName = null;
                    Schemata.Table table = this.schemata.getTable(column.getSelectorName());
                    if (table != null) {
                        Schemata.Column typedColumn = table.getColumn(column.getPropertyName());
                        typeName = typedColumn.getPropertyType();
                    }
                    if (typeName == null) {
                        typeName = PropertyType.nameFromValue((int)1);
                    }
                    types.add(typeName);
                }
                this.columnTypes = types;
            }
            return this.columnTypes.toArray(new String[this.columnTypes.size()]);
        }

        public String[] getSelectorNames() {
            if (this.columnTables == null) {
                QueryResults.Columns columns = this.results.getColumns();
                ArrayList<String> tables = new ArrayList<String>(columns.getColumnCount());
                for (Column column : columns) {
                    String tableName = "";
                    Schemata.Table table = this.schemata.getTable(column.getSelectorName());
                    if (table != null) {
                        tableName = table.getName().getName();
                    }
                    tables.add(tableName);
                }
                this.columnTables = tables;
            }
            return this.columnTables.toArray(new String[this.columnTables.size()]);
        }

        public NodeIterator getNodes() throws RepositoryException {
            int numRows = this.results.getRowCount();
            if (numRows == 0) {
                return new JcrEmptyNodeIterator();
            }
            ArrayList<AbstractJcrNode> nodes = new ArrayList<AbstractJcrNode>(numRows);
            String selectorName = (String)this.results.getColumns().getSelectorNames().get(0);
            int locationIndex = this.results.getColumns().getLocationIndex(selectorName);
            for (Object[] tuple : this.results.getTuples()) {
                Location location = (Location)tuple[locationIndex];
                if (this.session.wasRemovedInSession(location)) continue;
                nodes.add(this.session.getNode(location.getPath()));
            }
            return new QueryResultNodeIterator(nodes);
        }

        public RowIterator getRows() {
            int numRows = this.results.getRowCount();
            List tuples = this.results.getTuples();
            if (this.results.getColumns().getLocationCount() == 1) {
                return new SingleSelectorQueryResultRowIterator(this.session, this.queryStatement, this.results, tuples.iterator(), numRows);
            }
            return new QueryResultRowIterator(this.session, this.queryStatement, this.results, tuples.iterator(), numRows);
        }

        public String getPlan() {
            return this.results.getPlan();
        }

        public String toString() {
            return this.results.toString();
        }
    }

    @NotThreadSafe
    protected static class JcrSearch
    extends AbstractQuery {
        protected JcrSearch(JcrSession session, String statement, String language, Path storedAtPath) {
            super(session, statement, language, storedAtPath);
        }

        public javax.jcr.query.QueryResult execute() throws RepositoryException {
            Schemata schemata = this.session.workspace().nodeTypeManager().schemata();
            QueryResults result = this.session.repository().queryManager().search(this.session.workspace().getName(), this.statement, Integer.MAX_VALUE, 0);
            this.checkForProblems(result.getProblems());
            return new JcrQueryResult(this.session, this.statement, result, schemata);
        }

        public String toString() {
            return this.language + " -> " + this.statement;
        }
    }

    @NotThreadSafe
    protected static class JcrQuery
    extends AbstractQuery {
        private final QueryCommand query;
        private final PlanHints hints;
        private final Map<String, Object> variables;

        protected JcrQuery(JcrSession session, String statement, String language, QueryCommand query, PlanHints hints, Path storedAtPath) {
            super(session, statement, language, storedAtPath);
            assert (query != null);
            this.query = query;
            this.hints = hints;
            this.variables = null;
        }

        public QueryCommand getAbstractQueryModel() {
            return this.query;
        }

        public javax.jcr.query.QueryResult execute() throws RepositoryException {
            Schemata schemata = this.session.workspace().nodeTypeManager().schemata();
            QueryResults result = this.session.repository().queryManager().query(this.session.workspace().getName(), this.query, schemata, this.hints, this.variables);
            this.checkForProblems(result.getProblems());
            if ("xpath".equals(this.language)) {
                return new XPathQueryResult(this.session, this.statement, result, schemata);
            }
            if ("sql".equals(this.language)) {
                return new JcrSqlQueryResult(this.session, this.statement, result, schemata);
            }
            return new JcrQueryResult(this.session, this.statement, result, schemata);
        }

        public String toString() {
            return this.language + " -> " + this.statement + "\n" + StringUtil.createString((char)' ', (int)Math.min(this.language.length() - 3, 0)) + "AQM -> " + this.query;
        }
    }

    @NotThreadSafe
    protected static abstract class AbstractQuery
    implements Query {
        protected final JcrSession session;
        protected final String language;
        protected final String statement;
        private Path storedAtPath;

        protected AbstractQuery(JcrSession session, String statement, String language, Path storedAtPath) {
            assert (session != null);
            assert (statement != null);
            assert (language != null);
            this.session = session;
            this.language = language;
            this.statement = statement;
            this.storedAtPath = storedAtPath;
        }

        protected final JcrSession session() {
            return this.session;
        }

        public String getLanguage() {
            return this.language;
        }

        public String getStatement() {
            return this.statement;
        }

        public String getStoredQueryPath() throws ItemNotFoundException {
            if (this.storedAtPath == null) {
                throw new ItemNotFoundException(JcrI18n.notStoredQuery.text(new Object[0]));
            }
            return this.storedAtPath.getString(this.session.getExecutionContext().getNamespaceRegistry());
        }

        public Node storeAsNode(String absPath) throws PathNotFoundException, ConstraintViolationException, RepositoryException {
            Path path;
            NamespaceRegistry namespaces = this.session.namespaces();
            try {
                path = (Path)this.session.getExecutionContext().getValueFactories().getPathFactory().create(absPath);
            }
            catch (IllegalArgumentException iae) {
                throw new RepositoryException(JcrI18n.invalidPathParameter.text(new Object[]{"absPath", absPath}));
            }
            Path parentPath = path.getParent();
            AbstractJcrNode parentNode = this.session.getNode(parentPath);
            if (!parentNode.isCheckedOut()) {
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{parentNode.getPath()}));
            }
            Node queryNode = parentNode.addNode(path.relativeTo(parentPath).getString(namespaces), JcrNtLexicon.QUERY.getString(namespaces));
            queryNode.setProperty(JcrLexicon.LANGUAGE.getString(namespaces), this.language);
            queryNode.setProperty(JcrLexicon.STATEMENT.getString(namespaces), this.statement);
            this.storedAtPath = path;
            return queryNode;
        }

        protected void checkForProblems(Problems problems) throws RepositoryException {
            if (problems.hasErrors()) {
                StringBuilder msg = new StringBuilder();
                for (Problem problem : problems) {
                    if (problem.getStatus() != Problem.Status.ERROR) continue;
                    msg.append(problem.getMessageString()).append("\n");
                }
                throw new RepositoryException(msg.toString());
            }
        }
    }
}

