/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.AccessControlException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.Credentials;
import javax.jcr.LoginException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.SimpleCredentials;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.Immutable;
import net.jcip.annotations.ThreadSafe;
import org.modeshape.common.collection.UnmodifiableProperties;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.CheckArg;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.JaasSecurityContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.Node;
import org.modeshape.graph.SecurityContext;
import org.modeshape.graph.Subgraph;
import org.modeshape.graph.connector.RepositoryConnection;
import org.modeshape.graph.connector.RepositoryConnectionFactory;
import org.modeshape.graph.connector.RepositoryContext;
import org.modeshape.graph.connector.RepositorySource;
import org.modeshape.graph.connector.RepositorySourceCapabilities;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.connector.federation.FederatedRepositorySource;
import org.modeshape.graph.connector.federation.Projection;
import org.modeshape.graph.connector.federation.ProjectionParser;
import org.modeshape.graph.connector.inmemory.InMemoryRepositorySource;
import org.modeshape.graph.observe.Changes;
import org.modeshape.graph.observe.Observable;
import org.modeshape.graph.observe.Observer;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.property.basic.GraphNamespaceRegistry;
import org.modeshape.graph.query.parse.QueryParser;
import org.modeshape.graph.query.parse.QueryParsers;
import org.modeshape.graph.request.InvalidWorkspaceException;
import org.modeshape.jcr.CndNodeTypeSource;
import org.modeshape.jcr.FullTextSearchParser;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNamespaceRegistry;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSql2QueryParser;
import org.modeshape.jcr.JcrSqlQueryParser;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.RepositoryNodeTypeManager;
import org.modeshape.jcr.RepositoryQueryManager;
import org.modeshape.jcr.SecurityContextCredentials;
import org.modeshape.jcr.WorkspaceLockManager;
import org.modeshape.jcr.api.Repository;
import org.modeshape.jcr.xpath.XPathQueryParser;

@ThreadSafe
public class JcrRepository
implements Repository {
    static final boolean WORKSPACES_SHARE_SYSTEM_BRANCH = true;
    static final String ANONYMOUS_USER_NAME = "<anonymous>";
    private static final Logger LOGGER = Logger.getLogger(JcrRepository.class);
    private static Properties bundleProperties = null;
    protected static final Map<Option, String> DEFAULT_OPTIONS;
    private final String sourceName;
    private final Map<String, Object> descriptors;
    private final ExecutionContext executionContext;
    private final RepositoryConnectionFactory connectionFactory;
    private final RepositoryNodeTypeManager repositoryTypeManager;
    @GuardedBy(value="lockManagersLock")
    private final ConcurrentMap<String, WorkspaceLockManager> lockManagers;
    private final Path locksPath;
    private final Map<Option, String> options;
    private final String systemSourceName;
    private final String systemWorkspaceName;
    private final Projection systemSourceProjection;
    private final FederatedRepositorySource federatedSource;
    private final NamespaceRegistry persistentRegistry;
    private final RepositoryObservationManager repositoryObservationManager;
    private final SecurityContext anonymousUserContext;
    private final QueryParsers queryParsers;
    private final RepositoryQueryManager queryManager;
    final WeakHashMap<JcrSession, Object> activeSessions = new WeakHashMap();

    JcrRepository(ExecutionContext executionContext, RepositoryConnectionFactory connectionFactory, String repositorySourceName, Observable repositoryObservable, RepositorySourceCapabilities repositorySourceCapabilities, Map<String, String> descriptors, Map<Option, String> options) throws RepositoryException {
        CheckArg.isNotNull((Object)executionContext, (String)"executionContext");
        CheckArg.isNotNull((Object)connectionFactory, (String)"connectionFactory");
        CheckArg.isNotNull((Object)repositorySourceName, (String)"repositorySourceName");
        CheckArg.isNotNull((Object)repositoryObservable, (String)"repositoryObservable");
        this.descriptors = JcrRepository.initializeDescriptors(executionContext.getValueFactories(), descriptors);
        if (options == null) {
            this.options = DEFAULT_OPTIONS;
        } else {
            EnumMap<Option, String> localOptions = new EnumMap<Option, String>(DEFAULT_OPTIONS);
            localOptions.putAll(options);
            this.options = Collections.unmodifiableMap(localOptions);
        }
        this.repositoryObservationManager = new RepositoryObservationManager(repositoryObservable);
        String systemSourceNameValue = this.options.get((Object)Option.SYSTEM_SOURCE_NAME);
        String systemSourceName = null;
        String systemWorkspaceName = null;
        RepositoryConnectionFactory connectionFactoryWithSystem = connectionFactory;
        if (systemSourceNameValue != null) {
            I18n msg;
            try {
                SourceWorkspacePair pair = new SourceWorkspacePair(systemSourceNameValue);
                RepositoryConnection conn = connectionFactory.createConnection(pair.getSourceName());
                if (conn != null) {
                    systemSourceName = pair.getSourceName();
                    if (pair.getWorkspaceName() != null) {
                        Graph temp = Graph.create((RepositoryConnection)conn, (ExecutionContext)executionContext);
                        temp.useWorkspace(pair.getWorkspaceName());
                        systemWorkspaceName = pair.getWorkspaceName();
                    }
                } else {
                    I18n msg2 = JcrI18n.systemSourceNameOptionValueDoesNotReferenceExistingSource;
                    LOGGER.warn(msg2, new Object[]{systemSourceNameValue, systemSourceName});
                }
            }
            catch (InvalidWorkspaceException e) {
                systemSourceName = null;
                msg = JcrI18n.systemSourceNameOptionValueDoesNotReferenceValidWorkspace;
                LOGGER.warn(msg, new Object[]{systemSourceNameValue, systemSourceName});
            }
            catch (IllegalArgumentException e) {
                systemSourceName = null;
                msg = JcrI18n.systemSourceNameOptionValueIsNotFormattedCorrectly;
                LOGGER.warn(msg, new Object[]{systemSourceNameValue});
            }
        }
        if (systemSourceName == null) {
            systemWorkspaceName = "jcr:system";
            systemSourceName = "jcr:system source";
            InMemoryRepositorySource transientSystemSource = new InMemoryRepositorySource();
            transientSystemSource.setName(systemSourceName);
            transientSystemSource.setDefaultWorkspaceName(systemWorkspaceName);
            connectionFactoryWithSystem = new DelegatingConnectionFactory(connectionFactory, (RepositorySource)transientSystemSource);
        }
        this.queryParsers = new QueryParsers(new QueryParser[]{new JcrSql2QueryParser(), new XPathQueryParser(), new FullTextSearchParser(), new JcrSqlQueryParser()});
        assert (this.queryParsers.getParserFor("xpath") != null);
        this.systemWorkspaceName = systemWorkspaceName;
        this.systemSourceName = systemSourceName;
        this.connectionFactory = connectionFactoryWithSystem;
        assert (this.systemSourceName != null);
        assert (this.connectionFactory != null);
        this.sourceName = repositorySourceName;
        Graph systemGraph = Graph.create((String)this.systemSourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)executionContext);
        systemGraph.useWorkspace(systemWorkspaceName);
        this.initializeSystemContent(systemGraph);
        Name uriProperty = ModeShapeLexicon.NAMESPACE_URI;
        PathFactory pathFactory = executionContext.getValueFactories().getPathFactory();
        Path systemPath = (Path)pathFactory.create(JcrLexicon.SYSTEM);
        Path namespacesPath = pathFactory.create(systemPath, new Name[]{ModeShapeLexicon.NAMESPACES});
        PropertyFactory propertyFactory = executionContext.getPropertyFactory();
        Property namespaceType = propertyFactory.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.NAMESPACE});
        this.persistentRegistry = new GraphNamespaceRegistry(systemGraph, namespacesPath, uriProperty, new Property[]{namespaceType});
        this.executionContext = executionContext.with(this.persistentRegistry);
        for (Map.Entry<String, String> builtIn : JcrNamespaceRegistry.STANDARD_BUILT_IN_NAMESPACES_BY_PREFIX.entrySet()) {
            this.persistentRegistry.register(builtIn.getKey(), builtIn.getValue());
        }
        try {
            boolean includeInheritedProperties = Boolean.valueOf(this.options.get((Object)Option.TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES));
            this.repositoryTypeManager = new RepositoryNodeTypeManager(this, includeInheritedProperties);
            this.repositoryTypeManager.registerNodeTypes(new CndNodeTypeSource(new String[]{"/org/modeshape/jcr/jsr_170_builtins.cnd", "/org/modeshape/jcr/dna_builtins.cnd"}));
        }
        catch (RepositoryException re) {
            re.printStackTrace();
            throw new IllegalStateException("Could not load node type definition files", re);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            throw new IllegalStateException("Could not access node type definition files", ioe);
        }
        if (Boolean.valueOf(this.options.get((Object)Option.PROJECT_NODE_TYPES)).booleanValue()) {
            Path parentOfTypeNodes = pathFactory.create(systemPath, new Name[]{JcrLexicon.NODE_TYPES});
            this.repositoryTypeManager.projectOnto(systemGraph, parentOfTypeNodes);
        }
        ProjectionParser projectionParser = ProjectionParser.getInstance();
        String rule = "/jcr:system => /jcr:system";
        Projection.Rule[] systemProjectionRules = projectionParser.rulesFromString(this.executionContext, rule);
        this.systemSourceProjection = new Projection(systemSourceName, systemWorkspaceName, true, systemProjectionRules);
        this.federatedSource = new FederatedRepositorySource();
        this.federatedSource.setName("JCR " + repositorySourceName);
        this.federatedSource.initialize((RepositoryContext)new FederatedRepositoryContext(this.connectionFactory));
        this.lockManagers = new ConcurrentHashMap<String, WorkspaceLockManager>();
        this.locksPath = pathFactory.create(pathFactory.createRootPath(), new Name[]{JcrLexicon.SYSTEM, ModeShapeLexicon.LOCKS});
        if (Boolean.valueOf(this.options.get((Object)Option.QUERY_EXECUTION_ENABLED)).booleanValue()) {
            boolean canQueryFederated;
            RepositorySourceCapabilities fedCapabilities = this.federatedSource != null ? this.federatedSource.getCapabilities() : null;
            boolean canQuerySource = repositorySourceCapabilities != null && repositorySourceCapabilities.supportsSearches() && repositorySourceCapabilities.supportsQueries();
            boolean bl = canQueryFederated = fedCapabilities != null && fedCapabilities.supportsSearches() && fedCapabilities.supportsQueries();
            if (canQuerySource && canQueryFederated) {
                this.queryManager = new RepositoryQueryManager.PushDown(this.sourceName, this.executionContext, connectionFactory);
            } else {
                String indexDirectory = this.options.get((Object)Option.QUERY_INDEX_DIRECTORY);
                boolean updateIndexesSynchronously = Boolean.valueOf(this.options.get((Object)Option.QUERY_INDEXES_UPDATED_SYNCHRONOUSLY));
                this.queryManager = new RepositoryQueryManager.SelfContained(this.executionContext, this.sourceName, connectionFactory, repositoryObservable, this.repositoryTypeManager, indexDirectory, updateIndexesSynchronously);
            }
        } else {
            this.queryManager = new RepositoryQueryManager.Disabled(this.sourceName);
        }
        SecurityContext anonymousUserContext = null;
        String rawAnonRoles = this.options.get((Object)Option.ANONYMOUS_USER_ROLES);
        if (rawAnonRoles != null) {
            final HashSet<String> roles = new HashSet<String>();
            for (String role : rawAnonRoles.split("\\s*,\\s*")) {
                roles.add(role);
            }
            if (roles.size() > 0) {
                anonymousUserContext = new SecurityContext(){

                    public String getUserName() {
                        return JcrRepository.ANONYMOUS_USER_NAME;
                    }

                    public boolean hasRole(String roleName) {
                        return roles.contains(roleName);
                    }

                    public void logout() {
                    }
                };
            }
        }
        this.anonymousUserContext = anonymousUserContext;
    }

    protected void initializeSystemContent(Graph systemGraph) {
        ExecutionContext context = systemGraph.getContext();
        PathFactory pathFactory = context.getValueFactories().getPathFactory();
        Path systemPath = pathFactory.create(pathFactory.createRootPath(), new Name[]{JcrLexicon.SYSTEM});
        Property systemPrimaryType = context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.SYSTEM});
        systemGraph.create(systemPath, systemPrimaryType).ifAbsent().and();
        Path versionPath = pathFactory.createAbsolutePath(new Name[]{JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE});
        Property versionPrimaryType = context.getPropertyFactory().create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.VERSION_STORAGE});
        systemGraph.create(versionPath, versionPrimaryType).ifAbsent().and();
    }

    Graph createWorkspaceGraph(String workspaceName, ExecutionContext workspaceContext) {
        Graph graph = null;
        assert (this.federatedSource != null);
        graph = Graph.create((RepositorySource)this.federatedSource, (ExecutionContext)workspaceContext);
        graph.useWorkspace(workspaceName);
        return graph;
    }

    Graph createSystemGraph(ExecutionContext sessionContext) {
        assert (this.systemSourceName != null);
        assert (this.connectionFactory != null);
        assert (sessionContext != null);
        Graph result = Graph.create((String)this.systemSourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)sessionContext);
        if (this.systemWorkspaceName != null) {
            result.useWorkspace(this.systemWorkspaceName);
        }
        return result;
    }

    QueryParsers queryParsers() {
        return this.queryParsers;
    }

    RepositoryQueryManager queryManager() {
        return this.queryManager;
    }

    RepositoryNodeTypeManager getRepositoryTypeManager() {
        return this.repositoryTypeManager;
    }

    public Map<Option, String> getOptions() {
        return this.options;
    }

    String getRepositorySourceName() {
        return this.sourceName;
    }

    String getSystemSourceName() {
        return this.systemSourceName;
    }

    String getObservableSourceName() {
        return this.federatedSource.getName();
    }

    ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    NamespaceRegistry getPersistentRegistry() {
        return this.persistentRegistry;
    }

    Observer getObserver() {
        return this.repositoryObservationManager;
    }

    Observable getRepositoryObservable() {
        return this.repositoryObservationManager;
    }

    public String getDescriptor(String key) {
        if (!this.isSingleValueDescriptor(key)) {
            return null;
        }
        JcrValue value = (JcrValue)this.descriptors.get(key);
        try {
            return value.getString();
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public JcrValue getDescriptorValue(String key) {
        if (!this.isSingleValueDescriptor(key)) {
            return null;
        }
        return (JcrValue)this.descriptors.get(key);
    }

    public JcrValue[] getDescriptorValues(String key) {
        Object value = this.descriptors.get(key);
        if (value instanceof JcrValue[]) {
            return (JcrValue[])value;
        }
        if (value instanceof JcrValue) {
            return new JcrValue[]{(JcrValue)value};
        }
        return null;
    }

    public boolean isSingleValueDescriptor(String key) {
        CheckArg.isNotEmpty((String)key, (String)"key");
        return this.descriptors.get(key) instanceof JcrValue;
    }

    public boolean isStandardDescriptor(String key) {
        return STANDARD_DESCRIPTORS.contains(key);
    }

    public String[] getDescriptorKeys() {
        return this.descriptors.keySet().toArray(new String[this.descriptors.size()]);
    }

    public synchronized Session login() throws RepositoryException {
        return this.login(null, null);
    }

    public synchronized Session login(Credentials credentials) throws RepositoryException {
        return this.login(credentials, null);
    }

    public synchronized Session login(String workspaceName) throws RepositoryException {
        return this.login(null, workspaceName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized Session login(Credentials credentials, String workspaceName) throws RepositoryException {
        HashMap<String, Object> sessionAttributes = new HashMap<String, Object>();
        ExecutionContext execContext = null;
        if (credentials == null) {
            Subject subject = Subject.getSubject(AccessController.getContext());
            if (subject != null) {
                execContext = this.executionContext.with((SecurityContext)new JaasSecurityContext(subject));
                return this.sessionForContext(execContext, workspaceName, sessionAttributes);
            } else {
                if (this.anonymousUserContext == null) throw new LoginException(JcrI18n.mustBeInPrivilegedAction.text(new Object[0]));
                execContext = this.executionContext.with(this.anonymousUserContext);
            }
            return this.sessionForContext(execContext, workspaceName, sessionAttributes);
        }
        try {
            if (credentials instanceof SimpleCredentials) {
                SimpleCredentials simple = (SimpleCredentials)credentials;
                execContext = this.executionContext.with((SecurityContext)new JaasSecurityContext(this.options.get((Object)Option.JAAS_LOGIN_CONFIG_NAME), simple.getUserID(), simple.getPassword()));
                for (String attributeName : simple.getAttributeNames()) {
                    Object attributeValue = simple.getAttribute(attributeName);
                    sessionAttributes.put(attributeName, attributeValue);
                }
                return this.sessionForContext(execContext, workspaceName, sessionAttributes);
            }
            if (credentials instanceof SecurityContextCredentials) {
                execContext = this.executionContext.with(((SecurityContextCredentials)credentials).getSecurityContext());
                return this.sessionForContext(execContext, workspaceName, sessionAttributes);
            }
            try {
                Method method = credentials.getClass().getMethod("getLoginContext", new Class[0]);
                if (method.getReturnType() != LoginContext.class) {
                    throw new IllegalArgumentException(JcrI18n.credentialsMustReturnLoginContext.text(new Object[]{credentials.getClass()}));
                }
                LoginContext loginContext = (LoginContext)method.invoke((Object)credentials, new Object[0]);
                if (loginContext == null) {
                    throw new IllegalArgumentException(JcrI18n.credentialsMustReturnLoginContext.text(new Object[]{credentials.getClass()}));
                }
                execContext = this.executionContext.with((SecurityContext)new JaasSecurityContext(loginContext));
                return this.sessionForContext(execContext, workspaceName, sessionAttributes);
            }
            catch (NoSuchMethodException error) {
                throw new IllegalArgumentException(JcrI18n.credentialsMustProvideJaasMethod.text(new Object[]{credentials.getClass()}), error);
            }
        }
        catch (RuntimeException error) {
            throw error;
        }
        catch (Exception error) {
            throw new LoginException((Throwable)error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JcrSession sessionForContext(ExecutionContext execContext, String workspaceName, Map<String, Object> sessionAttributes) throws RepositoryException {
        CheckArg.isNotNull((Object)execContext.getSecurityContext(), (String)"execContext.securityContext");
        boolean isDefault = false;
        Graph graph = Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.executionContext);
        if (workspaceName == null) {
            try {
                workspaceName = graph.getCurrentWorkspace().getName();
            }
            catch (RepositorySourceException e) {
                throw new RepositoryException(JcrI18n.errorObtainingDefaultWorkspaceName.text(new Object[]{this.sourceName, e.getMessage()}), (Throwable)e);
            }
            isDefault = true;
        } else {
            try {
                Set workspaces = graph.getWorkspaces();
                if (!workspaces.contains(workspaceName)) {
                    this.federatedSource.removeWorkspace(workspaceName);
                    throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.sourceName, workspaceName}));
                }
                graph.useWorkspace(workspaceName);
            }
            catch (InvalidWorkspaceException e) {
                throw new NoSuchWorkspaceException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.sourceName, workspaceName}), (Throwable)e);
            }
            catch (RepositorySourceException e) {
                String msg = JcrI18n.errorVerifyingWorkspaceName.text(new Object[]{this.sourceName, workspaceName, e.getMessage()});
                throw new NoSuchWorkspaceException(msg, (Throwable)e);
            }
        }
        assert (this.federatedSource != null);
        assert (this.systemSourceProjection != null);
        FederatedRepositorySource e = this.federatedSource;
        synchronized (e) {
            if (!this.federatedSource.hasWorkspace(workspaceName)) {
                ProjectionParser projectionParser = ProjectionParser.getInstance();
                Projection.Rule[] mirrorRules = projectionParser.rulesFromString(this.executionContext, "/ => /");
                ArrayList<Projection> projections = new ArrayList<Projection>(2);
                projections.add(new Projection(this.sourceName, workspaceName, false, mirrorRules));
                projections.add(this.systemSourceProjection);
                this.federatedSource.addWorkspace(workspaceName, projections, isDefault);
            }
        }
        sessionAttributes = Collections.unmodifiableMap(sessionAttributes);
        JcrWorkspace workspace = new JcrWorkspace(this, workspaceName, execContext, sessionAttributes);
        JcrSession session = (JcrSession)workspace.getSession();
        try {
            session.checkPermission(workspaceName, null, "read");
        }
        catch (AccessControlException ace) {
            throw new LoginException(JcrI18n.workspaceNameIsInvalid.text(new Object[]{this.sourceName, workspaceName}), (Throwable)ace);
        }
        WeakHashMap<JcrSession, Object> weakHashMap = this.activeSessions;
        synchronized (weakHashMap) {
            this.activeSessions.put(session, null);
        }
        return session;
    }

    void close() {
        if (this.federatedSource != null) {
            this.federatedSource.close();
        }
        this.repositoryObservationManager.shutdown();
    }

    Set<String> workspaceNames() {
        return Graph.create((String)this.sourceName, (RepositoryConnectionFactory)this.connectionFactory, (ExecutionContext)this.executionContext).getWorkspaces();
    }

    WorkspaceLockManager getLockManager(String workspaceName) {
        WorkspaceLockManager lockManager = (WorkspaceLockManager)this.lockManagers.get(workspaceName);
        if (lockManager != null) {
            return lockManager;
        }
        lockManager = new WorkspaceLockManager(this.executionContext, this, workspaceName, this.locksPath);
        WorkspaceLockManager newLockManager = this.lockManagers.putIfAbsent(workspaceName, lockManager);
        if (newLockManager != null) {
            return newLockManager;
        }
        return lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sessionLoggedOut(JcrSession session) {
        WeakHashMap<JcrSession, Object> weakHashMap = this.activeSessions;
        synchronized (weakHashMap) {
            this.activeSessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Set<JcrSession> activeSessions() {
        HashSet<JcrSession> activeSessions;
        WeakHashMap<JcrSession, Object> weakHashMap = this.activeSessions;
        synchronized (weakHashMap) {
            activeSessions = new HashSet<JcrSession>(this.activeSessions.keySet());
        }
        Iterator iter = activeSessions.iterator();
        while (iter.hasNext()) {
            JcrSession session = (JcrSession)iter.next();
            if (session == null || session.isLive()) continue;
            iter.remove();
        }
        return activeSessions;
    }

    void cleanUpLocks() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(JcrI18n.cleaningUpLocks.text(new Object[0]), new Object[0]);
        }
        Set<JcrSession> activeSessions = this.activeSessions();
        HashSet<String> activeSessionIds = new HashSet<String>(activeSessions.size());
        for (JcrSession activeSession : activeSessions) {
            activeSessionIds.add(activeSession.sessionId());
        }
        Graph systemGraph = this.createSystemGraph(this.executionContext);
        PathFactory pathFactory = this.executionContext.getValueFactories().getPathFactory();
        ValueFactory booleanFactory = this.executionContext.getValueFactories().getBooleanFactory();
        ValueFactory stringFactory = this.executionContext.getValueFactories().getStringFactory();
        DateTimeFactory dateFactory = this.executionContext.getValueFactories().getDateFactory();
        DateTime now = dateFactory.create();
        DateTime newExpirationDate = now.plusMillis(60000);
        Path locksPath = pathFactory.createAbsolutePath(new Name[]{JcrLexicon.SYSTEM, ModeShapeLexicon.LOCKS});
        Subgraph locksGraph = null;
        try {
            locksGraph = (Subgraph)systemGraph.getSubgraphOfDepth(2).at(locksPath);
        }
        catch (PathNotFoundException pnfe) {
            return;
        }
        for (Location lockLocation : locksGraph.getRoot().getChildren()) {
            Node lockNode = locksGraph.getNode(lockLocation);
            Boolean isSessionScoped = (Boolean)booleanFactory.create(lockNode.getProperty(ModeShapeLexicon.IS_SESSION_SCOPED).getFirstValue());
            if (!isSessionScoped.booleanValue()) continue;
            String lockingSession = (String)stringFactory.create(lockNode.getProperty(ModeShapeLexicon.LOCKING_SESSION).getFirstValue());
            if (activeSessionIds.contains(lockingSession)) {
                ((Graph.SetValuesTo)systemGraph.set(ModeShapeLexicon.EXPIRATION_DATE).on(lockLocation)).to(newExpirationDate);
                continue;
            }
            DateTime expirationDate = (DateTime)dateFactory.create(lockNode.getProperty(ModeShapeLexicon.EXPIRATION_DATE).getFirstValue());
            if (!expirationDate.isBefore(now)) continue;
            String workspaceName = (String)stringFactory.create(lockNode.getProperty(ModeShapeLexicon.WORKSPACE).getFirstValue());
            WorkspaceLockManager lockManager = (WorkspaceLockManager)this.lockManagers.get(workspaceName);
            lockManager.unlock(this.executionContext, lockManager.createLock(lockNode));
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace(JcrI18n.cleanedUpLocks.text(new Object[0]), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Properties getBundleProperties() {
        if (bundleProperties == null) {
            InputStream stream = null;
            try {
                stream = JcrRepository.class.getClassLoader().getResourceAsStream("org/modeshape/jcr/repository.properties");
                assert (stream != null);
                Properties props = new Properties();
                props.load(stream);
                bundleProperties = new UnmodifiableProperties(props);
            }
            catch (IOException e) {
                throw new IllegalStateException(JcrI18n.failedToReadPropertiesFromManifest.text(new Object[]{e.getLocalizedMessage()}), e);
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                    }
                    finally {
                        stream = null;
                    }
                }
            }
        }
        return bundleProperties;
    }

    protected static String getBundleProperty(String propertyName, boolean required) {
        String value = JcrRepository.getBundleProperties().getProperty(propertyName);
        if (value == null && required) {
            throw new IllegalStateException(JcrI18n.failedToReadPropertyFromManifest.text(new Object[]{propertyName}));
        }
        return value;
    }

    private static Map<String, Object> initializeDescriptors(ValueFactories factories, Map<String, String> customDescriptors) {
        if (customDescriptors == null) {
            customDescriptors = Collections.emptyMap();
        }
        HashMap<String, Object> repoDescriptors = new HashMap<String, Object>(customDescriptors.size() + 60);
        for (Map.Entry<String, String> entry : customDescriptors.entrySet()) {
            repoDescriptors.put(entry.getKey(), JcrRepository.valueFor(factories, entry.getValue()));
        }
        repoDescriptors.put("level.1.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("level.2.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.locking.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.observation.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.query.sql.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.transactions.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.versioning.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("query.xpath.doc.order", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("query.xpath.pos.index", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("write.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("identifier.stability", JcrRepository.valueFor(factories, "identifier.stability.method.duration"));
        repoDescriptors.put("option.xml.import.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.xml.export.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.unfiled.content.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.simple.versioning.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.activities.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.baselines.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.access.control.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.journaled.observation.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.retention.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.lifecycle.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.transactions.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.workspace.management.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.node.and.property.with.same.name.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.update.primary.node.type.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.update.mixin.node.types.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("option.shareable.nodes.supported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("option.node.type.management.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.inheritance", JcrRepository.valueFor(factories, "node.type.management.inheritance.multiple"));
        repoDescriptors.put("node.type.management.primary.item.name.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.orderable.child.nodes.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.residual.definitions.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.autocreated.definitions.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.same.name.siblings.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.property.types", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.overrides.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.multivalued.properties.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.multiple.binary.properties.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.value.constraints.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("node.type.management.update.in.use.suported", JcrRepository.valueFor(factories, false));
        repoDescriptors.put("query.languages", new JcrValue[]{JcrRepository.valueFor(factories, "xpath"), JcrRepository.valueFor(factories, "JCR-SQL2"), JcrRepository.valueFor(factories, "sql")});
        repoDescriptors.put("query.stored.queries.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("query.full.text.search.supported", JcrRepository.valueFor(factories, true));
        repoDescriptors.put("query.joins", JcrRepository.valueFor(factories, "query.joins.inner"));
        repoDescriptors.put("jcr.specification.name", JcrRepository.valueFor(factories, JcrI18n.SPEC_NAME_DESC.text(new Object[0])));
        repoDescriptors.put("jcr.specification.version", JcrRepository.valueFor(factories, "1.0"));
        if (!repoDescriptors.containsKey("jcr.repository.name")) {
            repoDescriptors.put("jcr.repository.name", JcrRepository.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.name", true)));
        }
        if (!repoDescriptors.containsKey("jcr.repository.vendor")) {
            repoDescriptors.put("jcr.repository.vendor", JcrRepository.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.vendor", true)));
        }
        if (!repoDescriptors.containsKey("jcr.repository.vendor.url")) {
            repoDescriptors.put("jcr.repository.vendor.url", JcrRepository.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.vendor.url", true)));
        }
        if (!repoDescriptors.containsKey("jcr.repository.version")) {
            repoDescriptors.put("jcr.repository.version", JcrRepository.valueFor(factories, JcrRepository.getBundleProperty("jcr.repository.version", true)));
        }
        return Collections.unmodifiableMap(repoDescriptors);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, int type, Object value) {
        return new JcrValue(valueFactories, null, type, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, String value) {
        return JcrRepository.valueFor(valueFactories, 1, value);
    }

    private static JcrValue valueFor(ValueFactories valueFactories, boolean value) {
        return JcrRepository.valueFor(valueFactories, 6, value);
    }

    static {
        EnumMap<Option, String> defaults = new EnumMap<Option, String>(Option.class);
        defaults.put(Option.PROJECT_NODE_TYPES, DefaultOption.PROJECT_NODE_TYPES);
        defaults.put(Option.JAAS_LOGIN_CONFIG_NAME, "modeshape-jcr");
        defaults.put(Option.READ_DEPTH, "1");
        defaults.put(Option.ANONYMOUS_USER_ROLES, "admin");
        defaults.put(Option.TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES, DefaultOption.TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES);
        defaults.put(Option.QUERY_EXECUTION_ENABLED, DefaultOption.QUERY_EXECUTION_ENABLED);
        defaults.put(Option.QUERY_INDEXES_UPDATED_SYNCHRONOUSLY, DefaultOption.QUERY_INDEXES_UPDATED_SYNCHRONOUSLY);
        defaults.put(Option.QUERY_INDEX_DIRECTORY, DefaultOption.QUERY_INDEX_DIRECTORY);
        defaults.put(Option.PERFORM_REFERENTIAL_INTEGRITY_CHECKS, DefaultOption.PERFORM_REFERENTIAL_INTEGRITY_CHECKS);
        DEFAULT_OPTIONS = Collections.unmodifiableMap(defaults);
    }

    protected class RepositoryObservationManager
    implements Observable,
    Observer {
        private final ExecutorService observerService = Executors.newSingleThreadExecutor();
        private final CopyOnWriteArrayList<Observer> observers = new CopyOnWriteArrayList();
        private final Observable repositoryObservable;

        protected RepositoryObservationManager(Observable repositoryObservable) {
            this.repositoryObservable = repositoryObservable;
            this.repositoryObservable.register((Observer)this);
        }

        public void notify(final Changes changes) {
            if (!changes.getSourceName().equals(JcrRepository.this.getObservableSourceName())) {
                return;
            }
            if (this.observers.isEmpty()) {
                return;
            }
            final Iterator<Observer> observerIterator = this.observers.iterator();
            Runnable sender = new Runnable(){

                @Override
                public void run() {
                    while (observerIterator.hasNext()) {
                        Observer observer = (Observer)observerIterator.next();
                        assert (observer != null);
                        observer.notify(changes);
                    }
                }
            };
            this.observerService.execute(sender);
        }

        public boolean register(Observer observer) {
            if (observer == null) {
                return false;
            }
            return this.observers.addIfAbsent(observer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void shutdown() {
            RepositoryObservationManager repositoryObservationManager = this;
            synchronized (repositoryObservationManager) {
                this.repositoryObservable.unregister((Observer)this);
                this.observers.clear();
                this.observerService.shutdown();
            }
        }

        public boolean unregister(Observer observer) {
            if (observer == null) {
                return false;
            }
            return this.observers.remove(observer);
        }
    }

    @Immutable
    protected static class SourceWorkspacePair {
        private final String sourceName;
        private final String workspaceName;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected SourceWorkspacePair(String sourceAndWorkspaceName) {
            assert (sourceAndWorkspaceName != null);
            sourceAndWorkspaceName = sourceAndWorkspaceName.trim();
            assert (sourceAndWorkspaceName.length() != 0);
            sourceAndWorkspaceName = sourceAndWorkspaceName.trim();
            int maxIndex = sourceAndWorkspaceName.length() - 1;
            int index = sourceAndWorkspaceName.indexOf(64);
            while (index > 0 && index < maxIndex && sourceAndWorkspaceName.charAt(index - 1) == '\\') {
                index = sourceAndWorkspaceName.indexOf(64, index + 1);
            }
            if (index > 0) {
                this.workspaceName = sourceAndWorkspaceName.substring(0, index).trim().replaceAll("\\\\@", "@");
                if (index >= maxIndex) throw new IllegalArgumentException("The source name is invalid");
                this.sourceName = sourceAndWorkspaceName.substring(index + 1).trim().replaceAll("\\\\@", "@");
            } else if (index == 0) {
                this.sourceName = sourceAndWorkspaceName.length() == 1 ? "" : sourceAndWorkspaceName.substring(1).trim().replaceAll("\\\\@", "@");
                this.workspaceName = "";
            } else {
                this.workspaceName = null;
                this.sourceName = sourceAndWorkspaceName.replaceAll("\\\\@", "@");
            }
            assert (this.sourceName != null);
            return;
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public String getWorkspaceName() {
            return this.workspaceName;
        }

        public String toString() {
            if (this.sourceName == null) {
                return "";
            }
            if (this.workspaceName != null) {
                return this.workspaceName + '@' + this.sourceName;
            }
            return this.sourceName;
        }
    }

    protected class DelegatingConnectionFactory
    implements RepositoryConnectionFactory {
        private final RepositoryConnectionFactory delegate;
        private final RepositorySource source;

        protected DelegatingConnectionFactory(RepositoryConnectionFactory delegate, RepositorySource source) {
            assert (delegate != null);
            this.delegate = delegate;
            this.source = source;
        }

        public RepositoryConnection createConnection(String sourceName) throws RepositorySourceException {
            if (this.source.getName().equals(sourceName)) {
                return this.source.getConnection();
            }
            return this.delegate.createConnection(sourceName);
        }
    }

    protected class FederatedRepositoryContext
    implements RepositoryContext {
        private final RepositoryConnectionFactory connectionFactory;

        protected FederatedRepositoryContext(RepositoryConnectionFactory nonFederatingConnectionFactory) {
            this.connectionFactory = nonFederatingConnectionFactory;
        }

        public Subgraph getConfiguration(int depth) {
            throw new UnsupportedOperationException();
        }

        public ExecutionContext getExecutionContext() {
            return JcrRepository.this.getExecutionContext();
        }

        public Observer getObserver() {
            return JcrRepository.this.getObserver();
        }

        public RepositoryConnectionFactory getRepositoryConnectionFactory() {
            return this.connectionFactory;
        }
    }

    public static final class QueryLanguage {
        public static final String XPATH = "xpath";
        public static final String JCR_SQL = "sql";
        public static final String JCR_SQL2 = "JCR-SQL2";
        @Deprecated
        public static final String SQL = "JCR-SQL2";
        public static final String SEARCH = "Search";
    }

    public static class DefaultOption {
        public static final String PROJECT_NODE_TYPES = Boolean.FALSE.toString();
        public static final String JAAS_LOGIN_CONFIG_NAME = "modeshape-jcr";
        public static final String READ_DEPTH = "1";
        public static final String ANONYMOUS_USER_ROLES = "admin";
        public static final String TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES = Boolean.TRUE.toString();
        public static final String QUERY_EXECUTION_ENABLED = Boolean.TRUE.toString();
        public static final String QUERY_INDEXES_UPDATED_SYNCHRONOUSLY = Boolean.TRUE.toString();
        public static final String QUERY_INDEX_DIRECTORY = null;
        public static final String PERFORM_REFERENTIAL_INTEGRITY_CHECKS = Boolean.TRUE.toString();
    }

    public static enum Option {
        PROJECT_NODE_TYPES,
        JAAS_LOGIN_CONFIG_NAME,
        SYSTEM_SOURCE_NAME,
        READ_DEPTH,
        ANONYMOUS_USER_ROLES,
        TABLES_INCLUDE_COLUMNS_FOR_INHERITED_PROPERTIES,
        QUERY_EXECUTION_ENABLED,
        QUERY_INDEX_DIRECTORY,
        QUERY_INDEXES_UPDATED_SYNCHRONOUSLY,
        PERFORM_REFERENTIAL_INTEGRITY_CHECKS;


        public static Option findOption(String option) {
            if (option == null) {
                return null;
            }
            try {
                return Option.valueOf(option);
            }
            catch (IllegalArgumentException e) {
                try {
                    return Option.valueOf(option.toUpperCase());
                }
                catch (IllegalArgumentException e2) {
                    String underscored = Inflector.getInstance().underscore(option, new char[]{'_'});
                    if (underscored == null) {
                        throw e2;
                    }
                    return Option.valueOf(underscored.toUpperCase());
                }
            }
        }
    }
}

