/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.lock.LockException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.i18n.I18n;
import org.modeshape.common.text.Jsr283Encoder;
import org.modeshape.common.text.TextEncoder;
import org.modeshape.common.util.Logger;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Graph;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.DateTimeFactory;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.ValueFactories;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrChildNodeIterator;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNodeDefinition;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.JcrWorkspace;
import org.modeshape.jcr.ModeShapeIntLexicon;
import org.modeshape.jcr.NodeDefinitionId;
import org.modeshape.jcr.PropertyDefinitionId;
import org.modeshape.jcr.SessionCache;

final class JcrVersionManager {
    private static final Logger LOGGER = Logger.getLogger(JcrVersionManager.class);
    private static final TextEncoder NODE_ENCODER = new Jsr283Encoder();
    static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    static final Set<Name> IGNORED_PROP_NAMES_FOR_RESTORE = Collections.unmodifiableSet(new HashSet<Name>(Arrays.asList(JcrLexicon.FROZEN_PRIMARY_TYPE, JcrLexicon.FROZEN_MIXIN_TYPES, JcrLexicon.FROZEN_UUID, JcrLexicon.PRIMARY_TYPE, JcrLexicon.MIXIN_TYPES, JcrLexicon.UUID)));
    private final JcrSession session;

    public JcrVersionManager(JcrSession session) {
        this.session = session;
    }

    ExecutionContext context() {
        return this.session.getExecutionContext();
    }

    private ValueFactories factories() {
        return this.context().getValueFactories();
    }

    UUID uuid(Object ob) {
        return (UUID)this.factories().getUuidFactory().create(ob);
    }

    Name name(String s) {
        return (Name)this.factories().getNameFactory().create(s);
    }

    Name name(Object ob) {
        return (Name)this.factories().getNameFactory().create(ob);
    }

    final Path path(Path root, Name child) {
        return this.factories().getPathFactory().create(root, new Name[]{child});
    }

    Path path(Path root, Path.Segment childSegment) {
        return this.factories().getPathFactory().create(root, new Path.Segment[]{childSegment});
    }

    private Path absolutePath(Name ... absolutePathSegments) {
        return this.factories().getPathFactory().createAbsolutePath(absolutePathSegments);
    }

    DateTime dateTime(Calendar cal) {
        return (DateTime)this.factories().getDateFactory().create(cal);
    }

    private PropertyFactory propertyFactory() {
        return this.context().getPropertyFactory();
    }

    SessionCache cache() {
        return this.session.cache();
    }

    private JcrRepository repository() {
        return this.session.repository();
    }

    JcrSession session() {
        return this.session;
    }

    JcrWorkspace workspace() {
        return this.session.workspace();
    }

    Path versionHistoryPathFor(UUID uuid) {
        return this.absolutePath(JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE, this.name(uuid.toString()));
    }

    JcrVersionHistoryNode getVersionHistory(AbstractJcrNode node) throws RepositoryException {
        Location historyLocation = Location.create((Path)this.versionHistoryPathFor(node.uuid()));
        try {
            return (JcrVersionHistoryNode)this.cache().findJcrNode(historyLocation);
        }
        catch (ItemNotFoundException infe) {
            this.initializeVersionHistoryFor(node);
            JcrVersionHistoryNode historyNode = (JcrVersionHistoryNode)this.cache().findJcrNode(historyLocation);
            LOGGER.warn(JcrI18n.repairedVersionStorage, new Object[]{historyLocation});
            return historyNode;
        }
    }

    JcrNodeDefinition nodeDefinitionFor(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node) throws RepositoryException {
        NodeDefinitionId nodeDefnId = ((SessionCache.JcrNodePayload)node.getPayload()).getDefinitionId();
        return this.session().nodeTypeManager().getNodeDefinition(nodeDefnId);
    }

    JcrVersionNode checkin(AbstractJcrNode node) throws RepositoryException {
        if (node.isNew() || node.isModified()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        if (node.isLocked() && !node.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{node.getPath()}));
        }
        if (node.getProperty(JcrLexicon.MERGE_FAILED) != null) {
            throw new VersionException(JcrI18n.pendingMergeConflicts.text(new Object[]{node.getPath()}));
        }
        AbstractJcrProperty isCheckedOut = node.getProperty(JcrLexicon.IS_CHECKED_OUT);
        if (!isCheckedOut.getBoolean()) {
            return node.getBaseVersion();
        }
        Name primaryTypeName = node.getPrimaryTypeName();
        List<Name> mixinTypeNames = node.getMixinTypeNames();
        UUID jcrUuid = node.uuid();
        UUID versionUuid = UUID.randomUUID();
        JcrVersionHistoryNode historyNode = this.getVersionHistory(node);
        Path historyPath = historyNode.path();
        Graph systemGraph = this.repository().createSystemGraph(this.context());
        Graph.Batch systemBatch = systemGraph.batch();
        DateTime now = this.context().getValueFactories().getDateFactory().create();
        Path versionPath = this.path(historyPath, this.name(NODE_ENCODER.encode(now.getString())));
        AbstractJcrProperty predecessorsProp = node.getProperty(JcrLexicon.PREDECESSORS);
        systemBatch.create(versionPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION}).and(JcrLexicon.CREATED, new Object[]{now}).and(JcrLexicon.UUID, new Object[]{versionUuid}).and(predecessorsProp.property()).and();
        Path frozenVersionPath = this.path(versionPath, JcrLexicon.FROZEN_NODE);
        systemBatch.create(frozenVersionPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FROZEN_NODE}).and(JcrLexicon.FROZEN_UUID, new Object[]{jcrUuid}).and(JcrLexicon.FROZEN_PRIMARY_TYPE, new Object[]{primaryTypeName}).and(JcrLexicon.FROZEN_MIXIN_TYPES, new Object[]{mixinTypeNames}).and(this.versionedPropertiesFor(node)).and();
        int onParentVersion = node.getDefinition().getOnParentVersion();
        NodeIterator childNodes = node.getNodes();
        while (childNodes.hasNext()) {
            AbstractJcrNode childNode = (AbstractJcrNode)childNodes.nextNode();
            this.versionNodeAt(childNode, frozenVersionPath, systemBatch, onParentVersion);
        }
        PropertyFactory propFactory = this.propertyFactory();
        for (Object ob : predecessorsProp.property()) {
            UUID predUuid = this.uuid(ob);
            Property successorsProp = systemGraph.getNodeAt(predUuid).getProperty(JcrLexicon.SUCCESSORS);
            LinkedList newSuccessors = new LinkedList();
            if (successorsProp != null) {
                for (Object successor : successorsProp) {
                    newSuccessors.add(successor);
                }
            }
            newSuccessors.add(versionUuid);
            Property newSuccessorsProp = propFactory.create(JcrLexicon.SUCCESSORS, newSuccessors.toArray());
            ((Graph.BatchConjunction)systemBatch.set(new Property[]{newSuccessorsProp}).on(predUuid)).and();
        }
        systemBatch.execute();
        historyNode.refresh(false);
        AbstractJcrNode newVersion = this.cache().findJcrNode(Location.create((UUID)versionUuid));
        SessionCache.NodeEditor editor = node.editor();
        editor.setProperty(JcrLexicon.PREDECESSORS, node.valuesFrom(9, EMPTY_OBJECT_ARRAY), 9, false);
        editor.setProperty(JcrLexicon.BASE_VERSION, node.valueFrom(newVersion), false);
        editor.setProperty(JcrLexicon.IS_CHECKED_OUT, node.valueFrom(6, false), false);
        node.save();
        return (JcrVersionNode)newVersion;
    }

    private void versionNodeAt(AbstractJcrNode node, Path verisonedParentPath, Graph.Batch batch, int onParentVersionAction) throws RepositoryException {
        Path childPath = this.path(verisonedParentPath, node.path().getLastSegment());
        Name primaryTypeName = node.getPrimaryTypeName();
        List<Name> mixinTypeNames = node.getMixinTypeNames();
        UUID uuid = UUID.randomUUID();
        if (node.isReferenceable()) {
            uuid = node.uuid();
        }
        switch (onParentVersionAction) {
            case 6: {
                throw new VersionException(JcrI18n.cannotCheckinNodeWithAbortChildNode.text(new Object[]{node.getName(), node.getParent().getName()}));
            }
            case 2: {
                if (node.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                    JcrVersionHistoryNode history = node.getVersionHistory();
                    UUID historyUuid = history.uuid();
                    batch.create(childPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSIONED_CHILD}).with(JcrLexicon.CHILD_VERSION_HISTORY, new Object[]{historyUuid}).and();
                    break;
                }
            }
            case 1: {
                batch.create(childPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FROZEN_NODE}).and(JcrLexicon.FROZEN_PRIMARY_TYPE, new Object[]{primaryTypeName}).and(JcrLexicon.FROZEN_MIXIN_TYPES, new Object[]{mixinTypeNames}).and(JcrLexicon.FROZEN_UUID, new Object[]{uuid}).and(this.versionedPropertiesFor(node)).and();
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                return;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + onParentVersionAction);
            }
        }
        NodeIterator childNodes = node.getNodes();
        while (childNodes.hasNext()) {
            AbstractJcrNode childNode = (AbstractJcrNode)childNodes.nextNode();
            this.versionNodeAt(childNode, childPath, batch, onParentVersionAction);
        }
    }

    private Collection<Property> versionedPropertiesFor(AbstractJcrNode node) throws RepositoryException {
        LinkedList<Property> props = new LinkedList<Property>();
        PropertyIterator iter = node.getProperties();
        while (iter.hasNext()) {
            AbstractJcrProperty property = (AbstractJcrProperty)iter.nextProperty();
            Property prop = property.property();
            PropertyDefinitionId propDefnId = ((SessionCache.JcrPropertyPayload)property.propertyInfo().getPayload()).getPropertyDefinitionId();
            JcrPropertyDefinition propDefn = this.cache().nodeTypes().getPropertyDefinition(propDefnId);
            switch (propDefn.getOnParentVersion()) {
                case 6: {
                    I18n msg = JcrI18n.cannotCheckinNodeWithAbortProperty;
                    throw new VersionException(msg.text(new Object[]{property.getName(), node.getName()}));
                }
                case 1: 
                case 2: {
                    props.add(prop);
                    break;
                }
            }
        }
        return props;
    }

    void checkout(AbstractJcrNode node) throws LockException, RepositoryException {
        Property multiValuedProps;
        if (node.isLocked() && !node.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{node.getPath()}));
        }
        if (!node.hasProperty(JcrLexicon.BASE_VERSION)) {
            return;
        }
        PropertyFactory propFactory = this.propertyFactory();
        GraphSession.PropertyInfo mvProp = node.nodeInfo().getProperty(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES);
        Property property = multiValuedProps = mvProp != null ? mvProp.getProperty() : null;
        if (multiValuedProps == null) {
            multiValuedProps = propFactory.create(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES, new Object[]{JcrLexicon.PREDECESSORS});
        } else if (!Arrays.asList(multiValuedProps.getValues()).contains(JcrLexicon.PREDECESSORS)) {
            LinkedList values = new LinkedList();
            for (Object value : multiValuedProps) {
                values.add(value);
            }
            values.add(JcrLexicon.PREDECESSORS);
            multiValuedProps = propFactory.create(ModeShapeIntLexicon.MULTI_VALUED_PROPERTIES, values);
        }
        ValueFactory refFactory = this.context().getValueFactories().getReferenceFactory();
        Object[] oldPreds = EMPTY_OBJECT_ARRAY;
        AbstractJcrProperty oldPredsProperty = node.getBaseVersion().getProperty(JcrLexicon.PREDECESSORS);
        if (oldPredsProperty != null) {
            oldPreds = oldPredsProperty.property().getValuesAsArray();
        }
        Object[] newPreds = new Object[oldPreds.length + 1];
        newPreds[0] = refFactory.create(node.getBaseVersion().uuid());
        System.arraycopy(oldPreds, 0, newPreds, 1, oldPreds.length);
        Property isCheckedOut = propFactory.create(JcrLexicon.IS_CHECKED_OUT, new Object[]{true});
        Property predecessors = propFactory.create(JcrLexicon.PREDECESSORS, newPreds);
        Graph graph = this.workspace().graph();
        Location location = Location.create((UUID)node.uuid());
        ((Graph.Conjunction)graph.set(new Property[]{isCheckedOut, predecessors, multiValuedProps}).on(location)).and();
        this.cache().refreshProperties(location);
    }

    void restore(Version[] versions, boolean removeExisting) throws RepositoryException {
        HashMap<Version, AbstractJcrNode> existingVersions = new HashMap<Version, AbstractJcrNode>(versions.length);
        HashSet<Path> versionRootPaths = new HashSet<Path>(versions.length);
        ArrayList<Version> nonExistingVersions = new ArrayList<Version>(versions.length);
        for (int i = 0; i < versions.length; ++i) {
            VersionHistory history = versions[i].getContainingHistory();
            if (history.getRootVersion().isSame((Item)versions[i])) {
                throw new VersionException(JcrI18n.cannotRestoreRootVersion.text(new Object[]{versions[i].getPath()}));
            }
            try {
                AbstractJcrNode existingNode = this.session.getNodeByUUID(history.getVersionableUUID());
                existingVersions.put(versions[i], existingNode);
                versionRootPaths.add(existingNode.path());
                continue;
            }
            catch (ItemNotFoundException infe) {
                nonExistingVersions.add(versions[i]);
            }
        }
        if (existingVersions.isEmpty()) {
            throw new VersionException(JcrI18n.noExistingVersionForRestore.text(new Object[0]));
        }
        RestoreCommand op = new RestoreCommand(existingVersions, versionRootPaths, nonExistingVersions, null, removeExisting);
        op.execute();
    }

    void restore(Path path, Version version, String labelToRestore, boolean removeExisting) throws RepositoryException {
        AbstractJcrNode nodeToCheckLock;
        if (this.session().hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        AbstractJcrNode parentNode = this.cache().findJcrNode(null, path.getParent());
        AbstractJcrNode existingNode = null;
        JcrVersionNode jcrVersion = (JcrVersionNode)version;
        try {
            nodeToCheckLock = existingNode = this.cache().findJcrNode(null, path);
            JcrVersionHistoryNode versionHistory = existingNode.getVersionHistory();
            if (!versionHistory.isSame(jcrVersion.getParent())) {
                throw new VersionException(JcrI18n.invalidVersion.text(new Object[]{version.getPath(), versionHistory.getPath()}));
            }
            if (!versionHistory.isSame(existingNode.getVersionHistory())) {
                throw new VersionException(JcrI18n.invalidVersion.text(new Object[]{version.getPath(), existingNode.getVersionHistory().getPath()}));
            }
            if (jcrVersion.isSame((Item)versionHistory.getRootVersion())) {
                throw new VersionException(JcrI18n.cannotRestoreRootVersion.text(new Object[]{existingNode.getPath()}));
            }
        }
        catch (PathNotFoundException pnfe) {
            if (!parentNode.isCheckedOut()) {
                String parentPath = path.getString(this.context().getNamespaceRegistry());
                throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{parentPath}));
            }
            AbstractJcrNode sourceNode = this.frozenNodeFor(version);
            Name primaryTypeName = this.name(sourceNode.getProperty(JcrLexicon.FROZEN_PRIMARY_TYPE).property().getFirstValue());
            AbstractJcrProperty uuidProp = sourceNode.getProperty(JcrLexicon.FROZEN_UUID);
            UUID desiredUuid = this.uuid(uuidProp.property().getFirstValue());
            existingNode = parentNode.editor().createChild(path.getLastSegment().getName(), desiredUuid, primaryTypeName);
            nodeToCheckLock = parentNode;
        }
        if (nodeToCheckLock.isLocked() && !nodeToCheckLock.holdsLock()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{nodeToCheckLock.getPath()}));
        }
        RestoreCommand op = new RestoreCommand(Collections.singletonMap(version, existingNode), Collections.singleton(existingNode.path()), Collections.<Version>emptySet(), labelToRestore, removeExisting);
        op.execute();
        SessionCache.NodeEditor editor = existingNode.editor();
        editor.setProperty(JcrLexicon.IS_CHECKED_OUT, existingNode.valueFrom(6, false), false);
        editor.setProperty(JcrLexicon.BASE_VERSION, existingNode.valueFrom(jcrVersion), false);
        this.session().save();
    }

    AbstractJcrNode frozenNodeFor(Version version) throws RepositoryException {
        return ((AbstractJcrNode)version).getNode(JcrLexicon.FROZEN_NODE);
    }

    void doneMerge(AbstractJcrNode targetNode, Version version) throws RepositoryException {
        if (targetNode.isNew() || targetNode.isModified()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowedForNode.text(new Object[0]));
        }
        if (!targetNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
            throw new VersionException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
        AbstractJcrProperty prop = targetNode.getProperty(JcrLexicon.PREDECESSORS);
        JcrValue[] values = (JcrValue[])prop.getValues();
        Value[] newValues = new JcrValue[values.length + 1];
        System.arraycopy(values, 0, newValues, 0, values.length);
        newValues[values.length] = targetNode.valueFrom((Node)version);
        targetNode.editor().setProperty(JcrLexicon.PREDECESSORS, newValues, 9, false);
        this.removeVersionFromMergeFailedProperty(targetNode, version);
        targetNode.save();
    }

    void cancelMerge(AbstractJcrNode targetNode, Version version) throws RepositoryException {
        if (targetNode.isNew() || targetNode.isModified()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowedForNode.text(new Object[0]));
        }
        if (!targetNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
            throw new VersionException(JcrI18n.requiresVersionable.text(new Object[0]));
        }
        this.removeVersionFromMergeFailedProperty(targetNode, version);
        targetNode.save();
    }

    private void removeVersionFromMergeFailedProperty(AbstractJcrNode targetNode, Version version) throws RepositoryException {
        if (!targetNode.hasProperty(JcrLexicon.MERGE_FAILED)) {
            throw new VersionException(JcrI18n.versionNotInMergeFailed.text(new Object[]{version.getName(), targetNode.getPath()}));
        }
        AbstractJcrProperty prop = targetNode.getProperty(JcrLexicon.MERGE_FAILED);
        Value[] values = prop.getValues();
        String uuidString = version.getUUID();
        int matchIndex = -1;
        for (int i = 0; i < values.length; ++i) {
            if (!uuidString.equals(values[i].getString())) continue;
            matchIndex = i;
            break;
        }
        if (matchIndex == -1) {
            throw new VersionException(JcrI18n.versionNotInMergeFailed.text(new Object[]{version.getName(), targetNode.getPath()}));
        }
        if (values.length == 1) {
            prop.remove();
        } else {
            Value[] newValues = new JcrValue[values.length - 2];
            if (matchIndex == 0) {
                System.arraycopy(values, 1, newValues, 0, values.length - 1);
            } else if (matchIndex == values.length - 1) {
                System.arraycopy(values, 0, newValues, 0, values.length - 2);
            } else {
                System.arraycopy(values, 0, newValues, 0, matchIndex);
                System.arraycopy(values, matchIndex + 1, newValues, matchIndex, values.length - matchIndex - 1);
            }
            prop.setValue(newValues);
        }
    }

    NodeIterator merge(AbstractJcrNode targetNode, String srcWorkspace, boolean bestEffort) throws RepositoryException {
        if (this.session().hasPendingChanges()) {
            throw new InvalidItemStateException(JcrI18n.noPendingChangesAllowed.text(new Object[0]));
        }
        try {
            targetNode.correspondingNodePath(srcWorkspace);
        }
        catch (ItemNotFoundException infe) {
            return new JcrChildNodeIterator(Collections.<AbstractJcrNode>emptySet(), 0);
        }
        JcrSession sourceSession = this.session().with(srcWorkspace);
        MergeCommand op = new MergeCommand(targetNode, sourceSession, bestEffort);
        op.execute();
        this.session.save();
        return op.getFailures();
    }

    void restoreProperty(AbstractJcrProperty property, SessionCache.NodeEditor editor) throws RepositoryException {
        Name propName = property.name();
        editor.removeProperty(propName);
        if (property.isMultiple()) {
            Value[] values = (JcrValue[])property.getValues();
            editor.setProperty(propName, values, property.getType(), false);
        } else {
            JcrValue value = (JcrValue)property.getValue();
            editor.setProperty(propName, value, false);
        }
    }

    void initializeVersionHistoryFor(AbstractJcrNode node) throws RepositoryException {
        Graph.Batch batch = this.session().createBatch();
        this.initializeVersionHistoryFor(batch, node.nodeInfo(), true);
        batch.execute();
    }

    void initializeVersionHistoryFor(Graph.Batch batch, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node, boolean forceWrite) throws RepositoryException {
        boolean initialized;
        if (!this.cache().isVersionable(node)) {
            return;
        }
        boolean bl = initialized = node.getProperty(JcrLexicon.IS_CHECKED_OUT) != null;
        if (!forceWrite && initialized) {
            return;
        }
        UUID historyUuid = UUID.randomUUID();
        UUID versionUuid = UUID.randomUUID();
        this.initializeVersionStorageFor(node, historyUuid, versionUuid);
        GraphSession.PropertyInfo jcrUuidProp = node.getProperty(JcrLexicon.UUID);
        UUID jcrUuid = this.uuid(jcrUuidProp.getProperty().getFirstValue());
        Name nameSegment = this.name(jcrUuid.toString());
        Path historyPath = this.factories().getPathFactory().createAbsolutePath(new Name[]{JcrLexicon.SYSTEM, JcrLexicon.VERSION_STORAGE, nameSegment});
        ValueFactory refFactory = this.context().getValueFactories().getReferenceFactory();
        Property isCheckedOut = this.propertyFactory().create(JcrLexicon.IS_CHECKED_OUT, new Object[]{true});
        Property versionHistory = this.propertyFactory().create(JcrLexicon.VERSION_HISTORY, new Object[]{refFactory.create(historyUuid)});
        Property baseVersion = this.propertyFactory().create(JcrLexicon.BASE_VERSION, new Object[]{refFactory.create(versionUuid)});
        Property predecessors = this.propertyFactory().create(JcrLexicon.PREDECESSORS, new Object[]{refFactory.create(versionUuid)});
        ((Graph.BatchConjunction)batch.set(new Property[]{isCheckedOut, versionHistory, baseVersion, predecessors}).on(node.getPath())).and();
        Path storagePath = historyPath.getParent();
        GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> storageNode = this.cache().findNode(null, storagePath);
        this.cache().refresh(storageNode.getNodeId(), storagePath, false);
    }

    void initializeVersionStorageFor(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node, UUID historyUuid, UUID versionUuid) {
        SessionCache.JcrNodePayload payload = (SessionCache.JcrNodePayload)node.getPayload();
        Graph systemGraph = this.session().repository().createSystemGraph(this.context());
        Graph.Batch systemBatch = systemGraph.batch();
        Name primaryTypeName = payload.getPrimaryTypeName();
        List<Name> mixinTypeNames = payload.getMixinTypeNames();
        GraphSession.PropertyInfo jcrUuidProp = node.getProperty(JcrLexicon.UUID);
        UUID jcrUuid = this.uuid(jcrUuidProp.getProperty().getFirstValue());
        Path historyPath = this.versionHistoryPathFor(jcrUuid);
        systemBatch.create(historyPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION_HISTORY}).and(JcrLexicon.VERSIONABLE_UUID, new Object[]{jcrUuid}).and(JcrLexicon.UUID, new Object[]{historyUuid}).and();
        Path versionLabelsPath = this.path(historyPath, JcrLexicon.VERSION_LABELS);
        systemBatch.create(versionLabelsPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION_LABELS}).and();
        Path rootVersionPath = this.path(historyPath, JcrLexicon.ROOT_VERSION);
        DateTime now = this.context().getValueFactories().getDateFactory().create();
        systemBatch.create(rootVersionPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION}).and(JcrLexicon.CREATED, new Object[]{now}).and(JcrLexicon.UUID, new Object[]{versionUuid}).and();
        Path frozenVersionPath = this.path(rootVersionPath, JcrLexicon.FROZEN_NODE);
        systemBatch.create(frozenVersionPath).with(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FROZEN_NODE}).and(JcrLexicon.FROZEN_UUID, new Object[]{jcrUuid}).and(JcrLexicon.FROZEN_PRIMARY_TYPE, new Object[]{primaryTypeName}).and(JcrLexicon.FROZEN_MIXIN_TYPES, new Object[]{mixinTypeNames}).and();
        systemBatch.execute();
    }

    @NotThreadSafe
    private class MergeCommand {
        private final Collection<AbstractJcrNode> failures;
        private final AbstractJcrNode targetNode;
        private final boolean bestEffort;
        private final JcrSession sourceSession;
        private final String workspaceName;

        public MergeCommand(AbstractJcrNode targetNode, JcrSession sourceSession, boolean bestEffort) {
            this.targetNode = targetNode;
            this.sourceSession = sourceSession;
            this.bestEffort = bestEffort;
            this.workspaceName = sourceSession.getWorkspace().getName();
            this.failures = new LinkedList<AbstractJcrNode>();
        }

        final JcrChildNodeIterator getFailures() {
            return new JcrChildNodeIterator(this.failures, this.failures.size());
        }

        void execute() throws RepositoryException {
            this.doMerge(this.targetNode);
        }

        private void doMerge(AbstractJcrNode targetNode) throws RepositoryException {
            JcrVersionNode targetVersion;
            AbstractJcrNode sourceNode;
            Path sourcePath = targetNode.correspondingNodePath(this.workspaceName);
            try {
                sourceNode = this.sourceSession.getNode(sourcePath);
            }
            catch (ItemNotFoundException infe) {
                this.doLeave(targetNode);
                return;
            }
            if (!targetNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                this.doUpdate(targetNode, sourceNode);
                return;
            }
            if (!sourceNode.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                this.doLeave(targetNode);
                return;
            }
            JcrVersionNode sourceVersion = sourceNode.getBaseVersion();
            if (sourceVersion.isSuccessorOf(targetVersion = targetNode.getBaseVersion()) && !targetNode.isCheckedOut()) {
                this.doUpdate(targetNode, sourceNode);
                return;
            }
            if (targetVersion.isSuccessorOf(sourceVersion) || targetVersion.uuid().equals(sourceVersion.uuid())) {
                this.doLeave(targetNode);
                return;
            }
            this.doFail(targetNode, sourceVersion);
        }

        private void doLeave(AbstractJcrNode targetNode) throws RepositoryException {
            NodeIterator iter = targetNode.getNodes();
            while (iter.hasNext()) {
                this.doMerge((AbstractJcrNode)iter.nextNode());
            }
        }

        private void doUpdate(AbstractJcrNode targetNode, AbstractJcrNode sourceNode) throws RepositoryException {
            this.restoreProperties(sourceNode, targetNode);
            LinkedHashMap<String, AbstractJcrNode> sourceNodes = this.childNodeMapFor(sourceNode);
            LinkedHashMap<String, AbstractJcrNode> targetNodes = this.childNodeMapFor(targetNode);
            LinkedHashMap<String, AbstractJcrNode> sourceOnly = new LinkedHashMap<String, AbstractJcrNode>(sourceNodes);
            sourceOnly.keySet().removeAll(targetNodes.keySet());
            for (AbstractJcrNode node : sourceOnly.values()) {
                JcrVersionManager.this.workspace().copy(this.workspaceName, node.getPath(), targetNode.getPath() + "/" + node.getName());
            }
            LinkedHashMap<String, AbstractJcrNode> targetOnly = new LinkedHashMap<String, AbstractJcrNode>(targetNodes);
            targetOnly.keySet().removeAll(targetOnly.keySet());
            for (AbstractJcrNode node : targetOnly.values()) {
                node.remove();
            }
            HashMap<String, AbstractJcrNode> presentInBoth = new HashMap<String, AbstractJcrNode>(targetNodes);
            presentInBoth.keySet().retainAll(sourceNodes.keySet());
            for (AbstractJcrNode node : presentInBoth.values()) {
                this.doMerge(node);
            }
        }

        private LinkedHashMap<String, AbstractJcrNode> childNodeMapFor(AbstractJcrNode node) throws RepositoryException {
            LinkedHashMap<String, AbstractJcrNode> childNodes = new LinkedHashMap<String, AbstractJcrNode>();
            NodeIterator iter = node.getNodes();
            while (iter.hasNext()) {
                AbstractJcrNode child = (AbstractJcrNode)iter.nextNode();
                childNodes.put(child.getName(), child);
            }
            return childNodes;
        }

        private void doFail(AbstractJcrNode targetNode, JcrVersionNode sourceVersion) throws RepositoryException {
            if (!this.bestEffort) {
                throw new MergeException();
            }
            SessionCache.NodeEditor targetEditor = targetNode.editor();
            if (targetNode.hasProperty(JcrLexicon.MERGE_FAILED)) {
                JcrValue[] existingValues = (JcrValue[])targetNode.getProperty(JcrLexicon.MERGE_FAILED).getValues();
                boolean found = false;
                String sourceUuidString = sourceVersion.uuid().toString();
                for (int i = 0; i < existingValues.length; ++i) {
                    if (!sourceUuidString.equals(existingValues[i].getString())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    Value[] newValues = new JcrValue[existingValues.length + 1];
                    System.arraycopy(existingValues, 0, newValues, 0, existingValues.length);
                    newValues[newValues.length - 1] = targetNode.valueFrom(sourceVersion);
                    targetEditor.setProperty(JcrLexicon.MERGE_FAILED, newValues, 9, false);
                }
            } else {
                targetEditor.setProperty(JcrLexicon.MERGE_FAILED, targetNode.valueFrom(sourceVersion), false);
            }
            this.failures.add(targetNode);
            this.doLeave(targetNode);
        }

        private void restoreProperties(AbstractJcrNode sourceNode, AbstractJcrNode targetNode) throws RepositoryException {
            SessionCache.NodeEditor childEditor = targetNode.editor();
            HashMap<Name, GraphSession.PropertyInfo> sourcePropertyNames = new HashMap<Name, GraphSession.PropertyInfo>();
            for (GraphSession.PropertyInfo propInfo : sourceNode.nodeInfo().getProperties()) {
                if (IGNORED_PROP_NAMES_FOR_RESTORE.contains(propInfo.getName())) continue;
                sourcePropertyNames.put(propInfo.getName(), propInfo);
            }
            ArrayList targetProps = new ArrayList(targetNode.nodeInfo().getProperties());
            for (GraphSession.PropertyInfo propertyInfo : targetProps) {
                Name propName = propertyInfo.getName();
                if (sourcePropertyNames.containsKey(propName)) {
                    JcrVersionManager.this.restoreProperty(((SessionCache.JcrPropertyPayload)((GraphSession.PropertyInfo)sourcePropertyNames.get(propName)).getPayload()).getJcrProperty(), childEditor);
                    sourcePropertyNames.remove(propName);
                    continue;
                }
                PropertyDefinitionId propDefnId = ((SessionCache.JcrPropertyPayload)propertyInfo.getPayload()).getPropertyDefinitionId();
                JcrPropertyDefinition propDefn = JcrVersionManager.this.session().nodeTypeManager().getPropertyDefinition(propDefnId);
                switch (propDefn.getOnParentVersion()) {
                    case 1: 
                    case 2: 
                    case 6: {
                        childEditor.removeProperty(propName);
                        break;
                    }
                }
            }
            for (Map.Entry entry : sourcePropertyNames.entrySet()) {
                JcrVersionManager.this.restoreProperty(((SessionCache.JcrPropertyPayload)((GraphSession.PropertyInfo)entry.getValue()).getPayload()).getJcrProperty(), childEditor);
            }
        }
    }

    @NotThreadSafe
    private class RestoreCommand {
        private Map<Version, AbstractJcrNode> existingVersions;
        private Set<Path> versionRootPaths;
        private Collection<Version> nonExistingVersions;
        private boolean removeExisting;
        private String labelToRestore;
        private Map<AbstractJcrNode, AbstractJcrNode> changedNodes;

        public RestoreCommand(Map<Version, AbstractJcrNode> existingVersions, Set<Path> versionRootPaths, Collection<Version> nonExistingVersions, String labelToRestore, boolean removeExisting) {
            this.existingVersions = existingVersions;
            this.versionRootPaths = versionRootPaths;
            this.nonExistingVersions = nonExistingVersions;
            this.removeExisting = removeExisting;
            this.labelToRestore = labelToRestore;
            this.changedNodes = new HashMap<AbstractJcrNode, AbstractJcrNode>(100);
        }

        void execute() throws RepositoryException {
            ArrayList<Version> versionsToCheck = new ArrayList<Version>(this.existingVersions.keySet());
            for (Version version : versionsToCheck) {
                AbstractJcrNode root = this.existingVersions.get(version);
                if (root == null) continue;
                this.restoreNodeMixins(JcrVersionManager.this.frozenNodeFor(version), root);
                this.restoreNode(JcrVersionManager.this.frozenNodeFor(version), root, JcrVersionManager.this.dateTime(version.getCreated()));
            }
            if (!this.nonExistingVersions.isEmpty()) {
                StringBuilder versions = new StringBuilder();
                boolean bl = true;
                for (Version version : this.nonExistingVersions) {
                    boolean bl2;
                    if (!bl2) {
                        versions.append(", ");
                    } else {
                        bl2 = false;
                    }
                    versions.append(version.getName());
                }
                throw new VersionException(JcrI18n.unrootedVersionsInRestore.text(new Object[]{versions.toString()}));
            }
            for (Map.Entry entry : this.changedNodes.entrySet()) {
                this.restoreProperties((AbstractJcrNode)entry.getKey(), (AbstractJcrNode)entry.getValue());
            }
        }

        /*
         * WARNING - void declaration
         */
        private void restoreNode(AbstractJcrNode sourceNode, AbstractJcrNode targetNode, DateTime checkinTime) throws RepositoryException {
            this.changedNodes.put(sourceNode, targetNode);
            SessionCache.NodeEditor targetEditor = targetNode.editor();
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> targetNodeInfo = targetNode.nodeInfo();
            GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> sourceNodeInfo = sourceNode.nodeInfo();
            HashMap<GraphSession.Node, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> presentInBoth = new HashMap<GraphSession.Node, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>>();
            List<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> inTargetOnly = this.copyOf(targetNodeInfo.getChildren(), targetNodeInfo.getChildrenCount());
            HashMap<GraphSession.Node, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> inSourceOnly = new HashMap<GraphSession.Node, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>>();
            for (GraphSession.Node node : sourceNodeInfo.getChildren()) {
                GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> resolvedNode = this.resolveSourceNode((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)node, checkinTime);
                GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> match = this.findMatchFor(resolvedNode);
                if (match != null) {
                    inTargetOnly.remove(match);
                    presentInBoth.put(node, match);
                    continue;
                }
                inSourceOnly.put(node, resolvedNode);
            }
            for (GraphSession.Node node : inTargetOnly) {
                switch (JcrVersionManager.this.nodeDefinitionFor((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)node).getOnParentVersion()) {
                    case 1: 
                    case 2: 
                    case 6: {
                        targetEditor.destroyChild((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)node);
                        break;
                    }
                }
            }
            LinkedList<GraphSession.Node> reversedChildren = new LinkedList<GraphSession.Node>();
            for (GraphSession.Node sourceChild : sourceNodeInfo.getChildren()) {
                reversedChildren.addFirst(sourceChild);
            }
            Object var11_15 = null;
            for (GraphSession.Node sourceChild : reversedChildren) {
                void var11_16;
                AbstractJcrNode targetChildNode;
                AbstractJcrNode sourceChildNode;
                GraphSession.Node resolvedChild;
                GraphSession.Node targetChild = (GraphSession.Node)presentInBoth.get(sourceChild);
                if (targetChild != null) {
                    resolvedChild = this.resolveSourceNode((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)sourceChild, checkinTime);
                    sourceChildNode = JcrVersionManager.this.cache().findJcrNode(resolvedChild.getNodeId(), resolvedChild.getPath());
                    targetChildNode = JcrVersionManager.this.cache().findJcrNode(targetChild.getNodeId(), targetChild.getPath());
                } else {
                    resolvedChild = (GraphSession.Node)inSourceOnly.get(sourceChild);
                    sourceChildNode = JcrVersionManager.this.cache().findJcrNode(resolvedChild.getNodeId(), resolvedChild.getPath());
                    Name primaryTypeName = JcrVersionManager.this.name(resolvedChild.getProperty(JcrLexicon.FROZEN_PRIMARY_TYPE).getProperty().getFirstValue());
                    GraphSession.PropertyInfo uuidProp = resolvedChild.getProperty(JcrLexicon.FROZEN_UUID);
                    UUID desiredUuid = JcrVersionManager.this.uuid(uuidProp.getProperty().getFirstValue());
                    targetChildNode = targetEditor.createChild(sourceChild.getName(), desiredUuid, primaryTypeName);
                }
                this.restoreNodeMixins(sourceChildNode, targetChildNode);
                if (sourceChildNode.getParent().isNodeType(JcrNtLexicon.VERSION)) {
                    SessionCache.NodeEditor editor = targetChildNode.editor();
                    editor.setProperty(JcrLexicon.IS_CHECKED_OUT, targetChildNode.valueFrom(6, false), false);
                    editor.setProperty(JcrLexicon.BASE_VERSION, targetChildNode.valueFrom(sourceChildNode.getParent()), false);
                }
                this.orderBefore((GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)sourceChild, (GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>)var11_16, targetEditor);
                this.restoreNode(sourceChildNode, targetChildNode, checkinTime);
                GraphSession.Node node = sourceChild;
            }
        }

        private void orderBefore(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> targetNode, GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> beforeNode, SessionCache.NodeEditor parentEditor) throws RepositoryException {
            Path.Segment beforeSegment = beforeNode == null ? null : beforeNode.getSegment();
            parentEditor.orderChildBefore(targetNode.getSegment(), beforeSegment);
        }

        private void restoreNodeMixins(AbstractJcrNode sourceNode, AbstractJcrNode targetNode) throws RepositoryException {
            AbstractJcrProperty mixinTypesProp = sourceNode.getProperty(JcrLexicon.FROZEN_MIXIN_TYPES);
            SessionCache.NodeEditor childEditor = targetNode.editor();
            Object[] mixinTypeNames = mixinTypesProp == null ? EMPTY_OBJECT_ARRAY : mixinTypesProp.property().getValuesAsArray();
            HashSet<Name> currentMixinTypes = new HashSet<Name>(targetNode.getMixinTypeNames());
            for (int i = 0; i < mixinTypeNames.length; ++i) {
                Name mixinTypeName = JcrVersionManager.this.name(mixinTypeNames[i]);
                if (currentMixinTypes.remove(mixinTypeName)) continue;
                JcrNodeType mixinType = JcrVersionManager.this.session().nodeTypeManager().getNodeType(mixinTypeName);
                childEditor.addMixin(mixinType);
            }
        }

        private void restoreProperties(AbstractJcrNode sourceNode, AbstractJcrNode targetNode) throws RepositoryException {
            SessionCache.NodeEditor childEditor = targetNode.editor();
            HashMap<Name, GraphSession.PropertyInfo> sourcePropertyNames = new HashMap<Name, GraphSession.PropertyInfo>();
            for (GraphSession.PropertyInfo propInfo : sourceNode.nodeInfo().getProperties()) {
                if (IGNORED_PROP_NAMES_FOR_RESTORE.contains(propInfo.getName())) continue;
                sourcePropertyNames.put(propInfo.getName(), propInfo);
            }
            ArrayList targetProps = new ArrayList(targetNode.nodeInfo().getProperties());
            for (GraphSession.PropertyInfo propertyInfo : targetProps) {
                Name propName = propertyInfo.getName();
                if (sourcePropertyNames.containsKey(propName)) {
                    JcrVersionManager.this.restoreProperty(((SessionCache.JcrPropertyPayload)((GraphSession.PropertyInfo)sourcePropertyNames.get(propName)).getPayload()).getJcrProperty(), childEditor);
                    sourcePropertyNames.remove(propName);
                    continue;
                }
                PropertyDefinitionId propDefnId = ((SessionCache.JcrPropertyPayload)propertyInfo.getPayload()).getPropertyDefinitionId();
                JcrPropertyDefinition propDefn = JcrVersionManager.this.session().nodeTypeManager().getPropertyDefinition(propDefnId);
                switch (propDefn.getOnParentVersion()) {
                    case 1: 
                    case 2: 
                    case 6: {
                        childEditor.removeProperty(propName);
                        break;
                    }
                }
            }
            for (Map.Entry entry : sourcePropertyNames.entrySet()) {
                JcrVersionManager.this.restoreProperty(((SessionCache.JcrPropertyPayload)((GraphSession.PropertyInfo)entry.getValue()).getPayload()).getJcrProperty(), childEditor);
            }
        }

        private GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> resolveSourceNode(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> sourceNode, DateTime checkinTime) throws RepositoryException {
            Name sourcePrimaryTypeName = JcrVersionManager.this.name(sourceNode.getProperty(JcrLexicon.PRIMARY_TYPE).getProperty().getFirstValue());
            if (JcrNtLexicon.FROZEN_NODE.equals(sourcePrimaryTypeName)) {
                return sourceNode;
            }
            assert (JcrNtLexicon.VERSIONED_CHILD.equals(sourcePrimaryTypeName));
            GraphSession.PropertyInfo historyUuidProp = sourceNode.getProperty(JcrLexicon.CHILD_VERSION_HISTORY);
            UUID uuid = JcrVersionManager.this.uuid(historyUuidProp.getProperty().getFirstValue());
            assert (uuid != null);
            String uuidString = uuid.toString();
            for (Version version : this.nonExistingVersions) {
                if (!uuidString.equals(version.getContainingHistory().getUUID())) continue;
                JcrVersionNode versionNode = (JcrVersionNode)version;
                this.nonExistingVersions.remove(version);
                return versionNode.getFrozenNode().nodeInfo();
            }
            for (Version version : this.existingVersions.keySet()) {
                if (!uuidString.equals(version.getContainingHistory().getUUID())) continue;
                JcrVersionNode versionNode = (JcrVersionNode)version;
                this.existingVersions.remove(version);
                return versionNode.getFrozenNode().nodeInfo();
            }
            JcrVersionHistoryNode versionHistory = (JcrVersionHistoryNode)JcrVersionManager.this.cache().findJcrNode(Location.create((UUID)uuid));
            if (this.labelToRestore != null) {
                try {
                    JcrVersionNode versionNode = versionHistory.getVersionByLabel(this.labelToRestore);
                    return versionNode.getFrozenNode().nodeInfo();
                }
                catch (VersionException noVersionWithThatLabel) {
                    // empty catch block
                }
            }
            AbstractJcrNode match = this.closestMatchFor(versionHistory, checkinTime);
            return match.nodeInfo();
        }

        private GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> findMatchFor(GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> sourceNode) throws ItemExistsException, RepositoryException {
            GraphSession.PropertyInfo uuidProp = sourceNode.getProperty(JcrLexicon.FROZEN_UUID);
            UUID sourceUuid = JcrVersionManager.this.uuid(uuidProp.getProperty().getFirstValue());
            try {
                AbstractJcrNode match = JcrVersionManager.this.cache().findJcrNode(Location.create((UUID)sourceUuid));
                if (this.nodeIsOutsideRestoredForest(match)) {
                    return null;
                }
                return match.nodeInfo();
            }
            catch (ItemNotFoundException infe) {
                return null;
            }
        }

        private List<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> copyOf(Iterable<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> rawElements, int size) {
            ArrayList<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>> newList = new ArrayList<GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload>>(size);
            for (GraphSession.Node<SessionCache.JcrNodePayload, SessionCache.JcrPropertyPayload> node : rawElements) {
                newList.add(node);
            }
            return newList;
        }

        private boolean nodeIsOutsideRestoredForest(AbstractJcrNode node) throws ItemExistsException, RepositoryException {
            Path nodePath = node.path();
            for (Path rootPath : this.versionRootPaths) {
                if (!nodePath.isAtOrBelow(rootPath)) continue;
                return false;
            }
            if (!this.removeExisting) {
                throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(new Object[]{node.uuid(), JcrVersionManager.this.workspace().getName(), node.getPath()}));
            }
            node.remove();
            return true;
        }

        private AbstractJcrNode closestMatchFor(JcrVersionHistoryNode versionHistory, DateTime checkinTime) throws RepositoryException {
            DateTimeFactory dateFactory = JcrVersionManager.this.context().getValueFactories().getDateFactory();
            VersionIterator iter = versionHistory.getAllVersions();
            HashMap<Object, Version> versions = new HashMap<Object, Version>((int)iter.getSize());
            while (iter.hasNext()) {
                Version version = iter.nextVersion();
                versions.put(dateFactory.create(version.getCreated()), version);
            }
            ArrayList versionDates = new ArrayList(versions.keySet());
            Collections.sort(versionDates);
            for (int i = versionDates.size() - 1; i >= 0; --i) {
                if (!((DateTime)versionDates.get(i)).isBefore(checkinTime)) continue;
                Version version = (Version)versions.get(versionDates.get(i));
                return ((JcrVersionNode)version).getFrozenNode();
            }
            throw new IllegalStateException("First checkin must be before the checkin time of the node to be restored");
        }
    }
}

