/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrItemDefinitionTemplate;
import org.modeshape.jcr.nodetype.NodeDefinitionTemplate;

@NotThreadSafe
class JcrNodeDefinitionTemplate
extends JcrItemDefinitionTemplate
implements NodeDefinitionTemplate {
    private Name defaultPrimaryType;
    private Name[] requiredPrimaryTypes;
    private boolean allowSameNameSiblings;

    JcrNodeDefinitionTemplate(ExecutionContext context) {
        super(context);
    }

    @Override
    public void setDefaultPrimaryType(String defaultPrimaryType) throws ConstraintViolationException {
        this.setDefaultPrimaryTypeName(defaultPrimaryType);
    }

    public void setDefaultPrimaryTypeName(String defaultPrimaryType) throws ConstraintViolationException {
        try {
            this.defaultPrimaryType = (Name)this.getContext().getValueFactories().getNameFactory().create(defaultPrimaryType);
        }
        catch (ValueFormatException vfe) {
            throw new ConstraintViolationException((Throwable)vfe);
        }
    }

    @Override
    public void setRequiredPrimaryTypes(String[] requiredPrimaryTypes) throws ConstraintViolationException {
        this.setRequiredPrimaryTypeNames(requiredPrimaryTypes);
    }

    public void setRequiredPrimaryTypeNames(String[] requiredPrimaryTypes) throws ConstraintViolationException {
        if (requiredPrimaryTypes == null) {
            throw new ConstraintViolationException(JcrI18n.badNodeTypeName.text(new Object[]{"requiredPrimaryTypes"}));
        }
        NameFactory nameFactory = this.getContext().getValueFactories().getNameFactory();
        Name[] rpts = new Name[requiredPrimaryTypes.length];
        for (int i = 0; i < requiredPrimaryTypes.length; ++i) {
            try {
                rpts[i] = (Name)nameFactory.create(requiredPrimaryTypes[i]);
                continue;
            }
            catch (ValueFormatException vfe) {
                throw new ConstraintViolationException((Throwable)vfe);
            }
        }
        this.requiredPrimaryTypes = rpts;
    }

    public void setSameNameSiblings(boolean allowSameNameSiblings) {
        this.allowSameNameSiblings = allowSameNameSiblings;
    }

    public boolean allowsSameNameSiblings() {
        return this.allowSameNameSiblings;
    }

    public NodeType getDefaultPrimaryType() {
        return null;
    }

    public String getDefaultPrimaryTypeName() {
        if (this.defaultPrimaryType == null) {
            return null;
        }
        return this.defaultPrimaryType.getString(this.getContext().getNamespaceRegistry());
    }

    public NodeType[] getRequiredPrimaryTypes() {
        return null;
    }

    public String[] getRequiredPrimaryTypeNames() {
        if (this.requiredPrimaryTypes == null) {
            return null;
        }
        NamespaceRegistry registry = this.getContext().getNamespaceRegistry();
        String[] rpts = new String[this.requiredPrimaryTypes.length];
        for (int i = 0; i < this.requiredPrimaryTypes.length; ++i) {
            rpts[i] = this.requiredPrimaryTypes[i].getString(registry);
        }
        return rpts;
    }
}

