/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.JcrQueryResult;
import org.modeshape.jcr.query.qom.JcrAbstractQuery;

public class JcrSearch
extends JcrAbstractQuery {
    public static final int MAXIMUM_RESULTS_FOR_FULL_TEXT_SEARCH_QUERIES = Integer.MAX_VALUE;

    public JcrSearch(JcrQueryContext context, String statement, String language, Path storedAtPath) {
        super(context, statement, language, storedAtPath);
    }

    public QueryResult execute() throws RepositoryException {
        Schemata schemata = this.context.getSchemata();
        QueryResults result = this.context.search(this.statement, Integer.MAX_VALUE, 0);
        this.checkForProblems(result.getProblems());
        return new JcrQueryResult(this.context, this.statement, result, schemata);
    }

    public String toString() {
        return this.language + " -> " + this.statement;
    }

    public void bindValue(String varName, Value value) throws IllegalArgumentException, RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public String[] getBindVariableNames() throws RepositoryException {
        throw new UnsupportedRepositoryOperationException();
    }

    public void setLimit(long limit) {
        throw new IllegalStateException();
    }

    public void setOffset(long offset) {
        throw new IllegalStateException();
    }
}

