/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.IOException;
import java.io.InputStream;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.graph.property.Binary;

@NotThreadSafe
class SelfClosingInputStream
extends InputStream {
    private final Binary binary;
    private final InputStream stream;

    public SelfClosingInputStream(Binary binary) {
        assert (binary != null);
        this.binary = binary;
        this.binary.acquire();
        this.stream = binary.getStream();
    }

    @Override
    public int available() throws IOException {
        try {
            return this.stream.available();
        }
        catch (IOException e) {
            this.binary.release();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.release();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            this.stream.close();
        }
        finally {
            this.binary.release();
        }
    }

    public boolean equals(Object obj) {
        return this.stream.equals(obj);
    }

    public int hashCode() {
        return this.stream.hashCode();
    }

    @Override
    public void mark(int readlimit) {
        try {
            this.stream.mark(readlimit);
        }
        catch (RuntimeException e) {
            this.binary.release();
            throw e;
        }
    }

    @Override
    public boolean markSupported() {
        return this.stream.markSupported();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int result = this.stream.read(b, off, len);
            if (result == -1) {
                this.binary.release();
            }
            return result;
        }
        catch (IOException e) {
            this.binary.release();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.release();
            throw e;
        }
    }

    @Override
    public int read(byte[] b) throws IOException {
        try {
            int result = this.stream.read(b);
            if (result == -1) {
                this.binary.release();
            }
            return result;
        }
        catch (IOException e) {
            this.binary.release();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.release();
            throw e;
        }
    }

    @Override
    public int read() throws IOException {
        try {
            int result = this.stream.read();
            if (result == -1) {
                this.binary.release();
            }
            return result;
        }
        catch (IOException e) {
            this.binary.release();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.release();
            throw e;
        }
    }

    @Override
    public void reset() throws IOException {
        try {
            this.stream.reset();
        }
        catch (IOException e) {
            this.binary.release();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.release();
            throw e;
        }
    }

    @Override
    public long skip(long n) throws IOException {
        try {
            return this.stream.skip(n);
        }
        catch (IOException e) {
            this.binary.release();
            throw e;
        }
        catch (RuntimeException e) {
            this.binary.release();
            throw e;
        }
    }

    public String toString() {
        try {
            return this.stream.toString();
        }
        catch (RuntimeException e) {
            this.binary.release();
            throw e;
        }
    }
}

