/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.query.QueryResults;
import org.modeshape.graph.query.validate.Schemata;
import org.modeshape.jcr.query.JcrQueryContext;
import org.modeshape.jcr.query.JcrQueryResult;

public class JcrSqlQueryResult
extends JcrQueryResult {
    public static final String JCR_SCORE_COLUMN_NAME = "jcr:score";
    public static final String JCR_PATH_COLUMN_NAME = "jcr:path";
    public static final String JCR_SCORE_COLUMN_TYPE = PropertyType.nameFromValue((int)4).toUpperCase();
    public static final String JCR_PATH_COLUMN_TYPE = PropertyType.nameFromValue((int)1).toUpperCase();
    private final List<String> columnNames;
    private final List<String> columnTypes;

    public JcrSqlQueryResult(JcrQueryContext context, String query, QueryResults graphResults, Schemata schemata) {
        super(context, query, graphResults, schemata);
        LinkedList<String> columnNames = new LinkedList<String>(graphResults.getColumns().getColumnNames());
        LinkedList<String> columnTypes = new LinkedList<String>(graphResults.getColumns().getColumnTypes());
        if (!columnNames.contains(JCR_SCORE_COLUMN_NAME)) {
            columnNames.add(0, JCR_SCORE_COLUMN_NAME);
            columnTypes.add(0, JCR_SCORE_COLUMN_TYPE);
        }
        if (!columnNames.contains(JCR_PATH_COLUMN_NAME)) {
            columnNames.add(0, JCR_PATH_COLUMN_NAME);
            columnTypes.add(0, JCR_PATH_COLUMN_TYPE);
        }
        this.columnNames = Collections.unmodifiableList(columnNames);
        this.columnTypes = Collections.unmodifiableList(columnTypes);
    }

    @Override
    public List<String> getColumnNameList() {
        return this.columnNames;
    }

    @Override
    public List<String> getColumnTypeList() {
        return this.columnTypes;
    }

    @Override
    public RowIterator getRows() {
        int numRows = this.results.getRowCount();
        List tuples = this.results.getTuples();
        return new JcrSqlQueryResultRowIterator(this.context, this.queryStatement, this.results, tuples.iterator(), numRows);
    }

    protected static class JcrSqlQueryResultRow
    extends JcrQueryResult.SingleSelectorQueryResultRow {
        protected JcrSqlQueryResultRow(JcrQueryResult.SingleSelectorQueryResultRowIterator iterator, Node node, Object[] tuple) {
            super(iterator, node, tuple);
        }

        @Override
        public Value getValue(String columnName) throws ItemNotFoundException, RepositoryException {
            if (JcrSqlQueryResult.JCR_PATH_COLUMN_NAME.equals(columnName)) {
                Location location = (Location)this.tuple[this.iterator.locationIndex];
                return ((JcrSqlQueryResultRowIterator)this.iterator).jcrPath(location.getPath());
            }
            if (JcrSqlQueryResult.JCR_SCORE_COLUMN_NAME.equals(columnName)) {
                Float score = (Float)this.tuple[this.iterator.scoreIndex];
                return ((JcrSqlQueryResultRowIterator)this.iterator).jcrScore(score);
            }
            return super.getValue(columnName);
        }
    }

    protected static class JcrSqlQueryResultRowIterator
    extends JcrQueryResult.SingleSelectorQueryResultRowIterator {
        protected JcrSqlQueryResultRowIterator(JcrQueryContext context, String query, QueryResults results, Iterator<Object[]> tuples, long numRows) {
            super(context, query, results, tuples, numRows);
        }

        @Override
        protected Row createRow(Node node, Object[] tuple) {
            return new JcrSqlQueryResultRow(this, node, tuple);
        }

        protected Value jcrPath(Path path) {
            return this.context.createValue(8, path);
        }

        protected Value jcrScore(Float score) {
            return this.context.createValue(4, score);
        }
    }
}

