/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import org.modeshape.graph.Graph;
import org.modeshape.graph.connector.RepositorySourceException;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Reference;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrGraph;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNode;
import org.modeshape.jcr.JcrVersionNode;
import org.modeshape.jcr.SessionCache;

class JcrVersionHistoryNode
extends JcrNode
implements VersionHistory {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public JcrVersionHistoryNode(AbstractJcrNode node) {
        super(node.cache, node.nodeId, node.location);
        assert (!node.isRoot()) : "Version histories should always be located in the /jcr:system/jcr:versionStorage subgraph";
    }

    private AbstractJcrNode versionLabels() throws RepositoryException {
        Path.Segment segment = this.segmentFrom(JcrLexicon.VERSION_LABELS);
        return ((SessionCache.JcrNodePayload)this.nodeInfo().getChild(segment).getPayload()).getJcrNode();
    }

    public VersionIterator getAllVersions() throws RepositoryException {
        return new JcrVersionIterator(this.getNodes());
    }

    public Version getRootVersion() throws RepositoryException {
        Path.Segment segment = this.context().getValueFactories().getPathFactory().createSegment(JcrLexicon.ROOT_VERSION);
        try {
            return (JcrVersionNode)((SessionCache.JcrNodePayload)this.nodeInfo().getChild(segment).getPayload()).getJcrNode();
        }
        catch (PathNotFoundException e) {
            String msg = JcrI18n.childNotFoundUnderNode.text(new Object[]{segment, this.getPath(), this.cache.workspaceName()});
            throw new javax.jcr.PathNotFoundException(msg);
        }
        catch (RepositorySourceException e) {
            throw new RepositoryException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public JcrVersionNode getVersion(String versionName) throws VersionException, RepositoryException {
        try {
            AbstractJcrNode version = this.getNode(versionName);
            return (JcrVersionNode)version;
        }
        catch (javax.jcr.PathNotFoundException pnfe) {
            throw new VersionException(JcrI18n.invalidVersionName.text(new Object[]{versionName, this.getPath()}));
        }
    }

    public JcrVersionNode getVersionByLabel(String label) throws VersionException, RepositoryException {
        Property prop = this.versionLabels().getProperty(label);
        if (prop == null) {
            throw new VersionException(JcrI18n.invalidVersionLabel.text(new Object[]{label, this.getPath()}));
        }
        AbstractJcrNode version = this.session().getNodeByUUID(prop.getString());
        assert (version != null);
        return (JcrVersionNode)version;
    }

    public String[] getVersionLabels() throws RepositoryException {
        PropertyIterator iter = this.versionLabels().getProperties();
        String[] labels = new String[(int)iter.getSize()];
        int i = 0;
        while (iter.hasNext()) {
            labels[i] = iter.nextProperty().getName();
            ++i;
        }
        return labels;
    }

    private Collection<String> versionLabelsFor(Version version) throws RepositoryException {
        if (!version.getParent().equals(this)) {
            throw new VersionException(JcrI18n.invalidVersion.text(new Object[]{version.getPath(), this.getPath()}));
        }
        String versionUuid = version.getUUID();
        PropertyIterator iter = this.versionLabels().getProperties();
        LinkedList<String> labels = new LinkedList<String>();
        int i = 0;
        while (iter.hasNext()) {
            Property prop = iter.nextProperty();
            if (versionUuid.equals(prop.getString())) {
                labels.add(prop.getName());
            }
            ++i;
        }
        return labels;
    }

    public String[] getVersionLabels(Version version) throws RepositoryException {
        return this.versionLabelsFor(version).toArray(EMPTY_STRING_ARRAY);
    }

    public String getVersionableUUID() throws RepositoryException {
        return this.getProperty(JcrLexicon.VERSIONABLE_UUID).getString();
    }

    public boolean hasVersionLabel(String label) throws RepositoryException {
        return this.versionLabels().hasProperty(label);
    }

    public boolean hasVersionLabel(Version version, String label) throws RepositoryException {
        Collection<String> labels = this.versionLabelsFor(version);
        return labels.contains(label);
    }

    public void removeVersion(String versionName) throws ReferentialIntegrityException, AccessDeniedException, UnsupportedRepositoryOperationException, VersionException, RepositoryException {
        JcrVersionNode version = this.getVersion(versionName);
        Path versionHistoryPath = version.path().getParent();
        PropertyIterator iter = version.getReferences();
        while (iter.hasNext()) {
            AbstractJcrProperty prop = (AbstractJcrProperty)iter.next();
            Path nodePath = prop.path().getParent();
            if (nodePath.isRoot()) {
                throw new ReferentialIntegrityException(JcrI18n.cannotRemoveVersion.text(new Object[]{prop.getPath()}));
            }
            if (versionHistoryPath.equals(nodePath.getParent())) continue;
            throw new ReferentialIntegrityException(JcrI18n.cannotRemoveVersion.text(new Object[]{prop.getPath()}));
        }
        String versionUuid = version.getUUID();
        AbstractJcrProperty predecessors = version.getProperty(JcrLexicon.PREDECESSORS);
        Value[] values = predecessors.getValues();
        for (int i = 0; i < values.length; ++i) {
            AbstractJcrNode predecessor = this.session().getNodeByUUID(values[i].getString());
            Value[] nodeSuccessors = predecessor.getProperty(JcrLexicon.SUCCESSORS).getValues();
            Value[] newNodeSuccessors = new Value[nodeSuccessors.length - 1];
            int idx = 0;
            for (int j = 0; j < nodeSuccessors.length; ++j) {
                if (versionUuid.equals(nodeSuccessors[j].getString())) continue;
                newNodeSuccessors[idx++] = nodeSuccessors[j];
            }
            predecessor.editor().setProperty(JcrLexicon.SUCCESSORS, newNodeSuccessors, 9, false);
        }
        AbstractJcrProperty successors = version.getProperty(JcrLexicon.SUCCESSORS);
        values = successors.getValues();
        for (int i = 0; i < values.length; ++i) {
            AbstractJcrNode successor = this.session().getNodeByUUID(values[i].getString());
            Value[] nodePredecessors = successor.getProperty(JcrLexicon.PREDECESSORS).getValues();
            Value[] newNodePredecessors = new Value[nodePredecessors.length - 1];
            int idx = 0;
            for (int j = 0; j < nodePredecessors.length; ++j) {
                if (versionUuid.equals(nodePredecessors[j].getString())) continue;
                newNodePredecessors[idx++] = nodePredecessors[j];
            }
            successor.editor().setProperty(JcrLexicon.PREDECESSORS, newNodePredecessors, 9, false);
        }
        this.session().recordRemoval(version.location);
        version.editor().destroy();
    }

    public void addVersionLabel(String versionName, String label, boolean moveLabel) throws VersionException, RepositoryException {
        AbstractJcrNode versionLabels = this.versionLabels();
        JcrVersionNode version = this.getVersion(versionName);
        try {
            versionLabels.getProperty(label);
            if (!moveLabel) {
                throw new VersionException(JcrI18n.versionLabelAlreadyExists.text(new Object[]{label}));
            }
        }
        catch (javax.jcr.PathNotFoundException pnfe) {
            // empty catch block
        }
        JcrGraph graph = this.cache.session().repository().createSystemGraph(this.context());
        Reference ref = (Reference)this.context().getValueFactories().getReferenceFactory().create(version.getUUID());
        ((Graph.SetValuesTo)graph.set(label).on(versionLabels.location)).to(ref);
        versionLabels.refresh(false);
    }

    public void removeVersionLabel(String label) throws VersionException, RepositoryException {
        AbstractJcrNode versionLabels = this.versionLabels();
        try {
            versionLabels.getProperty(label);
        }
        catch (javax.jcr.PathNotFoundException pnfe) {
            throw new VersionException(JcrI18n.invalidVersionLabel.text(new Object[]{label, this.getPath()}));
        }
        JcrGraph graph = this.cache.session().repository().createSystemGraph(this.context());
        ((Graph.Conjunction)graph.remove(new String[]{label}).on(versionLabels.location)).and();
        versionLabels.refresh(false);
    }

    public NodeIterator getAllFrozenNodes() throws RepositoryException {
        return new FrozenNodeIterator(this.getAllVersions());
    }

    public NodeIterator getAllLinearFrozenNodes() throws RepositoryException {
        return new FrozenNodeIterator(this.getAllLinearVersions());
    }

    public VersionIterator getAllLinearVersions() throws RepositoryException {
        AbstractJcrNode existingNode = this.session().getNodeByIdentifier(this.getVersionableIdentifier());
        if (existingNode == null) {
            return this.getAllVersions();
        }
        assert (existingNode.isNodeType(JcrMixLexicon.VERSIONABLE));
        LinkedList<JcrVersionNode> versions = new LinkedList<JcrVersionNode>();
        for (JcrVersionNode baseVersion = existingNode.getBaseVersion(); baseVersion != null; baseVersion = baseVersion.getLinearPredecessor()) {
            versions.addFirst(baseVersion);
        }
        return new LinearVersionIterator(versions, versions.size());
    }

    public String getVersionableIdentifier() throws RepositoryException {
        return this.getVersionableUUID();
    }

    class FrozenNodeIterator
    implements NodeIterator {
        private final VersionIterator versions;

        FrozenNodeIterator(VersionIterator versionIter) {
            this.versions = versionIter;
        }

        public boolean hasNext() {
            return this.versions.hasNext();
        }

        public Object next() {
            return this.nextNode();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Node nextNode() {
            try {
                return this.versions.nextVersion().getFrozenNode();
            }
            catch (RepositoryException re) {
                throw new IllegalStateException(re);
            }
        }

        public long getPosition() {
            return this.versions.getPosition();
        }

        public long getSize() {
            return this.versions.getSize();
        }

        public void skip(long skipNum) {
            this.versions.skip(skipNum);
        }
    }

    class LinearVersionIterator
    implements VersionIterator {
        private final Iterator<? extends Version> versions;
        private final int size;
        private int pos;

        protected LinearVersionIterator(Iterable<? extends Version> versions, int size) {
            this.versions = versions.iterator();
            this.size = size;
            this.pos = 0;
        }

        public long getPosition() {
            return this.pos;
        }

        public long getSize() {
            return this.size;
        }

        public void skip(long skipNum) {
            while (skipNum-- > 0L && this.versions.hasNext()) {
                this.versions.next();
                ++this.pos;
            }
        }

        public Version nextVersion() {
            return this.versions.next();
        }

        public boolean hasNext() {
            return this.versions.hasNext();
        }

        public Object next() {
            return this.nextVersion();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    class JcrVersionIterator
    implements VersionIterator {
        private final NodeIterator nodeIterator;
        private Version next;
        private int position = 0;

        public JcrVersionIterator(NodeIterator nodeIterator) {
            this.nodeIterator = nodeIterator;
        }

        public Version nextVersion() {
            Version next = this.next;
            if (next != null) {
                this.next = null;
                return next;
            }
            next = this.nextVersionIfPossible();
            if (next == null) {
                throw new NoSuchElementException();
            }
            ++this.position;
            return next;
        }

        private JcrVersionNode nextVersionIfPossible() {
            while (this.nodeIterator.hasNext()) {
                Name nodeName;
                AbstractJcrNode node = (AbstractJcrNode)this.nodeIterator.nextNode();
                try {
                    nodeName = node.segment().getName();
                }
                catch (RepositoryException re) {
                    throw new IllegalStateException(re);
                }
                if (JcrLexicon.VERSION_LABELS.equals(nodeName)) continue;
                return (JcrVersionNode)node;
            }
            return null;
        }

        public long getPosition() {
            return this.position;
        }

        public long getSize() {
            return this.nodeIterator.getSize() - 1L;
        }

        public void skip(long count) {
            while (count-- > 0L) {
                this.nextVersion();
            }
        }

        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            this.next = this.nextVersionIfPossible();
            return this.next != null;
        }

        public Object next() {
            return this.nextVersion();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

