/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PathNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import net.jcip.annotations.NotThreadSafe;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.collection.Collections;
import org.modeshape.common.text.TextDecoder;
import org.modeshape.common.text.XmlNameEncoder;
import org.modeshape.common.util.Base64;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;
import org.modeshape.graph.property.NamespaceRegistry;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.AbstractJcrProperty;
import org.modeshape.jcr.JcrDocumentViewExporter;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrMixLexicon;
import org.modeshape.jcr.JcrNode;
import org.modeshape.jcr.JcrNodeType;
import org.modeshape.jcr.JcrNodeTypeManager;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrRootNode;
import org.modeshape.jcr.JcrSession;
import org.modeshape.jcr.JcrSvLexicon;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.JcrVersionHistoryNode;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.ModeShapeLexicon;
import org.modeshape.jcr.SessionCache;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@NotThreadSafe
class JcrContentHandler
extends DefaultHandler {
    protected static final TextDecoder SYSTEM_VIEW_NAME_DECODER = new XmlNameEncoder();
    protected static final TextDecoder DOCUMENT_VIEW_NAME_DECODER = new JcrDocumentViewExporter.JcrDocumentViewPropertyEncoder();
    private static final String ALT_XML_SCHEMA_NAMESPACE_PREFIX = "xsd";
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final ValueFactory<String> stringFactory;
    private final NamespaceRegistry namespaces;
    private final javax.jcr.ValueFactory jcrValueFactory;
    private final JcrNodeTypeManager nodeTypes;
    private final javax.jcr.NamespaceRegistry jcrNamespaceRegistry;
    private final SaveMode saveMode;
    protected final int uuidBehavior;
    protected final boolean retentionInfoRetained;
    protected final boolean lifecycleInfoRetained;
    protected final String primaryTypeName;
    protected final String mixinTypesName;
    protected final String uuidName;
    private AbstractJcrNode currentNode;
    private ContentHandler delegate;
    protected final List<AbstractJcrProperty> refPropsRequiringConstraintValidation = new LinkedList<AbstractJcrProperty>();
    protected final List<AbstractJcrNode> nodesForPostProcessing = new LinkedList<AbstractJcrNode>();
    private SessionCache cache;
    protected static final Set<Name> PROPERTIES_FOR_POST_PROCESSING = Collections.unmodifiableSet((Object[])new Name[]{JcrLexicon.LOCK_IS_DEEP, JcrLexicon.LOCK_OWNER, JcrLexicon.BASE_VERSION, JcrLexicon.LIFECYCLE_POLICY, JcrLexicon.CURRENT_LIFECYCLE_STATE, JcrLexicon.HOLD, JcrLexicon.IS_DEEP, JcrLexicon.RETENTION_POLICY});

    JcrContentHandler(JcrSession session, Path parentPath, int uuidBehavior, SaveMode saveMode, boolean retentionInfoRetained, boolean lifecycleInfoRetained) throws PathNotFoundException, RepositoryException {
        assert (session != null);
        assert (parentPath != null);
        assert (uuidBehavior == 0 || uuidBehavior == 1 || uuidBehavior == 2 || uuidBehavior == 3);
        ExecutionContext context = session.getExecutionContext();
        this.namespaces = context.getNamespaceRegistry();
        this.nameFactory = context.getValueFactories().getNameFactory();
        this.pathFactory = context.getValueFactories().getPathFactory();
        this.stringFactory = context.getValueFactories().getStringFactory();
        this.uuidBehavior = uuidBehavior;
        this.retentionInfoRetained = retentionInfoRetained;
        this.lifecycleInfoRetained = lifecycleInfoRetained;
        this.saveMode = saveMode;
        switch (this.saveMode) {
            case SESSION: {
                this.cache = session.cache();
                break;
            }
            case WORKSPACE: {
                this.cache = new SessionCache(session);
            }
        }
        assert (this.cache != null);
        try {
            this.currentNode = this.cache.findJcrNode(null, parentPath);
        }
        catch (ItemNotFoundException e) {
            throw new PathNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        if (!this.currentNode.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{this.currentNode.getPath()}));
        }
        this.jcrValueFactory = session.getValueFactory();
        this.nodeTypes = session.nodeTypeManager();
        this.jcrNamespaceRegistry = session.workspace().getNamespaceRegistry();
        this.primaryTypeName = JcrLexicon.PRIMARY_TYPE.getString(this.namespaces);
        this.mixinTypesName = JcrLexicon.MIXIN_TYPES.getString(this.namespaces);
        this.uuidName = JcrLexicon.UUID.getString(this.namespaces);
    }

    protected final NamespaceRegistry namespaces() {
        return this.namespaces;
    }

    protected final JcrNodeTypeManager nodeTypes() {
        return this.nodeTypes;
    }

    protected final JcrNodeType nodeTypeFor(String name) {
        return this.nodeTypes.getNodeType(this.nameFor(name));
    }

    protected final String stringFor(Object name) {
        return (String)this.stringFactory.create(name);
    }

    protected final Name nameFor(String name) {
        return (Name)this.nameFactory.create(name);
    }

    protected final Path pathFor(Name ... names) {
        return this.pathFor(this.pathFactory.createRootPath(), names);
    }

    protected final Path pathFor(Path parentPath, Name ... names) {
        return this.pathFactory.create(parentPath, names);
    }

    protected final Value valueFor(String value, int type) throws ValueFormatException {
        return this.jcrValueFactory.createValue(value, type);
    }

    protected final Value valueFor(InputStream stream) throws RepositoryException {
        return this.jcrValueFactory.createValue(this.jcrValueFactory.createBinary(stream));
    }

    protected final SessionCache cache() {
        return this.cache;
    }

    protected void postProcessNodes() throws SAXException {
        JcrVersionManager versions = null;
        try {
            for (AbstractJcrNode node : this.nodesForPostProcessing) {
                SessionCache.NodeEditor editor = null;
                if (node.isNodeType(JcrMixLexicon.VERSIONABLE)) {
                    boolean validHistory = this.isValidReference(node, JcrLexicon.VERSION_HISTORY, false);
                    if (validHistory) {
                        boolean validBaseVersion = this.isValidReference(node, JcrLexicon.BASE_VERSION, false);
                        boolean validPredecessors = this.isValidReference(node, JcrLexicon.PREDECESSORS, false);
                        if (!validBaseVersion || !validPredecessors) {
                            if (versions == null) {
                                versions = node.versionManager();
                            }
                            JcrVersionHistoryNode history = versions.getVersionHistory(node);
                            UUID baseVersion = history.getRootVersion().uuid();
                            JcrValue newValue = node.valueFrom(9, baseVersion.toString());
                            JcrValue[] newValues = new JcrValue[]{newValue};
                            editor = node.editor();
                            editor.setProperty(JcrLexicon.BASE_VERSION, newValue, true, false);
                            editor.setProperty(JcrLexicon.PREDECESSORS, (Value[])newValues, 9, false);
                        }
                    } else {
                        editor = node.editor();
                        editor.removeProperty(JcrLexicon.IS_CHECKED_OUT);
                        editor.removeProperty(JcrLexicon.VERSION_HISTORY);
                        editor.removeProperty(JcrLexicon.BASE_VERSION);
                        editor.removeProperty(JcrLexicon.PREDECESSORS);
                        editor.removeProperty(JcrLexicon.MERGE_FAILED);
                        editor.removeProperty(JcrLexicon.ACTIVITY);
                        editor.removeProperty(JcrLexicon.CONFIGURATION);
                    }
                }
                if (node.isNodeType(JcrMixLexicon.LOCKABLE) && node.isLocked()) {
                    node.unlock();
                }
                if (node.isNodeType(JcrMixLexicon.LIFECYCLE) && this.lifecycleInfoRetained && !this.isValidReference(node, JcrLexicon.LIFECYCLE_POLICY, false)) {
                    if (editor == null) {
                        editor = node.editor();
                    }
                    assert (editor != null);
                    editor.removeProperty(JcrLexicon.LIFECYCLE_POLICY);
                    editor.removeProperty(JcrLexicon.CURRENT_LIFECYCLE_STATE);
                }
                if (!node.isNodeType(JcrMixLexicon.MANAGED_RETENTION) || !this.retentionInfoRetained || this.isValidReference(node, JcrLexicon.RETENTION_POLICY, false)) continue;
                if (editor == null) {
                    editor = node.editor();
                }
                assert (editor != null);
                editor.removeProperty(JcrLexicon.HOLD);
                editor.removeProperty(JcrLexicon.IS_DEEP);
                editor.removeProperty(JcrLexicon.RETENTION_POLICY);
            }
        }
        catch (RepositoryException e) {
            throw new EnclosingSAXException((Exception)((Object)e));
        }
    }

    protected boolean isValidReference(AbstractJcrNode node, Name propertyName, boolean returnValueIfNoProperty) throws RepositoryException {
        AbstractJcrProperty property = node.getProperty(propertyName);
        return property == null ? returnValueIfNoProperty : this.isValidReference(property);
    }

    protected boolean isValidReference(AbstractJcrProperty property) throws RepositoryException {
        JcrPropertyDefinition defn = property.getDefinition();
        if (defn == null) {
            return false;
        }
        if (property.isMultiple()) {
            for (Value value : property.getValues()) {
                if (defn.canCastToTypeAndSatisfyConstraints(value)) continue;
                return false;
            }
            return true;
        }
        return defn.canCastToTypeAndSatisfyConstraints(property.getValue());
    }

    protected void validateReferenceConstraints() throws SAXException {
        if (this.refPropsRequiringConstraintValidation.isEmpty()) {
            return;
        }
        try {
            for (AbstractJcrProperty refProp : this.refPropsRequiringConstraintValidation) {
                if (refProp.propertyInfo() == null || this.isValidReference(refProp)) continue;
                JcrPropertyDefinition defn = refProp.getDefinition();
                String name = this.stringFor(refProp.name());
                throw new ConstraintViolationException(JcrI18n.constraintViolatedOnReference.text(new Object[]{name, defn}));
            }
        }
        catch (RepositoryException e) {
            throw new EnclosingSAXException((Exception)((Object)e));
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        assert (this.delegate != null);
        this.delegate.characters(ch, start, length);
    }

    @Override
    public void endDocument() throws SAXException {
        this.postProcessNodes();
        this.validateReferenceConstraints();
        if (this.saveMode == SaveMode.WORKSPACE) {
            try {
                this.cache.save();
            }
            catch (RepositoryException e) {
                throw new EnclosingSAXException((Exception)((Object)e));
            }
        }
        super.endDocument();
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        assert (this.delegate != null);
        this.delegate.endElement(uri, localName, name);
    }

    @Override
    public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
        this.checkDelegate(uri);
        assert (this.delegate != null);
        this.delegate.startElement(uri, localName, name, atts);
    }

    private void checkDelegate(String namespaceUri) {
        if (this.delegate != null) {
            return;
        }
        this.delegate = "http://www.jcp.org/jcr/sv/1.0".equals(namespaceUri) ? new SystemViewContentHandler(this.currentNode) : new DocumentViewContentHandler(this.currentNode);
    }

    protected static byte[] decodeBase64(String value) throws IOException {
        try {
            return Base64.decode((byte[])value.getBytes("UTF-8"));
        }
        catch (IOException e) {
            return Base64.decode((String)value, (int)16);
        }
    }

    protected static String decodeBase64AsString(String value) throws IOException {
        byte[] decoded = JcrContentHandler.decodeBase64(value);
        return new String(decoded, "UTF-8");
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        try {
            String existingUri;
            if (ALT_XML_SCHEMA_NAMESPACE_PREFIX.equals(prefix) && uri.equals("http://www.w3.org/2001/XMLSchema")) {
                prefix = "xs";
            }
            if ((existingUri = this.namespaces.getNamespaceForPrefix(prefix)) != null) {
                if (existingUri.equals(uri)) {
                    return;
                }
                throw new RepositoryException("Prefix " + prefix + " is already permanently mapped");
            }
            this.jcrNamespaceRegistry.registerNamespace(prefix, uri);
        }
        catch (RepositoryException re) {
            throw new EnclosingSAXException((Exception)((Object)re));
        }
    }

    private class DocumentViewContentHandler
    extends DefaultHandler {
        private NodeHandler current;
        private final NodeHandlerFactory nodeHandlerFactory;

        DocumentViewContentHandler(AbstractJcrNode currentNode) {
            this.current = new ExistingNodeHandler(currentNode, null);
            this.nodeHandlerFactory = new StandardNodeHandlerFactory();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            String nodeName = DOCUMENT_VIEW_NAME_DECODER.decode(name);
            this.current = this.nodeHandlerFactory.createFor(JcrContentHandler.this.nameFor(nodeName), this.current, JcrContentHandler.this.uuidBehavior);
            for (int i = 0; i < atts.getLength(); ++i) {
                String value = atts.getValue(i);
                String propertyName = DOCUMENT_VIEW_NAME_DECODER.decode(atts.getQName(i));
                this.current.addPropertyValue(JcrContentHandler.this.nameFor(propertyName), value, 1, null);
            }
            this.current.finish();
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            this.current.finish();
            this.current = this.current.parentHandler();
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            String value = new String(ch, start, length);
            this.current = this.nodeHandlerFactory.createFor(JcrLexicon.XMLTEXT, this.current, JcrContentHandler.this.uuidBehavior);
            this.current.addPropertyValue(JcrLexicon.PRIMARY_TYPE, JcrContentHandler.this.stringFor(JcrNtLexicon.UNSTRUCTURED), 7, DOCUMENT_VIEW_NAME_DECODER);
            this.current.addPropertyValue(JcrLexicon.XMLCHARACTERS, value, 1, null);
            this.current.finish();
            this.current = this.current.parentHandler();
        }
    }

    private class SystemViewContentHandler
    extends DefaultHandler {
        private final String svNameName;
        private final String svTypeName;
        private NodeHandler current;
        private final NodeHandlerFactory nodeHandlerFactory;
        private String currentPropertyName;
        private int currentPropertyType;
        private boolean currentPropertyValueIsBinary;
        private StringBuilder currentPropertyValue;

        SystemViewContentHandler(AbstractJcrNode parent) {
            this.svNameName = JcrSvLexicon.NAME.getString(JcrContentHandler.this.namespaces());
            this.svTypeName = JcrSvLexicon.TYPE.getString(JcrContentHandler.this.namespaces());
            this.current = new ExistingNodeHandler(parent, null);
            this.nodeHandlerFactory = new StandardNodeHandlerFactory();
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes atts) throws SAXException {
            this.currentPropertyValue = new StringBuilder();
            if ("node".equals(localName)) {
                this.current.finish();
                String nodeName = atts.getValue(SYSTEM_VIEW_NAME_DECODER.decode(this.svNameName));
                this.current = this.nodeHandlerFactory.createFor(JcrContentHandler.this.nameFor(nodeName), this.current, JcrContentHandler.this.uuidBehavior);
            } else if ("property".equals(localName)) {
                this.currentPropertyName = atts.getValue(SYSTEM_VIEW_NAME_DECODER.decode(this.svNameName));
                this.currentPropertyType = PropertyType.valueFromName((String)atts.getValue(this.svTypeName));
            } else if ("value".equals(localName)) {
                String xsiType = atts.getValue("http://www.w3.org/2001/XMLSchema-instance", "type");
                this.currentPropertyValueIsBinary = "xs:base64Binary".equals(xsiType);
            } else if (!"value".equals(localName)) {
                throw new IllegalStateException("Unexpected element '" + name + "' in system view");
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) {
            this.currentPropertyValue.append(ch, start, length);
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            if ("node".equals(localName)) {
                this.current.finish();
                this.current = this.current.parentHandler();
            } else if ("value".equals(localName)) {
                String currentPropertyString = this.currentPropertyValue.toString();
                if (this.currentPropertyValueIsBinary) {
                    try {
                        currentPropertyString = JcrContentHandler.decodeBase64AsString(currentPropertyString);
                    }
                    catch (IOException ioe) {
                        throw new EnclosingSAXException((Exception)ioe);
                    }
                }
                this.current.addPropertyValue(JcrContentHandler.this.nameFor(this.currentPropertyName), currentPropertyString, this.currentPropertyType, SYSTEM_VIEW_NAME_DECODER);
            } else if (!"property".equals(localName)) {
                throw new IllegalStateException("Unexpected element '" + name + "' in system view");
            }
            this.currentPropertyValue = new StringBuilder();
        }
    }

    protected class StandardNodeHandlerFactory
    implements NodeHandlerFactory {
        protected StandardNodeHandlerFactory() {
        }

        @Override
        public NodeHandler createFor(Name name, NodeHandler parentHandler, int uuidBehavior) throws SAXException {
            if (parentHandler instanceof IgnoreBranchHandler) {
                return new IgnoreBranchHandler(parentHandler);
            }
            if (JcrLexicon.ROOT.equals(name)) {
                try {
                    JcrRootNode rootNode = JcrContentHandler.this.cache().findJcrRootNode();
                    return new JcrRootHandler(rootNode);
                }
                catch (RepositoryException re) {
                    throw new EnclosingSAXException((Exception)((Object)re));
                }
            }
            if (JcrLexicon.SYSTEM.equals(name)) {
                return new JcrSystemHandler(parentHandler);
            }
            return new BasicNodeHandler(name, parentHandler, uuidBehavior);
        }
    }

    protected static interface NodeHandlerFactory {
        public NodeHandler createFor(Name var1, NodeHandler var2, int var3) throws SAXException;
    }

    protected class JcrSystemHandler
    extends IgnoreBranchHandler {
        protected JcrSystemHandler(NodeHandler parentHandler) {
            super(parentHandler);
        }
    }

    protected class IgnoreBranchHandler
    extends NodeHandler {
        private NodeHandler parentHandler;

        protected IgnoreBranchHandler(NodeHandler parentHandler) {
            this.parentHandler = parentHandler;
        }

        @Override
        public NodeHandler parentHandler() {
            return this.parentHandler;
        }
    }

    protected class JcrRootHandler
    extends ExistingNodeHandler {
        protected JcrRootHandler(AbstractJcrNode root) {
            super(root, null);
        }

        @Override
        public void addPropertyValue(Name propertyName, String value, int propertyType, TextDecoder decoder) {
        }
    }

    protected class ExistingNodeHandler
    extends NodeHandler {
        private final AbstractJcrNode node;
        private final NodeHandler parentHandler;

        protected ExistingNodeHandler(AbstractJcrNode node, NodeHandler parentHandler) {
            this.node = node;
            this.parentHandler = parentHandler;
        }

        @Override
        public AbstractJcrNode node() {
            return this.node;
        }

        @Override
        public NodeHandler parentHandler() {
            return this.parentHandler;
        }

        @Override
        public void addPropertyValue(Name propertyName, String value, int propertyType, TextDecoder decoder) {
            throw new UnsupportedOperationException();
        }
    }

    protected class BasicNodeHandler
    extends NodeHandler {
        private final Map<Name, List<Value>> properties;
        private final Name nodeName;
        private NodeHandler parentHandler;
        private AbstractJcrNode node;
        private final int uuidBehavior;
        private boolean postProcessed;

        protected BasicNodeHandler(Name name, NodeHandler parentHandler, int uuidBehavior) {
            this.postProcessed = false;
            this.nodeName = name;
            this.parentHandler = parentHandler;
            this.properties = new HashMap<Name, List<Value>>();
            this.uuidBehavior = uuidBehavior;
        }

        @Override
        public void finish() throws SAXException {
            this.node();
        }

        @Override
        protected String name() {
            return JcrContentHandler.this.stringFor(this.nodeName);
        }

        @Override
        public AbstractJcrNode node() throws SAXException {
            if (this.node == null) {
                this.create();
            }
            assert (this.node != null);
            return this.node;
        }

        @Override
        public NodeHandler parentHandler() {
            return this.parentHandler;
        }

        @Override
        public void addPropertyValue(Name name, String value, int propertyType, TextDecoder decoder) throws EnclosingSAXException {
            try {
                if (this.node != null) {
                    if (JcrLexicon.PRIMARY_TYPE.equals(name)) {
                        return;
                    }
                    if (JcrLexicon.MIXIN_TYPES.equals(name)) {
                        return;
                    }
                    if (JcrLexicon.UUID.equals(name)) {
                        return;
                    }
                    this.node.editor().setProperty(name, (JcrValue)JcrContentHandler.this.valueFor(value, propertyType));
                } else {
                    List<Value> values = this.properties.get(name);
                    if (values == null) {
                        values = new ArrayList<Value>();
                        this.properties.put(name, values);
                    }
                    if (propertyType == 2) {
                        byte[] binary = JcrContentHandler.decodeBase64(value);
                        ByteArrayInputStream is = new ByteArrayInputStream(binary);
                        values.add(JcrContentHandler.this.valueFor(is));
                    } else {
                        if (decoder != null) {
                            value = decoder.decode(value);
                        }
                        if (value != null && propertyType == 1) {
                            values.add(JcrContentHandler.this.valueFor(value, propertyType));
                        } else if (value != null && value.length() > 0) {
                            values.add(JcrContentHandler.this.valueFor(value, propertyType));
                        }
                    }
                }
                if (!this.postProcessed && PROPERTIES_FOR_POST_PROCESSING.contains(name)) {
                    this.postProcessed = true;
                }
            }
            catch (IOException ioe) {
                throw new EnclosingSAXException((Exception)ioe);
            }
            catch (RepositoryException re) {
                throw new EnclosingSAXException((Exception)((Object)re));
            }
        }

        protected void create() throws SAXException {
            try {
                AbstractJcrNode child;
                AbstractJcrNode existingNode;
                boolean nodeAlreadyExists;
                AbstractJcrNode parent = this.parentHandler.node();
                assert (parent != null);
                UUID uuid = null;
                List<Value> rawUuid = this.properties.get(JcrLexicon.UUID);
                if (rawUuid != null) {
                    assert (rawUuid.size() == 1);
                    uuid = UUID.fromString(rawUuid.get(0).getString());
                    try {
                        AbstractJcrNode existingNodeWithUuid = JcrContentHandler.this.cache().findJcrNode(Location.create((UUID)uuid));
                        switch (this.uuidBehavior) {
                            case 2: {
                                parent = existingNodeWithUuid.getParent();
                                existingNodeWithUuid.editor().destroy();
                                break;
                            }
                            case 0: {
                                uuid = UUID.randomUUID();
                                break;
                            }
                            case 1: {
                                if (existingNodeWithUuid.path().isAtOrAbove(parent.path())) {
                                    throw new ConstraintViolationException(JcrI18n.cannotRemoveParentNodeOfTarget.text(new Object[]{existingNodeWithUuid.getPath(), uuid, parent.getPath()}));
                                }
                                existingNodeWithUuid.editor().destroy();
                                break;
                            }
                            case 3: {
                                throw new ItemExistsException(JcrI18n.itemAlreadyExistsWithUuid.text(new Object[]{uuid, JcrContentHandler.this.cache().session().workspace().getName(), existingNodeWithUuid.getPath()}));
                            }
                        }
                    }
                    catch (ItemNotFoundException e) {
                        // empty catch block
                    }
                }
                boolean bl = nodeAlreadyExists = (existingNode = parent.getNode(this.nodeName)) != null && existingNode.getDefinition().isAutoCreated();
                if (!nodeAlreadyExists) {
                    List<Value> primaryTypeValueList = this.properties.get(JcrLexicon.PRIMARY_TYPE);
                    String typeName = primaryTypeValueList != null ? primaryTypeValueList.get(0).getString() : null;
                    Name primaryTypeName = JcrContentHandler.this.nameFor(typeName);
                    if (JcrNtLexicon.SHARE.equals(primaryTypeName) && uuid != null) {
                        JcrNode child2 = parent.editor().createChild(this.nodeName, UUID.randomUUID(), ModeShapeLexicon.SHARE);
                        SessionCache.NodeEditor newNodeEditor = child2.editor();
                        JcrValue uuidValue = (JcrValue)JcrContentHandler.this.valueFor(uuid.toString(), 1);
                        newNodeEditor.setProperty(ModeShapeLexicon.SHARED_UUID, uuidValue, false, true);
                        this.node = child2;
                        return;
                    }
                    child = parent.editor().createChild(this.nodeName, uuid, primaryTypeName);
                } else {
                    child = existingNode;
                }
                SessionCache.NodeEditor newNodeEditor = child.editor();
                List<Value> mixinTypeValueList = this.properties.get(JcrLexicon.MIXIN_TYPES);
                if (mixinTypeValueList != null) {
                    for (Value value : mixinTypeValueList) {
                        JcrNodeType mixinType = JcrContentHandler.this.nodeTypeFor(value.getString());
                        newNodeEditor.addMixin(mixinType);
                    }
                }
                boolean skipProtected = false;
                for (Map.Entry<Name, List<Value>> entry : this.properties.entrySet()) {
                    Name propertyName = entry.getKey();
                    if (JcrLexicon.PRIMARY_TYPE.equals(propertyName) || JcrLexicon.MIXIN_TYPES.equals(propertyName) || JcrLexicon.UUID.equals(propertyName)) continue;
                    List<Value> values = entry.getValue();
                    if (values.size() == 1) {
                        AbstractJcrProperty prop = newNodeEditor.setProperty(propertyName, (JcrValue)values.get(0), skipProtected, false);
                        if (prop.getType() != 9 || prop.getDefinition().getValueConstraints().length == 0) continue;
                        JcrContentHandler.this.refPropsRequiringConstraintValidation.add(prop);
                        continue;
                    }
                    newNodeEditor.setProperty(propertyName, values.toArray(new Value[values.size()]), 0, skipProtected);
                }
                this.node = child;
                if (this.postProcessed) {
                    JcrContentHandler.this.nodesForPostProcessing.add(this.node);
                }
            }
            catch (RepositoryException re) {
                throw new EnclosingSAXException((Exception)((Object)re));
            }
        }
    }

    protected abstract class NodeHandler {
        protected NodeHandler() {
        }

        public void finish() throws SAXException {
        }

        public AbstractJcrNode node() throws SAXException {
            return null;
        }

        public NodeHandler parentHandler() {
            return null;
        }

        public void addPropertyValue(Name name, String value, int propertyType, TextDecoder decoder) throws EnclosingSAXException {
        }

        protected String name() {
            try {
                Path path = this.node().path();
                return path.isRoot() ? "" : JcrContentHandler.this.stringFor(path.getLastSegment());
            }
            catch (Exception e) {
                throw new SystemFailureException((Throwable)e);
            }
        }

        public String toString() {
            NodeHandler parent = this.parentHandler();
            if (parent != null) {
                return parent.toString() + "/" + this.name();
            }
            try {
                return this.node().getPath();
            }
            catch (Throwable e) {
                try {
                    return this.node().toString();
                }
                catch (SAXException e2) {
                    throw new SystemFailureException((Throwable)e2);
                }
            }
        }
    }

    class EnclosingSAXException
    extends SAXException {
        private static final long serialVersionUID = -1044992767566435542L;

        EnclosingSAXException(Exception e) {
            super(e);
        }
    }

    static enum SaveMode {
        WORKSPACE,
        SESSION;

    }
}

