/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.UUID;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.Location;
import org.modeshape.graph.NodeConflictBehavior;
import org.modeshape.graph.property.DateTime;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.PathNotFoundException;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyFactory;
import org.modeshape.graph.property.UuidFactory;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.request.CreateNodeRequest;
import org.modeshape.graph.request.ReadAllChildrenRequest;
import org.modeshape.graph.request.ReadNodeRequest;
import org.modeshape.graph.request.ReadPropertyRequest;
import org.modeshape.graph.request.RequestBuilder;
import org.modeshape.graph.request.VerifyNodeExistsRequest;
import org.modeshape.graph.request.function.Function;
import org.modeshape.graph.request.function.FunctionContext;
import org.modeshape.jcr.JcrLexicon;
import org.modeshape.jcr.JcrNtLexicon;
import org.modeshape.jcr.JcrVersionManager;
import org.modeshape.jcr.ModeShapeLexicon;

public class SystemFunctions {
    public static final Function INITIALIZE_VERSION_HISTORY = new InitializeVersionHistoryFunction();
    public static final Function CREATE_VERSION_NODE = new CreateVersionNodeFunction();

    @Immutable
    public static class CreateVersionNodeFunction
    extends VersionHistoryFunction {
        private static final long serialVersionUID = 1L;
        public static final String VERSION_NAME = "versionName";
        public static final String VERSION_HISTORY_PATH = "versionHistoryPath";
        public static final String VERSIONED_NODE_UUID = "versionedNodeUuid";
        public static final String PRIMARY_TYPE_NAME = "primaryTypeName";
        public static final String MIXIN_TYPE_NAME_LIST = "mixinTypeNameList";
        public static final String PREDECESSOR_PROPERTY = "predecessorProperty";
        public static final String VERSION_PROPERTY_LIST = "versionPropertyList";
        public static final String VERSION_HISTORY_UUID = "versionHistoryUuid";
        public static final String VERSION_UUID = "versionUuid";
        public static final String VERSION_PATH = "versionPath";
        public static final String PATH_OF_HIGHEST_MODIFIED_NODE = "pathOfHighestModifiedNode";

        public void run(FunctionContext context) {
            Location versionHistoryLocation;
            Path versionHistoryPath = (Path)context.input(VERSION_HISTORY_PATH, Path.class);
            Name versionNodeName = (Name)context.input(VERSION_NAME, Name.class);
            UUID versionedNodeUuid = (UUID)context.input(VERSIONED_NODE_UUID, UUID.class);
            Name primaryType = (Name)context.input(PRIMARY_TYPE_NAME, Name.class);
            List mixinTypes = (List)context.input(MIXIN_TYPE_NAME_LIST);
            Property predecessors = (Property)context.input(PREDECESSOR_PROPERTY);
            List versionPropertyList = (List)context.input(VERSION_PROPERTY_LIST);
            assert (versionHistoryPath != null);
            assert (versionedNodeUuid != null);
            assert (primaryType != null);
            assert (predecessors != null);
            assert (!predecessors.isEmpty());
            RequestBuilder builder = context.builder();
            String workspace = context.workspace();
            PropertyFactory props = context.getExecutionContext().getPropertyFactory();
            DateTime now = context.getNowInUtc();
            UUID versionUuid = UUID.randomUUID();
            int numVersionProps = versionPropertyList != null ? versionPropertyList.size() : 0;
            Property[] properties = new Property[numVersionProps + 4];
            CreateNodeRequest request = null;
            Path pathOfHighestModifiedNode = null;
            if (versionNodeName == null) {
                String name = JcrVersionManager.NODE_ENCODER.encode(now.getString());
                versionNodeName = (Name)context.getExecutionContext().getValueFactories().getNameFactory().create(name);
            }
            if ((versionHistoryLocation = this.versionHistoryLocationFor(versionHistoryPath, null, builder, workspace)) == null) {
                UUID versionHistoryUuid = UUID.randomUUID();
                UUID rootVersionUuid = UUID.randomUUID();
                UUID originalUuid = null;
                versionHistoryLocation = Location.create((Path)versionHistoryPath, (UUID)versionHistoryUuid);
                pathOfHighestModifiedNode = this.initializeVersionStorage(versionedNodeUuid, primaryType, mixinTypes, versionHistoryLocation, originalUuid, rootVersionUuid, context.getExecutionContext(), context.builder(), context.workspace(), context.getNowInUtc());
                predecessors = props.create(JcrLexicon.PREDECESSORS, new Object[]{rootVersionUuid});
            }
            properties[0] = props.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION});
            properties[1] = props.create(JcrLexicon.CREATED, new Object[]{now});
            properties[2] = props.create(JcrLexicon.UUID, new Object[]{versionUuid});
            properties[3] = predecessors;
            request = builder.createNode(versionHistoryLocation, workspace, versionNodeName, properties);
            Location versionNodeLocation = request.getActualLocationOfNode();
            UUID versionNodeUuid = versionNodeLocation.getUuid();
            properties[0] = props.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FROZEN_NODE});
            properties[1] = props.create(JcrLexicon.FROZEN_UUID, new Object[]{versionedNodeUuid});
            properties[2] = props.create(JcrLexicon.FROZEN_PRIMARY_TYPE, new Object[]{primaryType});
            properties[3] = props.create(JcrLexicon.FROZEN_MIXIN_TYPES, (Iterable)mixinTypes);
            if (versionPropertyList != null) {
                int i = 0;
                int p = 4;
                while (i != numVersionProps) {
                    properties[p] = (Property)versionPropertyList.get(i);
                    ++i;
                    ++p;
                }
            }
            request = builder.createNode(versionNodeLocation, workspace, JcrLexicon.FROZEN_NODE, properties);
            UuidFactory uuidFactory = context.getExecutionContext().getValueFactories().getUuidFactory();
            Property successors = null;
            HashSet<Object> successorUuids = new HashSet<Object>();
            for (Object value : predecessors) {
                UUID predecessorUuid = (UUID)uuidFactory.create(value);
                Location predecessorLocation = Location.create((UUID)predecessorUuid);
                successors = builder.readProperty(predecessorLocation, workspace, JcrLexicon.SUCCESSORS).getProperty();
                if (successors != null) {
                    successorUuids.clear();
                    for (Object successorValue : successors) {
                        successorUuids.add(uuidFactory.create(successorValue));
                    }
                    if (!successorUuids.add(versionNodeUuid)) continue;
                    successors = props.create(JcrLexicon.SUCCESSORS, successorUuids);
                    builder.setProperty(predecessorLocation, workspace, successors);
                    continue;
                }
                successors = props.create(JcrLexicon.SUCCESSORS, new Object[]{versionNodeUuid});
                builder.setProperty(predecessorLocation, workspace, successors);
            }
            Path versionNodePath = versionNodeLocation.getPath();
            context.setOutput(VERSION_HISTORY_UUID, (Serializable)versionHistoryLocation.getUuid());
            context.setOutput(VERSION_UUID, (Serializable)versionNodeUuid);
            context.setOutput(VERSION_PATH, (Serializable)versionNodePath);
            if (pathOfHighestModifiedNode == null) {
                pathOfHighestModifiedNode = versionNodePath;
            }
            context.setOutput(PATH_OF_HIGHEST_MODIFIED_NODE, (Serializable)pathOfHighestModifiedNode);
        }
    }

    @Immutable
    public static class InitializeVersionHistoryFunction
    extends VersionHistoryFunction {
        private static final long serialVersionUID = 1L;
        public static final String VERSIONED_NODE_UUID = "versionedNodeUuid";
        public static final String ORIGINAL_UUID = "originalUuid";
        public static final String VERSION_HISTORY_PATH = "versionHistoryPath";
        public static final String VERSION_UUID = "versionUuid";
        public static final String PRIMARY_TYPE_NAME = "primaryTypeName";
        public static final String MIXIN_TYPE_NAME_LIST = "mixinTypeNameList";
        public static final String PREDECESSOR_UUID_LIST = "predecessorUuidList";
        public static final String VERSION_HISTORY_UUID = "versionHistoryUuid";
        public static final String BASE_VERSION_UUID = "baseVersionUuid";
        public static final String PATH_OF_HIGHEST_MODIFIED_NODE = "pathOfHighestModifiedNode";

        public void run(FunctionContext context) {
            String workspace;
            UUID uuid = (UUID)context.input(VERSIONED_NODE_UUID, UUID.class);
            UUID originalUuid = (UUID)context.input(ORIGINAL_UUID, UUID.class);
            Path versionHistoryPath = (Path)context.input(VERSION_HISTORY_PATH, Path.class);
            UUID versionHistoryUuid = (UUID)context.input(VERSION_HISTORY_UUID, UUID.class);
            UUID versionUuid = (UUID)context.input(VERSION_UUID, UUID.class);
            Name primaryType = (Name)context.input(PRIMARY_TYPE_NAME, Name.class);
            List mixinTypes = (List)context.input(MIXIN_TYPE_NAME_LIST);
            List<UUID> predecessors = null;
            UUID baseVersion = null;
            Path pathOfHighestModifiedNode = null;
            assert (uuid != null);
            assert (versionHistoryPath != null);
            RequestBuilder builder = context.builder();
            Location versionHistoryLocation = this.versionHistoryLocationFor(versionHistoryPath, versionHistoryUuid, builder, workspace = context.workspace());
            if (versionHistoryLocation != null) {
                ReadAllChildrenRequest readChildren = builder.readAllChildren(versionHistoryLocation, workspace);
                List children = readChildren.getChildren();
                int numChildren = children.size();
                if (numChildren < 2) {
                    versionHistoryLocation = null;
                } else if (numChildren == 2) {
                    Location rootVersionLocation = (Location)children.get(1);
                    UUID rootVersionUuid = rootVersionLocation.getUuid();
                    assert (rootVersionUuid != null);
                    predecessors = Collections.singletonList(rootVersionUuid);
                    baseVersion = rootVersionUuid;
                } else {
                    ListIterator iter = children.listIterator(children.size());
                    while (iter.hasPrevious()) {
                        Location location = (Location)iter.previous();
                        ReadPropertyRequest request = builder.readProperty(location, workspace, JcrLexicon.SUCCESSORS);
                        if (request.getProperty() != null) continue;
                        UUID baseVersionUuid = location.getUuid();
                        assert (baseVersionUuid != null);
                        predecessors = Collections.singletonList(baseVersionUuid);
                        baseVersion = baseVersionUuid;
                        break;
                    }
                }
            }
            if (versionHistoryLocation == null) {
                if (versionHistoryUuid == null) {
                    versionHistoryUuid = UUID.randomUUID();
                }
                UUID rootVersionUuid = versionUuid != null ? versionUuid : UUID.randomUUID();
                versionHistoryLocation = Location.create((Path)versionHistoryPath, (UUID)versionHistoryUuid);
                pathOfHighestModifiedNode = this.initializeVersionStorage(uuid, primaryType, mixinTypes, versionHistoryLocation, originalUuid, rootVersionUuid, context.getExecutionContext(), context.builder(), context.workspace(), context.getNowInUtc());
                predecessors = Collections.singletonList(rootVersionUuid);
                baseVersion = rootVersionUuid;
            }
            assert (predecessors instanceof Serializable);
            assert (versionHistoryLocation.getUuid() != null);
            context.setOutput(PREDECESSOR_UUID_LIST, (Serializable)((Object)predecessors));
            context.setOutput(VERSION_HISTORY_UUID, (Serializable)versionHistoryLocation.getUuid());
            context.setOutput(BASE_VERSION_UUID, baseVersion);
            context.setOutput(PATH_OF_HIGHEST_MODIFIED_NODE, pathOfHighestModifiedNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Immutable
    public static abstract class VersionHistoryFunction
    extends Function {
        private static final long serialVersionUID = 1L;

        protected Location versionHistoryLocationFor(Path versionHistoryPath, UUID possibleVersionHistoryUuid, RequestBuilder system, String workspace) {
            Location actual;
            VerifyNodeExistsRequest verify;
            assert (versionHistoryPath != null);
            if (possibleVersionHistoryUuid != null && (verify = system.verifyNodeExists(Location.create((UUID)possibleVersionHistoryUuid), workspace)).exists() && versionHistoryPath.equals((actual = verify.getActualLocationOfNode()).getPath())) {
                return actual;
            }
            verify = system.verifyNodeExists(Location.create((Path)versionHistoryPath), workspace);
            return verify.exists() ? verify.getActualLocationOfNode() : null;
        }

        protected Property createPropertyIfDifferent(Map<Name, Property> properties, Name name, Object expectedValue, PropertyFactory propFactory, ValueFactory<?> valueFactory) {
            Property existingProp = properties.get(name);
            if (existingProp != null) {
                Object actualValue = valueFactory.create(existingProp.getFirstValue());
                if (!actualValue.equals(expectedValue)) {
                    return propFactory.create(name, new Object[]{expectedValue});
                }
                return null;
            }
            return propFactory.create(name, new Object[]{expectedValue});
        }

        protected Path initializeVersionStorage(UUID versionableNodeUuid, Name primaryTypeName, List<Name> mixinTypeNames, Location versionHistoryLocation, UUID originalVersionUuid, UUID rootVersionUuid, ExecutionContext context, RequestBuilder system, String workspace, DateTime now) {
            Path versionHistoryPath = versionHistoryLocation.getPath();
            UUID versionHistoryUuid = versionHistoryLocation.getUuid();
            assert (versionHistoryPath != null);
            assert (versionHistoryUuid != null);
            Path highestChangedNode = null;
            Property[] properties = new Property[4];
            CreateNodeRequest create = null;
            PropertyFactory props = context.getPropertyFactory();
            ReadNodeRequest readHistory = system.readNode(versionHistoryLocation, workspace);
            if (!readHistory.hasError()) {
                UuidFactory uuids = context.getValueFactories().getUuidFactory();
                Map byName = readHistory.getPropertiesByName();
                properties[0] = this.createPropertyIfDifferent(byName, JcrLexicon.VERSIONABLE_UUID, versionableNodeUuid, props, (ValueFactory<?>)uuids);
                if (originalVersionUuid != null) {
                    int index = properties[0] == null ? 0 : 1;
                    Name name = JcrLexicon.COPIED_FROM;
                    properties[index] = this.createPropertyIfDifferent(byName, name, originalVersionUuid, props, (ValueFactory<?>)uuids);
                }
                if (properties[0] != null) {
                    system.setProperties(versionHistoryLocation, workspace, properties);
                    highestChangedNode = versionHistoryLocation.getPath();
                }
            } else {
                if (readHistory.getError() instanceof PathNotFoundException) {
                    PathNotFoundException pnfe = (PathNotFoundException)readHistory.getError();
                    highestChangedNode = pnfe.getLowestAncestorThatDoesExist();
                }
                Path versionHistoryParent = versionHistoryPath.getParent();
                Iterator pathsToParent = versionHistoryParent.pathsFromRoot();
                assert (pathsToParent.hasNext());
                pathsToParent.next();
                assert (pathsToParent.hasNext());
                pathsToParent.next();
                assert (pathsToParent.hasNext());
                pathsToParent.next();
                properties[0] = props.create(JcrLexicon.PRIMARY_TYPE, new Object[]{ModeShapeLexicon.VERSION_HISTORY_FOLDER});
                while (pathsToParent.hasNext()) {
                    Path intermediateNode = (Path)pathsToParent.next();
                    Name nodeName = intermediateNode.getLastSegment().getName();
                    Location parentLocation = Location.create((Path)intermediateNode.getParent());
                    system.createNode(parentLocation, workspace, nodeName, properties, NodeConflictBehavior.DO_NOT_REPLACE);
                }
                Location parentLocation = Location.create((Path)versionHistoryParent);
                Name name = versionHistoryPath.getLastSegment().getName();
                properties[0] = props.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION_HISTORY});
                properties[1] = props.create(JcrLexicon.VERSIONABLE_UUID, new Object[]{versionableNodeUuid});
                properties[2] = props.create(JcrLexicon.UUID, new Object[]{versionHistoryUuid});
                if (originalVersionUuid != null) {
                    properties[3] = props.create(JcrLexicon.COPIED_FROM, new Object[]{originalVersionUuid});
                }
                create = system.createNode(parentLocation, workspace, name, properties, NodeConflictBehavior.APPEND);
            }
            Location parentLocation = versionHistoryLocation;
            Name name = JcrLexicon.VERSION_LABELS;
            properties[0] = props.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION_LABELS});
            properties[1] = null;
            properties[2] = null;
            properties[3] = null;
            create = system.createNode(parentLocation, workspace, name, properties, NodeConflictBehavior.APPEND);
            parentLocation = versionHistoryLocation;
            name = JcrLexicon.ROOT_VERSION;
            properties[0] = props.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.VERSION});
            properties[1] = props.create(JcrLexicon.CREATED, new Object[]{now});
            properties[2] = props.create(JcrLexicon.UUID, new Object[]{rootVersionUuid});
            properties[3] = null;
            create = system.createNode(parentLocation, workspace, name, properties, NodeConflictBehavior.APPEND);
            parentLocation = create.getActualLocationOfNode();
            name = JcrLexicon.FROZEN_NODE;
            properties[0] = props.create(JcrLexicon.PRIMARY_TYPE, new Object[]{JcrNtLexicon.FROZEN_NODE});
            properties[1] = props.create(JcrLexicon.FROZEN_UUID, new Object[]{versionableNodeUuid});
            properties[2] = props.create(JcrLexicon.FROZEN_PRIMARY_TYPE, new Object[]{primaryTypeName});
            if (mixinTypeNames != null && !mixinTypeNames.isEmpty()) {
                properties[3] = props.create(JcrLexicon.FROZEN_MIXIN_TYPES, mixinTypeNames);
            }
            create = system.createNode(parentLocation, workspace, name, properties, NodeConflictBehavior.APPEND);
            return highestChangedNode;
        }
    }
}

