/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.query;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.modeshape.common.text.ParsingException;
import org.modeshape.common.text.Position;
import org.modeshape.common.text.TokenStream;
import org.modeshape.graph.GraphI18n;
import org.modeshape.graph.property.ValueFormatException;
import org.modeshape.graph.query.model.And;
import org.modeshape.graph.query.model.Comparison;
import org.modeshape.graph.query.model.Constraint;
import org.modeshape.graph.query.model.DynamicOperand;
import org.modeshape.graph.query.model.FullTextSearch;
import org.modeshape.graph.query.model.FullTextSearchScore;
import org.modeshape.graph.query.model.Join;
import org.modeshape.graph.query.model.JoinCondition;
import org.modeshape.graph.query.model.JoinType;
import org.modeshape.graph.query.model.Literal;
import org.modeshape.graph.query.model.NamedSelector;
import org.modeshape.graph.query.model.NodePath;
import org.modeshape.graph.query.model.Not;
import org.modeshape.graph.query.model.Operator;
import org.modeshape.graph.query.model.Or;
import org.modeshape.graph.query.model.PropertyExistence;
import org.modeshape.graph.query.model.PropertyValue;
import org.modeshape.graph.query.model.Query;
import org.modeshape.graph.query.model.SameNodeJoinCondition;
import org.modeshape.graph.query.model.Selector;
import org.modeshape.graph.query.model.SelectorName;
import org.modeshape.graph.query.model.SetCriteria;
import org.modeshape.graph.query.model.Source;
import org.modeshape.graph.query.model.StaticOperand;
import org.modeshape.graph.query.model.TypeSystem;
import org.modeshape.graph.query.model.Visitor;
import org.modeshape.graph.query.parse.SqlQueryParser;
import org.modeshape.jcr.JcrI18n;

public class JcrSqlQueryParser
extends SqlQueryParser {
    public static final String LANGUAGE = "sql";

    public String getLanguage() {
        return LANGUAGE;
    }

    protected Query parseQuery(TokenStream tokens, TypeSystem typeSystem) {
        Query query = super.parseQuery(tokens, typeSystem);
        if (query.source() instanceof JoinableSources) {
            JoinableSources joinableSources = (JoinableSources)query.source();
            Source newSource = this.rewrite(joinableSources);
            query = new Query(newSource, query.constraint(), query.orderings(), query.columns(), query.limits(), query.isDistinct());
        }
        return query;
    }

    protected Source parseFrom(TokenStream tokens, TypeSystem typeSystem) {
        Position firstSourcePosition = tokens.nextPosition();
        Source source = super.parseFrom(tokens, typeSystem);
        if (tokens.matches(',') && source instanceof NamedSelector) {
            NamedSelector selector = (NamedSelector)source;
            JoinableSources joinedSources = new JoinableSources((Selector)selector, firstSourcePosition);
            while (tokens.canConsume(',')) {
                Position nextSourcePosition = tokens.nextPosition();
                NamedSelector nextSource = this.parseNamedSelector(tokens, typeSystem);
                joinedSources.add((Selector)nextSource, nextSourcePosition);
            }
            source = joinedSources;
        }
        return source;
    }

    protected Constraint parseConstraint(TokenStream tokens, TypeSystem typeSystem, Source source) {
        Constraint constraint = null;
        if (tokens.canConsume("JCR", new String[]{":", "PATH"})) {
            SelectorName selector = this.getSelectorNameFor(source);
            PropertyValue value = new PropertyValue(selector, "jcr:path");
            Operator operator = this.parseComparisonOperator(tokens);
            StaticOperand right = this.parseStaticOperand(tokens, typeSystem);
            constraint = this.rewriteConstraint((Constraint)new Comparison((DynamicOperand)value, operator, right));
        } else if (tokens.matches("any value", new String[]{"IN"})) {
            Literal value = this.parseLiteral(tokens, typeSystem);
            tokens.consume("IN");
            PropertyValue propertyValue = this.parsePropertyValue(tokens, typeSystem, source);
            constraint = new SetCriteria((DynamicOperand)propertyValue, new StaticOperand[]{value});
        } else if (!(!(source instanceof JoinableSources) || tokens.matches("(") || tokens.matches("NOT") || tokens.matches("CONTAINS", new String[]{"("}) || tokens.matches("ISSAMENODE", new String[]{"("}) || tokens.matches("ISCHILDNODE", new String[]{"("}) || tokens.matches("ISDESCENDANTNODE", new String[]{"("}))) {
            JoinableSources joinableSources = (JoinableSources)source;
            if (tokens.matches("any value", new String[]{":", "any value", ".", "JCR", ":", "PATH", "="}) || tokens.matches("any value", new String[]{".", "JCR", ":", "PATH", "="})) {
                Constraint rhs;
                Position position = tokens.nextPosition();
                SelectorName selector1 = this.parseSelectorName(tokens, typeSystem);
                tokens.consume('.');
                this.parseName(tokens, typeSystem);
                tokens.consume('=');
                SelectorName selector2 = this.parseSelectorName(tokens, typeSystem);
                tokens.consume('.');
                this.parseName(tokens, typeSystem);
                joinableSources.add(new SameNodeJoinCondition(selector1, selector2), position);
                while (tokens.canConsume("AND")) {
                    rhs = this.parseConstraint(tokens, typeSystem, source);
                    if (rhs == null) continue;
                    constraint = constraint != null ? new And(constraint, rhs) : rhs;
                }
                while (tokens.canConsume("OR")) {
                    rhs = this.parseConstraint(tokens, typeSystem, source);
                    if (rhs == null) continue;
                    constraint = constraint != null ? new And(constraint, rhs) : rhs;
                }
                return constraint;
            }
        }
        if (constraint != null) {
            Constraint rhs;
            while (tokens.canConsume("AND")) {
                rhs = this.parseConstraint(tokens, typeSystem, source);
                if (rhs == null) continue;
                constraint = new And(constraint, rhs);
            }
            while (tokens.canConsume("OR")) {
                rhs = this.parseConstraint(tokens, typeSystem, source);
                if (rhs == null) continue;
                constraint = new Or(constraint, rhs);
            }
            return constraint;
        }
        constraint = super.parseConstraint(tokens, typeSystem, source);
        constraint = this.rewriteConstraint(constraint);
        return constraint;
    }

    protected Constraint parsePropertyExistance(TokenStream tokens, TypeSystem typeSystem, Source source) {
        if (tokens.matches("any value", new String[]{"IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{"IS", "NULL"}) || tokens.matches("any value", new String[]{".", "any value", "IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{".", "any value", ":", "any value", "IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{".", "any value", "IS", "NULL"}) || tokens.matches("any value", new String[]{".", "any value", ":", "any value", "IS", "NULL"}) || tokens.matches("any value", new String[]{":", "any value", "IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{":", "any value", ".", "any value", "IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{":", "any value", ".", "any value", ":", "any value", "IS", "NOT", "NULL"}) || tokens.matches("any value", new String[]{":", "any value", ".", "any value", "IS", "NULL"}) || tokens.matches("any value", new String[]{":", "any value", ".", "any value", ":", "any value", "IS", "NULL"})) {
            Position pos = tokens.nextPosition();
            String firstWord = this.parseName(tokens, typeSystem);
            SelectorName selectorName = null;
            String propertyName = null;
            if (tokens.canConsume('.')) {
                selectorName = new SelectorName(firstWord);
                propertyName = this.parseName(tokens, typeSystem);
            } else {
                if (!(source instanceof Selector)) {
                    String msg = GraphI18n.mustBeScopedAtLineAndColumn.text(new Object[]{firstWord, pos.getLine(), pos.getColumn()});
                    throw new ParsingException(pos, msg);
                }
                selectorName = ((Selector)source).name();
                propertyName = firstWord;
            }
            if (tokens.canConsume("IS", new String[]{"NOT", "NULL"})) {
                return new PropertyExistence(selectorName, propertyName);
            }
            tokens.consume("IS", new String[]{"NULL"});
            return new Not((Constraint)new PropertyExistence(selectorName, propertyName));
        }
        return null;
    }

    protected SelectorName getSelectorNameFor(Source source) {
        if (source instanceof JoinableSources) {
            return ((JoinableSources)source).getSelectors().values().iterator().next().aliasOrName();
        }
        if (source instanceof Selector) {
            return ((Selector)source).aliasOrName();
        }
        assert (false);
        return null;
    }

    protected Constraint rewriteConstraint(Constraint constraint) {
        if (constraint instanceof Comparison) {
            Comparison comparison = (Comparison)constraint;
            DynamicOperand left = comparison.operand1();
            if (left instanceof PropertyValue) {
                PropertyValue propValue = (PropertyValue)left;
                if ("jcr:path".equals(propValue.propertyName())) {
                    NodePath path = new NodePath(propValue.selectorName());
                    return new Comparison((DynamicOperand)path, comparison.operator(), comparison.operand2());
                }
                if ("jcr:score".equals(propValue.propertyName())) {
                    FullTextSearchScore score = new FullTextSearchScore(propValue.selectorName());
                    return new Comparison((DynamicOperand)score, comparison.operator(), comparison.operand2());
                }
            }
        } else if (constraint instanceof FullTextSearch) {
            FullTextSearch search = (FullTextSearch)constraint;
            if (".".equals(search.propertyName())) {
                return new FullTextSearch(search.selectorName(), search.fullTextSearchExpression());
            }
        } else if (constraint instanceof And) {
            And and = (And)constraint;
            constraint = new And(this.rewriteConstraint(and.left()), this.rewriteConstraint(and.right()));
        } else if (constraint instanceof Or) {
            Or or = (Or)constraint;
            constraint = new Or(this.rewriteConstraint(or.left()), this.rewriteConstraint(or.right()));
        }
        return constraint;
    }

    protected String parseName(TokenStream tokens, TypeSystem typeSystem) {
        String token1 = tokens.consume();
        token1 = this.removeBracketsAndQuotes(token1);
        if (tokens.canConsume(':')) {
            String token2 = tokens.consume();
            token2 = this.removeBracketsAndQuotes(token2);
            return token1 + ':' + token2;
        }
        return token1;
    }

    protected Object parseLiteralValue(TokenStream tokens, TypeSystem typeSystem) {
        if (tokens.canConsume("TIMESTAMP")) {
            Position pos = tokens.previousPosition();
            String value = this.removeBracketsAndQuotes(tokens.consume());
            TypeSystem.TypeFactory dateTimeFactory = typeSystem.getDateTimeFactory();
            try {
                Object dateTime = dateTimeFactory.create(value);
                return dateTime;
            }
            catch (ValueFormatException e) {
                String msg = GraphI18n.expectingLiteralAndUnableToParseAsDate.text(new Object[]{value, pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
        }
        return super.parseLiteralValue(tokens, typeSystem);
    }

    protected String removeBracketsAndQuotes(String text) {
        if (text.length() > 0) {
            char firstChar = text.charAt(0);
            switch (firstChar) {
                case '\'': {
                    assert (text.charAt(text.length() - 1) == firstChar);
                    return this.removeBracketsAndQuotes(text.substring(1, text.length() - 1));
                }
            }
        }
        return text;
    }

    protected Source rewrite(JoinableSources joinableSources) {
        LinkedList<Join> joins = new LinkedList<Join>();
        for (SameNodeJoinCondition joinCondition : joinableSources.getJoinConditions()) {
            Position pos;
            SelectorName selector1 = joinCondition.selector1Name();
            SelectorName selector2 = joinCondition.selector2Name();
            boolean found = false;
            ListIterator iter = joins.listIterator();
            while (iter.hasNext()) {
                Join next = (Join)iter.next();
                Join replacement = null;
                if (this.usesSelector(next, selector1)) {
                    Source right = (Source)joinableSources.getSelectors().get(selector2.name());
                    replacement = new Join((Source)next, JoinType.INNER, right, (JoinCondition)joinCondition);
                } else if (this.usesSelector(next, selector2)) {
                    Source left = (Source)joinableSources.getSelectors().get(selector1.name());
                    replacement = new Join(left, JoinType.INNER, (Source)next, (JoinCondition)joinCondition);
                }
                if (replacement == null) continue;
                iter.previous();
                iter.remove();
                joins.add(replacement);
                found = true;
                break;
            }
            if (found) continue;
            Source left = (Source)joinableSources.getSelectors().get(selector1.name());
            Source right = (Source)joinableSources.getSelectors().get(selector2.name());
            if (left == null) {
                pos = joinableSources.getJoinCriteriaPosition();
                String msg = JcrI18n.selectorUsedInEquiJoinCriteriaDoesNotExistInQuery.text(new Object[]{selector1.name(), pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            if (right == null) {
                pos = joinableSources.getJoinCriteriaPosition();
                String msg = JcrI18n.selectorUsedInEquiJoinCriteriaDoesNotExistInQuery.text(new Object[]{selector2.name(), pos.getLine(), pos.getColumn()});
                throw new ParsingException(pos, msg);
            }
            joins.add(new Join(left, JoinType.INNER, right, (JoinCondition)joinCondition));
        }
        if (joins.size() == 1) {
            return (Source)joins.get(0);
        }
        return null;
    }

    protected boolean usesSelector(Join join, SelectorName selector) {
        Source left = join.left();
        if (left instanceof Selector && selector.equals((Object)((Selector)left).aliasOrName())) {
            return true;
        }
        if (left instanceof Join && this.usesSelector((Join)left, selector)) {
            return true;
        }
        Source right = join.right();
        if (right instanceof Selector && selector.equals((Object)((Selector)right).aliasOrName())) {
            return true;
        }
        return right instanceof Join && this.usesSelector((Join)right, selector);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class JoinableSources
    implements Source {
        private static final long serialVersionUID = 1L;
        private transient Map<String, Selector> selectors = new LinkedHashMap<String, Selector>();
        private transient List<SameNodeJoinCondition> joinConditions = new ArrayList<SameNodeJoinCondition>();
        private transient List<Position> selectorPositions = new ArrayList<Position>();
        private transient Position joinCriteriaPosition;

        protected JoinableSources(Selector firstSelector, Position position) {
            this.add(firstSelector, position);
        }

        public void add(Selector selector, Position position) {
            this.selectors.put(selector.aliasOrName().name(), selector);
            this.selectorPositions.add(position);
        }

        public void add(SameNodeJoinCondition joinCondition, Position position) {
            this.joinConditions.add(joinCondition);
            this.joinCriteriaPosition = position;
        }

        public Iterable<String> selectorNames() {
            return this.selectors.keySet();
        }

        public List<SameNodeJoinCondition> getJoinConditions() {
            return this.joinConditions;
        }

        public Map<String, Selector> getSelectors() {
            return this.selectors;
        }

        public Position getJoinCriteriaPosition() {
            return this.joinCriteriaPosition;
        }

        public Position getPositionForSelector(String selector) {
            int index = 0;
            for (Map.Entry<String, Selector> entry : this.selectors.entrySet()) {
                if (entry.getKey().equals(selector)) {
                    return this.selectorPositions.get(index);
                }
                ++index;
            }
            return null;
        }

        public void accept(Visitor visitor) {
        }
    }
}

