/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.PropertyType;
import org.modeshape.jcr.JcrI18n;

@Immutable
public class PropertyTypeUtil {
    static final int jcrPropertyTypeFor(Property property) {
        Object value = property.getFirstValue();
        if (value == null) {
            return 0;
        }
        return PropertyTypeUtil.jcrPropertyTypeFor(PropertyType.discoverType((Object)value));
    }

    public static final PropertyType dnaPropertyTypeFor(int jcrPropertyType) {
        switch (jcrPropertyType) {
            case 1: {
                return PropertyType.STRING;
            }
            case 2: {
                return PropertyType.BINARY;
            }
            case 6: {
                return PropertyType.BOOLEAN;
            }
            case 4: {
                return PropertyType.DOUBLE;
            }
            case 3: {
                return PropertyType.LONG;
            }
            case 5: {
                return PropertyType.DATE;
            }
            case 12: {
                return PropertyType.DECIMAL;
            }
            case 8: {
                return PropertyType.PATH;
            }
            case 7: {
                return PropertyType.NAME;
            }
            case 9: {
                return PropertyType.REFERENCE;
            }
            case 11: {
                return PropertyType.URI;
            }
            case 10: {
                return PropertyType.WEAKREFERENCE;
            }
        }
        throw new SystemFailureException(JcrI18n.invalidPropertyType.text(new Object[]{jcrPropertyType}));
    }

    public static final int jcrPropertyTypeFor(PropertyType dnaPropertyType) {
        switch (dnaPropertyType) {
            case STRING: {
                return 1;
            }
            case NAME: {
                return 7;
            }
            case LONG: {
                return 3;
            }
            case UUID: {
                return 1;
            }
            case URI: {
                return 1;
            }
            case PATH: {
                return 8;
            }
            case BOOLEAN: {
                return 6;
            }
            case DATE: {
                return 5;
            }
            case DECIMAL: {
                return 12;
            }
            case DOUBLE: {
                return 4;
            }
            case BINARY: {
                return 2;
            }
            case OBJECT: {
                return 0;
            }
            case REFERENCE: {
                return 9;
            }
            case WEAKREFERENCE: {
                return 10;
            }
        }
        assert (false);
        return 0;
    }
}

