/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.io.Serializable;
import javax.jcr.PropertyType;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.NameFactory;

@Immutable
final class PropertyDefinitionId
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String ANY_NAME = "*";
    private final Name nodeTypeName;
    private final Name propertyDefinitionName;
    private final int propertyType;
    private final boolean allowsMultiple;
    private final String stringRepresentation;

    public PropertyDefinitionId(Name nodeTypeName, Name propertyDefinitionName, int propertyType, boolean allowsMultiple) {
        this.nodeTypeName = nodeTypeName;
        this.propertyDefinitionName = propertyDefinitionName;
        this.propertyType = propertyType;
        this.allowsMultiple = allowsMultiple;
        this.stringRepresentation = this.nodeTypeName.getString() + '/' + this.propertyDefinitionName.getString() + '/' + PropertyType.nameFromValue((int)propertyType) + '/' + (allowsMultiple ? (char)'*' : '1');
    }

    public Name getNodeTypeName() {
        return this.nodeTypeName;
    }

    public Name getPropertyDefinitionName() {
        return this.propertyDefinitionName;
    }

    public int getPropertyType() {
        return this.propertyType;
    }

    public boolean allowsMultiple() {
        return this.allowsMultiple;
    }

    public boolean allowsAnyChildName() {
        return this.propertyDefinitionName.getLocalName().equals(ANY_NAME) && this.propertyDefinitionName.getNamespaceUri().length() == 0;
    }

    public String getString() {
        return this.stringRepresentation;
    }

    public static PropertyDefinitionId fromString(String definition, NameFactory factory) {
        String[] parts = definition.split("/");
        String nodeTypeNameString = parts[0];
        String propertyDefinitionNameString = parts[1];
        Name nodeTypeName = (Name)factory.create(nodeTypeNameString);
        Name propertyDefinitionName = (Name)factory.create(propertyDefinitionNameString);
        int propertyType = PropertyType.valueFromName((String)parts[2]);
        boolean allowsMultiple = parts[3].charAt(0) == '*';
        return new PropertyDefinitionId(nodeTypeName, propertyDefinitionName, propertyType, allowsMultiple);
    }

    public PropertyDefinitionId asSingleValued() {
        return new PropertyDefinitionId(this.nodeTypeName, this.propertyDefinitionName, this.propertyType, false);
    }

    public PropertyDefinitionId asMultiValued() {
        return new PropertyDefinitionId(this.nodeTypeName, this.propertyDefinitionName, this.propertyType, true);
    }

    public int hashCode() {
        return this.stringRepresentation.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PropertyDefinitionId) {
            PropertyDefinitionId that = (PropertyDefinitionId)obj;
            return this.stringRepresentation.equals(that.stringRepresentation);
        }
        return false;
    }

    public String toString() {
        return this.stringRepresentation;
    }
}

