/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.Iterator;
import javax.jcr.InvalidItemStateException;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.ItemVisitor;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.lock.Lock;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.VersionException;
import org.modeshape.common.annotation.NotThreadSafe;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.property.Binary;
import org.modeshape.graph.property.Name;
import org.modeshape.graph.property.Path;
import org.modeshape.graph.property.Property;
import org.modeshape.graph.property.ValueFactory;
import org.modeshape.graph.session.GraphSession;
import org.modeshape.jcr.AbstractJcrItem;
import org.modeshape.jcr.AbstractJcrNode;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.JcrPropertyDefinition;
import org.modeshape.jcr.JcrValue;
import org.modeshape.jcr.SessionCache;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
abstract class AbstractJcrProperty
extends AbstractJcrItem
implements javax.jcr.Property,
Comparable<javax.jcr.Property> {
    protected final AbstractJcrNode node;
    protected final Name name;

    AbstractJcrProperty(SessionCache cache, AbstractJcrNode node, Name name) {
        super(cache);
        assert (node != null);
        assert (name != null);
        this.node = node;
        this.name = name;
    }

    final SessionCache.NodeEditor editor() throws ItemNotFoundException, InvalidItemStateException, RepositoryException {
        return this.node.editor();
    }

    public abstract boolean isMultiple();

    protected final void checkForLock() throws LockException, RepositoryException {
        Lock parentLock;
        if (this.getParent().isLocked() && !this.getParent().getLock().isLockOwningSession() && (parentLock = this.getParent().getLock()) != null && parentLock.getLockToken() == null) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.getParent().location()}));
        }
    }

    public final void accept(ItemVisitor visitor) throws RepositoryException {
        CheckArg.isNotNull((Object)visitor, (String)"visitor");
        this.checkSession();
        visitor.visit((javax.jcr.Property)this);
    }

    final GraphSession.PropertyInfo<SessionCache.JcrPropertyPayload> propertyInfo() throws PathNotFoundException, RepositoryException {
        return this.node.nodeInfo().getProperty(this.name);
    }

    final Name name() {
        return this.name;
    }

    final SessionCache.JcrPropertyPayload payload() throws RepositoryException {
        return (SessionCache.JcrPropertyPayload)this.propertyInfo().getPayload();
    }

    final Property property() throws RepositoryException {
        return this.propertyInfo().getProperty();
    }

    JcrValue createValue(Object value) throws RepositoryException {
        return new JcrValue(this.context().getValueFactories(), this.cache, this.payload().getPropertyType(), value);
    }

    final JcrValue createValue(Object value, int propertyType) {
        return new JcrValue(this.context().getValueFactories(), this.cache, propertyType, value);
    }

    @Override
    Path path() throws RepositoryException {
        return this.context().getValueFactories().getPathFactory().create(this.node.path(), new Name[]{this.name});
    }

    public int getType() throws RepositoryException {
        this.checkSession();
        return this.payload().getPropertyType();
    }

    public final JcrPropertyDefinition getDefinition() throws RepositoryException {
        this.checkSession();
        return this.cache.session().nodeTypeManager().getPropertyDefinition(this.payload().getPropertyDefinitionId());
    }

    public final String getName() {
        return this.name.getString(this.namespaces());
    }

    public final AbstractJcrNode getParent() {
        return this.node;
    }

    public final String getPath() throws RepositoryException {
        return this.path().getString(this.namespaces());
    }

    public final boolean isModified() {
        try {
            this.checkSession();
            return this.propertyInfo().isModified();
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final boolean isNew() {
        try {
            this.checkSession();
            return this.propertyInfo().isNew();
        }
        catch (RepositoryException re) {
            throw new IllegalStateException(re);
        }
    }

    public final boolean isNode() {
        return false;
    }

    @Override
    public final boolean isSame(Item otherItem) throws RepositoryException {
        this.checkSession();
        if (otherItem instanceof javax.jcr.Property) {
            javax.jcr.Property otherProperty = (javax.jcr.Property)otherItem;
            if (!this.getParent().isSame((Item)otherProperty.getParent())) {
                return false;
            }
            return this.getName().equals(otherProperty.getName());
        }
        return false;
    }

    public void refresh(boolean keepChanges) {
        throw new UnsupportedOperationException();
    }

    public void remove() throws VersionException, LockException, ConstraintViolationException, RepositoryException {
        Lock parentLock;
        this.checkSession();
        AbstractJcrNode parentNode = this.getParent();
        if (parentNode.isLocked() && (parentLock = parentNode.lockManager().getLock(parentNode)) != null && !parentLock.isLockOwningSession()) {
            throw new LockException(JcrI18n.lockTokenNotHeld.text(new Object[]{this.getPath()}));
        }
        if (!parentNode.isCheckedOut()) {
            throw new VersionException(JcrI18n.nodeIsCheckedIn.text(new Object[]{this.getPath()}));
        }
        this.editor().removeProperty(this.name);
    }

    public void save() throws RepositoryException {
        this.checkSession();
        this.getParent().save();
    }

    @Override
    public int compareTo(javax.jcr.Property that) {
        if (that == this) {
            return 0;
        }
        try {
            return this.getName().compareTo(that.getName());
        }
        catch (RepositoryException e) {
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        try {
            ValueFactory stringFactory = this.session().getExecutionContext().getValueFactories().getStringFactory();
            StringBuilder sb = new StringBuilder();
            sb.append(this.getName()).append('=');
            Property property = this.propertyInfo().getProperty();
            if (this.isMultiple()) {
                sb.append('[');
                Iterator iter = property.iterator();
                if (iter.hasNext()) {
                    Object value = iter.next();
                    if (value instanceof Binary) {
                        sb.append("**binary-value-not-shown**");
                    } else {
                        sb.append((String)stringFactory.create(value));
                    }
                    if (iter.hasNext()) {
                        sb.append(',');
                    }
                }
                sb.append(']');
            } else {
                Object value = property.getFirstValue();
                if (value instanceof Binary) {
                    sb.append("**binary-value-not-shown**");
                } else {
                    sb.append((String)stringFactory.create(value));
                }
            }
            return sb.toString();
        }
        catch (RepositoryException e) {
            return super.toString();
        }
    }
}

