/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr.security;

import java.util.Map;
import java.util.Set;
import javax.jcr.Credentials;
import org.modeshape.common.util.CheckArg;
import org.modeshape.graph.ExecutionContext;
import org.modeshape.graph.SecurityContext;
import org.modeshape.jcr.api.AnonymousCredentials;
import org.modeshape.jcr.security.AuthenticationProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnonymousProvider
implements AuthenticationProvider {
    private final SecurityContext anonymousContext;

    public AnonymousProvider(String anonymousUsername, Set<String> userRoles) {
        CheckArg.isNotEmpty((String)anonymousUsername, (String)"anonymousUsername");
        CheckArg.isNotNull(userRoles, (String)"userRoles");
        this.anonymousContext = new AnonymousSecurityContext(userRoles, anonymousUsername);
    }

    @Override
    public ExecutionContext authenticate(Credentials credentials, String repositoryName, String workspaceName, ExecutionContext repositoryContext, Map<String, Object> sessionAttributes) {
        if (credentials == null || credentials instanceof AnonymousCredentials) {
            return repositoryContext.with(this.anonymousContext);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class AnonymousSecurityContext
    implements SecurityContext {
        private final Set<String> userRoles;
        private final String anonymousUsername;

        protected AnonymousSecurityContext(Set<String> userRoles, String anonymousUsername) {
            this.userRoles = userRoles;
            this.anonymousUsername = anonymousUsername;
        }

        public String getUserName() {
            return this.anonymousUsername;
        }

        public boolean hasRole(String roleName) {
            return this.userRoles.contains(roleName);
        }

        public void logout() {
        }
    }
}

